/*
 * Decompiled with CFR 0.152.
 */
package phex.prefs.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import phex.common.log.NLogger;
import phex.prefs.api.Preferences;
import phex.prefs.api.RangeSetting;
import phex.prefs.api.Setting;
import phex.utils.ClassUtils;
import phex.utils.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PreferencesFactory {
    private static final String SET_SER_POSTFIX = "[S:%d]";
    private static final String SET_DESER_POSTFIX = "[S:";
    private static final String LIST_SER_POSTFIX = "[L:%d]";
    private static final String LIST_DESER_POSTFIX = "[L:";

    public static Setting<String> createStringSetting(String name, String defaultValue, Preferences preferences) {
        String value = preferences.getLoadedProperty(name);
        if (value == null) {
            value = defaultValue;
        }
        Setting<String> setting = new Setting<String>(name, value, defaultValue, preferences);
        preferences.registerSetting(name, setting);
        return setting;
    }

    public static Setting<Boolean> createBoolSetting(String name, boolean defaultValue, Preferences preferences) {
        Boolean defaultBool = defaultValue;
        String value = preferences.getLoadedProperty(name);
        Boolean boolValue = value == null ? defaultBool : (value.equals("true") ? Boolean.TRUE : (value.equals("false") ? Boolean.FALSE : defaultBool));
        Setting<Boolean> setting = new Setting<Boolean>(name, boolValue, defaultBool, preferences);
        preferences.registerSetting(name, setting);
        return setting;
    }

    public static Setting<Float> createFloatSetting(String name, float defaultValue, Preferences preferences) {
        Float floatValue;
        Float defaultFloat = Float.valueOf(defaultValue);
        String value = preferences.getLoadedProperty(name);
        if (StringUtils.isEmpty(value)) {
            floatValue = defaultFloat;
        } else {
            try {
                floatValue = Float.valueOf(value);
            }
            catch (NumberFormatException exp) {
                floatValue = defaultFloat;
            }
        }
        Setting<Float> setting = new Setting<Float>(name, floatValue, defaultFloat, preferences);
        preferences.registerSetting(name, setting);
        return setting;
    }

    public static Setting<Long> createLongSetting(String name, long defaultValue, Preferences preferences) {
        Long longValue;
        Long defaultLong = defaultValue;
        String value = preferences.getLoadedProperty(name);
        try {
            longValue = Long.valueOf(value);
        }
        catch (NumberFormatException exp) {
            longValue = defaultLong;
        }
        Setting<Long> setting = new Setting<Long>(name, longValue, defaultLong, preferences);
        preferences.registerSetting(name, setting);
        return setting;
    }

    public static Setting<Integer> createIntSetting(String name, int defaultValue, Preferences preferences) {
        Integer intValue;
        Integer defaultInt = defaultValue;
        String value = preferences.getLoadedProperty(name);
        try {
            intValue = Integer.valueOf(value);
        }
        catch (NumberFormatException exp) {
            intValue = defaultInt;
        }
        Setting<Integer> setting = new Setting<Integer>(name, intValue, defaultInt, preferences);
        preferences.registerSetting(name, setting);
        return setting;
    }

    public static RangeSetting<Integer> createIntRangeSetting(String name, int defaultValue, int minValue, int maxValue, Preferences preferences) {
        Integer intValue;
        Integer defaultInt = defaultValue;
        String value = preferences.getLoadedProperty(name);
        try {
            intValue = Integer.valueOf(value);
        }
        catch (NumberFormatException exp) {
            intValue = defaultInt;
        }
        RangeSetting<Integer> setting = new RangeSetting<Integer>(name, intValue, defaultInt, minValue, maxValue, preferences);
        preferences.registerSetting(name, setting);
        return setting;
    }

    public static Setting<Short> createShortRangeSetting(String name, short defaultValue, short minValue, short maxValue, Preferences preferences) {
        Short shortValue;
        Short defaultShort = defaultValue;
        String value = preferences.getLoadedProperty(name);
        try {
            shortValue = Short.valueOf(value);
        }
        catch (NumberFormatException exp) {
            shortValue = defaultShort;
        }
        RangeSetting<Short> setting = new RangeSetting<Short>(name, shortValue, defaultShort, minValue, maxValue, preferences);
        preferences.registerSetting(name, setting);
        return setting;
    }

    public static Setting<Set<String>> createSetSetting(String name, Preferences preferences) {
        Set<String> values = PreferencesFactory.deserializeSet(name, preferences);
        Setting<Object> setting = new Setting<Object>(name, values, null, preferences);
        preferences.registerSetting(name, setting);
        return setting;
    }

    public static Setting<List<String>> createListSetting(String name, Preferences preferences) {
        List<String> values = PreferencesFactory.deserializeList(name, preferences);
        Setting<Object> setting = new Setting<Object>(name, values, null, preferences);
        preferences.registerSetting(name, setting);
        return setting;
    }

    public static Setting<Integer> createListeningPortSetting(String name, Preferences preferences) {
        int port;
        String value = preferences.getLoadedProperty(name);
        try {
            port = Integer.parseInt(value);
        }
        catch (NumberFormatException exp) {
            port = -1;
        }
        if (port < 1 || port > 65500) {
            Random random = new Random(System.currentTimeMillis());
            port = random.nextInt(60000);
            port += 4000;
        }
        Setting<Object> setting = new Setting<Object>(name, port, null, preferences);
        preferences.registerSetting(name, setting);
        return setting;
    }

    private static List<String> deserializeList(String name, Preferences preferences) {
        ArrayList<String> list = new ArrayList<String>();
        List<String> names = preferences.getPrefixedPropertyNames(name + LIST_DESER_POSTFIX);
        Collections.sort(names, new ListPostfixKeyComparator());
        for (String key : names) {
            String value = preferences.getLoadedProperty(key);
            if (StringUtils.isEmpty(value)) continue;
            list.add(value);
        }
        return list;
    }

    private static Set<String> deserializeSet(String name, Preferences preferences) {
        HashSet<String> set = new HashSet<String>();
        String prefix = name + SET_DESER_POSTFIX;
        List<String> names = preferences.getPrefixedPropertyNames(prefix);
        for (String key : names) {
            String value = preferences.getLoadedProperty(key);
            if (StringUtils.isEmpty(value)) continue;
            set.add(value);
        }
        return set;
    }

    public static void serializeSetting(Setting<?> setting, Properties properties) {
        if (setting == null) {
            throw new NullPointerException("setting should not be null");
        }
        String name = setting.getName();
        Object value = setting.get();
        if (value instanceof String) {
            properties.setProperty(name, (String)value);
        } else if (value instanceof Number) {
            properties.setProperty(name, ((Number)value).toString());
        } else if (value instanceof Boolean) {
            properties.setProperty(name, ((Boolean)value).toString());
        } else if (value instanceof Set) {
            Set setValue = (Set)value;
            int pos = 1;
            for (String elem : setValue) {
                properties.setProperty(name + String.format(SET_SER_POSTFIX, pos++), elem);
            }
        } else if (value instanceof List) {
            List listValue = (List)value;
            int listSize = listValue.size();
            for (int i = 0; i < listSize; ++i) {
                properties.setProperty(name + String.format(LIST_SER_POSTFIX, i), (String)listValue.get(i));
            }
        } else {
            NLogger.error(PreferencesFactory.class, (Object)("Unknwon settings value type: " + name + " / " + ClassUtils.getClassString(value)));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ListPostfixKeyComparator
    implements Comparator<String>,
    Serializable {
        private ListPostfixKeyComparator() {
        }

        @Override
        public int compare(String key1, String key2) {
            int val2;
            int val1;
            if (key1.equals(key2)) {
                return 0;
            }
            int idx1 = key1.lastIndexOf(PreferencesFactory.LIST_DESER_POSTFIX) + PreferencesFactory.LIST_DESER_POSTFIX.length();
            int idx1E = key1.indexOf(93, idx1);
            String val1Str = key1.substring(idx1, idx1E);
            try {
                val1 = Integer.parseInt(val1Str);
            }
            catch (NumberFormatException exp) {
                val1 = Integer.MAX_VALUE;
            }
            int idx2 = key2.lastIndexOf(PreferencesFactory.LIST_DESER_POSTFIX) + PreferencesFactory.LIST_DESER_POSTFIX.length();
            int idx2E = key2.indexOf(93, idx2);
            String val2Str = key1.substring(idx2, idx2E);
            try {
                val2 = Integer.parseInt(val2Str);
            }
            catch (NumberFormatException exp) {
                val2 = Integer.MAX_VALUE;
            }
            if (val1 == val2) {
                return key1.hashCode() - key2.hashCode();
            }
            return val1 - val2;
        }
    }
}

