/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import phex.common.log.NLogger;
import phex.host.Host;
import phex.io.buffer.ByteBuffer;
import phex.msg.GUID;
import phex.msg.InvalidMessageException;
import phex.prefs.core.MessagePrefs;
import phex.utils.IOUtil;

public class MsgHeader {
    public static final int DATA_LENGTH = 23;
    public static final byte PING_PAYLOAD = 0;
    public static final byte PONG_PAYLOAD = 1;
    public static final byte ROUTE_TABLE_UPDATE_PAYLOAD = 48;
    public static final byte PUSH_PAYLOAD = 64;
    public static final byte QUERY_PAYLOAD = -128;
    public static final byte QUERY_HIT_PAYLOAD = -127;
    public static final byte VENDOR_MESSAGE_PAYLOAD = 49;
    public static final byte STANDARD_VENDOR_MESSAGE_PAYLOAD = 50;
    public static final byte sUnknown = -1;
    private GUID msgID;
    private byte payload;
    private byte ttl;
    private byte hopsTaken;
    private int dataLength;
    private long arrivalTime;
    private Host fromHost = null;

    public MsgHeader(byte payload, int dataLength) {
        this(new GUID(), payload, MessagePrefs.TTL.get().byteValue(), 0, dataLength);
    }

    public MsgHeader(byte payload, byte ttl, int dataLength) {
        this(new GUID(), payload, ttl, 0, dataLength);
    }

    public MsgHeader(GUID guid, byte payload, byte ttl, byte hops, int dataLength) {
        this.msgID = guid;
        this.payload = payload;
        this.ttl = ttl;
        this.hopsTaken = hops;
        this.dataLength = dataLength;
    }

    public GUID getMsgID() {
        return this.msgID;
    }

    public void setMsgID(GUID MsgID) {
        this.msgID = MsgID;
    }

    public byte getPayload() {
        return this.payload;
    }

    public void setPayloadType(byte payload) {
        this.payload = payload;
    }

    private String getPayloadName() {
        switch (this.payload) {
            case 0: {
                return "Ping";
            }
            case 1: {
                return "Pong";
            }
            case 48: {
                return "RouteTableUpdate";
            }
            case 64: {
                return "Push";
            }
            case -128: {
                return "Query";
            }
            case -127: {
                return "QueryHit";
            }
            case 49: {
                return "Vendor";
            }
            case 50: {
                return "Vendor(st)";
            }
        }
        return "Unknown";
    }

    public byte getTTL() {
        return this.ttl;
    }

    public void setTTL(byte ttl) {
        this.ttl = ttl;
    }

    public byte getHopsTaken() {
        return this.hopsTaken;
    }

    public void setHopsTaken(byte HopsTaken) {
        this.hopsTaken = HopsTaken;
    }

    public void countHop() {
        if (this.ttl > 0) {
            this.ttl = (byte)(this.ttl - 1);
        }
        this.hopsTaken = (byte)(this.hopsTaken + 1);
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public void setDataLength(int DataLen) {
        this.dataLength = DataLen;
    }

    public long getArrivalTime() {
        return this.arrivalTime;
    }

    public void setArrivalTime(long arrivalTime) {
        this.arrivalTime = arrivalTime;
    }

    public Host getFromHost() {
        return this.fromHost;
    }

    public void setFromHost(Host fromHost) {
        this.fromHost = fromHost;
    }

    public void copy(MsgHeader b) {
        this.msgID = b.msgID;
        this.payload = b.payload;
        this.ttl = b.ttl;
        this.hopsTaken = b.hopsTaken;
        this.dataLength = b.dataLength;
    }

    public ByteBuffer createHeaderBuffer() {
        ByteBuffer buffer = ByteBuffer.wrap(this.getBytes());
        return buffer;
    }

    public byte[] getBytes() {
        byte[] tmpArray = new byte[23];
        byte[] guid = this.msgID.getGuid();
        System.arraycopy(guid, 0, tmpArray, 0, 16);
        tmpArray[16] = this.payload;
        tmpArray[17] = this.ttl;
        tmpArray[18] = this.hopsTaken;
        IOUtil.serializeIntLE(this.dataLength, tmpArray, 19);
        return tmpArray;
    }

    public String toString() {
        return "Header[" + this.payload + "-" + this.getPayloadName() + ",TTL=" + this.ttl + ",Hop=" + this.hopsTaken + ",len=" + this.dataLength + ",GUID=" + this.msgID + " ]";
    }

    public static MsgHeader createMsgHeader(byte[] inbuf, int offset) throws InvalidMessageException {
        if (inbuf.length - offset < 23) {
            throw new InvalidMessageException("The byte array length is less then the message header length.");
        }
        byte[] guidBytes = new byte[16];
        System.arraycopy(inbuf, offset, guidBytes, 0, 16);
        GUID guid = new GUID(guidBytes);
        offset += 16;
        byte payload = inbuf[offset++];
        byte ttl = inbuf[offset++];
        byte hopsTaken = inbuf[offset++];
        int dataLen = IOUtil.deserializeIntLE(inbuf, offset);
        offset += 4;
        MsgHeader header = new MsgHeader(guid, payload, ttl, hopsTaken, dataLen);
        int length = header.getDataLength();
        if (length < 0) {
            throw new InvalidMessageException("Negative body size when creating header from byte array.");
        }
        if (length > MessagePrefs.MaxLength.get()) {
            NLogger.warn(MsgHeader.class, (Object)("Body too big(" + length + "). Header: " + header + " Byte Array : " + new String(inbuf)));
            throw new InvalidMessageException("Package too big when creating Message from byte array: " + header.getDataLength());
        }
        header.setArrivalTime(System.currentTimeMillis());
        return header;
    }
}

