/*
 * Decompiled with CFR 0.152.
 */
package phex.metalink;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.httpclient.URI;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import phex.common.log.NLogger;
import phex.metalink.DMetalink;
import phex.metalink.MetalinkSAXHandler;
import phex.utils.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetalinkParser {
    private List<URI> magnets = new ArrayList<URI>();
    private InputStream inStream;

    public static List<URI> parseMagnetUriFromFile(File metalinkFile) {
        try {
            BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(metalinkFile));
            MetalinkParser parser = new MetalinkParser(inStream);
            parser.start();
            return parser.getMagnets();
        }
        catch (IOException exp) {
            NLogger.warn(MetalinkParser.class, (Object)exp.getMessage(), (Throwable)exp);
            return Collections.emptyList();
        }
    }

    public MetalinkParser(InputStream inStream) {
        this.inStream = inStream;
    }

    public void start() throws IOException {
        DMetalink metalink = new DMetalink();
        MetalinkSAXHandler handler = new MetalinkSAXHandler(metalink);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(this.inStream, (DefaultHandler)handler);
            for (DMetalink.FileEntry fileEntry : metalink.files) {
                String magnetStr = fileEntry.magnet();
                if (StringUtils.isEmpty(magnetStr)) continue;
                this.magnets.add(new URI(magnetStr, true));
            }
        }
        catch (ParserConfigurationException exp) {
            NLogger.error(MetalinkParser.class, (Object)exp, (Throwable)exp);
            throw new IOException("Parsing Metalink XML failed.");
        }
        catch (SAXException exp) {
            NLogger.error(MetalinkParser.class, (Object)exp, (Throwable)exp);
            throw new IOException("Parsing Metalink XML failed.");
        }
    }

    public List<URI> getMagnets() {
        return this.magnets;
    }
}

