/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.search.cp;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.text.Keymap;
import phex.common.address.DestAddress;
import phex.gui.common.BoxPanel;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.prefs.PhexGuiPrefs;
import phex.gui.prefs.SearchTabPrefs;
import phex.gui.tabs.search.cp.SearchControlPanel;
import phex.query.BrowseHostResults;
import phex.utils.Localizer;

public class BrowseHostSearchBox
extends BoxPanel {
    private SearchControlPanel controlPanel;
    private DefaultComboBoxModel hostNameComboModel;
    private JComboBox hostNameComboBox;
    private JButton browseButton;
    private JButton stopButton;

    public BrowseHostSearchBox(SearchControlPanel cp) {
        super(Localizer.getString("SearchTab_BrowseHost"));
        this.controlPanel = cp;
        CellConstraints cc = new CellConstraints();
        FormLayout searchBoxLayout = new FormLayout("6dlu, p, 6dlu", "4dlu, p, 2dlu, p, 6dlu, p, 4dlu");
        PanelBuilder searchBoxBuilder = new PanelBuilder(searchBoxLayout, this.getContentPanel());
        searchBoxBuilder.addLabel(Localizer.getString("SearchTab_TypeHostAddress"), cc.xy(2, 2));
        SubmitSearchHandler submitSearchHandler = new SubmitSearchHandler();
        this.hostNameComboModel = new DefaultComboBoxModel<Object>(SearchTabPrefs.BrowseHostHistory.get().toArray());
        this.hostNameComboBox = new JComboBox(this.hostNameComboModel);
        this.hostNameComboBox.setEditable(true);
        JTextField editor = (JTextField)this.hostNameComboBox.getEditor().getEditorComponent();
        Keymap keymap = JTextField.addKeymap("SearchTermEditor", editor.getKeymap());
        editor.setKeymap(keymap);
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(10, 0), submitSearchHandler);
        GUIUtils.assignKeymapToComboBoxEditor(keymap, this.hostNameComboBox);
        this.hostNameComboBox.setSelectedItem("");
        searchBoxBuilder.add((Component)this.hostNameComboBox, cc.xy(2, 4));
        this.browseButton = new JButton(Localizer.getString("SearchTab_StartBrowseHost"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Search.Search"));
        this.browseButton.setCursor(Cursor.getPredefinedCursor(12));
        this.browseButton.setToolTipText(Localizer.getString("SearchTab_TTTStartBrowseHost"));
        this.browseButton.setMargin(GUIUtils.NARROW_BUTTON_INSETS);
        this.browseButton.addActionListener(submitSearchHandler);
        StopSearchHandler stopSearchHandler = new StopSearchHandler();
        this.stopButton = new JButton(Localizer.getString("SearchTab_StopSearch"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Search.Stop"));
        this.stopButton.setCursor(Cursor.getPredefinedCursor(12));
        this.stopButton.setToolTipText(Localizer.getString("SearchTab_TTTStopSearch"));
        this.stopButton.setMargin(GUIUtils.NARROW_BUTTON_INSETS);
        this.stopButton.addActionListener(stopSearchHandler);
        ButtonBarBuilder builder = new ButtonBarBuilder();
        builder.setLeftToRightButtonOrder(true);
        builder.addFixedNarrow(this.browseButton);
        builder.addRelatedGap();
        builder.addFixedNarrow(this.stopButton);
        builder.addGlue();
        JPanel btnBar = builder.getPanel();
        btnBar.setOpaque(false);
        searchBoxBuilder.add((Component)btnBar, cc.xy(2, 6));
        this.adjustComponents();
    }

    private void adjustComponents() {
        if (this.hostNameComboBox != null) {
            GUIUtils.adjustComboBoxHeight(this.hostNameComboBox);
            ListCellRenderer renderer = this.hostNameComboBox.getRenderer();
            if (renderer != null) {
                FontMetrics fm = this.hostNameComboBox.getFontMetrics(this.hostNameComboBox.getFont());
                int maxWidth = fm.getMaxAdvance() * 10;
                int minWidth = fm.getMaxAdvance() * 8;
                Dimension dim = this.hostNameComboBox.getMaximumSize();
                dim.width = Math.max(minWidth, Math.min(maxWidth, dim.width));
                this.hostNameComboBox.setMaximumSize(dim);
                dim = this.hostNameComboBox.getPreferredSize();
                dim.width = Math.max(minWidth, Math.min(maxWidth, dim.width));
                this.hostNameComboBox.setPreferredSize(dim);
            }
        }
        if (this.browseButton != null) {
            String orgText = this.browseButton.getText();
            this.browseButton.setText(Localizer.getString("SearchTab_BrowseHost"));
            Dimension dim = this.browseButton.getPreferredSize();
            this.browseButton.setText(Localizer.getString("SearchTab_Searching"));
            Dimension dim2 = this.browseButton.getPreferredSize();
            dim.width = Math.max(dim.width, dim2.width);
            this.browseButton.setPreferredSize(dim);
            this.browseButton.setText(orgText);
        }
    }

    public void clearBrowseHostHistory() {
        this.hostNameComboModel.removeAllElements();
        SearchTabPrefs.BrowseHostHistory.get().clear();
        SearchTabPrefs.BrowseHostHistory.changed();
        PhexGuiPrefs.save(false);
    }

    public void focusInputField() {
        this.hostNameComboBox.requestFocus();
    }

    public void updateUI() {
        super.updateUI();
        this.adjustComponents();
    }

    public void updateControlPanel(BrowseHostResults search) {
        if (search != null) {
            DestAddress destAddress = search.getDestAddress();
            this.hostNameComboBox.setSelectedItem(destAddress.getFullHostName());
            ((JTextField)this.hostNameComboBox.getEditor().getEditorComponent()).setText(destAddress.getFullHostName());
            if (search.isSearching()) {
                this.browseButton.setText(Localizer.getString("SearchTab_Searching"));
                this.browseButton.setToolTipText(Localizer.getString("SearchTab_TTTSearching"));
                this.browseButton.setEnabled(false);
                this.hostNameComboBox.setEnabled(false);
            } else {
                this.browseButton.setText(Localizer.getString("SearchTab_BrowseHost"));
                this.browseButton.setToolTipText(Localizer.getString("SearchTab_TTTBrowseHost"));
                this.browseButton.setEnabled(true);
                this.hostNameComboBox.setEnabled(true);
            }
        } else {
            this.hostNameComboBox.setSelectedItem(null);
            ((JTextField)this.hostNameComboBox.getEditor().getEditorComponent()).setText("");
            this.browseButton.setText(Localizer.getString("SearchTab_BrowseHost"));
            this.browseButton.setToolTipText(Localizer.getString("SearchTab_TTTBrowseHost"));
            this.browseButton.setEnabled(true);
            this.hostNameComboBox.setEnabled(true);
        }
    }

    private class StopSearchHandler
    extends AbstractAction
    implements ActionListener {
        private StopSearchHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            BrowseHostSearchBox.this.controlPanel.stopSearching();
        }
    }

    private class SubmitSearchHandler
    extends AbstractAction
    implements ActionListener {
        private SubmitSearchHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            String hostName = (String)BrowseHostSearchBox.this.hostNameComboBox.getEditor().getItem();
            BrowseHostSearchBox.this.hostNameComboModel.setSelectedItem(hostName);
            hostName = hostName.trim();
            if (hostName.length() == 0) {
                return;
            }
            boolean succ = BrowseHostSearchBox.this.controlPanel.startBrowseHost(hostName);
            if (!succ) {
                return;
            }
            int idx = BrowseHostSearchBox.this.hostNameComboModel.getIndexOf(hostName);
            if (idx < 0) {
                BrowseHostSearchBox.this.hostNameComboModel.insertElementAt(hostName, 0);
                if (BrowseHostSearchBox.this.hostNameComboModel.getSize() > SearchTabPrefs.MaxSearchHistorySize.get()) {
                    BrowseHostSearchBox.this.hostNameComboModel.removeElementAt(BrowseHostSearchBox.this.hostNameComboModel.getSize() - 1);
                }
                this.saveSearchList();
            } else if (idx > 0) {
                BrowseHostSearchBox.this.hostNameComboModel.removeElementAt(idx);
                BrowseHostSearchBox.this.hostNameComboModel.insertElementAt(hostName, 0);
                this.saveSearchList();
            }
        }

        private void saveSearchList() {
            int length = BrowseHostSearchBox.this.hostNameComboModel.getSize();
            ArrayList searchList = new ArrayList(length);
            for (int i = 0; i < length; ++i) {
                searchList.add(BrowseHostSearchBox.this.hostNameComboModel.getElementAt(i));
            }
            SearchTabPrefs.BrowseHostHistory.get().clear();
            SearchTabPrefs.BrowseHostHistory.get().addAll(searchList);
            SearchTabPrefs.BrowseHostHistory.changed();
            PhexGuiPrefs.save(false);
        }
    }
}

