/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.search;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreePath;
import phex.common.Environment;
import phex.common.address.DestAddress;
import phex.common.log.NLogger;
import phex.download.RemoteFile;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SwarmingManager;
import phex.gui.actions.BanHostActionUtils;
import phex.gui.actions.FWAction;
import phex.gui.actions.GUIActionPerformer;
import phex.gui.common.BrowserLauncher;
import phex.gui.common.FWToolBar;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.table.FWTable;
import phex.gui.common.table.FWTableColumn;
import phex.gui.common.table.SortedTableHeaderRenderer;
import phex.gui.common.treetable.JTreeTable;
import phex.gui.dialogs.DownloadConfigDialog;
import phex.gui.models.ISearchDataModel;
import phex.gui.models.SearchTreeTableModel;
import phex.gui.renderer.SearchResultsRowRenderer;
import phex.gui.renderer.SearchTreeCellRenderer;
import phex.gui.tabs.search.SearchResultElement;
import phex.gui.tabs.search.SearchResultsDataModel;
import phex.gui.tabs.search.SearchTab;
import phex.servent.Servent;
import phex.share.SharedFilesService;
import phex.utils.Localizer;
import phex.utils.StringUtils;
import phex.utils.URLUtil;
import phex.xml.sax.gui.DGuiSettings;
import phex.xml.sax.gui.DTable;

public class SearchResultsPanel
extends JPanel {
    private static final String SEARCH_TREE_TABLE_IDENTIFIER = "SearchTreeTable";
    private static final RemoteFile[] EMPTY_REMOTE_FILE_ARRAY = new RemoteFile[0];
    private final SwarmingManager downloadService;
    private SearchTab searchTab;
    private JPopupMenu searchResultPopup;
    private JTreeTable searchTreeTable;
    private SearchTreeTableModel searchTreeTableModel;
    private JScrollPane searchTreeTableScrollPane;
    private static final String QUICK_DOWNLOAD_ACTION_KEY = "SWQuickDownloadAction";
    private static final String CONFIG_DOWNLOAD_ACTION_KEY = "SWConfigDownloadAction";
    private static final String VIEW_BITZI_TICKET_ACTION_KEY = "ViewBitziTicketAction";
    private static final String CHAT_TO_HOST_ACTION_KEY = "ChatToHostAction";
    private static final String BROWSE_HOST_ACTION_KEY = "BrowseHostAction";
    private static final String ADD_TO_FAVORITES_ACTION_KEY = "AddToFavoritesAction";

    public SearchResultsPanel(SearchTab searchTab, SwarmingManager downloadService) {
        if (searchTab == null) {
            throw new NullPointerException("SearchTab missing");
        }
        if (downloadService == null) {
            throw new NullPointerException("DownloadService missing");
        }
        this.searchTab = searchTab;
        this.downloadService = downloadService;
    }

    public void initializeComponent(DGuiSettings guiSettings) {
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("fill:d:grow", "fill:d:grow, 1dlu, p");
        PanelBuilder panelBuilder = new PanelBuilder(layout, this);
        MouseHandler mouseHandler = new MouseHandler();
        this.searchTreeTableModel = new SearchTreeTableModel();
        this.searchTreeTable = new JTreeTable(this.searchTreeTableModel);
        GUIUtils.updateTableFromDGuiSettings(guiSettings, this.searchTreeTable, SEARCH_TREE_TABLE_IDENTIFIER);
        this.searchTreeTable.activateHeaderPopupMenu();
        this.searchTreeTable.activateColumnResizeToFit();
        JTableHeader header = this.searchTreeTable.getTableHeader();
        header.setDefaultRenderer(new SortedTableHeaderRenderer(this.searchTreeTable));
        header.addMouseListener(new TableHeaderMouseHandler());
        this.searchTreeTable.addMouseListener(mouseHandler);
        this.searchTreeTable.setAutoResizeMode(0);
        this.searchTreeTable.getSelectionModel().addListSelectionListener(new SearchTreeTableSelectionListener());
        this.searchTreeTable.setTreeCellRenderer(new SearchTreeCellRenderer(this.downloadService));
        SharedFilesService sharedFilesService = Servent.getInstance().getSharedFilesService();
        SearchResultsRowRenderer resultRowRenderer = new SearchResultsRowRenderer(sharedFilesService, this.downloadService);
        List<TableColumn> colList = this.searchTreeTable.getColumns(true);
        for (TableColumn column : colList) {
            column.setCellRenderer(resultRowRenderer);
        }
        this.searchTreeTableScrollPane = FWTable.createFWTableScrollPane(this.searchTreeTable);
        this.searchTreeTableScrollPane.addMouseListener(mouseHandler);
        panelBuilder.add((Component)this.searchTreeTableScrollPane, cc.xy(1, 1));
        FWToolBar resultToolbar = new FWToolBar(0);
        resultToolbar.setBorderPainted(false);
        resultToolbar.setFloatable(false);
        panelBuilder.add((Component)resultToolbar, cc.xy(1, 3));
        this.searchResultPopup = new JPopupMenu();
        FWAction action = new SWQuickDownloadAction();
        this.searchTab.addTabAction(QUICK_DOWNLOAD_ACTION_KEY, action);
        resultToolbar.addAction(action);
        this.searchResultPopup.add(action);
        action = new SWConfigDownloadAction();
        this.searchTab.addTabAction(CONFIG_DOWNLOAD_ACTION_KEY, action);
        resultToolbar.addAction(action);
        this.searchResultPopup.add(action);
        action = new ViewBitziTicketAction();
        this.searchTab.addTabAction(VIEW_BITZI_TICKET_ACTION_KEY, action);
        resultToolbar.addAction(action);
        this.searchResultPopup.add(action);
        this.searchResultPopup.addSeparator();
        action = new AddToFavoritesAction();
        this.searchTab.addTabAction(ADD_TO_FAVORITES_ACTION_KEY, action);
        this.searchResultPopup.add(action);
        action = new BrowseHostAction();
        this.searchTab.addTabAction(BROWSE_HOST_ACTION_KEY, action);
        resultToolbar.addAction(action);
        this.searchResultPopup.add(action);
        action = new ChatToHostAction();
        this.searchTab.addTabAction(CHAT_TO_HOST_ACTION_KEY, action);
        this.searchResultPopup.add(action);
        BanHostActionProvider banHostActionProvider = new BanHostActionProvider();
        BanHostActionUtils.BanHostActionMenu bhActionMenu = BanHostActionUtils.createActionMenu(banHostActionProvider);
        this.searchResultPopup.add(bhActionMenu.menu);
        this.searchTab.addTabActions(bhActionMenu.actions);
        action = BanHostActionUtils.createToolBarAction(banHostActionProvider);
        resultToolbar.addAction(action);
        this.searchTab.addTabAction(action);
        this.searchResultPopup.addSeparator();
        this.searchResultPopup.add(this.searchTab.getTabAction("CreateNewSearchAction"));
        this.searchResultPopup.add(this.searchTab.getTabAction("ClearSearchResultsAction"));
        this.searchResultPopup.add(this.searchTab.getTabAction("CloseSearchAction"));
    }

    public void setDisplayedSearch(SearchResultsDataModel searchResultsDataModel) {
        this.searchTreeTableModel.setDisplayedSearch(searchResultsDataModel);
    }

    public RemoteFile[] getSelectedRemoteFiles(boolean singleForAll) {
        ISearchDataModel searchDataModel = this.searchTreeTableModel.getDisplayedResultsData();
        if (searchDataModel == null) {
            return EMPTY_REMOTE_FILE_ARRAY;
        }
        TreePath[] selectionPaths = this.searchTreeTable.getTreeSelectionModel().getSelectionPaths();
        if (selectionPaths == null || selectionPaths.length == 0) {
            return EMPTY_REMOTE_FILE_ARRAY;
        }
        HashSet<RemoteFile> remoteFileSet = new HashSet<RemoteFile>();
        for (int i = 0; i < selectionPaths.length; ++i) {
            RemoteFile[] files;
            SearchResultElement element;
            if (selectionPaths[i].getPathCount() == 3) {
                if (singleForAll) {
                    element = (SearchResultElement)selectionPaths[i].getPathComponent(1);
                    files = element.getRemoteFiles();
                    remoteFileSet.addAll(Arrays.asList(files));
                    continue;
                }
                RemoteFile remoteFile = (RemoteFile)selectionPaths[i].getPathComponent(2);
                remoteFileSet.add(remoteFile);
                continue;
            }
            element = (SearchResultElement)selectionPaths[i].getPathComponent(1);
            files = element.getRemoteFiles();
            remoteFileSet.addAll(Arrays.asList(files));
        }
        RemoteFile[] result = new RemoteFile[remoteFileSet.size()];
        remoteFileSet.toArray(result);
        return result;
    }

    private RemoteFile getSelectedRemoteFile(boolean useRepresent) {
        RemoteFile remoteFile;
        ISearchDataModel searchDataModel = this.searchTreeTableModel.getDisplayedResultsData();
        if (searchDataModel == null) {
            return null;
        }
        TreePath selectionPath = this.searchTreeTable.getTreeSelectionModel().getSelectionPath();
        if (selectionPath == null) {
            return null;
        }
        if (selectionPath.getPathCount() == 3) {
            remoteFile = (RemoteFile)selectionPath.getPathComponent(2);
        } else {
            SearchResultElement element = (SearchResultElement)selectionPath.getPathComponent(1);
            if (!useRepresent && element.getRemoteFileListCount() != 0) {
                return null;
            }
            remoteFile = element.getSingleRemoteFile();
        }
        return remoteFile;
    }

    public void updateUI() {
        super.updateUI();
        if (this.searchTreeTableScrollPane != null) {
            FWTable.updateFWTableScrollPane(this.searchTreeTableScrollPane);
        }
    }

    public void appendDGuiSettings(DGuiSettings dSettings) {
        DTable dTable = GUIUtils.createDTable(this.searchTreeTable, SEARCH_TREE_TABLE_IDENTIFIER);
        dSettings.getTableList().getTableList().add(dTable);
    }

    private class SearchTreeTableSelectionListener
    implements ListSelectionListener {
        private SearchTreeTableSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            try {
                if (!e.getValueIsAdjusting()) {
                    SearchResultsPanel.this.searchTab.refreshTabActions();
                }
            }
            catch (Throwable th) {
                NLogger.error(SearchTreeTableSelectionListener.class, (Object)th, th);
            }
        }
    }

    private class TableHeaderMouseHandler
    extends MouseAdapter
    implements MouseListener {
        private TableHeaderMouseHandler() {
        }

        public void mouseClicked(MouseEvent e) {
            try {
                FWTableColumn column = SearchResultsPanel.this.searchTreeTable.getResizingColumn(e.getPoint());
                int clickCount = e.getClickCount();
                if (column == null && clickCount == 1) {
                    this.handleColumnSorting(e);
                }
            }
            catch (Throwable th) {
                NLogger.error(TableHeaderMouseHandler.class, (Object)th, th);
            }
        }

        private void handleColumnSorting(MouseEvent e) {
            int viewIdx = SearchResultsPanel.this.searchTreeTable.getColumnModel().getColumnIndexAtX(e.getX());
            int modelIdx = SearchResultsPanel.this.searchTreeTable.convertColumnIndexToModel(viewIdx);
            if (modelIdx == -1) {
                return;
            }
            FWTableColumn column = (FWTableColumn)SearchResultsPanel.this.searchTreeTable.getColumnModel().getColumn(viewIdx);
            boolean isAscending = column.reverseSortingOrder();
            SearchResultsPanel.this.searchTreeTableModel.sortByColumn(modelIdx, isAscending);
        }
    }

    private class MouseHandler
    extends MouseAdapter
    implements MouseListener {
        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent e) {
            try {
                if (e.getClickCount() == 2 && e.getSource() == SearchResultsPanel.this.searchTreeTable) {
                    SearchResultsPanel.this.searchTab.getTabAction(SearchResultsPanel.QUICK_DOWNLOAD_ACTION_KEY).actionPerformed(null);
                }
            }
            catch (Throwable th) {
                NLogger.error(MouseHandler.class, (Object)th, th);
            }
        }

        public void mouseReleased(MouseEvent e) {
            try {
                if (e.isPopupTrigger()) {
                    this.popupMenu((Component)e.getSource(), e.getX(), e.getY());
                }
            }
            catch (Throwable th) {
                NLogger.error(MouseHandler.class, (Object)th, th);
            }
        }

        public void mousePressed(MouseEvent e) {
            try {
                if (e.isPopupTrigger()) {
                    this.popupMenu((Component)e.getSource(), e.getX(), e.getY());
                }
            }
            catch (Throwable th) {
                NLogger.error(MouseHandler.class, (Object)th, th);
            }
        }

        private void popupMenu(Component source, int x, int y) {
            if (source == SearchResultsPanel.this.searchTreeTable || source == SearchResultsPanel.this.searchTreeTableScrollPane) {
                SearchResultsPanel.this.searchResultPopup.show(source, x, y);
            }
        }
    }

    private class AddToFavoritesAction
    extends FWAction {
        public AddToFavoritesAction() {
            super(Localizer.getString("AddToFavorites"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Search.FavoriteHost"), Localizer.getString("TTTAddToFavorites"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            RemoteFile[] files = SearchResultsPanel.this.getSelectedRemoteFiles(false);
            DestAddress[] addresses = new DestAddress[files.length];
            for (int i = 0; i < files.length; ++i) {
                addresses[i] = files[i].getHostAddress();
            }
            GUIActionPerformer.addHostsToFavorites(addresses);
        }

        public void refreshActionState() {
            if (SearchResultsPanel.this.searchTreeTable.getSelectedRow() < 0) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    private final class BanHostActionProvider
    implements BanHostActionUtils.BanHostActionProvider {
        private BanHostActionProvider() {
        }

        public DestAddress[] getBanHostAddresses() {
            RemoteFile[] files = SearchResultsPanel.this.getSelectedRemoteFiles(false);
            DestAddress[] addresses = new DestAddress[files.length];
            for (int i = 0; i < files.length; ++i) {
                addresses[i] = files[i].getHostAddress();
            }
            return addresses;
        }

        public boolean isBanHostActionEnabled(boolean allowMultipleAddresses) {
            return SearchResultsPanel.this.searchTreeTable.getSelectedRow() >= 0 && (allowMultipleAddresses || SearchResultsPanel.this.searchTreeTable.getSelectedRowCount() <= 1);
        }
    }

    private class BrowseHostAction
    extends FWAction {
        public BrowseHostAction() {
            super(Localizer.getString("BrowseHost"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Search.BrowseHost"), Localizer.getString("TTTBrowseHost"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            RemoteFile rfile = SearchResultsPanel.this.getSelectedRemoteFile(false);
            if (rfile == null) {
                return;
            }
            if (!rfile.getQueryHitHost().isBrowseHostSupported()) {
                return;
            }
            GUIActionPerformer.browseHost(rfile.getHostAddress());
        }

        public void refreshActionState() {
            RemoteFile rfile;
            if (SearchResultsPanel.this.searchTreeTable.getSelectedRowCount() == 1 && (rfile = SearchResultsPanel.this.getSelectedRemoteFile(false)) != null && rfile.getQueryHitHost().isBrowseHostSupported()) {
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }
    }

    private class ChatToHostAction
    extends FWAction {
        public ChatToHostAction() {
            super(Localizer.getString("ChatToHost"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Search.Chat"), Localizer.getString("TTTChatToHost"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            RemoteFile rfile = SearchResultsPanel.this.getSelectedRemoteFile(false);
            if (rfile == null) {
                return;
            }
            if (!rfile.getQueryHitHost().isChatSupported()) {
                return;
            }
            GUIActionPerformer.chatToHost(rfile.getHostAddress());
        }

        public void refreshActionState() {
            RemoteFile rfile;
            if (SearchResultsPanel.this.searchTreeTable.getSelectedRowCount() == 1 && (rfile = SearchResultsPanel.this.getSelectedRemoteFile(false)) != null && rfile.getQueryHitHost().isChatSupported()) {
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }
    }

    private class ViewBitziTicketAction
    extends FWAction {
        public ViewBitziTicketAction() {
            super(Localizer.getString("ViewBitziTicket"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Search.ViewBitzi"), Localizer.getString("TTTViewBitziTicket"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            block3: {
                RemoteFile rfile = SearchResultsPanel.this.getSelectedRemoteFile(true);
                if (rfile == null) {
                    return;
                }
                String url = URLUtil.buildBitziLookupURL(rfile.getURN());
                try {
                    BrowserLauncher.openURL(url);
                }
                catch (IOException exp) {
                    NLogger.warn(ViewBitziTicketAction.class, (Object)exp, (Throwable)exp);
                    Object[] dialogOptions = new Object[]{Localizer.getString("Yes"), Localizer.getString("No")};
                    int choice = JOptionPane.showOptionDialog(SearchResultsPanel.this.searchTab, Localizer.getString("FailedToLaunchBrowserURLInClipboard"), Localizer.getString("FailedToLaunchBrowser"), 0, 2, null, dialogOptions, Localizer.getString("Yes"));
                    if (choice != 0) break block3;
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(url), null);
                }
            }
        }

        public void refreshActionState() {
            if (SearchResultsPanel.this.searchTreeTable.getSelectedRowCount() == 1) {
                RemoteFile rfile = SearchResultsPanel.this.getSelectedRemoteFile(true);
                if (rfile != null && rfile.getURN() != null) {
                    this.setEnabled(true);
                    return;
                }
            } else {
                this.setEnabled(false);
            }
        }
    }

    private class SWConfigDownloadAction
    extends FWAction {
        public SWConfigDownloadAction() {
            super(Localizer.getString("Download"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Search.ConfigDownload"), Localizer.getString("TTTDownload"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            RemoteFile[] rfiles = SearchResultsPanel.this.getSelectedRemoteFiles(true);
            for (int i = 0; i < rfiles.length; ++i) {
                SWDownloadFile downloadFile = SearchResultsPanel.this.downloadService.getDownloadFile(rfiles[i].getFileSize(), rfiles[i].getURN());
                if (downloadFile != null) {
                    downloadFile.addDownloadCandidate(rfiles[i]);
                    rfiles[i].setInDownloadQueue(true);
                    continue;
                }
                DownloadConfigDialog dialog = new DownloadConfigDialog(rfiles[i]);
                dialog.setVisible(true);
            }
        }

        public void refreshActionState() {
            if (SearchResultsPanel.this.searchTreeTable.getSelectedRow() < 0) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    private class SWQuickDownloadAction
    extends FWAction {
        public SWQuickDownloadAction() {
            super(Localizer.getString("QuickDownload"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Search.Download"), Localizer.getString("TTTQuickDownload"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            final RemoteFile[] rfiles = SearchResultsPanel.this.getSelectedRemoteFiles(true);
            Runnable runner = new Runnable(){

                public void run() {
                    try {
                        for (int i = 0; i < rfiles.length; ++i) {
                            rfiles[i].setInDownloadQueue(true);
                            SWDownloadFile downloadFile = SearchResultsPanel.this.downloadService.getDownloadFile(rfiles[i].getFileSize(), rfiles[i].getURN());
                            if (downloadFile != null) {
                                downloadFile.addDownloadCandidate(rfiles[i]);
                                continue;
                            }
                            RemoteFile dfile = new RemoteFile(rfiles[i]);
                            String searchTerm = StringUtils.createNaturalSearchTerm(dfile.getFilename());
                            SearchResultsPanel.this.downloadService.addFileToDownload(dfile, dfile.getFilename(), searchTerm);
                        }
                    }
                    catch (Throwable th) {
                        NLogger.error(SWQuickDownloadAction.class, (Object)th, th);
                    }
                }
            };
            Environment.getInstance().executeOnThreadPool(runner, "QuickDownloadAction");
        }

        public void refreshActionState() {
            if (SearchResultsPanel.this.searchTreeTable.getSelectedRow() < 0) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }
}

