/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.download;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import phex.download.swarming.SWDownloadFile;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.table.FWSortedTableModel;
import phex.gui.common.table.FWTable;
import phex.gui.tabs.download.DownloadTransferTableModel;
import phex.xml.sax.gui.DGuiSettings;
import phex.xml.sax.gui.DTable;

public class DownloadTransfersPanel
extends JPanel {
    private static final String TRANSFER_TABLE_IDENTIFIER = "TransferTable";
    private SWDownloadFile lastDownloadFile;
    private FWTable transferTable;
    private JScrollPane transferTableScrollPane;
    private DownloadTransferTableModel transferModel;

    public void initializeComponent(DGuiSettings guiSettings) {
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("fill:d:grow", "fill:d:grow");
        PanelBuilder tabBuilder = new PanelBuilder(layout, this);
        this.transferModel = new DownloadTransferTableModel();
        this.transferTable = new FWTable(new FWSortedTableModel(this.transferModel));
        GUIUtils.updateTableFromDGuiSettings(guiSettings, this.transferTable, TRANSFER_TABLE_IDENTIFIER);
        this.transferTable.activateAllHeaderActions();
        this.transferTable.setSelectionMode(0);
        this.transferTable.setAutoResizeMode(0);
        GUIRegistry.getInstance().getGuiUpdateTimer().addTable(this.transferTable);
        this.transferTableScrollPane = FWTable.createFWTableScrollPane(this.transferTable);
        tabBuilder.add((Component)this.transferTableScrollPane, cc.xy(1, 1));
        GUIUtils.adjustTableProgresssBarHeight(this.transferTable);
    }

    public void updateDownloadFile(SWDownloadFile file) {
        this.lastDownloadFile = file;
        this.transferModel.updateDownloadFile(file);
    }

    public void updateUI() {
        super.updateUI();
        if (this.transferTable != null) {
            GUIUtils.adjustTableProgresssBarHeight(this.transferTable);
        }
        if (this.transferTableScrollPane != null) {
            FWTable.updateFWTableScrollPane(this.transferTableScrollPane);
        }
    }

    public void appendDGuiSettings(DGuiSettings dSettings) {
        DTable dTable = GUIUtils.createDTable(this.transferTable, TRANSFER_TABLE_IDENTIFIER);
        dSettings.getTableList().getTableList().add(dTable);
    }
}

