/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import phex.common.URN;
import phex.common.log.NLogger;
import phex.download.MagnetData;
import phex.download.swarming.SwarmingManager;
import phex.gui.common.DialogBanner;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.HTMLMultiLinePanel;
import phex.servent.Servent;
import phex.share.SharedFilesService;
import phex.utils.InternalFileHandler;
import phex.utils.Localizer;

public class NewDownloadDialog
extends JDialog {
    public static final int URI_DOWNLOAD = 1;
    public static final int MAGMA_DOWNLOAD = 2;
    public static final int RSS_DOWNLOAD = 3;
    private JTextField uriTF;
    private JTextField magmaTF;
    private JTextField rssTF;
    private JTabbedPane downloadTabPane;

    public NewDownloadDialog() throws HeadlessException {
        super(GUIRegistry.getInstance().getMainFrame(), Localizer.getString("NewDownload_DialogTitle"), false);
        this.prepareComponent();
    }

    public NewDownloadDialog(String downloadValue, int type) throws HeadlessException {
        super(GUIRegistry.getInstance().getMainFrame(), Localizer.getString("NewDownload_DialogTitle"), false);
        this.prepareComponent();
        switch (type) {
            case 1: {
                this.uriTF.setText(downloadValue);
                this.downloadTabPane.setSelectedIndex(0);
                break;
            }
            case 2: {
                this.magmaTF.setText(downloadValue);
                this.downloadTabPane.setSelectedIndex(1);
                break;
            }
            case 3: {
                this.rssTF.setText(downloadValue);
                this.downloadTabPane.setSelectedIndex(2);
            }
        }
    }

    private void prepareComponent() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                NewDownloadDialog.this.closeDialog();
            }
        });
        CellConstraints cc = new CellConstraints();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel();
        contentPane.add((Component)contentPanel, "Center");
        FormLayout layout = new FormLayout("2dlu, fill:d:grow, 2dlu", "p, p, 2dlu, p, 6dlu, p, 3dlu, p 6dlu");
        PanelBuilder builder = new PanelBuilder(layout, contentPanel);
        DialogBanner banner = new DialogBanner(Localizer.getString("NewDownload_BannerHeader"), Localizer.getString("NewDownload_BannerSubHeader"));
        builder.add((Component)banner, cc.xywh(1, 1, 3, 1));
        builder.add((Component)new JSeparator(), cc.xywh(1, 2, 3, 1));
        this.downloadTabPane = new JTabbedPane();
        JPanel urlPanel = this.createByUrlPanel();
        this.downloadTabPane.addTab(Localizer.getString("NewDownload_ByUrl"), urlPanel);
        JPanel magmaPanel = this.createByMagmaPanel();
        this.downloadTabPane.addTab(Localizer.getString("NewDownload_ByMagmaFile"), magmaPanel);
        JPanel rssPanel = this.createByRSSPanel();
        this.downloadTabPane.addTab(Localizer.getString("NewDownload_ByRSSFile"), rssPanel);
        builder.add((Component)this.downloadTabPane, cc.xy(2, 4));
        builder.add((Component)new JSeparator(), cc.xywh(1, 6, 3, 1));
        JButton cancelBtn = new JButton(Localizer.getString("Cancel"));
        cancelBtn.addActionListener(new CancelBtnListener());
        JButton okBtn = new JButton(Localizer.getString("OK"));
        okBtn.addActionListener(new OkBtnListener());
        JPanel btnPanel = ButtonBarFactory.buildOKCancelBar(okBtn, cancelBtn);
        builder.add((Component)btnPanel, cc.xy(2, 8));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private JPanel createByUrlPanel() {
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("6dlu, d, 2dlu, d, fill:d:grow, 6dlu", "10dlu, p, 10dlu, p, 6dlu, p, 6dlu");
        JPanel panel = new JPanel();
        PanelBuilder builder = new PanelBuilder(layout, panel);
        JLabel label = new JLabel(Localizer.getString("NewDownload_UrlToDownload"));
        builder.add((Component)label, cc.xy(2, 2));
        this.uriTF = new JTextField(40);
        builder.add((Component)this.uriTF, cc.xywh(4, 2, 2, 1));
        builder.addSeparator(Localizer.getString("NewDownload_Examples"), cc.xywh(2, 4, 4, 1));
        JPanel examplesPanel = new JPanel();
        builder.add((Component)examplesPanel, cc.xywh(2, 6, 4, 1));
        FormLayout examplesLayout = new FormLayout("2dlu, d", "p, 3dlu, p");
        PanelBuilder examplesBuilder = new PanelBuilder(examplesLayout, examplesPanel);
        examplesBuilder.addLabel("http://www.host.com/path/file.zip", cc.xy(2, 1));
        examplesBuilder.addLabel("magnet:?xt=urn:sha1:AABBCCDDEEFFGGHHIIJJKKLLMMNNOOPP", cc.xy(2, 3));
        return panel;
    }

    private JPanel createByMagmaPanel() {
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("6dlu, d, 2dlu, d, fill:d:grow, 2dlu, d, 6dlu", "10dlu, p, 10dlu, p, 6dlu, p, 6dlu");
        JPanel panel = new JPanel();
        PanelBuilder builder = new PanelBuilder(layout, panel);
        JLabel label = new JLabel(Localizer.getString("NewDownload_MagmaFile"));
        builder.add((Component)label, cc.xy(2, 2));
        this.magmaTF = new JTextField(30);
        builder.add((Component)this.magmaTF, cc.xywh(4, 2, 2, 1));
        builder.addSeparator(Localizer.getString("NewDownload_CreatingMagma"), cc.xywh(2, 4, 7, 1));
        HTMLMultiLinePanel magmaHowTo = new HTMLMultiLinePanel(Localizer.getString("NewDownload_MagmaHowTo")){

            public Dimension getPreferredSize() {
                return new Dimension(0, super.getPreferredSize().height);
            }
        };
        builder.add((Component)magmaHowTo, cc.xywh(2, 6, 6, 1));
        JButton button = new JButton(Localizer.getString("NewDownload_Browse"));
        button.addActionListener(new SetDownlodDirectoryListener());
        builder.add((Component)button, cc.xy(7, 2));
        return panel;
    }

    private JPanel createByRSSPanel() {
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("6dlu, d, 2dlu, d, fill:d:grow, 2dlu, d, 6dlu", "10dlu, p, 10dlu, p, 6dlu, p, 6dlu");
        JPanel panel = new JPanel();
        PanelBuilder builder = new PanelBuilder(layout, panel);
        JLabel label = new JLabel(Localizer.getString("NewDownload_RSSFile"));
        builder.add((Component)label, cc.xy(2, 2));
        this.rssTF = new JTextField(30);
        builder.add((Component)this.rssTF, cc.xywh(4, 2, 2, 1));
        builder.addSeparator(Localizer.getString("NewDownload_CreatingRSS"), cc.xywh(2, 4, 7, 1));
        HTMLMultiLinePanel rssHowTo = new HTMLMultiLinePanel(Localizer.getString("NewDownload_RSSHowTo")){

            public Dimension getPreferredSize() {
                return new Dimension(0, super.getPreferredSize().height);
            }
        };
        builder.add((Component)rssHowTo, cc.xywh(2, 6, 6, 1));
        JButton button = new JButton(Localizer.getString("NewDownload_Browse"));
        button.addActionListener(new SetDownlodDirectoryListener());
        builder.add((Component)button, cc.xy(7, 2));
        return panel;
    }

    private void createNewDownload() throws URIException {
        SwarmingManager swarmingMgr = Servent.getInstance().getDownloadService();
        SharedFilesService shareService = Servent.getInstance().getSharedFilesService();
        String uriStr = this.uriTF.getText().trim();
        if (uriStr.length() == 0) {
            return;
        }
        URI uri = new URI(uriStr, true);
        String protocol = uri.getScheme();
        if ("magnet".equals(protocol)) {
            MagnetData magnetData = MagnetData.parseFromURI(uri);
            URN urn = MagnetData.lookupSHA1URN(magnetData);
            if (swarmingMgr.isURNDownloaded(urn)) {
                GUIUtils.showErrorMessage(Localizer.getString("NewDownload_AlreadyDownloadingMessage"), Localizer.getString("NewDownload_AlreadyDownloadingTitle"));
                return;
            }
            if (shareService.isURNShared(urn)) {
                GUIUtils.showErrorMessage(Localizer.getString("NewDownload_AlreadySharedMessage"), Localizer.getString("NewDownload_AlreadySharedTitle"));
                return;
            }
        }
        swarmingMgr.addFileToDownload(uri, true);
    }

    private void createNewMagmaDownload() {
        String magmaFileName = this.magmaTF.getText().trim();
        if (magmaFileName.length() == 0) {
            return;
        }
        File file = new File(magmaFileName);
        if (!file.exists()) {
            return;
        }
        InternalFileHandler.magmaReadout(file);
    }

    private void createNewRSSDownload() {
        String rssFileName = this.rssTF.getText().trim();
        if (rssFileName.length() == 0) {
            return;
        }
        File file = new File(rssFileName);
        if (!file.exists()) {
            return;
        }
        InternalFileHandler.rssReadout(file);
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    static class TransImageFilter
    extends RGBImageFilter {
        public static Icon createTransIcon(Icon icon) {
            TransImageFilter filter = new TransImageFilter();
            FilteredImageSource prod = new FilteredImageSource(((ImageIcon)icon).getImage().getSource(), filter);
            Image grayImage = Toolkit.getDefaultToolkit().createImage(prod);
            return new ImageIcon(grayImage);
        }

        public TransImageFilter() {
            this.canFilterIndexColorModel = true;
        }

        public int filterRGB(int x, int y, int rgb) {
            return rgb &= 0x33FFFFFF;
        }
    }

    private final class CancelBtnListener
    implements ActionListener {
        private CancelBtnListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                NewDownloadDialog.this.closeDialog();
            }
            catch (Throwable th) {
                NLogger.error(CancelBtnListener.class, (Object)th, th);
            }
        }
    }

    private final class OkBtnListener
    implements ActionListener {
        private OkBtnListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                NewDownloadDialog.this.createNewDownload();
                NewDownloadDialog.this.createNewMagmaDownload();
                NewDownloadDialog.this.createNewRSSDownload();
                NewDownloadDialog.this.closeDialog();
            }
            catch (URIException exp) {
                NLogger.error(OkBtnListener.class, (Object)exp, (Throwable)exp);
                GUIUtils.showErrorMessage(Localizer.getString("NewDownload_FailedToCreateDownloadMessage"), Localizer.getString("NewDownload_FailedToCreateDownloadTitle"));
            }
            catch (Throwable th) {
                NLogger.error(OkBtnListener.class, (Object)th, th);
            }
        }
    }

    private class SetDownlodDirectoryListener
    implements ActionListener {
        private SetDownlodDirectoryListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                JFileChooser chooser = new JFileChooser();
                chooser.setSelectedFile(new File(NewDownloadDialog.this.magmaTF.getText()));
                chooser.setSelectedFile(new File(NewDownloadDialog.this.rssTF.getText()));
                chooser.setAcceptAllFileFilterUsed(false);
                chooser.setFileSelectionMode(0);
                chooser.setMultiSelectionEnabled(false);
                chooser.setDialogTitle(Localizer.getString("NewDownload_SelectMagmaFile"));
                chooser.setApproveButtonText(Localizer.getString("Select"));
                chooser.setApproveButtonMnemonic(Localizer.getChar("SelectMnemonic"));
                int returnVal = chooser.showDialog(NewDownloadDialog.this, null);
                if (returnVal == 0) {
                    String directory = chooser.getSelectedFile().getAbsolutePath();
                    NewDownloadDialog.this.magmaTF.setText(directory);
                    NewDownloadDialog.this.rssTF.setText(directory);
                }
            }
            catch (Throwable th) {
                NLogger.error(SetDownlodDirectoryListener.class, (Object)th, th);
            }
        }
    }
}

