/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang.SystemUtils;
import phex.common.log.NLogger;
import phex.gui.common.BanneredDialog;
import phex.gui.common.GUIRegistry;
import phex.servent.Servent;
import phex.share.ShareFile;
import phex.share.SharedFilesService;
import phex.share.export.ExportEngine;
import phex.utils.FileUtils;
import phex.utils.IOUtil;
import phex.utils.Localizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportDialog
extends BanneredDialog {
    private static final int DEFAULT_HTML_INDEX = 0;
    private static final int DEFAULT_MAGMA_YAML_INDEX = 1;
    private static final int DEFAULT_METALINK_XML_INDEX = 2;
    private static final int DEFAULT_RSS_XML_INDEX = 3;
    private CloseEventHandler closeEventHandler;
    private JRadioButton standardExport;
    private JComboBox standardExportFormatCB;
    private JRadioButton customExport;
    private JTextField customExportFormatTF;
    private JRadioButton exportAllFiles;
    private JRadioButton exportSelectedFiles;
    private JTextField outputFileTF;
    private JCheckBox magnetInclXs;
    private JCheckBox magnetInclFreebase;
    private JButton browseCustomFormat;
    private JButton browseOutFile;
    private JButton okBtn;
    private JButton cancelBtn;
    private List<ShareFile> shareFileList;

    public ExportDialog() {
        this((List<ShareFile>)null);
    }

    public ExportDialog(List<ShareFile> selectionList) {
        super(GUIRegistry.getInstance().getMainFrame(), Localizer.getString("ExportDialog_DialogTitle"), false, Localizer.getString("ExportDialog_BannerHeader"), Localizer.getString("ExportDialog_BannerSubHeader"));
        this.shareFileList = selectionList;
        this.initContent();
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void initContent() {
        if (this.shareFileList == null || this.shareFileList.isEmpty()) {
            this.exportAllFiles.setSelected(true);
            this.exportSelectedFiles.setEnabled(false);
            this.exportSelectedFiles.setText(Localizer.getFormatedString("ExportDialog_ExportSelectedFiles", 0));
        } else {
            this.exportSelectedFiles.setSelected(true);
            this.exportSelectedFiles.setText(Localizer.getFormatedString("ExportDialog_ExportSelectedFiles", this.shareFileList.size()));
        }
    }

    @Override
    protected JPanel createDialogContentPanel() {
        this.initComponents();
        JPanel contentPanel = new JPanel();
        FormLayout layout = new FormLayout("7dlu, d, 3dlu, fill:d:grow, 2dlu, d");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, contentPanel);
        builder.setLeadingColumnOffset(1);
        builder.appendSeparator(Localizer.getString("ExportDialog_ExportFormat"));
        builder.append(this.standardExport);
        builder.append(this.standardExportFormatCB);
        builder.nextLine();
        builder.append(this.customExport);
        builder.append(this.customExportFormatTF);
        builder.append(this.browseCustomFormat);
        builder.appendSeparator(Localizer.getString("ExportDialog_ExportSource"));
        builder.append((Component)this.exportAllFiles, 3);
        builder.nextLine();
        builder.append((Component)this.exportSelectedFiles, 3);
        builder.nextLine();
        builder.appendSeparator(Localizer.getString("ExportDialog_Output"));
        builder.append(Localizer.getString("ExportDialog_FileName"), (Component)this.outputFileTF, (Component)this.browseOutFile);
        builder.appendSeparator(Localizer.getString("ExportDialog_Options"));
        this.magnetInclXs = new JCheckBox(Localizer.getString("ExportDialog_MagnetIncludeXS"));
        this.magnetInclXs.setToolTipText(Localizer.getString("ExportDialog_TTTMagnetIncludeXS"));
        builder.append((Component)this.magnetInclXs, 3);
        builder.nextLine();
        builder.append((Component)this.magnetInclFreebase, 3);
        return contentPanel;
    }

    @Override
    protected JPanel createDialogButtonPanel() {
        JPanel btnPanel = ButtonBarFactory.buildOKCancelBar(this.okBtn, this.cancelBtn);
        return btnPanel;
    }

    private void initComponents() {
        this.closeEventHandler = new CloseEventHandler();
        this.addWindowListener(this.closeEventHandler);
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.insertElementAt(Localizer.getString("ExportDialog_DefaultHTMLExport"), 0);
        model.insertElementAt(Localizer.getString("ExportDialog_MagmaYAMLExport"), 1);
        model.insertElementAt(Localizer.getString("ExportDialog_MetalinkXMLExport"), 2);
        model.insertElementAt(Localizer.getString("ExportDialog_RSSXMLExport"), 3);
        this.standardExport = new JRadioButton(Localizer.getString("ExportDialog_StandardExportFormat"));
        this.standardExport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExportDialog.this.replaceFileExtForStandardExport();
            }
        });
        this.customExport = new JRadioButton(Localizer.getString("ExportDialog_CustomExportFormat"));
        this.customExport.setToolTipText(Localizer.getString("ExportDialog_TTTCustomExportFormat"));
        ButtonGroup exportFormatGroup = new ButtonGroup();
        exportFormatGroup.add(this.standardExport);
        exportFormatGroup.add(this.customExport);
        this.standardExport.setSelected(true);
        this.standardExportFormatCB = new JComboBox(model);
        this.standardExportFormatCB.addActionListener(new ExportTypeListener());
        this.customExportFormatTF = new JTextField(40);
        this.customExportFormatTF.setToolTipText(Localizer.getString("ExportDialog_TTTCustomExportFormat"));
        this.customExportFormatTF.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                ExportDialog.this.customExport.setSelected(true);
            }

            public void keyReleased(KeyEvent e) {
                ExportDialog.this.customExport.setSelected(true);
            }

            public void keyTyped(KeyEvent e) {
                ExportDialog.this.customExport.setSelected(true);
            }
        });
        this.browseCustomFormat = new JButton(Localizer.getString("ExportDialog_Browse"));
        this.browseCustomFormat.addActionListener(new BrowseCustomFileBtnListener());
        this.exportAllFiles = new JRadioButton(Localizer.getString("ExportDialog_ExportAllFiles"));
        this.exportSelectedFiles = new JRadioButton();
        ButtonGroup exportSourceGroup = new ButtonGroup();
        exportSourceGroup.add(this.exportAllFiles);
        exportSourceGroup.add(this.exportSelectedFiles);
        this.outputFileTF = new JTextField(40);
        File defOutFile = new File(SystemUtils.USER_HOME, "shared_files.html");
        this.outputFileTF.setText(defOutFile.getAbsolutePath());
        this.browseOutFile = new JButton(Localizer.getString("ExportDialog_Browse"));
        this.browseOutFile.addActionListener(new BrowseOutFileBtnListener());
        this.magnetInclXs = new JCheckBox(Localizer.getString("ExportDialog_MagnetIncludeXS"));
        this.magnetInclXs.setToolTipText(Localizer.getString("ExportDialog_TTTMagnetIncludeXS"));
        this.magnetInclFreebase = new JCheckBox(Localizer.getString("ExportDialog_MagnetIncludeFreebase"));
        this.magnetInclFreebase.setToolTipText(Localizer.getString("ExportDialog_TTTMagnetIncludeFreebase"));
        this.standardExportFormatCB.setSelectedIndex(0);
        this.okBtn = new JButton(Localizer.getString("OK"));
        this.okBtn.addActionListener(new OkBtnListener());
        this.cancelBtn = new JButton(Localizer.getString("Cancel"));
        this.cancelBtn.addActionListener(this.closeEventHandler);
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    private void replaceFileExtForStandardExport() {
        String filename = this.outputFileTF.getText();
        String ext = FileUtils.getFileExtension(filename);
        int idx = this.standardExportFormatCB.getSelectedIndex();
        switch (idx) {
            case 0: {
                if (ext.equals("htm") || ext.equals("html")) break;
                filename = FileUtils.replaceFileExtension(filename, "html");
                break;
            }
            case 1: {
                if (ext.equals("magma")) break;
                filename = FileUtils.replaceFileExtension(filename, "magma");
                break;
            }
            case 2: {
                if (ext.equals("metalink")) break;
                filename = FileUtils.replaceFileExtension(filename, "metalink");
                break;
            }
            case 3: {
                if (ext.equals("xml")) break;
                filename = FileUtils.replaceFileExtension(filename, "xml");
            }
        }
        this.outputFileTF.setText(filename);
    }

    private String ensureStandardExportFileExtension(String filename) {
        String ext = FileUtils.getFileExtension(filename);
        int idx = this.standardExportFormatCB.getSelectedIndex();
        switch (idx) {
            case 0: {
                if (ext.equals("htm") || ext.equals("html")) break;
                filename = filename + ".html";
                break;
            }
            case 1: {
                if (ext.equals("magma")) break;
                filename = filename + ".magma";
                break;
            }
            case 2: {
                if (ext.equals("metalink")) break;
                filename = filename + ".metalink";
                break;
            }
            case 3: {
                if (ext.equals("xml")) break;
                filename = filename + ".rss.xml";
            }
        }
        return filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startExport() {
        BufferedOutputStream outStream;
        InputStream inStream;
        block16: {
            block17: {
                String outFileName = this.outputFileTF.getText();
                File file = new File(outFileName);
                inStream = null;
                outStream = null;
                outStream = new BufferedOutputStream(new FileOutputStream(file));
                if (this.standardExport.isSelected()) {
                    int idx = this.standardExportFormatCB.getSelectedIndex();
                    switch (idx) {
                        case 0: {
                            inStream = ClassLoader.getSystemResourceAsStream("phex/resources/defaultSharedFilesHTMLExport.xsl");
                            break;
                        }
                        case 1: {
                            inStream = ClassLoader.getSystemResourceAsStream("phex/resources/magmaSharedFilesYAMLExport.xsl");
                            break;
                        }
                        case 2: {
                            inStream = ClassLoader.getSystemResourceAsStream("phex/resources/metalinkSharedFilesXMLExport.xsl");
                            break;
                        }
                        case 3: {
                            inStream = ClassLoader.getSystemResourceAsStream("phex/resources/rssSharedFilesXMLExport.xsl");
                        }
                    }
                    break block16;
                }
                if (!this.customExport.isSelected()) break block17;
                String styleFileName = this.customExportFormatTF.getText();
                File styleFile = new File(styleFileName);
                inStream = new BufferedInputStream(new FileInputStream(styleFile));
                break block16;
            }
            IOUtil.closeQuietly(inStream);
            IOUtil.closeQuietly(outStream);
            return;
        }
        try {
            List<ShareFile> exportData;
            HashMap<String, String> exportOptions = new HashMap<String, String>();
            if (this.magnetInclXs.isSelected()) {
                exportOptions.put("UseMagnetURLWithXS", "true");
            }
            if (this.magnetInclFreebase.isSelected()) {
                exportOptions.put("UseMagnetURLWithFreeBase", "true");
            }
            if (this.exportAllFiles.isSelected()) {
                SharedFilesService sharedFilesService = Servent.getInstance().getSharedFilesService();
                exportData = sharedFilesService.getSharedFiles();
            } else {
                exportData = this.shareFileList;
            }
            ExportEngine exportEngine = new ExportEngine(Servent.getInstance().getLocalAddress(), inStream, outStream, exportData, exportOptions);
            exportEngine.startExport();
        }
        catch (IOException exp) {
            try {
                NLogger.error(ExportDialog.class, (Object)exp, (Throwable)exp);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(inStream);
                IOUtil.closeQuietly(outStream);
                throw throwable;
            }
            IOUtil.closeQuietly(inStream);
            IOUtil.closeQuietly(outStream);
        }
        IOUtil.closeQuietly(inStream);
        IOUtil.closeQuietly(outStream);
    }

    private final class CloseEventHandler
    extends WindowAdapter
    implements ActionListener {
        private CloseEventHandler() {
        }

        public void windowClosing(WindowEvent evt) {
            ExportDialog.this.closeDialog();
        }

        public void actionPerformed(ActionEvent e) {
            ExportDialog.this.closeDialog();
        }
    }

    private final class ExportTypeListener
    implements ActionListener {
        private ExportTypeListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                ExportDialog.this.standardExport.setSelected(true);
                ExportDialog.this.replaceFileExtForStandardExport();
            }
            catch (Throwable th) {
                NLogger.error(ExportTypeListener.class, (Object)th, th);
            }
        }
    }

    private final class BrowseCustomFileBtnListener
    implements ActionListener {
        private BrowseCustomFileBtnListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                ExportDialog.this.customExport.setSelected(true);
                if (SystemUtils.IS_OS_MAC_OSX) {
                    FileDialog dia = new FileDialog((Frame)GUIRegistry.getInstance().getMainFrame(), Localizer.getString("ExportDialog_SelectCustomStyleFile"), 0);
                    dia.setVisible(true);
                    ExportDialog.this.customExportFormatTF.setText(dia.getDirectory() + dia.getFile());
                } else {
                    JFileChooser chooser = new JFileChooser();
                    chooser.setDialogTitle(Localizer.getString("ExportDialog_SelectCustomStyleFile"));
                    chooser.setFileSelectionMode(0);
                    chooser.setMultiSelectionEnabled(false);
                    chooser.setFileFilter(new FileFilter(){

                        public boolean accept(File file) {
                            return file.isDirectory() || FileUtils.getFileExtension(file).equalsIgnoreCase("XSL");
                        }

                        public String getDescription() {
                            return "XSL-Stylesheet";
                        }
                    });
                    int rc = chooser.showOpenDialog(ExportDialog.this);
                    if (rc == 0) {
                        File file = chooser.getSelectedFile();
                        ExportDialog.this.customExportFormatTF.setText(file.getAbsolutePath());
                    }
                }
            }
            catch (Throwable th) {
                NLogger.error(BrowseCustomFileBtnListener.class, (Object)th, th);
            }
        }
    }

    private final class BrowseOutFileBtnListener
    implements ActionListener {
        private BrowseOutFileBtnListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (SystemUtils.IS_OS_MAC_OSX) {
                    FileDialog dia = new FileDialog((Frame)GUIRegistry.getInstance().getMainFrame(), Localizer.getString("ExportDialog_SelectOutputFile"), 1);
                    dia.setVisible(true);
                    String filename = dia.getDirectory() + dia.getFile();
                    if (ExportDialog.this.standardExport.isSelected()) {
                        filename = ExportDialog.this.ensureStandardExportFileExtension(filename);
                    }
                    ExportDialog.this.outputFileTF.setText(filename);
                } else {
                    JFileChooser chooser = new JFileChooser();
                    chooser.setDialogTitle(Localizer.getString("ExportDialog_SelectOutputFile"));
                    chooser.setFileSelectionMode(0);
                    chooser.setMultiSelectionEnabled(false);
                    int rc = chooser.showSaveDialog(ExportDialog.this);
                    if (rc == 0) {
                        File file = chooser.getSelectedFile();
                        String filename = file.getAbsolutePath();
                        if (ExportDialog.this.standardExport.isSelected()) {
                            filename = ExportDialog.this.ensureStandardExportFileExtension(filename);
                        }
                        ExportDialog.this.outputFileTF.setText(filename);
                    }
                }
            }
            catch (Throwable th) {
                NLogger.error(BrowseOutFileBtnListener.class, (Object)th, th);
            }
        }
    }

    private final class OkBtnListener
    implements ActionListener {
        private OkBtnListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                ExportDialog.this.startExport();
                ExportDialog.this.closeDialog();
            }
            catch (Throwable th) {
                NLogger.error(OkBtnListener.class, (Object)th, th);
            }
        }
    }
}

