/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import phex.gui.common.GUIRegistry;
import phex.gui.common.PlainMultiLinePanel;
import phex.gui.prefs.InterfacePrefs;
import phex.gui.prefs.PhexGuiPrefs;
import phex.utils.Localizer;

public class CloseOptionsDialog
extends JDialog {
    private JRadioButton minimizeToBackgroundRBtn;
    private JRadioButton shutdownRBtn;
    private JCheckBox dontDisplayAgainChkBox;
    private boolean isOkActivated = false;

    public CloseOptionsDialog() {
        super(GUIRegistry.getInstance().getMainFrame(), Localizer.getString("CloseOptions"), true);
        this.prepareComponent();
    }

    private void prepareComponent() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                CloseOptionsDialog.this.closeDialog(false);
            }
        });
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel();
        contentPane.add((Component)contentPanel, "Center");
        FormLayout layout = new FormLayout("d:grow", "top:p:grow, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p");
        layout.setRowGroups(new int[][]{{3, 5, 9}});
        contentPanel.setLayout(layout);
        PanelBuilder builder = new PanelBuilder(layout, contentPanel);
        CellConstraints cc = new CellConstraints();
        builder.setDefaultDialogBorder();
        PlainMultiLinePanel label = new PlainMultiLinePanel(Localizer.getString("CloseOptionsText"));
        builder.add((Component)label, cc.xy(1, 1));
        String backgroundText = GUIRegistry.getInstance().getDesktopIndicator() != null ? Localizer.getString("MinimizeToSysTray") : Localizer.getString("MinimizeToBackground");
        this.minimizeToBackgroundRBtn = new JRadioButton(backgroundText, (boolean)InterfacePrefs.MinimizeToBackground.get());
        Font font = this.minimizeToBackgroundRBtn.getFont();
        Font newFont = font.deriveFont(1, font.getSize() + 1);
        this.minimizeToBackgroundRBtn.setFont(newFont);
        builder.add((Component)this.minimizeToBackgroundRBtn, cc.xy(1, 3));
        this.shutdownRBtn = new JRadioButton(Localizer.getString("Shutdown"), InterfacePrefs.MinimizeToBackground.get() == false);
        builder.add((Component)this.shutdownRBtn, cc.xy(1, 5));
        ButtonGroup group = new ButtonGroup();
        group.add(this.minimizeToBackgroundRBtn);
        group.add(this.shutdownRBtn);
        JSeparator separator = new JSeparator();
        builder.add((Component)separator, cc.xy(1, 7));
        ButtonBarBuilder btnBuilder = new ButtonBarBuilder();
        this.dontDisplayAgainChkBox = new JCheckBox(Localizer.getString("DontAskAnymore"));
        btnBuilder.addGridded(this.dontDisplayAgainChkBox);
        btnBuilder.addRelatedGap();
        btnBuilder.addGlue();
        ButtonActionHandler actionHandler = new ButtonActionHandler();
        JButton okButton = new JButton(Localizer.getString("OK"));
        okButton.setDefaultCapable(true);
        okButton.setRequestFocusEnabled(true);
        okButton.addActionListener(actionHandler);
        okButton.setActionCommand("OK");
        JButton cancelButton = new JButton(Localizer.getString("Cancel"));
        cancelButton.setRequestFocusEnabled(true);
        cancelButton.addActionListener(actionHandler);
        cancelButton.setActionCommand("CANCEL");
        btnBuilder.addGriddedButtons(new JButton[]{okButton, cancelButton});
        JPanel panel = btnBuilder.getPanel();
        builder.add((Component)panel, cc.xy(1, 9));
        this.setDefaultCloseOperation(2);
        this.getRootPane().setDefaultButton(okButton);
        this.getContentPane().validate();
        contentPanel.doLayout();
        contentPanel.revalidate();
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void closeDialog(boolean triggerSave) {
        boolean showDialog = !this.dontDisplayAgainChkBox.isSelected();
        InterfacePrefs.ShowCloseOptionsDialog.set(showDialog);
        PhexGuiPrefs.save(false);
        this.setVisible(false);
        this.dispose();
    }

    public boolean isOkActivated() {
        return this.isOkActivated;
    }

    private class ButtonActionHandler
    implements ActionListener {
        private ButtonActionHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            boolean triggerSave = false;
            if (e.getActionCommand().equals("OK")) {
                boolean minimizeToBackground = CloseOptionsDialog.this.minimizeToBackgroundRBtn.isSelected();
                if (minimizeToBackground != InterfacePrefs.MinimizeToBackground.get()) {
                    InterfacePrefs.MinimizeToBackground.set(minimizeToBackground);
                    triggerSave = true;
                }
                CloseOptionsDialog.this.isOkActivated = true;
            }
            CloseOptionsDialog.this.closeDialog(triggerSave);
        }
    }
}

