/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common.statusbar;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import phex.common.bandwidth.BandwidthManager;
import phex.common.log.NLogger;
import phex.download.swarming.SwarmingManager;
import phex.gui.common.GUIRegistry;
import phex.gui.common.statusbar.ConnectionsZone;
import phex.gui.common.statusbar.DownloadZone;
import phex.gui.common.statusbar.StatusBar;
import phex.gui.common.statusbar.UploadZone;
import phex.servent.Servent;

public class MainStatusBar
extends StatusBar {
    private final UpdateAction updateAction;

    public MainStatusBar() {
        BandwidthManager bandwidthService = Servent.getInstance().getBandwidthService();
        SwarmingManager downloadService = Servent.getInstance().getDownloadService();
        this.updateAction = new UpdateAction();
        this.addZone("ConnectionsZone", new ConnectionsZone(), "*");
        this.addZone("DownloadZone", new DownloadZone(downloadService, bandwidthService), "");
        this.addZone("UploadZone", new UploadZone(bandwidthService), "");
    }

    public void removeNotify() {
        super.removeNotify();
        GUIRegistry.getInstance().getGuiUpdateTimer().removeActionListener(this.updateAction);
    }

    public void addNotify() {
        super.addNotify();
        GUIRegistry.getInstance().getGuiUpdateTimer().addActionListener(this.updateAction);
    }

    private final class UpdateAction
    implements ActionListener {
        private UpdateAction() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                ((ConnectionsZone)MainStatusBar.this.getZone("ConnectionsZone")).updateZone();
                ((DownloadZone)MainStatusBar.this.getZone("DownloadZone")).updateZone();
                ((UploadZone)MainStatusBar.this.getZone("UploadZone")).updateZone();
            }
            catch (Throwable th) {
                NLogger.error(UpdateAction.class, (Object)th, th);
            }
        }
    }
}

