/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common.statusbar;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import phex.gui.common.GUIRegistry;
import phex.gui.common.IconPack;
import phex.host.HostManager;
import phex.host.NetworkHostsContainer;
import phex.servent.Servent;
import phex.utils.Localizer;

public class ConnectionsZone
extends JPanel {
    private final Servent servent;
    private NetworkHostsContainer hostsContainer;
    private JLabel connectionLabel;
    private Icon connectedIcon;
    private Icon firewalledIcon;
    private Icon disconnectedIcon;

    public ConnectionsZone() {
        SpringLayout layout = new SpringLayout();
        this.setLayout(layout);
        this.servent = Servent.getInstance();
        HostManager hostMgr = this.servent.getHostService();
        this.hostsContainer = hostMgr.getNetworkHostsContainer();
        this.connectionLabel = new JLabel();
        this.add(this.connectionLabel);
        this.updateZone();
        layout.putConstraint("North", (Component)this.connectionLabel, 2, "North", (Component)this);
        layout.putConstraint("West", (Component)this.connectionLabel, 5, "West", (Component)this);
        layout.putConstraint("East", (Component)this, 5, "East", (Component)this.connectionLabel);
        layout.putConstraint("South", (Component)this, 2, "South", (Component)this.connectionLabel);
        this.setupIcons();
    }

    private void setupIcons() {
        IconPack factory = GUIRegistry.getInstance().getPlafIconPack();
        this.connectedIcon = factory.getIcon("StatusBar.Connected");
        this.firewalledIcon = factory.getIcon("StatusBar.Firewalled");
        this.disconnectedIcon = factory.getIcon("StatusBar.Disconnected");
        this.connectionLabel.setIcon(this.disconnectedIcon);
    }

    public void updateZone() {
        int hostCount = this.hostsContainer.getTotalConnectionCount();
        if (hostCount > 0) {
            if (this.servent.isFirewalled()) {
                this.connectionLabel.setIcon(this.firewalledIcon);
            } else {
                this.connectionLabel.setIcon(this.connectedIcon);
            }
        } else {
            this.connectionLabel.setIcon(this.disconnectedIcon);
        }
        Object[] args = new Object[]{hostCount};
        String text = Localizer.getFormatedString("StatusBar_Connections", args);
        this.connectionLabel.setText(text);
        this.connectionLabel.setToolTipText(Localizer.getString("StatusBar_TTTConnections"));
        this.validate();
    }
}

