/*
 * Decompiled with CFR 0.152.
 */
package phex.download.swarming;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.bushe.swing.event.annotation.EventTopicSubscriber;
import phex.common.AddressCounter;
import phex.common.AltLocContainer;
import phex.common.AlternateLocation;
import phex.common.Environment;
import phex.common.FileHandlingException;
import phex.common.MediaType;
import phex.common.TransferDataProvider;
import phex.common.URN;
import phex.common.address.DestAddress;
import phex.common.address.MalformedDestAddressException;
import phex.common.bandwidth.BandwidthController;
import phex.common.file.FileManager;
import phex.common.file.ManagedFile;
import phex.common.file.ManagedFileException;
import phex.common.log.NLogger;
import phex.download.DownloadScope;
import phex.download.DownloadScopeList;
import phex.download.MagnetData;
import phex.download.MemoryFile;
import phex.download.RatedDownloadScopeList;
import phex.download.RemoteFile;
import phex.download.ThexVerificationData;
import phex.download.swarming.SWDownloadCandidate;
import phex.download.swarming.SWDownloadConstants;
import phex.download.swarming.SWDownloadInfo;
import phex.download.swarming.SWDownloadWorker;
import phex.download.swarming.SwarmingManager;
import phex.event.ChangeEvent;
import phex.event.ContainerEvent;
import phex.event.PhexEventService;
import phex.http.HTTPRangeSet;
import phex.net.repres.PresentationManager;
import phex.prefs.core.DownloadPrefs;
import phex.query.ResearchSetting;
import phex.servent.Servent;
import phex.statistic.SimpleStatisticProvider;
import phex.utils.FileUtils;
import phex.utils.StringUtils;
import phex.utils.URLUtil;
import phex.xml.sax.downloads.DDownloadCandidate;
import phex.xml.sax.downloads.DDownloadFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWDownloadFile
implements TransferDataProvider,
SWDownloadConstants {
    private static Random random = new Random();
    private final SwarmingManager downloadService;
    private final PhexEventService eventService;
    @NonNull
    private MemoryFile memoryFile;
    private AltLocContainer goodAltLocContainer;
    private AltLocContainer badAltLocContainer;
    private Object candidatesLock = new Object();
    private final List<SWDownloadCandidate> allCandidatesList;
    private final List<SWDownloadCandidate> goodCandidatesList;
    private final List<SWDownloadCandidate> mediumCandidatesList;
    private final List<SWDownloadCandidate> badCandidatesList;
    private final CandidateAllocator goodCandidateAllocator;
    private final CandidateAllocator mediumCandidateAllocator;
    private final CandidateAllocator badCandidateAllocator;
    private List<SWDownloadCandidate> transferCandidatesList;
    private Set<SWDownloadCandidate> queuedCandidatesSet;
    private Map<SWDownloadCandidate, SWDownloadWorker> allocatedCandidateWorkerMap;
    private int downloadingCandidateCount;
    private int queuedCandidateCount;
    private int connectingCandidateCount;
    private long lastCandidateWorkerCountUpdate;
    private static final int CANDIDATE_WORKER_COUNT_TIMEOUT = 2000;
    private long fileSize;
    private String fileName;
    private File destinationDirectory;
    private boolean isDestStreamable;
    private ManagedFile incompleteManagedFile;
    private Date createdDate;
    private Date modifiedDate;
    private int status;
    private long transferStartTime;
    private long transferStopTime;
    private Integer currentProgress;
    private short workerCount;
    private URN fileURN;
    private ResearchSetting researchSetting;
    private long previewSize;
    private BandwidthController bandwidthController;
    private ThexVerificationData thexVerificationData;

    private SWDownloadFile(SwarmingManager downloadService, PhexEventService eventService) {
        if (downloadService == null) {
            throw new NullPointerException("DownloadService is null.");
        }
        if (eventService == null) {
            throw new NullPointerException("eventService is null.");
        }
        this.downloadService = downloadService;
        this.eventService = eventService;
        eventService.processAnnotations(this);
        this.allCandidatesList = new ArrayList<SWDownloadCandidate>();
        this.goodCandidatesList = new ArrayList<SWDownloadCandidate>();
        this.mediumCandidatesList = new ArrayList<SWDownloadCandidate>();
        this.badCandidatesList = new ArrayList<SWDownloadCandidate>();
        this.transferCandidatesList = new ArrayList<SWDownloadCandidate>();
        this.queuedCandidatesSet = new HashSet<SWDownloadCandidate>();
        this.allocatedCandidateWorkerMap = new LinkedMap();
        this.goodCandidateAllocator = new CandidateAllocator(this.goodCandidatesList);
        this.mediumCandidateAllocator = new CandidateAllocator(this.mediumCandidatesList);
        this.badCandidateAllocator = new CandidateAllocator(this.badCandidatesList);
        this.downloadingCandidateCount = 0;
        this.queuedCandidateCount = 0;
        this.connectingCandidateCount = 0;
        this.lastCandidateWorkerCountUpdate = 0L;
        this.currentProgress = 0;
        this.createdDate = this.modifiedDate = new Date(System.currentTimeMillis());
        this.thexVerificationData = new ThexVerificationData();
        this.status = 1;
        this.bandwidthController = downloadService.createBandwidthControllerFor(this);
    }

    public SWDownloadFile(String filename, String searchString, long aFileSize, URN aFileURN, SwarmingManager swMgr, PhexEventService eventService) {
        this(swMgr, eventService);
        this.initialize(filename, aFileURN, aFileSize, searchString, true);
        try {
            this.initIncompleteFile();
        }
        catch (FileHandlingException exp) {
            NLogger.error(SWDownloadFile.class, (Object)exp, (Throwable)exp);
        }
        catch (ManagedFileException exp) {
            NLogger.error(SWDownloadFile.class, (Object)exp, (Throwable)exp);
        }
    }

    public SWDownloadFile(URI downloadUri, SwarmingManager swMgr, PhexEventService eventService) throws URIException {
        this(swMgr, eventService);
        String protocol = downloadUri.getScheme();
        if ("magnet".equals(protocol)) {
            MagnetData magnetData = MagnetData.parseFromURI(downloadUri);
            URN urn = MagnetData.lookupSHA1URN(magnetData);
            String magnetFileName = MagnetData.lookupFileName(magnetData);
            magnetFileName = FileUtils.convertToLocalSystemFilename(magnetFileName);
            String searchTerm = magnetData.getKeywordTopic() != null ? magnetData.getKeywordTopic() : StringUtils.createNaturalSearchTerm(MagnetData.lookupSearchName(magnetData));
            this.initialize(magnetFileName, urn, -1L, searchTerm, true);
            try {
                this.initIncompleteFile();
            }
            catch (FileHandlingException exp) {
                NLogger.error(SWDownloadFile.class, (Object)exp, (Throwable)exp);
            }
            catch (ManagedFileException exp) {
                NLogger.error(SWDownloadFile.class, (Object)exp, (Throwable)exp);
            }
            List<URI> urlList = MagnetData.lookupHttpURIs(magnetData);
            for (URI uri : urlList) {
                String host = uri.getHost();
                int port = uri.getPort();
                if (port == -1) {
                    port = 80;
                }
                try {
                    DestAddress address = PresentationManager.getInstance().createHostAddress(host, port);
                    SWDownloadCandidate candidate = new SWDownloadCandidate(address, uri, this, this.downloadService.getCandidateLogBuffer());
                    this.addDownloadCandidate(candidate);
                }
                catch (MalformedDestAddressException e) {
                    throw new URIException("URI contained a malformed destination address.");
                }
            }
            if (urn != null || this.getCandidatesCount() == 0) {
                this.startSearchForCandidates();
            }
        } else {
            String uriFileName = URLUtil.getFileNameFromUri(downloadUri);
            uriFileName = FileUtils.convertToLocalSystemFilename(uriFileName);
            String searchTerm = StringUtils.createNaturalSearchTerm(uriFileName);
            this.initialize(uriFileName, null, -1L, searchTerm, true);
            try {
                this.initIncompleteFile();
            }
            catch (FileHandlingException exp) {
                NLogger.error(SWDownloadFile.class, (Object)exp, (Throwable)exp);
            }
            catch (ManagedFileException exp) {
                NLogger.error(SWDownloadFile.class, (Object)exp, (Throwable)exp);
            }
            String host = downloadUri.getHost();
            if (host != null) {
                int port = downloadUri.getPort();
                if (port == -1) {
                    port = 80;
                }
                try {
                    DestAddress address = PresentationManager.getInstance().createHostAddress(host, port);
                    SWDownloadCandidate candidate = new SWDownloadCandidate(address, downloadUri, this, this.downloadService.getCandidateLogBuffer());
                    this.addDownloadCandidate(candidate);
                }
                catch (MalformedDestAddressException e) {
                    throw new URIException("URI contained a malformed destination address.");
                }
            }
        }
    }

    public SWDownloadFile(DDownloadFile dFile, SwarmingManager swMgr, PhexEventService eventService) {
        this(swMgr, eventService);
        String destDir;
        URN fileUrn = null;
        if (dFile.getFileURN() != null) {
            fileUrn = new URN(dFile.getFileURN());
        }
        if (!StringUtils.isEmpty(destDir = dFile.getDestinationDirectory())) {
            this.destinationDirectory = new File(destDir);
        }
        this.initialize(dFile.getLocalFileName(), fileUrn, dFile.getFileSize(), dFile.getSearchTerm(), false);
        String incompleteFileName = dFile.getIncompleteFileName();
        if (!StringUtils.isEmpty(incompleteFileName)) {
            try {
                this.incompleteManagedFile = FileManager.getInstance().getReadWriteManagedFile(new File(incompleteFileName));
            }
            catch (ManagedFileException exp) {
                NLogger.error(SWDownloadFile.class, (Object)exp, (Throwable)exp);
                this.incompleteManagedFile = null;
            }
        }
        this.setCreatedDate(new Date(dFile.getCreationTime()));
        this.setDownloadedDate(new Date(dFile.getModificationTime()));
        this.status = dFile.getStatus();
        this.memoryFile.createDownloadScopes(dFile);
        this.createDownloadCandidates(dFile);
        this.verifyStatus();
        if (this.isFileCompletedOrMoved() && this.isFileCompleted() && this.memoryFile.getFinishedLength() == 0L) {
            this.setStatus(6);
        }
    }

    private void initialize(String fileName, URN aFileURN, long aFileSize, String searchTerm, boolean createSegments) {
        this.fileName = fileName;
        this.updateDestinationStreamable();
        if (aFileURN != null) {
            this.fileURN = aFileURN;
            this.initAltLocContainers();
        }
        this.fileSize = aFileSize;
        this.previewSize = this.fileSize / 10L;
        this.researchSetting = new ResearchSetting(this, Servent.getInstance());
        this.researchSetting.setSearchTerm(searchTerm);
        this.memoryFile = this.downloadService.createMemoryFile(this);
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
        this.memoryFile.updateFileSize();
        this.previewSize = fileSize / 10L;
    }

    public boolean isScopeAllocateable(DownloadScopeList candidateScopeList) {
        return this.memoryFile.isMissingScopeAllocateable(candidateScopeList);
    }

    @CheckForNull
    public SWDownloadCandidate allocateDownloadCandidate(SWDownloadWorker worker, AddressCounter addressCounter) {
        int val = random.nextInt(10);
        if (val < 6) {
            return this.allocateDownloadCandidate(worker, addressCounter, this.goodCandidateAllocator, this.mediumCandidateAllocator, this.badCandidateAllocator);
        }
        if (val < 9) {
            return this.allocateDownloadCandidate(worker, addressCounter, this.mediumCandidateAllocator, this.badCandidateAllocator, this.goodCandidateAllocator);
        }
        return this.allocateDownloadCandidate(worker, addressCounter, this.badCandidateAllocator, this.mediumCandidateAllocator, this.goodCandidateAllocator);
    }

    @CheckForNull
    private SWDownloadCandidate allocateDownloadCandidate(SWDownloadWorker worker, AddressCounter addressCounter, CandidateAllocator ... candidateAllocators) {
        for (int i = 0; i < candidateAllocators.length; ++i) {
            SWDownloadCandidate candidate = candidateAllocators[i].allocate(worker, addressCounter);
            if (candidate == null) continue;
            return candidate;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseDownloadCandidate(SWDownloadCandidate candidate) {
        Object object = this.candidatesLock;
        synchronized (object) {
            this.downloadService.releaseCandidateAddress(candidate);
            NLogger.debug(SWDownloadFile.class, (Object)("Release allocation " + candidate + "."));
            this.allocatedCandidateWorkerMap.remove(candidate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public List<SWDownloadCandidate> getAllocatedCandidates() {
        Object object = this.candidatesLock;
        synchronized (object) {
            ArrayList<SWDownloadCandidate> list = new ArrayList<SWDownloadCandidate>(this.allocatedCandidateWorkerMap.size());
            list.addAll(this.allocatedCandidateWorkerMap.keySet());
            return list;
        }
    }

    public boolean addDownloadCandidate(RemoteFile remoteFile) {
        SWDownloadCandidate candidate = new SWDownloadCandidate(remoteFile, this, this.downloadService.getCandidateLogBuffer());
        return this.addDownloadCandidate(candidate);
    }

    public boolean addDownloadCandidate(AlternateLocation altLoc) {
        URN altLocURN = altLoc.getURN();
        if (this.fileURN != null && !altLocURN.equals(this.fileURN)) {
            NLogger.debug(SWDownloadFile.class, (Object)"AlternateLocation URN does not match!");
            return false;
        }
        DestAddress hostAddress = altLoc.getHostAddress();
        if (hostAddress.isLocalHost()) {
            return false;
        }
        SWDownloadCandidate candidate = new SWDownloadCandidate(hostAddress, 0L, null, altLocURN, this, this.downloadService.getCandidateLogBuffer());
        return this.addDownloadCandidate(candidate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addDownloadCandidate(SWDownloadCandidate candidate) {
        int pos;
        URN candidateURN = candidate.getResourceURN();
        if (this.fileURN == null && candidateURN != null) {
            this.fileURN = candidateURN;
            this.initAltLocContainers();
        }
        if (this.fileURN != null && candidateURN != null && !this.fileURN.equals(candidateURN)) {
            NLogger.debug(SWDownloadFile.class, (Object)"Candidate URN to add does not match!");
            return false;
        }
        Object object = this.candidatesLock;
        synchronized (object) {
            if (this.allCandidatesList.contains(candidate)) {
                return false;
            }
            NLogger.debug(SWDownloadFile.class, (Object)("Adding download candidate " + candidate));
            pos = this.allCandidatesList.size();
            this.allCandidatesList.add(candidate);
            this.mediumCandidatesList.add(candidate);
        }
        this.fireDownloadCandidateAdded(candidate, pos);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markCandidateGood(SWDownloadCandidate candidate) {
        if (candidate == null) {
            throw new NullPointerException("Candidate is null.");
        }
        Object object = this.candidatesLock;
        synchronized (object) {
            int pos = this.badCandidatesList.indexOf(candidate);
            if (pos >= 0) {
                this.badCandidatesList.remove(pos);
            }
            if ((pos = this.mediumCandidatesList.indexOf(candidate)) >= 0) {
                this.mediumCandidatesList.remove(pos);
            }
            if (!this.goodCandidatesList.contains(candidate)) {
                this.goodCandidatesList.add(candidate);
                NLogger.debug(SWDownloadFile.class, (Object)("Moving candidate to good list: " + candidate.getHostAddress()));
                candidate.addToCandidateLog("Moving candidate to good list.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markCandidateMedium(SWDownloadCandidate candidate) {
        if (candidate == null) {
            throw new NullPointerException("Candidate is null.");
        }
        Object object = this.candidatesLock;
        synchronized (object) {
            int pos = this.badCandidatesList.indexOf(candidate);
            if (pos >= 0) {
                this.badCandidatesList.remove(pos);
            }
            if ((pos = this.goodCandidatesList.indexOf(candidate)) >= 0) {
                this.goodCandidatesList.remove(pos);
            }
            if (!this.mediumCandidatesList.contains(candidate)) {
                this.mediumCandidatesList.add(candidate);
                NLogger.debug(SWDownloadFile.class, (Object)("Moving candidate to medium list: " + candidate.getHostAddress()));
                candidate.addToCandidateLog("Moving candidate to medium list.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markCandidateBad(SWDownloadCandidate candidate) {
        if (candidate == null) {
            throw new NullPointerException("Candidate is null.");
        }
        Object object = this.candidatesLock;
        synchronized (object) {
            int pos = this.goodCandidatesList.indexOf(candidate);
            if (pos >= 0) {
                this.goodCandidatesList.remove(pos);
            }
            if ((pos = this.mediumCandidatesList.indexOf(candidate)) >= 0) {
                this.mediumCandidatesList.remove(pos);
            }
            if (!this.badCandidatesList.contains(candidate)) {
                this.badCandidatesList.add(candidate);
                NLogger.debug(SWDownloadFile.class, (Object)("Moving candidate to bad list: " + candidate.getHostAddress()));
                candidate.addToCandidateLog("Moving candidate to bad list.");
            }
        }
        candidate.setStatus(SWDownloadCandidate.CandidateStatus.BAD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markCandidateIgnored(SWDownloadCandidate candidate, String reason) {
        if (candidate == null) {
            throw new NullPointerException("Candidate is null.");
        }
        Object object = this.candidatesLock;
        synchronized (object) {
            int pos = this.goodCandidatesList.indexOf(candidate);
            if (pos >= 0) {
                this.goodCandidatesList.remove(pos);
            }
            if ((pos = this.mediumCandidatesList.indexOf(candidate)) >= 0) {
                this.mediumCandidatesList.remove(pos);
            }
            if (!this.badCandidatesList.contains(candidate)) {
                this.badCandidatesList.add(candidate);
                NLogger.debug(SWDownloadFile.class, (Object)("Moving candidate to bad list: " + candidate.getHostAddress()));
                candidate.addToCandidateLog("Moving candidate to bad list (ignoring).");
            }
        }
        candidate.setStatus(SWDownloadCandidate.CandidateStatus.IGNORED, -1, reason);
    }

    @EventTopicSubscriber(topic="phex:download/candidate/status")
    public void onCandidateStatusChange(String topic, ChangeEvent event) {
        SWDownloadCandidate candidate = (SWDownloadCandidate)event.getSource();
        if (this != candidate.getDownloadFile()) {
            return;
        }
        switch ((SWDownloadCandidate.CandidateStatus)((Object)event.getOldValue())) {
            case CONNECTING: 
            case PUSH_REQUEST: 
            case REMOTLY_QUEUED: 
            case REQUESTING: 
            case DOWNLOADING: {
                this.transferCandidatesList.remove(candidate);
                break;
            }
        }
        switch ((SWDownloadCandidate.CandidateStatus)((Object)event.getNewValue())) {
            case CONNECTING: 
            case PUSH_REQUEST: 
            case REMOTLY_QUEUED: 
            case REQUESTING: 
            case DOWNLOADING: {
                this.transferCandidatesList.add(candidate);
                break;
            }
        }
    }

    public void addBadAltLoc(SWDownloadCandidate candidate) {
        URN candidateURN = candidate.getResourceURN();
        if (candidateURN != null && this.fileURN != null) {
            AlternateLocation altLoc = new AlternateLocation(candidate.getHostAddress(), candidateURN);
            this.goodAltLocContainer.removeAlternateLocation(altLoc);
            this.badAltLocContainer.addAlternateLocation(altLoc);
        }
        NLogger.debug(SWDownloadFile.class, (Object)("Adding bad alt loc: " + candidate.getHostAddress()));
    }

    public void addGoodAltLoc(SWDownloadCandidate candidate) {
        URN candidateURN = candidate.getResourceURN();
        if (candidateURN != null && this.fileURN != null) {
            AlternateLocation altLoc = new AlternateLocation(candidate.getHostAddress(), candidateURN);
            this.badAltLocContainer.removeAlternateLocation(altLoc);
            this.goodAltLocContainer.addAlternateLocation(altLoc);
        }
        NLogger.debug(SWDownloadFile.class, (Object)("Adding good alt loc: " + candidate.getHostAddress()));
    }

    public BandwidthController getBandwidthController() {
        return this.bandwidthController;
    }

    public void setDownloadThrottlingRate(int speedInBytes) {
        this.bandwidthController.setThrottlingRate(speedInBytes);
    }

    public long getDownloadThrottlingRate() {
        return this.bandwidthController.getThrottlingRate();
    }

    public long getTransferSpeed() {
        return this.bandwidthController.getShortTransferAvg().getAverage();
    }

    public int getCandidatesCount() {
        return this.allCandidatesList.size();
    }

    public int getDownloadingCandidatesCount() {
        this.updateCandidateWorkerCounts();
        return this.downloadingCandidateCount;
    }

    public int getQueuedCandidatesCount() {
        this.updateCandidateWorkerCounts();
        return this.queuedCandidateCount;
    }

    public int getConnectingCandidatesCount() {
        this.updateCandidateWorkerCounts();
        return this.connectingCandidateCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCandidateWorkerCounts() {
        Object object = this.candidatesLock;
        synchronized (object) {
            long now = System.currentTimeMillis();
            if (this.lastCandidateWorkerCountUpdate + 2000L > now) {
                return;
            }
            int downloadingCount = 0;
            int queuedCount = 0;
            int connectingCount = 0;
            for (SWDownloadCandidate candidate : this.transferCandidatesList) {
                SWDownloadCandidate.CandidateStatus candStatus = candidate.getStatus();
                switch (candStatus) {
                    case DOWNLOADING: {
                        ++downloadingCount;
                        break;
                    }
                    case REMOTLY_QUEUED: {
                        ++queuedCount;
                        break;
                    }
                    case CONNECTING: {
                        ++connectingCount;
                    }
                }
            }
            this.queuedCandidateCount = queuedCount;
            this.downloadingCandidateCount = downloadingCount;
            this.connectingCandidateCount = connectingCount;
            this.lastCandidateWorkerCountUpdate = System.currentTimeMillis();
        }
    }

    public int getGoodCandidateCount() {
        return this.goodCandidatesList.size();
    }

    public int getBadCandidateCount() {
        return this.badCandidatesList.size();
    }

    public SWDownloadCandidate getCandidate(int index) {
        if (index < 0 || index >= this.allCandidatesList.size()) {
            return null;
        }
        return this.allCandidatesList.get(index);
    }

    public AltLocContainer getGoodAltLocContainer() {
        return this.goodAltLocContainer;
    }

    public AltLocContainer getBadAltLocContainer() {
        return this.badAltLocContainer;
    }

    public int getTransferCandidateCount() {
        return this.transferCandidatesList.size();
    }

    public SWDownloadCandidate getTransferCandidate(int index) {
        if (index < 0 || index >= this.transferCandidatesList.size()) {
            return null;
        }
        return this.transferCandidatesList.get(index);
    }

    public URN getFileURN() {
        return this.fileURN;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    protected void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public Date getDownloadedDate() {
        return this.modifiedDate;
    }

    protected void setDownloadedDate(Date modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    public MemoryFile getMemoryFile() {
        return this.memoryFile;
    }

    public ThexVerificationData getThexVerificationData() {
        return this.thexVerificationData;
    }

    public HTTPRangeSet createAvailableRangeSet() {
        HTTPRangeSet rangeSet = new HTTPRangeSet();
        List<DownloadScope> finishedScopes = this.memoryFile.getFinishedScopeListCopy();
        for (DownloadScope scope : finishedScopes) {
            rangeSet.addRange(scope.getStart(), scope.getEnd());
        }
        return rangeSet;
    }

    public ResearchSetting getResearchSetting() {
        return this.researchSetting;
    }

    public void startSearchForCandidates() {
        if (this.isFileCompletedOrMoved()) {
            return;
        }
        this.researchSetting.stopSearch();
        this.researchSetting.startSearch(300000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(int newStatus) {
        if (this.status == newStatus) {
            return;
        }
        Object object = this.candidatesLock;
        synchronized (object) {
            NLogger.debug(SWDownloadFile.class, (Object)("DownloadFile Status: " + SWDownloadInfo.getDownloadFileStatusString(newStatus) + " (" + newStatus + ")."));
            switch (newStatus) {
                case 3: {
                    SimpleStatisticProvider provider = (SimpleStatisticProvider)Servent.getInstance().getStatisticsService().getStatisticProvider("SessionDownloadCountProvider");
                    provider.increment(1);
                    this.researchSetting.stopSearch();
                }
                case 1: 
                case 4: {
                    this.downloadStopNotify();
                    break;
                }
                case 2: {
                    this.downloadStartNotify();
                    break;
                }
                case 6: {
                    Servent.getInstance().getEventService().publish("phex:download/file/completed", this);
                }
            }
            this.status = newStatus;
        }
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isAbleToBeAllocated() {
        return !this.isDownloadStopped() && !this.isFileCompletedOrMoved() && this.workerCount <= DownloadPrefs.MaxWorkerPerDownload.get();
    }

    public void incrementWorkerCount() {
        this.workerCount = (short)(this.workerCount + 1);
    }

    public void decrementWorkerCount() {
        this.workerCount = (short)(this.workerCount - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyStatus() {
        if (!this.isFileCompletedOrMoved() && this.memoryFile.getDownloadedLength() == this.getTotalDataSize()) {
            this.memoryFile.requestBufferWriting();
            return;
        }
        Object object = this.candidatesLock;
        synchronized (object) {
            Iterator<SWDownloadCandidate> iterator = this.allocatedCandidateWorkerMap.keySet().iterator();
            SWDownloadCandidate.CandidateStatus highestStatus = SWDownloadCandidate.CandidateStatus.WAITING;
            while (iterator.hasNext() && highestStatus != SWDownloadCandidate.CandidateStatus.DOWNLOADING) {
                SWDownloadCandidate candidate = iterator.next();
                switch (candidate.getStatus()) {
                    case DOWNLOADING: {
                        highestStatus = SWDownloadCandidate.CandidateStatus.DOWNLOADING;
                        break;
                    }
                    case REMOTLY_QUEUED: {
                        highestStatus = SWDownloadCandidate.CandidateStatus.REMOTLY_QUEUED;
                    }
                }
            }
            if (!this.isDownloadStopped() && !this.isFileCompletedOrMoved()) {
                switch (highestStatus) {
                    case REMOTLY_QUEUED: {
                        this.setStatus(5);
                        break;
                    }
                    case DOWNLOADING: {
                        this.setStatus(2);
                        break;
                    }
                    default: {
                        this.setStatus(1);
                    }
                }
            }
        }
    }

    public boolean isFileCompleted() {
        return this.status == 3;
    }

    public boolean isFileCompletedMoved() {
        return this.status == 6;
    }

    public boolean isFileCompletedOrMoved() {
        return this.status == 6 || this.status == 3;
    }

    public boolean isDownloadInProgress() {
        return this.status == 2;
    }

    public boolean isDownloadStopped() {
        return this.status == 4;
    }

    public ManagedFile getIncompleteDownloadFile() throws ManagedFileException, FileHandlingException {
        this.initIncompleteFile();
        return this.incompleteManagedFile;
    }

    public boolean isDestinationStreamable() {
        return this.isDestStreamable;
    }

    private void updateDestinationStreamable() {
        this.isDestStreamable = MediaType.getStreamableMediaType().isFilenameOf(this.getFileName());
    }

    public File getDestinationDirectory() {
        return this.destinationDirectory;
    }

    public void setDestinationDirectory(File directory) {
        this.destinationDirectory = directory;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        if (StringUtils.isEmpty(fileName)) {
            throw new IllegalArgumentException("Empty file name not allowed: " + fileName);
        }
        this.fileName = fileName;
        this.updateDestinationStreamable();
    }

    public File getDestinationFile() {
        if (this.destinationDirectory == null) {
            return new File(DownloadPrefs.DestinationDirectory.get(), this.fileName);
        }
        return new File(this.destinationDirectory, this.fileName);
    }

    public File getPreviewFile() {
        if (this.isFileCompletedOrMoved()) {
            return this.getDestinationFile();
        }
        if (!this.memoryFile.isFileBeginningAvailable()) {
            return null;
        }
        long previewLength = this.memoryFile.getFileBeginningScopeLength();
        StringBuffer fullFileNameBuf = new StringBuffer();
        fullFileNameBuf.append(DownloadPrefs.IncompleteDirectory.get());
        fullFileNameBuf.append(File.separatorChar);
        fullFileNameBuf.append("PREVIEW");
        fullFileNameBuf.append("-");
        fullFileNameBuf.append(this.fileName);
        File previewFile = new File(fullFileNameBuf.toString());
        previewFile.deleteOnExit();
        try {
            FileUtils.copyFile(this.incompleteManagedFile.getFile(), previewFile, previewLength);
            return previewFile;
        }
        catch (IOException exp) {
            return null;
        }
    }

    public boolean isPreviewPossible() {
        if (this.isFileCompletedOrMoved()) {
            return true;
        }
        return this.memoryFile.isFileBeginningAvailable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void moveToDestinationFile() {
        if (this.isFileCompletedMoved()) {
            return;
        }
        if (this.memoryFile.getMissingLength() > 0L && this.status == 3) {
            throw new RuntimeException("There should be no missing length (found " + this.memoryFile.getMissingLength() + ") and the download must be completed to move to destination file '" + this.fileName + "'");
        }
        File destFile = this.getDestinationFile();
        try {
            this.getIncompleteDownloadFile().acquireFileLock();
            try {
                this.getIncompleteDownloadFile().closeFile();
                int tryCount = 0;
                while (destFile.exists()) {
                    ++tryCount;
                    StringBuffer newName = new StringBuffer();
                    newName.append(destFile.getParent());
                    newName.append(File.separatorChar);
                    newName.append('(');
                    newName.append(tryCount);
                    newName.append(") ");
                    newName.append(this.fileName);
                    destFile = new File(newName.toString());
                }
                NLogger.debug(SWDownloadFile.class, (Object)("Renaming final segment from " + this.getIncompleteDownloadFile().getAbsolutePath() + " to " + destFile.getAbsoluteFile() + "."));
                this.getIncompleteDownloadFile().renameFile(destFile);
                this.setStatus(6);
                if (DownloadPrefs.AutoRemoveCompleted.get().booleanValue()) {
                    this.downloadService.removeDownloadFile(this);
                } else {
                    this.downloadService.notifyDownloadListChange();
                }
            }
            finally {
                this.getIncompleteDownloadFile().releaseFileLock();
            }
        }
        catch (FileHandlingException exp) {
            NLogger.warn(SWDownloadFile.class, (Object)("Failed renaming from " + this.incompleteManagedFile.getAbsolutePath() + " to " + destFile.getAbsolutePath() + "."), (Throwable)exp);
            NLogger.error(SWDownloadFile.class, (Object)exp, (Throwable)exp);
        }
        catch (ManagedFileException exp) {
            if (exp.getCause() instanceof InterruptedException) {
                NLogger.debug(SWDownloadFile.class, (Object)exp);
            }
            if (exp.getCause() instanceof FileHandlingException) {
                NLogger.warn(SWDownloadFile.class, (Object)("Failed renaming from " + this.incompleteManagedFile.getAbsolutePath() + " to " + destFile.getAbsolutePath() + "."), (Throwable)exp);
                NLogger.error(SWDownloadFile.class, (Object)exp, (Throwable)exp);
            }
            NLogger.error(SWDownloadFile.class, (Object)exp, (Throwable)exp);
        }
    }

    public Integer getProgress() {
        long tmpTransferDataSize;
        int percentage = this.isFileCompletedOrMoved() ? 100 : ((tmpTransferDataSize = this.fileSize) == -1L || tmpTransferDataSize == 0L ? -1 : (int)(this.getTransferredDataSize() * 100L / tmpTransferDataSize));
        if (this.currentProgress != percentage) {
            this.currentProgress = percentage;
        }
        return this.currentProgress;
    }

    public void startDownload() {
        this.setStatus(1);
        this.verifyStatus();
        this.downloadService.notifyWaitingWorkers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopDownload(SWDownloadCandidate candidate) {
        SWDownloadWorker worker;
        Object object = this.candidatesLock;
        synchronized (object) {
            worker = this.allocatedCandidateWorkerMap.get(candidate);
        }
        if (worker != null) {
            worker.stopWorker();
            worker.waitTillFinished();
        }
    }

    public void stopDownload() {
        this.setStatus(4);
        this.stopAllWorkers(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopAllWorkers(boolean waitTillFinished) {
        SWDownloadWorker[] workers;
        Object object = this.candidatesLock;
        synchronized (object) {
            Collection<SWDownloadWorker> workerColl = this.allocatedCandidateWorkerMap.values();
            workers = new SWDownloadWorker[workerColl.size()];
            workerColl.toArray(workers);
            for (int i = 0; i < workers.length; ++i) {
                SWDownloadWorker worker = workers[i];
                worker.stopWorker();
            }
        }
        if (!waitTillFinished) {
            return;
        }
        for (int i = 0; i < workers.length; ++i) {
            SWDownloadWorker worker = workers[i];
            if (!worker.isInsideCriticalSection()) continue;
            worker.waitTillFinished();
        }
    }

    public void removeIncompleteDownloadFile() {
        if (this.isFileCompletedOrMoved()) {
            return;
        }
        if (this.status != 4) {
            NLogger.error(SWDownloadFile.class, (Object)"Can't clean temp files of not stopped download file.");
            return;
        }
        this.stopAllWorkers(true);
        if (this.incompleteManagedFile != null) {
            try {
                this.incompleteManagedFile.deleteFile();
            }
            catch (ManagedFileException exp) {
                NLogger.error(SWDownloadFile.class, (Object)exp, (Throwable)exp);
            }
        }
    }

    private void downloadStartNotify() {
        this.transferStartTime = System.currentTimeMillis();
        this.modifiedDate = new Date(this.transferStartTime);
        this.transferStopTime = 0L;
    }

    private void downloadStopNotify() {
        if (this.transferStopTime == 0L) {
            this.transferStopTime = System.currentTimeMillis();
            if (this.status == 2) {
                this.modifiedDate = new Date(this.transferStopTime);
            }
        }
        this.downloadService.notifyDownloadListChange();
        if (this.incompleteManagedFile != null) {
            try {
                this.getIncompleteDownloadFile().closeFile();
            }
            catch (FileHandlingException exp) {
                NLogger.error(SWDownloadFile.class, (Object)exp, (Throwable)exp);
            }
            catch (ManagedFileException exp) {
                if (exp.getCause() instanceof InterruptedException) {
                    NLogger.debug(SWDownloadFile.class, (Object)exp);
                }
                NLogger.error(SWDownloadFile.class, (Object)exp, (Throwable)exp);
            }
        }
    }

    public RatedDownloadScopeList getRatedScopeList() {
        return this.memoryFile.getRatedScopeList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rateDownloadScopeList(RatedDownloadScopeList ratedScopeList) {
        long oldestConnectTime = System.currentTimeMillis() - 10800000L;
        Object object = this.candidatesLock;
        synchronized (object) {
            for (SWDownloadCandidate candidate : this.goodCandidatesList) {
                if (candidate.getLastConnectionTime() == 0L || candidate.getLastConnectionTime() < oldestConnectTime) continue;
                DownloadScopeList availableScopeList = candidate.getAvailableScopeList();
                if (availableScopeList == null) {
                    availableScopeList = new DownloadScopeList();
                    availableScopeList.add(new DownloadScope(0L, this.fileSize - 1L));
                }
                ratedScopeList.rateDownloadScopeList(availableScopeList, candidate.getSpeed());
            }
        }
    }

    public DownloadScope allocateDownloadScope(DownloadScopeList candidateScopeList, long preferredSegmentSize, long speed) {
        boolean retry;
        DownloadScope result = null;
        do {
            retry = false;
            if (this.fileSize != -1L) {
                result = this.allocateSegmentForRangeSet(candidateScopeList, preferredSegmentSize);
                NLogger.debug(SWDownloadFile.class, (Object)("Allocated: " + result));
                continue;
            }
            result = this.allocateSegment(preferredSegmentSize);
            NLogger.debug(SWDownloadFile.class, (Object)("Allocated: " + result));
        } while (retry);
        return result;
    }

    private DownloadScope allocateSegment(long preferredSize) {
        return this.memoryFile.allocateMissingScope(preferredSize);
    }

    private DownloadScope allocateSegmentForRangeSet(DownloadScopeList candidateScopeList, long preferredSize) {
        assert (this.fileSize != -1L) : "Cant allocate segment for range set with unknown end.";
        NLogger.debug(SWDownloadFile.class, (Object)("allocateSegmentForRangeSet() size: " + preferredSize));
        if (candidateScopeList == null) {
            candidateScopeList = new DownloadScopeList();
            candidateScopeList.add(new DownloadScope(0L, this.fileSize - 1L));
        }
        return this.memoryFile.allocateMissingScopeForCandidate(candidateScopeList, preferredSize);
    }

    public void releaseDownloadScope(DownloadScope downloadScope, long transferredSize, SWDownloadCandidate downloadCandidate) {
        this.memoryFile.releaseAllocatedScope(downloadScope, transferredSize, downloadCandidate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAndValidateQueuedCandidate(SWDownloadCandidate candidate) {
        int maxWorkers = Math.min(DownloadPrefs.MaxTotalDownloadWorker.get(), DownloadPrefs.MaxWorkerPerDownload.get());
        int maxQueuedWorkers = (int)Math.max(Math.floor((double)maxWorkers - (double)maxWorkers * 0.2), 1.0);
        Object object = this.candidatesLock;
        synchronized (object) {
            int queuedCount = this.queuedCandidatesSet.size();
            if (queuedCount < maxQueuedWorkers) {
                candidate.addToCandidateLog("Accept queued candidate (" + queuedCount + "/" + maxQueuedWorkers + ")");
                this.queuedCandidatesSet.add(candidate);
                return true;
            }
            if (this.queuedCandidatesSet.contains(candidate)) {
                return true;
            }
            SWDownloadCandidate highestCandidate = null;
            int highestPos = -1;
            for (SWDownloadCandidate altCandidate : this.queuedCandidatesSet) {
                int altPos = altCandidate.getXQueueParameters().getPosition();
                if (altPos <= highestPos) continue;
                highestCandidate = altCandidate;
                highestPos = altPos;
            }
            int candidatePos = candidate.getXQueueParameters().getPosition();
            if (highestCandidate != null && highestPos > candidatePos) {
                highestCandidate.addToCandidateLog("Drop queued candidate - new alternative: " + highestPos + " - " + candidatePos + ")");
                highestCandidate.setStatus(SWDownloadCandidate.CandidateStatus.BUSY, Math.min(15, candidatePos) * 60);
                SWDownloadWorker worker = this.allocatedCandidateWorkerMap.get(highestCandidate);
                if (worker != null) {
                    worker.stopWorker();
                }
                this.queuedCandidatesSet.add(candidate);
                return true;
            }
            candidate.addToCandidateLog("Drop queued candidate - existing alternative: " + candidatePos + " - " + highestPos);
            candidate.setStatus(SWDownloadCandidate.CandidateStatus.BUSY, Math.min(15, candidatePos) * 60);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQueuedCandidate(SWDownloadCandidate candidate) {
        Object object = this.candidatesLock;
        synchronized (object) {
            this.queuedCandidatesSet.remove(candidate);
        }
    }

    private void initAltLocContainers() {
        this.goodAltLocContainer = new AltLocContainer(this.fileURN);
        this.badAltLocContainer = new AltLocContainer(this.fileURN);
    }

    private void initIncompleteFile() throws FileHandlingException, ManagedFileException {
        if (this.incompleteManagedFile != null) {
            return;
        }
        try {
            this.incompleteManagedFile = FileManager.getInstance().getReadWriteManagedFile(SWDownloadFile.createIncompleteFile(this.fileName));
        }
        catch (FileHandlingException exp) {
            String filename = exp.getFileName();
            Throwable cause = exp.getCause();
            String errorStr = cause != null ? cause.toString() : "Unknown";
            this.stopDownload();
            Environment.getInstance().fireDisplayUserMessage("SegmentCreateIncompleteFileFailed", new String[]{filename, errorStr});
            throw exp;
        }
    }

    public static File createIncompleteFile(String fileName) throws FileHandlingException {
        File tryFile;
        boolean succ;
        int tryCount = 0;
        IOException lastExp = null;
        do {
            StringBuffer incFileNameBuf = new StringBuffer();
            incFileNameBuf.append("INCOMPLETE");
            if (tryCount > 0) {
                incFileNameBuf.append('(');
                incFileNameBuf.append(String.valueOf(tryCount));
                incFileNameBuf.append(')');
            }
            incFileNameBuf.append("-");
            incFileNameBuf.append(fileName);
            String incFileName = FileUtils.convertToLocalSystemFilename(incFileNameBuf.toString());
            tryFile = new File(DownloadPrefs.IncompleteDirectory.get(), incFileName);
            tryFile.getParentFile().mkdirs();
            ++tryCount;
            try {
                succ = tryFile.createNewFile();
            }
            catch (IOException exp) {
                lastExp = exp;
                succ = false;
            }
        } while (!succ && tryCount < 50);
        if (lastExp != null) {
            NLogger.error(SWDownloadFile.class, (Object)tryFile.getAbsolutePath());
            NLogger.error(SWDownloadFile.class, (Object)lastExp, (Throwable)lastExp);
        }
        if (!succ) {
            NLogger.error(SWDownloadFile.class, (Object)("Tryied " + tryCount + " times to create a segment file. Giving up"));
            throw new FileHandlingException(2, tryFile.getAbsolutePath(), lastExp);
        }
        return tryFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDownloadCandidates(DDownloadFile dFile) {
        Object object = this.candidatesLock;
        synchronized (object) {
            long before24h = System.currentTimeMillis() - 86400000L;
            this.allCandidatesList.clear();
            this.goodCandidatesList.clear();
            this.mediumCandidatesList.clear();
            this.badCandidatesList.clear();
            Iterator<DDownloadCandidate> iterator = dFile.getCandidateList().getSubElementList().iterator();
            while (iterator.hasNext()) {
                try {
                    DDownloadCandidate dCandidate = iterator.next();
                    SWDownloadCandidate candidate = new SWDownloadCandidate(dCandidate, this, this.downloadService.getCandidateLogBuffer());
                    NLogger.debug(SWDownloadFile.class, (Object)("Adding download candidate " + candidate));
                    int pos = this.allCandidatesList.size();
                    this.allCandidatesList.add(candidate);
                    this.fireDownloadCandidateAdded(candidate, pos);
                    if (dCandidate.getConnectionFailedRepetition() >= 3) {
                        this.badCandidatesList.add(candidate);
                        continue;
                    }
                    if (dCandidate.getLastConnectionTime() > before24h) {
                        this.goodCandidatesList.add(candidate);
                        continue;
                    }
                    this.mediumCandidatesList.add(candidate);
                }
                catch (MalformedDestAddressException exp) {
                    NLogger.warn(SWDownloadFile.class, (Object)exp, (Throwable)exp);
                }
                catch (Exception exp) {
                    NLogger.error(SWDownloadFile.class, (Object)"Error loading a download candidate from XML.", (Throwable)exp);
                }
            }
            Collections.sort(this.goodCandidatesList, new InitialCandidatesComparator());
            Collections.sort(this.mediumCandidatesList, new InitialCandidatesComparator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DDownloadFile createDDownloadFile() {
        DDownloadFile dFile = new DDownloadFile();
        dFile.setLocalFileName(this.fileName);
        if (this.incompleteManagedFile != null) {
            dFile.setIncompleteFileName(this.incompleteManagedFile.getAbsolutePath());
        }
        if (this.destinationDirectory != null) {
            dFile.setDestinationDirectory(this.destinationDirectory.getAbsolutePath());
        }
        dFile.setFileSize(this.fileSize);
        dFile.setSearchTerm(this.researchSetting.getSearchTerm());
        dFile.setCreationTime(this.createdDate.getTime());
        dFile.setModificationTime(this.modifiedDate.getTime());
        if (this.fileURN != null) {
            dFile.setFileURN(this.fileURN.getAsString());
        }
        dFile.setStatus(this.status);
        Object object = this.candidatesLock;
        synchronized (object) {
            DDownloadCandidate xjbCandidate;
            List<DDownloadCandidate> list = dFile.getCandidateList().getSubElementList();
            for (SWDownloadCandidate candidate : this.goodCandidatesList) {
                xjbCandidate = candidate.createDDownloadCandidate();
                list.add(xjbCandidate);
            }
            for (SWDownloadCandidate candidate : this.mediumCandidatesList) {
                xjbCandidate = candidate.createDDownloadCandidate();
                list.add(xjbCandidate);
            }
            for (SWDownloadCandidate candidate : this.badCandidatesList) {
                if (candidate.getStatus() == SWDownloadCandidate.CandidateStatus.IGNORED) continue;
                xjbCandidate = candidate.createDDownloadCandidate();
                list.add(xjbCandidate);
            }
        }
        this.memoryFile.createXJBFinishedScopes(dFile);
        return dFile;
    }

    @Override
    public void setTransferRateTimestamp(long timestamp) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getShortTermTransferRate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getLongTermTransferRate() {
        return (int)this.getTransferSpeed();
    }

    @Override
    public short getDataTransferStatus() {
        switch (this.status) {
            case 2: {
                return 10;
            }
            case 3: 
            case 6: {
                return 12;
            }
        }
        return 11;
    }

    @Override
    public long getTransferDataSize() {
        return this.getTotalDataSize();
    }

    @Override
    public long getTotalDataSize() {
        return this.fileSize;
    }

    @Override
    public long getTransferredDataSize() {
        return this.memoryFile.getDownloadedLength();
    }

    private void fireDownloadCandidateAdded(SWDownloadCandidate candidate, int position) {
        this.eventService.publish("phex:download/candidate", new ContainerEvent(ContainerEvent.Type.ADDED, candidate, this, position));
    }

    private void fireDownloadCandidateRemoved(SWDownloadCandidate candidate, int position) {
        this.eventService.publish("phex:download/candidate", new ContainerEvent(ContainerEvent.Type.REMOVED, candidate, this, position));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InitialCandidatesComparator
    implements Comparator<SWDownloadCandidate> {
        private InitialCandidatesComparator() {
        }

        @Override
        public int compare(SWDownloadCandidate candidate1, SWDownloadCandidate candidate2) {
            if (candidate1 == candidate2 || candidate1.equals(candidate2)) {
                return 0;
            }
            long diff = candidate1.getLastConnectionTime() - candidate2.getLastConnectionTime();
            if (diff < 0L) {
                return 1;
            }
            if (diff > 0L) {
                return -1;
            }
            return candidate1.hashCode() - candidate2.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CandidateAllocator {
        private final List<SWDownloadCandidate> candidatesList;
        private int allocationIndex;

        public CandidateAllocator(List<SWDownloadCandidate> candidatesList) {
            this.candidatesList = candidatesList;
            this.allocationIndex = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SWDownloadCandidate allocate(SWDownloadWorker worker, AddressCounter addressCounter) {
            SWDownloadCandidate candidate = null;
            Object object = SWDownloadFile.this.candidatesLock;
            synchronized (object) {
                int numCandidates = this.candidatesList.size();
                if (numCandidates == 0) {
                    return null;
                }
                if (this.allocationIndex >= numCandidates) {
                    this.allocationIndex = 0;
                }
                for (int i = 0; i < numCandidates; ++i) {
                    int currentIndex = i + this.allocationIndex;
                    if (currentIndex >= numCandidates) {
                        currentIndex -= numCandidates;
                    }
                    if (!(candidate = this.candidatesList.get(currentIndex)).isAbleToBeAllocated() || SWDownloadFile.this.allocatedCandidateWorkerMap.containsKey(candidate)) continue;
                    boolean addrSucc = addressCounter.validateAndCountAddress(candidate.getHostAddress());
                    if (addrSucc) {
                        NLogger.debug(SWDownloadFile.class, (Object)("Allocating good candidate " + candidate + " from " + worker));
                        candidate.addToCandidateLog("Allocating as good candidate.");
                        SWDownloadFile.this.allocatedCandidateWorkerMap.put(candidate, worker);
                        this.allocationIndex = currentIndex + 1;
                        return candidate;
                    }
                    candidate.addToCandidateLog("Max downloads for candidate address already reached.");
                }
            }
            return null;
        }
    }
}

