/*
 * Decompiled with CFR 0.152.
 */
package phex.download;

import java.io.IOException;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import phex.common.address.DestAddress;
import phex.common.log.NLogger;
import phex.download.PushHandler;
import phex.http.HttpClientFactory;
import phex.msg.GUID;
import phex.msg.PushRequestMsg;
import phex.msghandling.MessageService;
import phex.net.repres.SocketFacade;
import phex.prefs.core.DownloadPrefs;
import phex.servent.Servent;
import phex.statistic.SimpleStatisticProvider;
import phex.statistic.StatisticsManager;

public class PushRequestSleeper {
    private final StatisticsManager statsService;
    private final MessageService msgService;
    private final DestAddress serventAddress;
    private final GUID clientGUID;
    private final long fileIndex;
    private final DestAddress[] pushProxyAddresses;
    private SocketFacade givenSocket;

    public PushRequestSleeper(Servent servent, GUID aClientGUID, long aFileIndex, DestAddress[] pushProxyAddresses) {
        this.statsService = servent.getStatisticsService();
        this.msgService = servent.getMessageService();
        this.serventAddress = servent.getLocalAddress();
        this.clientGUID = aClientGUID;
        this.fileIndex = aFileIndex;
        this.pushProxyAddresses = pushProxyAddresses;
    }

    public GUID getGUID() {
        return this.clientGUID;
    }

    public long getFileIndex() {
        return this.fileIndex;
    }

    public synchronized boolean acceptGIVConnection(SocketFacade aGivenSocket, GUID givenGUID) {
        if (!this.clientGUID.equals(givenGUID)) {
            return false;
        }
        this.givenSocket = aGivenSocket;
        this.notify();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SocketFacade requestSocketViaPush() {
        boolean succ = false;
        try {
            if (this.pushProxyAddresses != null && this.pushProxyAddresses.length > 0) {
                succ = this.requestViaPushProxies();
            }
            if (!succ) {
                succ = this.requestViaPushRoute();
            }
            if (!succ) {
                SocketFacade socketFacade = null;
                return socketFacade;
            }
            try {
                this.wait(DownloadPrefs.PushRequestTimeout.get().intValue());
            }
            catch (InterruptedException exp) {
                Thread.currentThread().interrupt();
            }
            if (this.givenSocket == null) {
                SocketFacade socketFacade = null;
                return socketFacade;
            }
            SocketFacade socketFacade = this.givenSocket;
            return socketFacade;
        }
        finally {
            PushHandler.unregisterPushRequestSleeper(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean requestViaPushProxies() {
        String requestPart = "/gnet/push-proxy?guid=" + this.clientGUID.toHexString();
        if (this.pushProxyAddresses.length > 0) {
            ((SimpleStatisticProvider)this.statsService.getStatisticProvider("PushDldPushProxyAttemptsProvider")).increment(1);
        }
        for (int i = 0; i < this.pushProxyAddresses.length; ++i) {
            String urlStr = "http://" + this.pushProxyAddresses[i].getFullHostName() + requestPart;
            NLogger.debug(PushRequestSleeper.class, (Object)("PUSH via push proxy: " + urlStr));
            HttpClient httpClient = HttpClientFactory.createHttpClient();
            httpClient.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(1, false));
            httpClient.getParams().setSoTimeout(10000);
            httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(5000);
            HeadMethod method = null;
            try {
                method = new HeadMethod(urlStr);
                method.addRequestHeader("X-Node", this.serventAddress.getFullHostName());
                method.addRequestHeader("Cache-Control", "no-cache");
                method.addRequestHeader("Connection", "close");
                int responseCode = httpClient.executeMethod((HttpMethod)method);
                NLogger.debug(PushRequestSleeper.class, (Object)("PUSH via push proxy response code: " + responseCode + " (" + urlStr + ")"));
                if (responseCode != 202) continue;
                ((SimpleStatisticProvider)this.statsService.getStatisticProvider("PushDldPushProxySuccessProvider")).increment(1);
                boolean bl = true;
                return bl;
            }
            catch (IOException exp) {
                NLogger.warn(PushRequestSleeper.class, (Object)exp);
                continue;
            }
            finally {
                if (method != null) {
                    method.releaseConnection();
                }
            }
        }
        return false;
    }

    private boolean requestViaPushRoute() {
        if (this.serventAddress.getIpAddress() == null) {
            NLogger.warn(PushRequestSleeper.class, (Object)"Local address has no IP to use for PUSH.");
            return false;
        }
        PushRequestMsg push = new PushRequestMsg(this.clientGUID, this.fileIndex, this.serventAddress);
        return this.msgService.routePushMessage(push);
    }
}

