/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import java.util.Vector;
import phex.common.ThreadTracking;
import phex.common.log.NLogger;

public class RunnerQueueWorker {
    private boolean isInterrupted;
    private boolean isPaused;
    private Vector<Runnable> queue;
    private Thread runnerThread;
    private int threadPriority;

    public RunnerQueueWorker() {
        this(5);
    }

    public RunnerQueueWorker(int threadPriority) {
        this.threadPriority = threadPriority;
        this.queue = new Vector();
        this.isInterrupted = false;
        this.isPaused = false;
    }

    public synchronized int getQueueSize() {
        return this.queue.size();
    }

    public synchronized void setPause(boolean state) {
        this.isPaused = state;
        this.notify();
    }

    public synchronized void stopAndClear() {
        this.queue.clear();
        if (this.runnerThread != null) {
            this.runnerThread.interrupt();
            this.isInterrupted = true;
        }
    }

    public synchronized void add(Runnable runable) {
        this.queue.add(runable);
        this.notify();
        if (this.runnerThread == null) {
            this.createRunner();
        }
    }

    private synchronized void createRunner() {
        this.isInterrupted = false;
        this.runnerThread = new Thread(ThreadTracking.rootThreadGroup, new QueueWorker());
        this.runnerThread.setPriority(5);
        this.runnerThread.setDaemon(true);
        this.runnerThread.start();
    }

    private class QueueWorker
    implements Runnable {
        private QueueWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                while (true) {
                    Runnable next = (Runnable)RunnerQueueWorker.this.queue.remove(0);
                    try {
                        next.run();
                    }
                    catch (Throwable th) {
                        NLogger.error(QueueWorker.class, (Object)th, th);
                    }
                    RunnerQueueWorker runnerQueueWorker = RunnerQueueWorker.this;
                    synchronized (runnerQueueWorker) {
                        if (!(RunnerQueueWorker.this.queue.isEmpty() || RunnerQueueWorker.this.isInterrupted || RunnerQueueWorker.this.isPaused)) {
                            continue;
                        }
                        try {
                            while (RunnerQueueWorker.this.isPaused) {
                                RunnerQueueWorker.this.wait(5000L);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (RunnerQueueWorker.this.queue.isEmpty() || RunnerQueueWorker.this.isInterrupted) break;
                    }
                }
                {
                    RunnerQueueWorker.this.runnerThread = null;
                }
            }
            catch (Throwable th) {
                RunnerQueueWorker.this.runnerThread = null;
                NLogger.error(QueueWorker.class, (Object)th, th);
            }
            if (!RunnerQueueWorker.this.queue.isEmpty()) {
                RunnerQueueWorker.this.createRunner();
            }
        }
    }
}

