/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import phex.common.LifeCycle;
import phex.common.log.NLogger;

public abstract class AbstractLifeCycle
implements LifeCycle {
    private Status status = Status.STOPPED;

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }

    public final void start() throws Exception {
        try {
            if (this.status == Status.STARTED) {
                return;
            }
            this.status = Status.STARTING;
            this.doStart();
            NLogger.debug(this.getClass(), (Object)"lifecycle started");
            this.status = Status.STARTED;
        }
        catch (Exception exp) {
            NLogger.error(this.getClass(), (Object)exp);
            this.status = Status.FAILED;
            throw exp;
        }
        catch (Error err) {
            NLogger.error(this.getClass(), (Object)err);
            this.status = Status.FAILED;
            throw err;
        }
    }

    public final void stop() throws Exception {
        try {
            if (this.status == Status.STOPPING || this.status == Status.STOPPED) {
                return;
            }
            this.status = Status.STOPPING;
            this.doStop();
            NLogger.debug(this.getClass(), (Object)"lifecycle stopped");
            this.status = Status.STOPPED;
        }
        catch (Exception exp) {
            NLogger.error(this.getClass(), (Object)exp);
            this.status = Status.FAILED;
            throw exp;
        }
        catch (Error err) {
            NLogger.error(this.getClass(), (Object)err);
            this.status = Status.FAILED;
            throw err;
        }
    }

    public boolean isRunning() {
        return this.status == Status.STARTED || this.status == Status.STARTING;
    }

    public boolean isStarted() {
        return this.status == Status.STARTED;
    }

    public boolean isStarting() {
        return this.status == Status.STARTING;
    }

    public boolean isStopping() {
        return this.status == Status.STOPPING;
    }

    public boolean isStopped() {
        return this.status == Status.STOPPED;
    }

    public boolean isFailed() {
        return this.status == Status.FAILED;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        STOPPED,
        STARTING,
        STARTED,
        STOPPING,
        FAILED;

    }
}

