/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.web;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.I2PAppContext;
import net.i2p.data.Base32;
import net.i2p.data.Certificate;
import net.i2p.data.Destination;
import net.i2p.data.PrivateKeyFile;
import net.i2p.data.SessionKey;
import net.i2p.i2ptunnel.TunnelController;
import net.i2p.i2ptunnel.TunnelControllerGroup;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.Log;

public class IndexBean {
    protected I2PAppContext _context = I2PAppContext.getGlobalContext();
    protected Log _log = this._context.logManager().getLog(IndexBean.class);
    protected TunnelControllerGroup _group = TunnelControllerGroup.getInstance();
    private String _action = null;
    private int _tunnel = -1;
    private long _prevNonce = -1L;
    private long _curNonce = -1L;
    private long _nextNonce;
    private String _passphrase;
    private String _type;
    private String _name;
    private String _description;
    private String _i2cpHost;
    private String _i2cpPort;
    private String _tunnelDepth;
    private String _tunnelQuantity;
    private String _tunnelVariance;
    private String _tunnelBackupQuantity;
    private boolean _connectDelay;
    private String _customOptions;
    private String _proxyList;
    private String _port;
    private String _reachableBy;
    private String _reachableByOther;
    private String _targetDestination;
    private String _targetHost;
    private String _targetPort;
    private String _spoofedHost;
    private String _privKeyFile;
    private String _profile;
    private boolean _startOnLoad;
    private boolean _sharedClient;
    private boolean _privKeyGenerate;
    private boolean _removeConfirmed;
    private Set<String> _booleanOptions;
    private Map<String, String> _otherOptions;
    private int _hashCashValue;
    private int _certType;
    private String _certSigner;
    public static final int RUNNING = 1;
    public static final int STARTING = 2;
    public static final int NOT_RUNNING = 3;
    public static final int STANDBY = 4;
    public static final String PROP_TUNNEL_PASSPHRASE = "i2ptunnel.passphrase";
    static final String PROP_NONCE = IndexBean.class.getName() + ".nonce";
    static final String CLIENT_NICKNAME = "shared clients";
    public static final String PROP_THEME_NAME = "routerconsole.theme";
    public static final String DEFAULT_THEME = "light";
    public static final String PROP_CSS_DISABLED = "routerconsole.css.disabled";
    public static final String PROP_JS_DISABLED = "routerconsole.javascript.disabled";
    private static final String[] _noShowOpts = new String[]{"inbound.length", "outbound.length", "inbound.lengthVariance", "outbound.lengthVariance", "inbound.backupQuantity", "outbound.backupQuantity", "inbound.quantity", "outbound.quantity", "inbound.nickname", "outbound.nickname", "i2p.streaming.connectDelay", "i2p.streaming.maxWindowSize"};
    private static final String[] _booleanClientOpts = new String[]{"i2cp.reduceOnIdle", "i2cp.closeOnIdle", "i2cp.newDestOnResume", "persistentClientKey", "i2cp.delayOpen"};
    private static final String[] _booleanServerOpts = new String[]{"i2cp.reduceOnIdle", "i2cp.encryptLeaseSet", "i2cp.enableAccessList"};
    private static final String[] _otherClientOpts = new String[]{"i2cp.reduceIdleTime", "i2cp.reduceQuantity", "i2cp.closeIdleTime"};
    private static final String[] _otherServerOpts = new String[]{"i2cp.reduceIdleTime", "i2cp.reduceQuantity", "i2cp.leaseSetKey", "i2cp.accessList"};
    protected static final Set _noShowSet = new HashSet();

    public IndexBean() {
        try {
            String nonce = System.getProperty(PROP_NONCE);
            if (nonce != null) {
                this._prevNonce = Long.parseLong(nonce);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this._nextNonce = this._context.random().nextLong();
        System.setProperty(PROP_NONCE, Long.toString(this._nextNonce));
        this._booleanOptions = new ConcurrentHashSet<String>(4);
        this._otherOptions = new ConcurrentHashMap<String, String>(4);
    }

    public long getNextNonce() {
        return this._nextNonce;
    }

    public void setNonce(String nonce) {
        if (nonce == null || nonce.trim().length() <= 0) {
            return;
        }
        try {
            this._curNonce = Long.parseLong(nonce);
        }
        catch (NumberFormatException nfe) {
            this._curNonce = -1L;
        }
    }

    public void setPassphrase(String phrase) {
        this._passphrase = phrase;
    }

    public void setAction(String action) {
        if (action == null || action.trim().length() <= 0) {
            return;
        }
        this._action = action;
    }

    public void setTunnel(String tunnel) {
        if (tunnel == null || tunnel.trim().length() <= 0) {
            return;
        }
        try {
            this._tunnel = Integer.parseInt(tunnel);
        }
        catch (NumberFormatException nfe) {
            this._tunnel = -1;
        }
    }

    private boolean validPassphrase(String proposed) {
        if (proposed == null) {
            return false;
        }
        String pass = this._context.getProperty(PROP_TUNNEL_PASSPHRASE);
        if (pass != null && pass.trim().length() > 0) {
            return pass.trim().equals(proposed.trim());
        }
        return false;
    }

    private String processAction() {
        if (this._action == null || this._action.trim().length() <= 0 || "Cancel".equals(this._action)) {
            return "";
        }
        if (this._prevNonce != this._curNonce && !this.validPassphrase(this._passphrase)) {
            return "Invalid form submission, probably because you used the 'back' or 'reload' button on your browser. Please resubmit.";
        }
        if ("Stop all".equals(this._action)) {
            return this.stopAll();
        }
        if ("Start all".equals(this._action)) {
            return this.startAll();
        }
        if ("Restart all".equals(this._action)) {
            return this.restartAll();
        }
        if ("Reload configuration".equals(this._action)) {
            return this.reloadConfig();
        }
        if ("stop".equals(this._action)) {
            return this.stop();
        }
        if ("start".equals(this._action)) {
            return this.start();
        }
        if ("Save changes".equals(this._action) || this._action.toLowerCase().indexOf("s</span>ave") >= 0) {
            return this.saveChanges();
        }
        if ("Delete this proxy".equals(this._action) || this._action.toLowerCase().indexOf("d</span>elete") >= 0) {
            return this.deleteTunnel();
        }
        if ("Estimate".equals(this._action)) {
            return PrivateKeyFile.estimateHashCashTime(this._hashCashValue);
        }
        if ("Modify".equals(this._action)) {
            return this.modifyDestination();
        }
        if ("Generate".equals(this._action)) {
            return this.generateNewEncryptionKey();
        }
        return "Action " + this._action + " unknown";
    }

    private String stopAll() {
        if (this._group == null) {
            return "";
        }
        List msgs = this._group.stopAllControllers();
        return this.getMessages(msgs);
    }

    private String startAll() {
        if (this._group == null) {
            return "";
        }
        List msgs = this._group.startAllControllers();
        return this.getMessages(msgs);
    }

    private String restartAll() {
        if (this._group == null) {
            return "";
        }
        List msgs = this._group.restartAllControllers();
        return this.getMessages(msgs);
    }

    private String reloadConfig() {
        if (this._group == null) {
            return "";
        }
        this._group.reloadControllers();
        return "Config reloaded";
    }

    private String start() {
        if (this._tunnel < 0) {
            return "Invalid tunnel";
        }
        List controllers = this._group.getControllers();
        if (this._tunnel >= controllers.size()) {
            return "Invalid tunnel";
        }
        TunnelController controller = (TunnelController)controllers.get(this._tunnel);
        controller.startTunnelBackground();
        return "";
    }

    private String stop() {
        if (this._tunnel < 0) {
            return "Invalid tunnel";
        }
        List controllers = this._group.getControllers();
        if (this._tunnel >= controllers.size()) {
            return "Invalid tunnel";
        }
        TunnelController controller = (TunnelController)controllers.get(this._tunnel);
        controller.stopTunnel();
        return "";
    }

    private String saveChanges() {
        TunnelController cur = this.getController(this._tunnel);
        Properties config = this.getConfig();
        if (config == null) {
            return "Invalid params";
        }
        if (cur == null) {
            cur = new TunnelController(config, "", true);
            this._group.addController(cur);
            if (cur.getStartOnLoad()) {
                cur.startTunnelBackground();
            }
        } else {
            cur.setConfig(config, "");
        }
        if ("true".equalsIgnoreCase(cur.getSharedClient()) && IndexBean.isClient(cur.getType())) {
            List controllers = this._group.getControllers();
            for (int i = 0; i < controllers.size(); ++i) {
                TunnelController c = (TunnelController)controllers.get(i);
                if (c == cur || !"true".equalsIgnoreCase(c.getSharedClient()) || !IndexBean.isClient(c.getType())) continue;
                Properties cOpt = c.getConfig("");
                if (this._tunnelQuantity != null) {
                    cOpt.setProperty("option.inbound.quantity", this._tunnelQuantity);
                    cOpt.setProperty("option.outbound.quantity", this._tunnelQuantity);
                }
                if (this._tunnelDepth != null) {
                    cOpt.setProperty("option.inbound.length", this._tunnelDepth);
                    cOpt.setProperty("option.outbound.length", this._tunnelDepth);
                }
                if (this._tunnelVariance != null) {
                    cOpt.setProperty("option.inbound.lengthVariance", this._tunnelVariance);
                    cOpt.setProperty("option.outbound.lengthVariance", this._tunnelVariance);
                }
                if (this._tunnelBackupQuantity != null) {
                    cOpt.setProperty("option.inbound.backupQuantity", this._tunnelBackupQuantity);
                    cOpt.setProperty("option.outbound.backupQuantity", this._tunnelBackupQuantity);
                }
                cOpt.setProperty("option.inbound.nickname", CLIENT_NICKNAME);
                cOpt.setProperty("option.outbound.nickname", CLIENT_NICKNAME);
                c.setConfig(cOpt, "");
            }
        }
        List msgs = this.doSave();
        msgs.add(0, "Changes saved");
        return this.getMessages(msgs);
    }

    private List doSave() {
        this._group.saveConfig();
        return this._group.clearAllMessages();
    }

    private String deleteTunnel() {
        if (!this._removeConfirmed) {
            return "Please confirm removal";
        }
        TunnelController cur = this.getController(this._tunnel);
        if (cur == null) {
            return "Invalid tunnel number";
        }
        List msgs = this._group.removeController(cur);
        msgs.addAll(this.doSave());
        return this.getMessages(msgs);
    }

    public String getMessages() {
        if (this._group == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder(512);
        if (this._action != null) {
            try {
                buf.append(this.processAction()).append("\n");
            }
            catch (Exception e) {
                this._log.log(50, "Error processing " + this._action, e);
            }
        }
        this.getMessages(this._group.clearAllMessages(), buf);
        return buf.toString();
    }

    public String getTheme() {
        String theme = this._context.getProperty(PROP_THEME_NAME, DEFAULT_THEME);
        return "/themes/console/" + theme + "/";
    }

    public boolean allowCSS() {
        String css = this._context.getProperty(PROP_CSS_DISABLED);
        return css == null;
    }

    public boolean allowJS() {
        String js = this._context.getProperty(PROP_JS_DISABLED);
        return js == null;
    }

    public int getTunnelCount() {
        if (this._group == null) {
            return 0;
        }
        return this._group.getControllers().size();
    }

    public boolean isClient(int tunnelNum) {
        TunnelController cur = this.getController(tunnelNum);
        if (cur == null) {
            return false;
        }
        return IndexBean.isClient(cur.getType());
    }

    public static boolean isClient(String type) {
        return "client".equals(type) || "httpclient".equals(type) || "sockstunnel".equals(type) || "connectclient".equals(type) || "streamrclient".equals(type) || "ircclient".equals(type);
    }

    public String getTunnelName(int tunnel) {
        TunnelController tun = this.getController(tunnel);
        if (tun != null && tun.getName() != null) {
            return tun.getName();
        }
        return "New Tunnel";
    }

    public String getClientPort(int tunnel) {
        TunnelController tun = this.getController(tunnel);
        if (tun != null && tun.getListenPort() != null) {
            return tun.getListenPort();
        }
        return "";
    }

    public String getTunnelType(int tunnel) {
        TunnelController tun = this.getController(tunnel);
        if (tun != null) {
            return this.getTypeName(tun.getType());
        }
        return "";
    }

    public String getTypeName(String internalType) {
        if ("client".equals(internalType)) {
            return "Standard client";
        }
        if ("httpclient".equals(internalType)) {
            return "HTTP client";
        }
        if ("ircclient".equals(internalType)) {
            return "IRC client";
        }
        if ("server".equals(internalType)) {
            return "Standard server";
        }
        if ("httpserver".equals(internalType)) {
            return "HTTP server";
        }
        if ("sockstunnel".equals(internalType)) {
            return "SOCKS 4/4a/5 proxy";
        }
        if ("connectclient".equals(internalType)) {
            return "CONNECT/SSL/HTTPS proxy";
        }
        if ("ircserver".equals(internalType)) {
            return "IRC server";
        }
        if ("streamrclient".equals(internalType)) {
            return "Streamr client";
        }
        if ("streamrserver".equals(internalType)) {
            return "Streamr server";
        }
        return internalType;
    }

    public String getInternalType(int tunnel) {
        TunnelController tun = this.getController(tunnel);
        if (tun != null) {
            return tun.getType();
        }
        return "";
    }

    public String getClientInterface(int tunnel) {
        TunnelController tun = this.getController(tunnel);
        if (tun != null) {
            return tun.getListenOnInterface();
        }
        return "";
    }

    public int getTunnelStatus(int tunnel) {
        TunnelController tun = this.getController(tunnel);
        if (tun == null) {
            return 3;
        }
        if (tun.getIsRunning()) {
            if (this.isClient(tunnel) && tun.getIsStandby()) {
                return 4;
            }
            return 1;
        }
        if (tun.getIsStarting()) {
            return 2;
        }
        return 3;
    }

    public String getTunnelDescription(int tunnel) {
        TunnelController tun = this.getController(tunnel);
        if (tun != null && tun.getDescription() != null) {
            return tun.getDescription();
        }
        return "";
    }

    public String getSharedClient(int tunnel) {
        TunnelController tun = this.getController(tunnel);
        if (tun != null) {
            return tun.getSharedClient();
        }
        return "";
    }

    public String getClientDestination(int tunnel) {
        TunnelController tun = this.getController(tunnel);
        if (tun == null) {
            return "";
        }
        String rv = "client".equals(tun.getType()) || "ircclient".equals(tun.getType()) || "streamrclient".equals(tun.getType()) ? tun.getTargetDestination() : tun.getProxyList();
        return rv != null ? rv : "";
    }

    public String getServerTarget(int tunnel) {
        TunnelController tun = this.getController(tunnel);
        if (tun != null) {
            return tun.getTargetHost() + ':' + tun.getTargetPort();
        }
        return "";
    }

    public String getDestinationBase64(int tunnel) {
        TunnelController tun = this.getController(tunnel);
        if (tun != null) {
            String rv = tun.getMyDestination();
            if (rv != null) {
                return rv;
            }
            String keyFile = tun.getPrivKeyFile();
            if (keyFile != null && keyFile.trim().length() > 0) {
                PrivateKeyFile pkf = new PrivateKeyFile(keyFile);
                try {
                    Destination d = pkf.getDestination();
                    if (d != null) {
                        return d.toBase64();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return "";
    }

    public String getDestHashBase32(int tunnel) {
        String rv;
        TunnelController tun = this.getController(tunnel);
        if (tun != null && (rv = tun.getMyDestHashBase32()) != null) {
            return rv;
        }
        return "";
    }

    public void setType(String type) {
        this._type = type != null ? type.trim() : null;
    }

    String getType() {
        return this._type;
    }

    public void setName(String name) {
        this._name = name != null ? name.trim() : null;
    }

    public void setDescription(String description) {
        this._description = description != null ? description.trim() : null;
    }

    public void setClientHost(String host) {
        this._i2cpHost = host != null ? host.trim() : null;
    }

    public void setClientport(String port) {
        this._i2cpPort = port != null ? port.trim() : null;
    }

    public void setTunnelDepth(String tunnelDepth) {
        this._tunnelDepth = tunnelDepth != null ? tunnelDepth.trim() : null;
    }

    public void setTunnelQuantity(String tunnelQuantity) {
        this._tunnelQuantity = tunnelQuantity != null ? tunnelQuantity.trim() : null;
    }

    public void setTunnelVariance(String tunnelVariance) {
        this._tunnelVariance = tunnelVariance != null ? tunnelVariance.trim() : null;
    }

    public void setTunnelBackupQuantity(String tunnelBackupQuantity) {
        this._tunnelBackupQuantity = tunnelBackupQuantity != null ? tunnelBackupQuantity.trim() : null;
    }

    public void setCustomOptions(String customOptions) {
        this._customOptions = customOptions != null ? customOptions.trim() : null;
    }

    public void setProxyList(String proxyList) {
        this._proxyList = proxyList != null ? proxyList.trim() : null;
    }

    public void setPort(String port) {
        this._port = port != null ? port.trim() : null;
    }

    public void setReachableBy(String reachableBy) {
        this._reachableBy = reachableBy != null ? reachableBy.trim() : null;
    }

    public void setReachableByOther(String reachableByOther) {
        this._reachableByOther = reachableByOther != null ? reachableByOther.trim() : null;
    }

    public void setTargetDestination(String dest) {
        this._targetDestination = dest != null ? dest.trim() : null;
    }

    public void setTargetHost(String host) {
        this._targetHost = host != null ? host.trim() : null;
    }

    public void setTargetPort(String port) {
        this._targetPort = port != null ? port.trim() : null;
    }

    public void setSpoofedHost(String host) {
        this._spoofedHost = host != null ? host.trim() : null;
    }

    public void setPrivKeyFile(String file) {
        this._privKeyFile = file != null ? file.trim() : null;
    }

    public void setRemoveConfirm(String moo) {
        this._removeConfirmed = true;
    }

    public void setStartOnLoad(String moo) {
        this._startOnLoad = true;
    }

    public void setShared(String moo) {
        this._sharedClient = true;
    }

    public void setShared(boolean val) {
        this._sharedClient = val;
    }

    public void setConnectDelay(String moo) {
        this._connectDelay = true;
    }

    public void setProfile(String profile) {
        this._profile = profile;
    }

    public void setReduce(String moo) {
        this._booleanOptions.add("i2cp.reduceOnIdle");
    }

    public void setClose(String moo) {
        this._booleanOptions.add("i2cp.closeOnIdle");
    }

    public void setEncrypt(String moo) {
        this._booleanOptions.add("i2cp.encryptLeaseSet");
    }

    public void setAccess(String moo) {
        this._booleanOptions.add("i2cp.enableAccessList");
    }

    public void setDelayOpen(String moo) {
        this._booleanOptions.add("i2cp.delayOpen");
    }

    public void setNewDest(String val) {
        if ("1".equals(val)) {
            this._booleanOptions.add("i2cp.newDestOnResume");
        } else if ("2".equals(val)) {
            this._booleanOptions.add("persistentClientKey");
        }
    }

    public void setReduceTime(String val) {
        if (val != null) {
            try {
                this._otherOptions.put("i2cp.reduceIdleTime", "" + Integer.parseInt(val.trim()) * 60 * 1000);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void setReduceCount(String val) {
        if (val != null) {
            this._otherOptions.put("i2cp.reduceQuantity", val.trim());
        }
    }

    public void setEncryptKey(String val) {
        if (val != null) {
            this._otherOptions.put("i2cp.leaseSetKey", val.trim());
        }
    }

    public void setAccessList(String val) {
        if (val != null) {
            this._otherOptions.put("i2cp.accessList", val.trim().replaceAll("\r\n", ",").replaceAll("\n", ",").replaceAll(" ", ","));
        }
    }

    public void setCloseTime(String val) {
        if (val != null) {
            try {
                this._otherOptions.put("i2cp.closeIdleTime", "" + Integer.parseInt(val.trim()) * 60 * 1000);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void setEffort(String val) {
        if (val != null) {
            try {
                this._hashCashValue = Integer.parseInt(val.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void setCert(String val) {
        if (val != null) {
            try {
                this._certType = Integer.parseInt(val.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void setSigner(String val) {
        this._certSigner = val;
    }

    private String modifyDestination() {
        Destination newdest;
        if (this._privKeyFile == null || this._privKeyFile.trim().length() <= 0) {
            return "Private Key File not specified";
        }
        TunnelController tun = this.getController(this._tunnel);
        Properties config = this.getConfig();
        if (config == null) {
            return "Invalid params";
        }
        if (tun == null) {
            tun = new TunnelController(config, "", true);
            this._group.addController(tun);
            this.saveChanges();
        } else if (tun.getIsRunning() || tun.getIsStarting()) {
            return "Tunnel must be stopped before modifying destination";
        }
        PrivateKeyFile pkf = new PrivateKeyFile(this._privKeyFile);
        try {
            pkf.createIfAbsent();
        }
        catch (Exception e) {
            return "Create private key file failed: " + e;
        }
        switch (this._certType) {
            case 0: 
            case 2: {
                pkf.setCertType(this._certType);
                break;
            }
            case 1: {
                pkf.setHashCashCert(this._hashCashValue);
                break;
            }
            case 3: {
                if (this._certSigner == null || this._certSigner.trim().length() <= 0) {
                    return "No signing destination specified";
                }
                String signerPKF = null;
                for (int i = 0; i < this.getTunnelCount(); ++i) {
                    TunnelController c = this.getController(i);
                    if (!this._certSigner.equals(c.getConfig("").getProperty("name")) && !this._certSigner.equals(c.getConfig("").getProperty("spoofedHost"))) continue;
                    signerPKF = c.getConfig("").getProperty("privKeyFile");
                    break;
                }
                if (signerPKF == null || signerPKF.length() <= 0) {
                    return "Signing destination " + this._certSigner + " not found";
                }
                if (this._privKeyFile.equals(signerPKF)) {
                    return "Self-signed destinations not allowed";
                }
                Certificate c = pkf.setSignedCert(new PrivateKeyFile(signerPKF));
                if (c != null) break;
                return "Signing failed - does signer destination exist?";
            }
            default: {
                return "Unknown certificate type";
            }
        }
        try {
            pkf.write();
            newdest = pkf.getDestination();
        }
        catch (Exception e) {
            return "Modification failed: " + e;
        }
        return "Destination modified - New Base32 is " + Base32.encode(newdest.calculateHash().getData()) + ".b32.i2p " + "New Destination is " + newdest.toBase64();
    }

    private String generateNewEncryptionKey() {
        TunnelController tun = this.getController(this._tunnel);
        Properties config = this.getConfig();
        if (config == null) {
            return "Invalid params";
        }
        if (tun == null) {
            tun = new TunnelController(config, "", true);
            this._group.addController(tun);
            this.saveChanges();
        } else if (tun.getIsRunning() || tun.getIsStarting()) {
            return "Tunnel must be stopped before modifying leaseset encryption key";
        }
        byte[] data = new byte[32];
        this._context.random().nextBytes(data);
        SessionKey sk = new SessionKey(data);
        this.setEncryptKey(sk.toBase64());
        this.setEncrypt("");
        this.saveChanges();
        return "New Leaseset Encryption Key: " + sk.toBase64();
    }

    private Properties getConfig() {
        Properties config = new Properties();
        this.updateConfigGeneric(config);
        if (IndexBean.isClient(this._type)) {
            if (this._port != null) {
                config.setProperty("listenPort", this._port);
            }
            if (this._reachableByOther != null) {
                config.setProperty("interface", this._reachableByOther);
            } else {
                config.setProperty("interface", this._reachableBy);
            }
            config.setProperty("sharedClient", this._sharedClient + "");
            for (String p : _booleanClientOpts) {
                config.setProperty("option." + p, "" + this._booleanOptions.contains(p));
            }
            for (String p : _otherClientOpts) {
                if (!this._otherOptions.containsKey(p)) continue;
                config.setProperty("option." + p, this._otherOptions.get(p));
            }
        } else {
            if (this._targetHost != null) {
                config.setProperty("targetHost", this._targetHost);
            }
            if (this._targetPort != null) {
                config.setProperty("targetPort", this._targetPort);
            }
            for (String p : _booleanServerOpts) {
                config.setProperty("option." + p, "" + this._booleanOptions.contains(p));
            }
            for (String p : _otherServerOpts) {
                if (!this._otherOptions.containsKey(p)) continue;
                config.setProperty("option." + p, this._otherOptions.get(p));
            }
        }
        if ("httpclient".equals(this._type) || "connectclient".equals(this._type)) {
            if (this._proxyList != null) {
                config.setProperty("proxyList", this._proxyList);
            }
        } else if ("ircclient".equals(this._type) || "client".equals(this._type) || "streamrclient".equals(this._type)) {
            if (this._targetDestination != null) {
                config.setProperty("targetDestination", this._targetDestination);
            }
        } else if ("httpserver".equals(this._type) && this._spoofedHost != null) {
            config.setProperty("spoofedHost", this._spoofedHost);
        }
        return config;
    }

    private void updateConfigGeneric(Properties config) {
        config.setProperty("type", this._type);
        if (this._name != null) {
            config.setProperty("name", this._name);
        }
        if (this._description != null) {
            config.setProperty("description", this._description);
        }
        if (this._i2cpHost != null) {
            config.setProperty("i2cpHost", this._i2cpHost);
        }
        if (this._i2cpPort != null && this._i2cpPort.trim().length() > 0) {
            config.setProperty("i2cpPort", this._i2cpPort);
        } else {
            config.setProperty("i2cpPort", "7654");
        }
        if (this._privKeyFile != null) {
            config.setProperty("privKeyFile", this._privKeyFile);
        }
        if (this._customOptions != null) {
            StringTokenizer tok = new StringTokenizer(this._customOptions);
            while (tok.hasMoreTokens()) {
                String key;
                String pair = tok.nextToken();
                int eq = pair.indexOf(61);
                if (eq <= 0 || eq >= pair.length() || _noShowSet.contains(key = pair.substring(0, eq))) continue;
                String val = pair.substring(eq + 1);
                config.setProperty("option." + key, val);
            }
        }
        config.setProperty("startOnLoad", this._startOnLoad + "");
        if (this._tunnelQuantity != null) {
            config.setProperty("option.inbound.quantity", this._tunnelQuantity);
            config.setProperty("option.outbound.quantity", this._tunnelQuantity);
        }
        if (this._tunnelDepth != null) {
            config.setProperty("option.inbound.length", this._tunnelDepth);
            config.setProperty("option.outbound.length", this._tunnelDepth);
        }
        if (this._tunnelVariance != null) {
            config.setProperty("option.inbound.lengthVariance", this._tunnelVariance);
            config.setProperty("option.outbound.lengthVariance", this._tunnelVariance);
        }
        if (this._tunnelBackupQuantity != null) {
            config.setProperty("option.inbound.backupQuantity", this._tunnelBackupQuantity);
            config.setProperty("option.outbound.backupQuantity", this._tunnelBackupQuantity);
        }
        if (this._connectDelay) {
            config.setProperty("option.i2p.streaming.connectDelay", "1000");
        } else {
            config.setProperty("option.i2p.streaming.connectDelay", "0");
        }
        if (IndexBean.isClient(this._type) && this._sharedClient) {
            config.setProperty("option.inbound.nickname", CLIENT_NICKNAME);
            config.setProperty("option.outbound.nickname", CLIENT_NICKNAME);
        } else if (this._name != null) {
            config.setProperty("option.inbound.nickname", this._name);
            config.setProperty("option.outbound.nickname", this._name);
        }
        if ("interactive".equals(this._profile)) {
            config.setProperty("option.i2p.streaming.maxWindowSize", "16");
        } else {
            config.remove("option.i2p.streaming.maxWindowSize");
        }
    }

    protected TunnelController getController(int tunnel) {
        if (tunnel < 0) {
            return null;
        }
        if (this._group == null) {
            return null;
        }
        List controllers = this._group.getControllers();
        if (controllers.size() > tunnel) {
            return (TunnelController)controllers.get(tunnel);
        }
        return null;
    }

    private String getMessages(List msgs) {
        StringBuilder buf = new StringBuilder(128);
        this.getMessages(msgs, buf);
        return buf.toString();
    }

    private void getMessages(List msgs, StringBuilder buf) {
        if (msgs == null) {
            return;
        }
        for (int i = 0; i < msgs.size(); ++i) {
            buf.append((String)msgs.get(i)).append("\n");
        }
    }

    static {
        _noShowSet.addAll(Arrays.asList(_noShowOpts));
        _noShowSet.addAll(Arrays.asList(_booleanClientOpts));
        _noShowSet.addAll(Arrays.asList(_booleanServerOpts));
        _noShowSet.addAll(Arrays.asList(_otherClientOpts));
        _noShowSet.addAll(Arrays.asList(_otherServerOpts));
    }
}

