/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.web;

import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import net.i2p.i2ptunnel.TunnelController;
import net.i2p.i2ptunnel.TunnelControllerGroup;
import net.i2p.i2ptunnel.web.IndexBean;

public class EditBean
extends IndexBean {
    public static boolean staticIsClient(int tunnel) {
        TunnelControllerGroup group = TunnelControllerGroup.getInstance();
        List controllers = group.getControllers();
        if (controllers.size() > tunnel) {
            TunnelController cur = (TunnelController)controllers.get(tunnel);
            if (cur == null) {
                return false;
            }
            return EditBean.isClient(cur.getType());
        }
        return false;
    }

    public String getTargetHost(int tunnel) {
        TunnelController tun = this.getController(tunnel);
        if (tun != null && tun.getTargetHost() != null) {
            return tun.getTargetHost();
        }
        return "127.0.0.1";
    }

    public String getTargetPort(int tunnel) {
        TunnelController tun = this.getController(tunnel);
        if (tun != null && tun.getTargetPort() != null) {
            return tun.getTargetPort();
        }
        return "";
    }

    public String getSpoofedHost(int tunnel) {
        TunnelController tun = this.getController(tunnel);
        if (tun != null && tun.getSpoofedHost() != null) {
            return tun.getSpoofedHost();
        }
        return "";
    }

    public String getPrivateKeyFile(int tunnel) {
        TunnelController tun = this.getController(tunnel);
        if (tun != null && tun.getPrivKeyFile() != null) {
            return tun.getPrivKeyFile();
        }
        if (tunnel < 0) {
            tunnel = this._group.getControllers().size();
        }
        return "i2ptunnel" + tunnel + "-privKeys.dat";
    }

    public boolean startAutomatically(int tunnel) {
        TunnelController tun = this.getController(tunnel);
        if (tun != null) {
            return tun.getStartOnLoad();
        }
        return false;
    }

    public boolean isSharedClient(int tunnel) {
        TunnelController tun = this.getController(tunnel);
        if (tun != null) {
            return "true".equalsIgnoreCase(tun.getSharedClient());
        }
        return true;
    }

    public boolean shouldDelay(int tunnel) {
        return this.getProperty(tunnel, "i2p.streaming.connectDelay", 0) > 0;
    }

    public boolean isInteractive(int tunnel) {
        return this.getProperty(tunnel, "i2p.streaming.maxWindowSize", 128) == 12;
    }

    public int getTunnelDepth(int tunnel, int defaultLength) {
        return this.getProperty(tunnel, "inbound.length", defaultLength);
    }

    public int getTunnelQuantity(int tunnel, int defaultQuantity) {
        return this.getProperty(tunnel, "inbound.quantity", defaultQuantity);
    }

    public int getTunnelBackupQuantity(int tunnel, int defaultBackupQuantity) {
        return this.getProperty(tunnel, "inbound.backupQuantity", defaultBackupQuantity);
    }

    public int getTunnelVariance(int tunnel, int defaultVariance) {
        return this.getProperty(tunnel, "inbound.lengthVariance", defaultVariance);
    }

    public boolean getReduce(int tunnel) {
        return this.getBooleanProperty(tunnel, "i2cp.reduceOnIdle");
    }

    public int getReduceCount(int tunnel) {
        return this.getProperty(tunnel, "i2cp.reduceQuantity", 1);
    }

    public int getReduceTime(int tunnel) {
        return this.getProperty(tunnel, "i2cp.reduceIdleTime", 1200000) / 60000;
    }

    public int getCert(int tunnel) {
        return 0;
    }

    public int getEffort(int tunnel) {
        return 23;
    }

    public String getSigner(int tunnel) {
        return "";
    }

    public boolean getEncrypt(int tunnel) {
        return this.getBooleanProperty(tunnel, "i2cp.encryptLeaseSet");
    }

    public String getEncryptKey(int tunnel) {
        return this.getProperty(tunnel, "i2cp.leaseSetKey", "");
    }

    public boolean getAccess(int tunnel) {
        return this.getBooleanProperty(tunnel, "i2cp.enableAccessList");
    }

    public String getAccessList(int tunnel) {
        return this.getProperty(tunnel, "i2cp.accessList", "").replaceAll(",", "\n");
    }

    public boolean getClose(int tunnel) {
        return this.getBooleanProperty(tunnel, "i2cp.closeOnIdle");
    }

    public int getCloseTime(int tunnel) {
        return this.getProperty(tunnel, "i2cp.closeIdleTime", 1800000) / 60000;
    }

    public boolean getNewDest(int tunnel) {
        return this.getBooleanProperty(tunnel, "i2cp.newDestOnResume") && this.getBooleanProperty(tunnel, "i2cp.closeOnIdle") && !this.getBooleanProperty(tunnel, "persistentClientKey");
    }

    public boolean getPersistentClientKey(int tunnel) {
        return this.getBooleanProperty(tunnel, "persistentClientKey");
    }

    public boolean getDelayOpen(int tunnel) {
        return this.getBooleanProperty(tunnel, "i2cp.delayOpen");
    }

    private int getProperty(int tunnel, String prop, int def) {
        Properties opts;
        TunnelController tun = this.getController(tunnel);
        if (tun != null && (opts = EditBean.getOptions(tun)) != null) {
            String s = opts.getProperty(prop);
            if (s == null) {
                return def;
            }
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return def;
    }

    private String getProperty(int tunnel, String prop, String def) {
        Properties opts;
        TunnelController tun = this.getController(tunnel);
        if (tun != null && (opts = EditBean.getOptions(tun)) != null) {
            return opts.getProperty(prop, def);
        }
        return def;
    }

    private boolean getBooleanProperty(int tunnel, String prop) {
        Properties opts;
        TunnelController tun = this.getController(tunnel);
        if (tun != null && (opts = EditBean.getOptions(tun)) != null) {
            return Boolean.valueOf(opts.getProperty(prop));
        }
        return false;
    }

    public String getI2CPHost(int tunnel) {
        TunnelController tun = this.getController(tunnel);
        if (tun != null) {
            return tun.getI2CPHost();
        }
        return "127.0.0.1";
    }

    public String getI2CPPort(int tunnel) {
        TunnelController tun = this.getController(tunnel);
        if (tun != null) {
            return tun.getI2CPPort();
        }
        return "7654";
    }

    public String getCustomOptions(int tunnel) {
        TunnelController tun = this.getController(tunnel);
        if (tun != null) {
            Properties opts = EditBean.getOptions(tun);
            if (opts == null) {
                return "";
            }
            StringBuilder buf = new StringBuilder(64);
            int i = 0;
            for (String string : opts.keySet()) {
                if (_noShowSet.contains(string)) continue;
                String val = opts.getProperty(string);
                if (i != 0) {
                    buf.append(' ');
                }
                buf.append(string).append('=').append(val);
                ++i;
            }
            return buf.toString();
        }
        return "";
    }

    private static Properties getOptions(TunnelController controller) {
        if (controller == null) {
            return null;
        }
        String opts = controller.getClientOptions();
        StringTokenizer tok = new StringTokenizer(opts);
        Properties props = new Properties();
        while (tok.hasMoreTokens()) {
            String pair = tok.nextToken();
            int eq = pair.indexOf(61);
            if (eq <= 0 || eq >= pair.length()) continue;
            String key = pair.substring(0, eq);
            String val = pair.substring(eq + 1);
            props.setProperty(key, val);
        }
        return props;
    }
}

