/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.udp;

import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.client.datagram.I2PDatagramMaker;
import net.i2p.data.Destination;
import net.i2p.i2ptunnel.udp.Sink;

public class I2PSinkAnywhere
implements Sink {
    protected boolean raw;
    protected I2PSession sess;
    protected Destination dest;
    protected I2PDatagramMaker maker;

    public I2PSinkAnywhere(I2PSession sess) {
        this(sess, false);
    }

    public I2PSinkAnywhere(I2PSession sess, boolean raw) {
        this.sess = sess;
        this.raw = raw;
        if (!raw) {
            this.maker = new I2PDatagramMaker(this.sess);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void send(Destination to, byte[] data) {
        byte[] payload;
        if (!this.raw) {
            I2PDatagramMaker i2PDatagramMaker = this.maker;
            synchronized (i2PDatagramMaker) {
                payload = this.maker.makeI2PDatagram(data);
            }
        } else {
            payload = data;
        }
        try {
            this.sess.sendMessage(to, payload, 17, 0, 0);
        }
        catch (I2PSessionException exc) {
            exc.printStackTrace();
        }
    }
}

