/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.socks;

import java.util.Map;
import net.i2p.data.Destination;
import net.i2p.i2ptunnel.socks.SOCKSHeader;
import net.i2p.i2ptunnel.udp.Sink;
import net.i2p.i2ptunnel.udp.Source;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOCKSUDPWrapper
implements Source,
Sink {
    private Sink sink;
    private Map<Destination, SOCKSHeader> cache;

    public SOCKSUDPWrapper(Map<Destination, SOCKSHeader> cache) {
        this.cache = cache;
    }

    @Override
    public void setSink(Sink sink) {
        this.sink = sink;
    }

    @Override
    public void start() {
    }

    @Override
    public void send(Destination from, byte[] data) {
        if (this.sink == null) {
            return;
        }
        SOCKSHeader h = this.cache.get(from);
        if (h == null) {
            return;
        }
        byte[] header = h.getBytes();
        byte[] wrapped = new byte[header.length + data.length];
        System.arraycopy(wrapped, 0, header, 0, header.length);
        System.arraycopy(wrapped, header.length, data, 0, data.length);
        this.sink.send(from, wrapped);
    }
}

