/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.I2PClient;
import net.i2p.client.I2PClientFactory;
import net.i2p.client.I2PSession;
import net.i2p.data.Base32;
import net.i2p.data.Destination;
import net.i2p.i2ptunnel.I2PTunnel;
import net.i2p.i2ptunnel.Logging;
import net.i2p.i2ptunnel.TunnelControllerGroup;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

public class TunnelController
implements Logging {
    private Log _log;
    private Properties _config;
    private I2PTunnel _tunnel = new I2PTunnel();
    private List _messages;
    private List _sessions;
    private boolean _running;
    private boolean _starting;

    public TunnelController(Properties config, String prefix) {
        this(config, prefix, true);
    }

    public TunnelController(Properties config, String prefix, boolean createKey) {
        this._log = I2PAppContext.getGlobalContext().logManager().getLog(TunnelController.class);
        this.setConfig(config, prefix);
        this._messages = new ArrayList(4);
        this._running = false;
        if (createKey && (this.getType().endsWith("server") || this.getPersistentClientKey())) {
            this.createPrivateKey();
        }
        this._starting = this.getStartOnLoad();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createPrivateKey() {
        I2PClient client = I2PClientFactory.createClient();
        String filename = this.getPrivKeyFile();
        if (filename == null || filename.trim().length() <= 0) {
            this.log("No filename specified for the private key");
            return;
        }
        File keyFile = new File(this.getPrivKeyFile());
        if (!keyFile.isAbsolute()) {
            keyFile = new File(I2PAppContext.getGlobalContext().getConfigDir(), this.getPrivKeyFile());
        }
        if (keyFile.exists()) {
            return;
        }
        File parent = keyFile.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        FileOutputStream fos = null;
        fos = new FileOutputStream(keyFile);
        Destination dest = client.createDestination(fos);
        String destStr = dest.toBase64();
        this.log("Private key created and saved in " + keyFile.getAbsolutePath());
        this.log("New destination: " + destStr);
        this.log("Base32: " + Base32.encode(dest.calculateHash().getData()) + ".b32.i2p");
        Object var8_9 = null;
        if (fos == null) return;
        try {
            fos.close();
            return;
        }
        catch (IOException ioe2) {}
        return;
        {
            catch (I2PException ie) {
                if (this._log.shouldLog(40)) {
                    this._log.error("Error creating new destination", ie);
                }
                this.log("Error creating new destination: " + ie.getMessage());
                Object var8_10 = null;
                if (fos == null) return;
                try {
                    fos.close();
                    return;
                }
                catch (IOException ioe2) {}
                return;
            }
            catch (IOException ioe) {
                if (this._log.shouldLog(40)) {
                    this._log.error("Error creating writing the destination to " + keyFile.getAbsolutePath(), ioe);
                }
                this.log("Error writing the keys to " + keyFile.getAbsolutePath());
                Object var8_11 = null;
                if (fos == null) return;
                try {
                    fos.close();
                    return;
                }
                catch (IOException ioe2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (fos == null) throw throwable;
            try {
                fos.close();
                throw throwable;
            }
            catch (IOException ioe2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public void startTunnelBackground() {
        if (this._running) {
            return;
        }
        this._starting = true;
        new I2PThread(new Runnable(){

            public void run() {
                TunnelController.this.startTunnel();
            }
        }).start();
    }

    public void startTunnel() {
        this._starting = true;
        try {
            this.doStartTunnel();
        }
        catch (Exception e) {
            this._log.error("Error starting up the tunnel", e);
            this.log("Error starting up the tunnel - " + e.getMessage());
        }
        this._starting = false;
    }

    private void doStartTunnel() {
        if (this._running) {
            if (this._log.shouldLog(20)) {
                this._log.info("Already running");
            }
            this.log("Tunnel " + this.getName() + " is already running");
            return;
        }
        String type = this.getType();
        if (type == null || type.length() <= 0) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Cannot start the tunnel - no type specified");
            }
            return;
        }
        this.setI2CPOptions();
        this.setSessionOptions();
        if ("httpclient".equals(type)) {
            this.startHttpClient();
        } else if ("ircclient".equals(type)) {
            this.startIrcClient();
        } else if ("sockstunnel".equals(type)) {
            this.startSocksClient();
        } else if ("connectclient".equals(type)) {
            this.startConnectClient();
        } else if ("client".equals(type)) {
            this.startClient();
        } else if ("streamrclient".equals(type)) {
            this.startStreamrClient();
        } else if ("server".equals(type)) {
            this.startServer();
        } else if ("httpserver".equals(type)) {
            this.startHttpServer();
        } else if ("ircserver".equals(type)) {
            this.startIrcServer();
        } else if ("streamrserver".equals(type)) {
            this.startStreamrServer();
        } else {
            if (this._log.shouldLog(40)) {
                this._log.error("Cannot start tunnel - unknown type [" + type + "]");
            }
            return;
        }
        this.acquire();
        this._running = true;
    }

    private void startHttpClient() {
        this.setListenOn();
        String listenPort = this.getListenPort();
        String proxyList = this.getProxyList();
        String sharedClient = this.getSharedClient();
        if (proxyList == null) {
            this._tunnel.runHttpClient(new String[]{listenPort, sharedClient}, this);
        } else {
            this._tunnel.runHttpClient(new String[]{listenPort, sharedClient, proxyList}, this);
        }
    }

    private void startConnectClient() {
        this.setListenOn();
        String listenPort = this.getListenPort();
        String proxyList = this.getProxyList();
        String sharedClient = this.getSharedClient();
        if (proxyList == null) {
            this._tunnel.runConnectClient(new String[]{listenPort, sharedClient}, this);
        } else {
            this._tunnel.runConnectClient(new String[]{listenPort, sharedClient, proxyList}, this);
        }
    }

    private void startIrcClient() {
        this.setListenOn();
        String listenPort = this.getListenPort();
        String dest = this.getTargetDestination();
        String sharedClient = this.getSharedClient();
        if (this.getPersistentClientKey()) {
            String privKeyFile = this.getPrivKeyFile();
            this._tunnel.runIrcClient(new String[]{listenPort, dest, sharedClient, privKeyFile}, this);
        } else {
            this._tunnel.runIrcClient(new String[]{listenPort, dest, sharedClient}, this);
        }
    }

    private void startSocksClient() {
        this.setListenOn();
        String listenPort = this.getListenPort();
        String sharedClient = this.getSharedClient();
        this._tunnel.runSOCKSTunnel(new String[]{listenPort, sharedClient}, this);
    }

    private void startStreamrClient() {
        String targetHost = this.getListenOnInterface();
        String targetPort = this.getListenPort();
        String dest = this.getTargetDestination();
        this._tunnel.runStreamrClient(new String[]{targetHost, targetPort, dest}, this);
    }

    private void startStreamrServer() {
        String listenOn = this.getTargetHost();
        if (listenOn != null && listenOn.length() > 0) {
            this._tunnel.runListenOn(new String[]{listenOn}, this);
        }
        String listenPort = this.getTargetPort();
        String privKeyFile = this.getPrivKeyFile();
        this._tunnel.runStreamrServer(new String[]{listenPort, privKeyFile}, this);
    }

    private void acquire() {
        List<I2PSession> sessions = this._tunnel.getSessions();
        if (sessions != null) {
            for (int i = 0; i < sessions.size(); ++i) {
                I2PSession session = sessions.get(i);
                TunnelControllerGroup.getInstance().acquire(this, session);
            }
            this._sessions = sessions;
        } else {
            this._log.error("No sessions to acquire?");
        }
    }

    private void release() {
        if (this._sessions != null) {
            for (int i = 0; i < this._sessions.size(); ++i) {
                I2PSession s = (I2PSession)this._sessions.get(i);
                TunnelControllerGroup.getInstance().release(this, s);
            }
        } else {
            this._log.error("No sessions to release?");
        }
    }

    private void startClient() {
        this.setListenOn();
        String listenPort = this.getListenPort();
        String dest = this.getTargetDestination();
        String sharedClient = this.getSharedClient();
        if (this.getPersistentClientKey()) {
            String privKeyFile = this.getPrivKeyFile();
            this._tunnel.runClient(new String[]{listenPort, dest, sharedClient, privKeyFile}, this);
        } else {
            this._tunnel.runClient(new String[]{listenPort, dest, sharedClient}, this);
        }
    }

    private void startServer() {
        String targetHost = this.getTargetHost();
        String targetPort = this.getTargetPort();
        String privKeyFile = this.getPrivKeyFile();
        this._tunnel.runServer(new String[]{targetHost, targetPort, privKeyFile}, this);
    }

    private void startHttpServer() {
        String targetHost = this.getTargetHost();
        String targetPort = this.getTargetPort();
        String spoofedHost = this.getSpoofedHost();
        String privKeyFile = this.getPrivKeyFile();
        this._tunnel.runHttpServer(new String[]{targetHost, targetPort, spoofedHost, privKeyFile}, this);
    }

    private void startIrcServer() {
        String targetHost = this.getTargetHost();
        String targetPort = this.getTargetPort();
        String privKeyFile = this.getPrivKeyFile();
        this._tunnel.runIrcServer(new String[]{targetHost, targetPort, privKeyFile}, this);
    }

    private void setListenOn() {
        String listenOn = this.getListenOnInterface();
        if (listenOn != null && listenOn.length() > 0) {
            this._tunnel.runListenOn(new String[]{listenOn}, this);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setSessionOptions() {
        void var3_7;
        ArrayList<String> opts = new ArrayList<String>();
        for (String string : this._config.keySet()) {
            String val = this._config.getProperty(string);
            if (!string.startsWith("option.")) continue;
            String string2 = string.substring("option.".length());
            opts.add(string2 + "=" + val);
        }
        String[] args = new String[opts.size()];
        boolean bl = false;
        while (var3_7 < opts.size()) {
            args[var3_7] = (String)opts.get((int)var3_7);
            ++var3_7;
        }
        this._tunnel.runClientOptions(args, this);
    }

    private void setI2CPOptions() {
        String port;
        String host = this.getI2CPHost();
        if (host != null && host.length() > 0) {
            this._tunnel.host = host;
        }
        if ("localhost".equals(this._tunnel.host)) {
            this._tunnel.host = "127.0.0.1";
        }
        if ((port = this.getI2CPPort()) != null && port.length() > 0) {
            try {
                int portNum = Integer.parseInt(port);
                this._tunnel.port = String.valueOf(portNum);
            }
            catch (NumberFormatException nfe) {
                this._tunnel.port = "7654";
            }
        } else {
            this._tunnel.port = "7654";
        }
    }

    public void stopTunnel() {
        this._tunnel.runClose(new String[]{"forced", "all"}, this);
        this.release();
        this._running = false;
    }

    public void restartTunnel() {
        this.stopTunnel();
        this.startTunnel();
    }

    public void setConfig(Properties config, String prefix) {
        Properties props = new Properties();
        for (String string : config.keySet()) {
            String val = config.getProperty(string);
            if (!string.startsWith(prefix)) continue;
            String string2 = string.substring(prefix.length());
            props.setProperty(string2, val);
            if (!this._log.shouldLog(10)) continue;
            this._log.debug("Set prop [" + string2 + "] to [" + val + "]");
        }
        this._config = props;
    }

    public Properties getConfig(String prefix) {
        Properties rv = new Properties();
        for (String string : this._config.keySet()) {
            String val = this._config.getProperty(string);
            rv.setProperty(prefix + string, val);
        }
        return rv;
    }

    public String getType() {
        return this._config.getProperty("type");
    }

    public String getName() {
        return this._config.getProperty("name");
    }

    public String getDescription() {
        return this._config.getProperty("description");
    }

    public String getI2CPHost() {
        return this._config.getProperty("i2cpHost");
    }

    public String getI2CPPort() {
        return this._config.getProperty("i2cpPort");
    }

    public String getClientOptions() {
        StringBuilder opts = new StringBuilder(64);
        for (String string : this._config.keySet()) {
            String val = this._config.getProperty(string);
            if (!string.startsWith("option.")) continue;
            String string2 = string.substring("option.".length());
            if (opts.length() > 0) {
                opts.append(' ');
            }
            opts.append(string2).append('=').append(val);
        }
        return opts.toString();
    }

    public String getListenOnInterface() {
        return this._config.getProperty("interface");
    }

    public String getTargetHost() {
        return this._config.getProperty("targetHost");
    }

    public String getTargetPort() {
        return this._config.getProperty("targetPort");
    }

    public String getSpoofedHost() {
        return this._config.getProperty("spoofedHost");
    }

    public String getPrivKeyFile() {
        return this._config.getProperty("privKeyFile");
    }

    public String getListenPort() {
        return this._config.getProperty("listenPort");
    }

    public String getTargetDestination() {
        return this._config.getProperty("targetDestination");
    }

    public String getProxyList() {
        return this._config.getProperty("proxyList");
    }

    public String getSharedClient() {
        return this._config.getProperty("sharedClient", "true");
    }

    public boolean getStartOnLoad() {
        return "true".equalsIgnoreCase(this._config.getProperty("startOnLoad", "true"));
    }

    public boolean getPersistentClientKey() {
        return Boolean.valueOf(this._config.getProperty("option.persistentClientKey"));
    }

    public String getMyDestination() {
        if (this._tunnel != null) {
            List<I2PSession> sessions = this._tunnel.getSessions();
            for (int i = 0; i < sessions.size(); ++i) {
                I2PSession session = sessions.get(i);
                Destination dest = session.getMyDestination();
                if (dest == null) continue;
                return dest.toBase64();
            }
        }
        return null;
    }

    public String getMyDestHashBase32() {
        if (this._tunnel != null) {
            List<I2PSession> sessions = this._tunnel.getSessions();
            for (int i = 0; i < sessions.size(); ++i) {
                I2PSession session = sessions.get(i);
                Destination dest = session.getMyDestination();
                if (dest == null) continue;
                return Base32.encode(dest.calculateHash().getData());
            }
        }
        return null;
    }

    public boolean getIsRunning() {
        return this._running;
    }

    public boolean getIsStarting() {
        return this._starting;
    }

    public boolean getIsStandby() {
        if (!this._running) {
            return false;
        }
        for (I2PSession sess : this._tunnel.getSessions()) {
            if (sess.isClosed()) continue;
            return false;
        }
        return true;
    }

    public void getSummary(StringBuilder buf) {
        String type = this.getType();
        if ("httpclient".equals(type)) {
            this.getHttpClientSummary(buf);
        } else if ("client".equals(type)) {
            this.getClientSummary(buf);
        } else if ("server".equals(type)) {
            this.getServerSummary(buf);
        } else if ("httpserver".equals(type)) {
            this.getHttpServerSummary(buf);
        } else {
            buf.append("Unknown type ").append(type);
        }
    }

    private void getHttpClientSummary(StringBuilder buf) {
        String description = this.getDescription();
        if (description != null && description.trim().length() > 0) {
            buf.append("<i>").append(description).append("</i><br />\n");
        }
        buf.append("HTTP proxy listening on port ").append(this.getListenPort());
        String listenOn = this.getListenOnInterface();
        if ("0.0.0.0".equals(listenOn)) {
            buf.append(" (reachable by any machine)");
        } else if ("127.0.0.1".equals(listenOn)) {
            buf.append(" (reachable locally only)");
        } else {
            buf.append(" (reachable at the ").append(listenOn).append(" interface)");
        }
        buf.append("<br />\n");
        String proxies = this.getProxyList();
        if (proxies == null || proxies.trim().length() <= 0) {
            buf.append("Outproxy: default [squid.i2p]<br />\n");
        } else {
            buf.append("Outproxy: ").append(proxies).append("<br />\n");
        }
        this.getOptionSummary(buf);
    }

    private void getClientSummary(StringBuilder buf) {
        String description = this.getDescription();
        if (description != null && description.trim().length() > 0) {
            buf.append("<i>").append(description).append("</i><br />\n");
        }
        buf.append("Client tunnel listening on port ").append(this.getListenPort());
        buf.append(" pointing at ").append(this.getTargetDestination());
        String listenOn = this.getListenOnInterface();
        if ("0.0.0.0".equals(listenOn)) {
            buf.append(" (reachable by any machine)");
        } else if ("127.0.0.1".equals(listenOn)) {
            buf.append(" (reachable locally only)");
        } else {
            buf.append(" (reachable at the ").append(listenOn).append(" interface)");
        }
        buf.append("<br />\n");
        this.getOptionSummary(buf);
    }

    private void getServerSummary(StringBuilder buf) {
        String description = this.getDescription();
        if (description != null && description.trim().length() > 0) {
            buf.append("<i>").append(description).append("</i><br />\n");
        }
        buf.append("Server tunnel pointing at port ").append(this.getTargetPort());
        buf.append(" on ").append(this.getTargetHost());
        buf.append("<br />\n");
        buf.append("Private destination loaded from ").append(this.getPrivKeyFile()).append("<br />\n");
        this.getOptionSummary(buf);
    }

    private void getHttpServerSummary(StringBuilder buf) {
        String description = this.getDescription();
        if (description != null && description.trim().length() > 0) {
            buf.append("<i>").append(description).append("</i><br />\n");
        }
        buf.append("Server tunnel pointing at port ").append(this.getTargetPort());
        buf.append(" on ").append(this.getTargetHost());
        buf.append(" for the site ").append(this.getSpoofedHost());
        buf.append("<br />\n");
        buf.append("Private destination loaded from ").append(this.getPrivKeyFile()).append("<br />\n");
        this.getOptionSummary(buf);
    }

    private void getOptionSummary(StringBuilder buf) {
        String opts = this.getClientOptions();
        if (opts != null && opts.length() > 0) {
            buf.append("Network options: ").append(opts).append("<br />\n");
        }
        if (this._running) {
            List<I2PSession> sessions = this._tunnel.getSessions();
            for (int i = 0; i < sessions.size(); ++i) {
                I2PSession session = sessions.get(i);
                Destination dest = session.getMyDestination();
                if (dest == null) continue;
                buf.append("Destination hash: ").append(dest.calculateHash().toBase64()).append("<br />\n");
                if (!"server".equals(this.getType()) && !"httpserver".equals(this.getType())) continue;
                buf.append("Full destination: ");
                buf.append("<input type=\"text\" size=\"10\" onclick=\"this.select();\" ");
                buf.append("value=\"").append(dest.toBase64()).append("\" />\n");
                long val = new Random().nextLong();
                if (val < 0L) {
                    val = 0L - val;
                }
                buf.append("<br />You can <a href=\"http://temp").append(val);
                buf.append(".i2p/?i2paddresshelper=").append(dest.toBase64()).append("\">view</a>");
                buf.append(" it in a browser (only when you're using the eepProxy)\n");
                buf.append("<br />If you are going to share this on IRC, you need to split it up:<br />\n");
                String str = dest.toBase64();
                buf.append(str.substring(0, str.length() / 2)).append("<br />\n");
                buf.append(str.substring(str.length() / 2)).append("<br />\n");
                buf.append("You can also post it to <a href=\"http://forum.i2p/viewforum.php?f=16\">Eepsite announcement forum</a><br />");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(String s) {
        TunnelController tunnelController = this;
        synchronized (tunnelController) {
            this._messages.add(s);
            while (this._messages.size() > 10) {
                this._messages.remove(0);
            }
        }
        if (this._log.shouldLog(20)) {
            this._log.info(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List clearMessages() {
        ArrayList rv = null;
        TunnelController tunnelController = this;
        synchronized (tunnelController) {
            rv = new ArrayList(this._messages);
            this._messages.clear();
        }
        return rv;
    }
}

