/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketOptions;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.i2ptunnel.I2PTunnel;
import net.i2p.i2ptunnel.I2PTunnelClientBase;
import net.i2p.i2ptunnel.I2PTunnelHTTPClientRunner;
import net.i2p.i2ptunnel.Logging;
import net.i2p.util.EventDispatcher;
import net.i2p.util.FileUtil;
import net.i2p.util.Log;

public class I2PTunnelHTTPClient
extends I2PTunnelClientBase
implements Runnable {
    private static final Log _log = new Log(I2PTunnelHTTPClient.class);
    private final List proxyList;
    private HashMap addressHelpers = new HashMap();
    private static final byte[] ERR_REQUEST_DENIED = "HTTP/1.1 403 Access Denied\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\n\r\n<html><body><H1>I2P ERROR: REQUEST DENIED</H1>You attempted to connect to a non-I2P website or location.<BR>".getBytes();
    private static final byte[] ERR_DESTINATION_UNKNOWN = "HTTP/1.1 503 Service Unavailable\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\n\r\n<html><body><H1>I2P ERROR: DESTINATION NOT FOUND</H1>That I2P Destination was not found. Perhaps you pasted in the wrong BASE64 I2P Destination or the link you are following is bad. The host (or the WWW proxy, if you're using one) could also be temporarily offline.  You may want to <b>retry</b>.  Could not find the following Destination:<BR><BR><div>".getBytes();
    private static final byte[] ERR_TIMEOUT = "HTTP/1.1 504 Gateway Timeout\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\n\r\n<html><body><H1>I2P ERROR: TIMEOUT</H1>That Destination was reachable, but timed out getting a response.  This is likely a temporary error, so you should simply try to refresh, though if the problem persists, the remote destination may have issues.  Could not get a response from the following Destination:<BR><BR>".getBytes();
    private static final byte[] ERR_NO_OUTPROXY = "HTTP/1.1 503 Service Unavailable\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\n\r\n<html><body><H1>I2P ERROR: No outproxy found</H1>Your request was for a site outside of I2P, but you have no HTTP outproxy configured.  Please configure an outproxy in I2PTunnel".getBytes();
    private static final byte[] ERR_AHELPER_CONFLICT = "HTTP/1.1 409 Conflict\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\n\r\n<html><body><H1>I2P ERROR: Destination key conflict</H1>The addresshelper link you followed specifies a different destination key than a host entry in your host database. Someone could be trying to impersonate another eepsite, or people have given two eepsites identical names.<P/>You can resolve the conflict by considering which key you trust, and either discarding the addresshelper link, discarding the host entry from your host database, or naming one of them differently.<P/>".getBytes();
    private static final byte[] ERR_BAD_PROTOCOL = "HTTP/1.1 403 Bad Protocol\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\n\r\n<html><body><H1>I2P ERROR: NON-HTTP PROTOCOL</H1>The request uses a bad protocol. The I2P HTTP Proxy supports http:// requests ONLY. Other protocols such as https:// and ftp:// are not allowed.<BR>".getBytes();
    private static final byte[] ERR_LOCALHOST = "HTTP/1.1 403 Access Denied\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\n\r\n<html><body><H1>I2P ERROR: REQUEST DENIED</H1>Your browser is misconfigured. Do not use the proxy to access the router console or other localhost destinations.<BR>".getBytes();
    private static volatile long __clientId = 0L;
    private static final File _errorDir = new File(I2PAppContext.getGlobalContext().getBaseDir(), "docs");
    private static final int DEFAULT_READ_TIMEOUT = 60000;
    private static final boolean DEFAULT_GZIP = true;
    public static final String PROP_REFERER = "i2ptunnel.httpclient.sendReferer";
    public static final String PROP_USER_AGENT = "i2ptunnel.httpclient.sendUserAgent";
    public static final String PROP_VIA = "i2ptunnel.httpclient.sendVia";
    private static long __requestId = 0L;
    private static String[] jumpServers = new String[]{"http://i2host.i2p/cgi-bin/i2hostjump?", "http://stats.i2p/cgi-bin/jump.cgi?a=", "http://i2jump.i2p/"};
    private static final String[] SUPPORTED_HOSTS = new String[]{"i2p", "www.i2p.com", "i2p."};
    private static final byte[] ERR_404 = "HTTP/1.1 404 Not Found\r\nContent-Type: text/plain\r\n\r\nHTTP Proxy local file not found".getBytes();

    public I2PTunnelHTTPClient(int localPort, Logging l, boolean ownDest, String wwwProxy, EventDispatcher notifyThis, I2PTunnel tunnel) throws IllegalArgumentException {
        super(localPort, ownDest, l, notifyThis, "HTTPHandler " + ++__clientId, tunnel);
        this.proxyList = new ArrayList();
        if (this.waitEventValue("openBaseClientResult").equals("error")) {
            this.notifyEvent("openHTTPClientResult", "error");
            return;
        }
        if (wwwProxy != null) {
            StringTokenizer tok = new StringTokenizer(wwwProxy, ", ");
            while (tok.hasMoreTokens()) {
                this.proxyList.add(tok.nextToken().trim());
            }
        }
        this.setName(this.getLocalPort() + " -> HTTPClient [WWW outproxy list: " + wwwProxy + "]");
        this.startRunning();
        this.notifyEvent("openHTTPClientResult", "ok");
    }

    private String getPrefix(long requestId) {
        return "Client[" + this._clientId + "/" + requestId + "]: ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String selectProxy() {
        List list = this.proxyList;
        synchronized (list) {
            int size = this.proxyList.size();
            if (size <= 0) {
                if (_log.shouldLog(20)) {
                    _log.info("Proxy list is empty - no outproxy available");
                }
                this.l.log("Proxy list is emtpy - no outproxy available");
                return null;
            }
            int index = I2PAppContext.getGlobalContext().random().nextInt(size);
            String proxy = (String)this.proxyList.get(index);
            return proxy;
        }
    }

    protected I2PSocketOptions getDefaultOptions() {
        Properties defaultOpts = this.getTunnel().getClientOptions();
        if (!defaultOpts.contains("i2p.streaming.readTimeout")) {
            defaultOpts.setProperty("i2p.streaming.readTimeout", "60000");
        }
        I2PSocketOptions opts = this.sockMgr.buildOptions(defaultOpts);
        if (!defaultOpts.containsKey("i2p.streaming.connectTimeout")) {
            opts.setConnectTimeout(60000L);
        }
        return opts;
    }

    protected I2PSocketOptions getDefaultOptions(Properties overrides) {
        Properties defaultOpts = this.getTunnel().getClientOptions();
        defaultOpts.putAll((Map<?, ?>)overrides);
        if (!defaultOpts.contains("i2p.streaming.readTimeout")) {
            defaultOpts.setProperty("i2p.streaming.readTimeout", "60000");
        }
        if (!defaultOpts.contains("i2p.streaming.inactivityTimeout")) {
            defaultOpts.setProperty("i2p.streaming.inactivityTimeout", "60000");
        }
        this.verifySocketManager();
        I2PSocketOptions opts = this.sockMgr.buildOptions(defaultOpts);
        if (!defaultOpts.containsKey("i2p.streaming.connectTimeout")) {
            opts.setConnectTimeout(60000L);
        }
        return opts;
    }

    protected void clientConnectionRun(Socket s) {
        Object in = null;
        OutputStream out = null;
        String targetRequest = null;
        boolean usingWWWProxy = false;
        String currentProxy = null;
        long requestId = ++__requestId;
        try {
            String line;
            out = s.getOutputStream();
            InputReader reader = new InputReader(s.getInputStream());
            String method = null;
            String protocol = null;
            String host = null;
            String destination = null;
            StringBuilder newRequest = new StringBuilder();
            boolean ahelper = false;
            while ((line = reader.readLine(method)) != null) {
                String lowercaseLine;
                line = line.trim();
                if (_log.shouldLog(10)) {
                    _log.debug(this.getPrefix(requestId) + "Line=[" + line + "]");
                }
                if ((lowercaseLine = line.toLowerCase()).startsWith("connection: ") || lowercaseLine.startsWith("keep-alive: ") || lowercaseLine.startsWith("proxy-connection: ")) continue;
                if (method == null) {
                    boolean isValid;
                    int pos;
                    if (_log.shouldLog(10)) {
                        _log.debug(this.getPrefix(requestId) + "Method is null for [" + line + "]");
                    }
                    if ((pos = line.indexOf(" ")) == -1) break;
                    method = line.substring(0, pos);
                    String request = line.substring(pos + 1);
                    if (request.startsWith("/") && this.getTunnel().getClientOptions().getProperty("i2ptunnel.noproxy") != null) {
                        request = "http://i2p" + request;
                    } else if (request.startsWith("/eepproxy/")) {
                        int protopos;
                        String subRequest = request.substring("/eepproxy/".length());
                        String uri = subRequest.substring(0, protopos = subRequest.indexOf(" "));
                        if (uri.indexOf("/") == -1) {
                            uri = uri + "/";
                        }
                        request = "http://" + uri + subRequest.substring(protopos);
                    }
                    pos = request.indexOf("//");
                    if (pos == -1) {
                        method = null;
                        break;
                    }
                    protocol = request.substring(0, pos + 2);
                    targetRequest = request = request.substring(pos + 2);
                    pos = request.indexOf("/");
                    if (pos == -1) {
                        method = null;
                        break;
                    }
                    host = request.substring(0, pos);
                    int posPort = host.indexOf(":");
                    int port = 80;
                    if (posPort != -1) {
                        String[] parts = host.split(":");
                        host = parts[0];
                        try {
                            port = Integer.parseInt(parts[1]);
                        }
                        catch (Exception exc) {
                            // empty catch block
                        }
                    }
                    if (host.toLowerCase().endsWith(".i2p")) {
                        String addressHelper;
                        destination = host;
                        host = I2PTunnelHTTPClient.getHostName(destination);
                        int pos2 = request.indexOf("?");
                        if (pos2 != -1) {
                            String ahelperKey = null;
                            boolean ahelperConflict = false;
                            String fragments = request.substring(pos2 + 1);
                            String uriPath = request.substring(0, pos2);
                            pos2 = fragments.indexOf(" ");
                            String protocolVersion = fragments.substring(pos2 + 1);
                            String urlEncoding = "";
                            String initialFragments = fragments = fragments.substring(0, pos2);
                            fragments = fragments + "&";
                            while (fragments.length() > 0) {
                                pos2 = fragments.indexOf("&");
                                String fragment = fragments.substring(0, pos2);
                                fragments = fragments.substring(pos2 + 1);
                                if (fragment.startsWith("i2paddresshelper=")) {
                                    pos2 = fragment.indexOf("=");
                                    ahelperKey = fragment.substring(pos2 + 1);
                                    if (ahelperKey == null) continue;
                                    if (host == null || "i2p".equals(host)) {
                                        this.addressHelpers.put(destination, ahelperKey);
                                        continue;
                                    }
                                    if (host.equals(ahelperKey)) continue;
                                    ahelperConflict = true;
                                    if (!_log.shouldLog(30)) continue;
                                    _log.warn(this.getPrefix(requestId) + "Addresshelper key conflict for site [" + destination + "], trusted key [" + host + "], specified key [" + ahelperKey + "].");
                                    continue;
                                }
                                if ("".equals(urlEncoding)) {
                                    urlEncoding = "?" + fragment;
                                    continue;
                                }
                                urlEncoding = urlEncoding + "&" + fragment;
                            }
                            request = uriPath + urlEncoding + " " + protocolVersion;
                            if (ahelperConflict) {
                                String str = FileUtil.readTextFile(new File(_errorDir, "ahelper-conflict-header.ht").getAbsolutePath(), 100, true);
                                byte[] header = str != null ? str.getBytes() : ERR_AHELPER_CONFLICT;
                                if (out != null) {
                                    long alias = I2PAppContext.getGlobalContext().random().nextLong();
                                    String trustedURL = protocol + uriPath + urlEncoding;
                                    String conflictURL = protocol + alias + ".i2p/?" + initialFragments;
                                    out.write(header);
                                    out.write(("To visit the destination in your host database, click <a href=\"" + trustedURL + "\">here</a>. To visit the conflicting addresshelper link by temporarily giving it a random alias, click <a href=\"" + conflictURL + "\">here</a>.<P/>").getBytes());
                                    out.write("</div><div class=\"proxyfooter\"><p><i>I2P HTTP Proxy Server<br />Generated on: ".getBytes());
                                    out.write(new Date().toString().getBytes());
                                    out.write("</i></div></body></html>\n".getBytes());
                                    out.flush();
                                }
                                s.close();
                                return;
                            }
                        }
                        if ((addressHelper = (String)this.addressHelpers.get(destination)) != null) {
                            destination = addressHelper;
                            host = I2PTunnelHTTPClient.getHostName(destination);
                            ahelper = true;
                        }
                        line = method + " " + request.substring(pos);
                    } else {
                        if (host.toLowerCase().equals("localhost") || host.equals("127.0.0.1")) {
                            if (out != null) {
                                out.write(ERR_LOCALHOST);
                                out.write("<p /><i>Generated on: ".getBytes());
                                out.write(new Date().toString().getBytes());
                                out.write("</i></body></html>\n".getBytes());
                                out.flush();
                            }
                            s.close();
                            return;
                        }
                        if (host.indexOf(".") != -1) {
                            host = host + ":" + port;
                            if (_log.shouldLog(10)) {
                                _log.debug("Before selecting outproxy for " + host);
                            }
                            currentProxy = this.selectProxy();
                            if (_log.shouldLog(10)) {
                                _log.debug("After selecting outproxy for " + host + ": " + currentProxy);
                            }
                            if (currentProxy == null) {
                                if (_log.shouldLog(30)) {
                                    _log.warn(this.getPrefix(requestId) + "Host wants to be outproxied, but we dont have any!");
                                }
                                this.l.log("No HTTP outproxy found for the request.");
                                if (out != null) {
                                    out.write(ERR_NO_OUTPROXY);
                                    out.write("<p /><i>Generated on: ".getBytes());
                                    out.write(new Date().toString().getBytes());
                                    out.write("</i></body></html>\n".getBytes());
                                    out.flush();
                                }
                                s.close();
                                return;
                            }
                            destination = currentProxy;
                            usingWWWProxy = true;
                            if (_log.shouldLog(10)) {
                                _log.debug(this.getPrefix(requestId) + "Host doesnt end with .i2p and it contains a period [" + host + "]: wwwProxy!");
                            }
                        } else {
                            if ((pos = (request = request.substring(pos + 1)).indexOf("/")) < 0) {
                                this.l.log("Invalid request url [" + request + "]");
                                if (out != null) {
                                    out.write(ERR_REQUEST_DENIED);
                                    out.write("<p /><i>Generated on: ".getBytes());
                                    out.write(new Date().toString().getBytes());
                                    out.write("</i></body></html>\n".getBytes());
                                    out.flush();
                                }
                                s.close();
                                return;
                            }
                            destination = request.substring(0, pos);
                            line = method + " " + request.substring(pos);
                        }
                    }
                    boolean bl = isValid = usingWWWProxy || I2PTunnelHTTPClient.isSupportedAddress(host, protocol);
                    if (!isValid) {
                        if (_log.shouldLog(20)) {
                            _log.info(this.getPrefix(requestId) + "notValid(" + host + ")");
                        }
                        method = null;
                        destination = null;
                        break;
                    }
                    if (!usingWWWProxy) {
                        if (_log.shouldLog(20)) {
                            _log.info(this.getPrefix(requestId) + "host=getHostName(" + destination + ")");
                        }
                        host = I2PTunnelHTTPClient.getHostName(destination);
                    }
                    if (_log.shouldLog(10)) {
                        _log.debug(this.getPrefix(requestId) + "METHOD:" + method + ":");
                        _log.debug(this.getPrefix(requestId) + "PROTOC:" + protocol + ":");
                        _log.debug(this.getPrefix(requestId) + "HOST  :" + host + ":");
                        _log.debug(this.getPrefix(requestId) + "DEST  :" + destination + ":");
                    }
                } else if (lowercaseLine.startsWith("host: ") && !usingWWWProxy) {
                    line = "Host: " + host;
                    if (_log.shouldLog(20)) {
                        _log.info(this.getPrefix(requestId) + "Setting host = " + host);
                    }
                } else {
                    if (lowercaseLine.startsWith("user-agent: ") && !Boolean.valueOf(this.getTunnel().getClientOptions().getProperty(PROP_USER_AGENT)).booleanValue()) {
                        line = null;
                        continue;
                    }
                    if (lowercaseLine.startsWith("accept")) {
                        line = null;
                        continue;
                    }
                    if (lowercaseLine.startsWith("referer: ") && !Boolean.valueOf(this.getTunnel().getClientOptions().getProperty(PROP_REFERER)).booleanValue()) {
                        line = null;
                        continue;
                    }
                    if (lowercaseLine.startsWith("via: ") && !Boolean.valueOf(this.getTunnel().getClientOptions().getProperty(PROP_VIA)).booleanValue()) {
                        line = null;
                        continue;
                    }
                    if (lowercaseLine.startsWith("from: ")) {
                        line = null;
                        continue;
                    }
                }
                if (line.length() == 0) {
                    String ok = this.getTunnel().getClientOptions().getProperty("i2ptunnel.gzip");
                    boolean gzip = true;
                    if (ok != null) {
                        gzip = Boolean.valueOf(ok);
                    }
                    if (gzip) {
                        newRequest.append("Accept-Encoding: \r\n");
                        newRequest.append("X-Accept-Encoding: x-i2p-gzip;q=1.0, identity;q=0.5, deflate;q=0, gzip;q=0, *;q=0\r\n");
                    }
                    if (!Boolean.valueOf(this.getTunnel().getClientOptions().getProperty(PROP_USER_AGENT)).booleanValue()) {
                        newRequest.append("User-Agent: MYOB/6.66 (AN/ON)\r\n");
                    }
                    newRequest.append("Connection: close\r\n\r\n");
                    break;
                }
                newRequest.append(line).append("\r\n");
            }
            if (_log.shouldLog(10)) {
                _log.debug(this.getPrefix(requestId) + "NewRequest header: [" + newRequest.toString() + "]");
            }
            if (method == null || destination == null) {
                this.l.log("No HTTP method found in the request.");
                if (out != null) {
                    if ("http://".equalsIgnoreCase(protocol)) {
                        out.write(ERR_REQUEST_DENIED);
                    } else {
                        out.write(ERR_BAD_PROTOCOL);
                    }
                    out.write("<p /><i>Generated on: ".getBytes());
                    out.write(new Date().toString().getBytes());
                    out.write("</i></body></html>\n".getBytes());
                    out.flush();
                }
                s.close();
                return;
            }
            if (_log.shouldLog(10)) {
                _log.debug(this.getPrefix(requestId) + "Destination: " + destination);
            }
            if (destination.equals("proxy.i2p")) {
                I2PTunnelHTTPClient.serveLocalFile(out, method, targetRequest);
                s.close();
                return;
            }
            Destination clientDest = I2PTunnel.destFromName(destination);
            if (clientDest == null) {
                String str;
                if (_log.shouldLog(30)) {
                    _log.warn("Unable to resolve " + destination + " (proxy? " + usingWWWProxy + ", request: " + targetRequest);
                }
                boolean showAddrHelper = false;
                if (usingWWWProxy) {
                    str = FileUtil.readTextFile(new File(_errorDir, "dnfp-header.ht").getAbsolutePath(), 100, true);
                } else if (ahelper) {
                    str = FileUtil.readTextFile(new File(_errorDir, "dnfb-header.ht").getAbsolutePath(), 100, true);
                } else if (destination.length() == 60 && destination.endsWith(".b32.i2p")) {
                    str = FileUtil.readTextFile(new File(_errorDir, "dnf-header.ht").getAbsolutePath(), 100, true);
                } else {
                    str = FileUtil.readTextFile(new File(_errorDir, "dnfh-header.ht").getAbsolutePath(), 100, true);
                    showAddrHelper = true;
                }
                byte[] header = str != null ? str.getBytes() : ERR_DESTINATION_UNKNOWN;
                I2PTunnelHTTPClient.writeErrorMessage(header, out, targetRequest, usingWWWProxy, destination, showAddrHelper);
                s.close();
                return;
            }
            Properties opts = new Properties();
            I2PSocket i2ps = this.createI2PSocket(clientDest, this.getDefaultOptions(opts));
            byte[] data = newRequest.toString().getBytes("ISO-8859-1");
            OnTimeout onTimeout = new OnTimeout(s, s.getOutputStream(), targetRequest, usingWWWProxy, currentProxy, requestId);
            I2PTunnelHTTPClientRunner runner = new I2PTunnelHTTPClientRunner(s, i2ps, this.sockLock, data, this.mySockets, onTimeout);
        }
        catch (SocketException ex) {
            _log.info(this.getPrefix(requestId) + "Error trying to connect", ex);
            this.l.log(ex.getMessage());
            I2PTunnelHTTPClient.handleHTTPClientException(ex, out, targetRequest, usingWWWProxy, currentProxy, requestId);
            I2PTunnelHTTPClient.closeSocket(s);
        }
        catch (IOException ex) {
            _log.info(this.getPrefix(requestId) + "Error trying to connect", ex);
            this.l.log(ex.getMessage());
            I2PTunnelHTTPClient.handleHTTPClientException(ex, out, targetRequest, usingWWWProxy, currentProxy, requestId);
            I2PTunnelHTTPClient.closeSocket(s);
        }
        catch (I2PException ex) {
            _log.info("getPrefix(requestId) + Error trying to connect", ex);
            this.l.log(ex.getMessage());
            I2PTunnelHTTPClient.handleHTTPClientException(ex, out, targetRequest, usingWWWProxy, currentProxy, requestId);
            I2PTunnelHTTPClient.closeSocket(s);
        }
        catch (OutOfMemoryError oom) {
            IOException ex = new IOException("OOM");
            _log.info("getPrefix(requestId) + Error trying to connect", ex);
            this.l.log(ex.getMessage());
            I2PTunnelHTTPClient.handleHTTPClientException(ex, out, targetRequest, usingWWWProxy, currentProxy, requestId);
            I2PTunnelHTTPClient.closeSocket(s);
        }
    }

    private static final String getHostName(String host) {
        if (host == null) {
            return null;
        }
        try {
            Destination dest = I2PTunnel.destFromName(host);
            if (dest == null) {
                return "i2p";
            }
            return dest.toBase64();
        }
        catch (DataFormatException dfe) {
            return "i2p";
        }
    }

    private static void writeErrorMessage(byte[] errMessage, OutputStream out, String targetRequest, boolean usingWWWProxy, String wwwProxy, boolean showAddrHelper) throws IOException {
        if (out != null) {
            out.write(errMessage);
            if (targetRequest != null) {
                int protopos = targetRequest.indexOf(" ");
                String uri = null;
                uri = protopos >= 0 ? targetRequest.substring(0, protopos) : targetRequest;
                out.write("<a href=\"http://".getBytes());
                out.write(uri.getBytes());
                out.write("\">http://".getBytes());
                out.write(uri.getBytes());
                out.write("</a>".getBytes());
                if (usingWWWProxy) {
                    out.write(("<br />WWW proxy: " + wwwProxy).getBytes());
                }
                if (showAddrHelper) {
                    out.write("<br /><br />Click a link below to look for an address helper by using a \"jump\" service:<br />".getBytes());
                    for (int i = 0; i < jumpServers.length; ++i) {
                        String jumphost = jumpServers[i].substring(7);
                        jumphost = jumphost.substring(0, jumphost.indexOf(47));
                        try {
                            Destination dest = I2PTunnel.destFromName(jumphost);
                            if (dest == null) {
                            }
                        }
                        catch (DataFormatException dfe) {}
                        continue;
                        out.write("<br /><a href=\"".getBytes());
                        out.write(jumpServers[i].getBytes());
                        out.write(uri.getBytes());
                        out.write("\">".getBytes());
                        out.write(jumpServers[i].getBytes());
                        out.write(uri.getBytes());
                        out.write("</a>".getBytes());
                    }
                }
            }
            out.write("</div><div class=\"proxyfooter\"><p><i>I2P HTTP Proxy Server<br />Generated on: ".getBytes());
            out.write(new Date().toString().getBytes());
            out.write("</i></div></body></html>\n".getBytes());
            out.flush();
        }
    }

    private static void handleHTTPClientException(Exception ex, OutputStream out, String targetRequest, boolean usingWWWProxy, String wwwProxy, long requestId) {
        if (out != null) {
            try {
                String str = usingWWWProxy ? FileUtil.readTextFile(new File(_errorDir, "dnfp-header.ht").getAbsolutePath(), 100, true) : FileUtil.readTextFile(new File(_errorDir, "dnf-header.ht").getAbsolutePath(), 100, true);
                byte[] header = str != null ? str.getBytes() : ERR_DESTINATION_UNKNOWN;
                I2PTunnelHTTPClient.writeErrorMessage(header, out, targetRequest, usingWWWProxy, wwwProxy, false);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }

    private static boolean isSupportedAddress(String host, String protocol) {
        if (host == null || protocol == null) {
            return false;
        }
        boolean found = false;
        String lcHost = host.toLowerCase();
        for (int i = 0; i < SUPPORTED_HOSTS.length; ++i) {
            if (!SUPPORTED_HOSTS[i].equals(lcHost)) continue;
            found = true;
            break;
        }
        if (!found) {
            try {
                Destination d = I2PTunnel.destFromName(host);
                if (d == null) {
                    return false;
                }
            }
            catch (DataFormatException dfe) {
                // empty catch block
            }
        }
        return protocol.equalsIgnoreCase("http://");
    }

    private static void serveLocalFile(OutputStream out, String method, String targetRequest) {
        if (targetRequest.startsWith("proxy.i2p/ ")) {
            try {
                out.write("HTTP/1.1 200 OK\r\nContent-Type: text/plain\r\nCache-Control: max-age=86400\r\n\r\nI2P HTTP proxy OK".getBytes());
                out.flush();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            return;
        }
        if ((method.equals("GET") || method.equals("HEAD")) && targetRequest.startsWith("proxy.i2p/themes/") && !targetRequest.contains("..")) {
            File themesDir;
            File file;
            int space = targetRequest.indexOf(32);
            String filename = null;
            try {
                filename = targetRequest.substring(17, space);
            }
            catch (IndexOutOfBoundsException ioobe) {
                // empty catch block
            }
            if (filename.startsWith("console/default/")) {
                filename = filename.replaceFirst("default", I2PAppContext.getGlobalContext().getProperty("routerconsole.theme", "light"));
            }
            if ((file = new File(themesDir = new File(_errorDir, "themes"), filename)).exists() && !file.isDirectory()) {
                String type = filename.endsWith(".css") ? "text/css" : (filename.endsWith(".ico") ? "image/x-icon" : (filename.endsWith(".png") ? "image/png" : (filename.endsWith(".jpg") ? "image/jpeg" : "text/html")));
                try {
                    out.write("HTTP/1.1 200 OK\r\nContent-Type: ".getBytes());
                    out.write(type.getBytes());
                    out.write("\r\nCache-Control: max-age=86400\r\n\r\n".getBytes());
                    FileUtil.readFile(filename, themesDir.getAbsolutePath(), out);
                    return;
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
        }
        try {
            out.write(ERR_404);
            out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class OnTimeout
    implements Runnable {
        private Socket _socket;
        private OutputStream _out;
        private String _target;
        private boolean _usingProxy;
        private String _wwwProxy;
        private long _requestId;

        public OnTimeout(Socket s, OutputStream out, String target, boolean usingProxy, String wwwProxy, long id) {
            this._socket = s;
            this._out = out;
            this._target = target;
            this._usingProxy = usingProxy;
            this._wwwProxy = wwwProxy;
            this._requestId = id;
        }

        public void run() {
            if (_log.shouldLog(10)) {
                _log.debug("Timeout occured requesting " + this._target);
            }
            I2PTunnelHTTPClient.handleHTTPClientException(new RuntimeException("Timeout"), this._out, this._target, this._usingProxy, this._wwwProxy, this._requestId);
            I2PTunnelClientBase.closeSocket(this._socket);
        }
    }

    private static class InputReader {
        BufferedReader _br = null;
        InputStream _s;

        public InputReader(InputStream s) {
            this._s = s;
        }

        String readLine(String method) throws IOException {
            if (method == null || "POST".equals(method)) {
                return DataHelper.readLine(this._s);
            }
            if (this._br == null) {
                this._br = new BufferedReader(new InputStreamReader(this._s, "ISO-8859-1"));
            }
            return this._br.readLine();
        }
    }
}

