/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.I2PSession;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketManager;
import net.i2p.client.streaming.I2PSocketManagerFactory;
import net.i2p.client.streaming.I2PSocketOptions;
import net.i2p.data.Destination;
import net.i2p.i2ptunnel.I2PTunnel;
import net.i2p.i2ptunnel.I2PTunnelTask;
import net.i2p.i2ptunnel.Logging;
import net.i2p.util.EventDispatcher;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;
import net.i2p.util.SimpleScheduler;
import net.i2p.util.SimpleTimer;

public abstract class I2PTunnelClientBase
extends I2PTunnelTask
implements Runnable {
    private static final Log _log = new Log(I2PTunnelClientBase.class);
    protected I2PAppContext _context;
    protected Logging l;
    static final long DEFAULT_CONNECT_TIMEOUT = 60000L;
    private static volatile long __clientId = 0L;
    protected long _clientId;
    protected final Object sockLock = new Object();
    protected I2PSocketManager sockMgr;
    protected List mySockets = new ArrayList();
    protected boolean _ownDest;
    protected Destination dest = null;
    private int localPort;
    private boolean listenerReady = false;
    private ServerSocket ss;
    private final Object startLock = new Object();
    private boolean startRunning = false;
    private String handlerName;
    private String privKeyFile;
    private List _waitingSockets = new ArrayList();
    private int _numConnectionBuilders;
    private int _maxWaitTime;
    public static final String PROP_NUM_CONNECTION_BUILDERS = "i2ptunnel.numConnectionBuilders";
    public static final String PROP_MAX_WAIT_TIME = "i2ptunnel.maxWaitTime";
    private static final int DEFAULT_NUM_CONNECTION_BUILDERS = 5;
    private static final int DEFAULT_MAX_WAIT_TIME = 30000;
    private static I2PSocketManager socketManager;

    public I2PTunnelClientBase(int localPort, boolean ownDest, Logging l, EventDispatcher notifyThis, String handlerName, I2PTunnel tunnel) throws IllegalArgumentException {
        this(localPort, ownDest, l, notifyThis, handlerName, tunnel, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public I2PTunnelClientBase(int localPort, boolean ownDest, Logging l, EventDispatcher notifyThis, String handlerName, I2PTunnel tunnel, String pkf) throws IllegalArgumentException {
        super(localPort + " (uninitialized)", notifyThis, tunnel);
        boolean openNow;
        this._clientId = ++__clientId;
        this.localPort = localPort;
        this.l = l;
        this.handlerName = handlerName + this._clientId;
        this._ownDest = ownDest;
        this._context = tunnel.getContext();
        this._context.statManager().createRateStat("i2ptunnel.client.closeBacklog", "How many pending sockets remain when we close one due to backlog?", "I2PTunnel", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("i2ptunnel.client.closeNoBacklog", "How many pending sockets remain when it was removed prior to backlog timeout?", "I2PTunnel", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("i2ptunnel.client.manageTime", "How long it takes to accept a socket and fire it into an i2ptunnel runner (or queue it for the pool)?", "I2PTunnel", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("i2ptunnel.client.buildRunTime", "How long it takes to run a queued socket into an i2ptunnel runner?", "I2PTunnel", new long[]{60000L, 600000L, 3600000L});
        if (pkf != null) {
            File keyFile = new File(pkf);
            if (!keyFile.isAbsolute()) {
                keyFile = new File(this._context.getConfigDir(), pkf);
            }
            this.privKeyFile = keyFile.getAbsolutePath();
        }
        tunnel.getClientOptions().setProperty("i2cp.dontPublishLeaseSet", "true");
        boolean bl = openNow = Boolean.valueOf(tunnel.getClientOptions().getProperty("i2cp.delayOpen")) == false;
        if (openNow) {
            while (this.sockMgr == null) {
                this.verifySocketManager();
                if (this.sockMgr != null) continue;
                _log.log(50, "Unable to create socket manager (our own? " + ownDest + ")");
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {}
            }
            if (this.sockMgr == null) {
                l.log("Invalid I2CP configuration");
                throw new IllegalArgumentException("Socket manager could not be created");
            }
            l.log("I2P session created");
        }
        I2PThread t = new I2PThread(this);
        t.setName("Client " + this._clientId);
        this.listenerReady = false;
        t.start();
        this.open = true;
        I2PTunnelClientBase i2PTunnelClientBase = this;
        synchronized (i2PTunnelClientBase) {
            while (!this.listenerReady && this.open) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {}
            }
        }
        this.configurePool(tunnel);
        if (this.open && this.listenerReady) {
            if (openNow) {
                l.log("Ready! Port " + this.getLocalPort());
            } else {
                l.log("Listening on port " + this.getLocalPort() + ", delaying tunnel open until required");
            }
            this.notifyEvent("openBaseClientResult", "ok");
        } else {
            l.log("Error listening - please see the logs!");
            this.notifyEvent("openBaseClientResult", "error");
        }
    }

    private void configurePool(I2PTunnel tunnel) {
        this._waitingSockets = new ArrayList(4);
        Properties opts = tunnel.getClientOptions();
        String maxWait = opts.getProperty(PROP_MAX_WAIT_TIME, "30000");
        try {
            this._maxWaitTime = Integer.parseInt(maxWait);
        }
        catch (NumberFormatException nfe) {
            this._maxWaitTime = 30000;
        }
        String numBuild = opts.getProperty(PROP_NUM_CONNECTION_BUILDERS, "5");
        try {
            this._numConnectionBuilders = Integer.parseInt(numBuild);
        }
        catch (NumberFormatException nfe) {
            this._numConnectionBuilders = 5;
        }
        for (int i = 0; i < this._numConnectionBuilders; ++i) {
            String name = "ClientBuilder" + this._clientId + '.' + i;
            I2PThread b = new I2PThread(new TunnelConnectionBuilder(), name);
            b.setDaemon(true);
            b.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verifySocketManager() {
        Object object = this.sockLock;
        synchronized (object) {
            boolean newManager = false;
            if (this.sockMgr == null) {
                newManager = true;
            } else {
                I2PSession sess = this.sockMgr.getSession();
                if (sess == null) {
                    newManager = true;
                } else if (sess.isClosed() && Boolean.valueOf(this.getTunnel().getClientOptions().getProperty("i2cp.closeOnIdle")).booleanValue() && Boolean.valueOf(this.getTunnel().getClientOptions().getProperty("i2cp.newDestOnResume")).booleanValue()) {
                    this.getTunnel().removeSession(sess);
                    if (_log.shouldLog(30)) {
                        _log.warn(this.getTunnel().getClientOptions().getProperty("inbound.nickname") + ": Built a new destination on resume");
                    }
                    newManager = true;
                }
            }
            if (newManager) {
                this.sockMgr = this._ownDest ? this.buildSocketManager() : this.getSocketManager();
            }
        }
    }

    protected synchronized I2PSocketManager getSocketManager() {
        return I2PTunnelClientBase.getSocketManager(this.getTunnel(), this.privKeyFile);
    }

    protected static synchronized I2PSocketManager getSocketManager(I2PTunnel tunnel) {
        return I2PTunnelClientBase.getSocketManager(tunnel, null);
    }

    protected static synchronized I2PSocketManager getSocketManager(I2PTunnel tunnel, String pkf) {
        if (socketManager != null) {
            I2PSession s = socketManager.getSession();
            if (s == null || s.isClosed()) {
                if (_log.shouldLog(20)) {
                    _log.info(tunnel.getClientOptions().getProperty("inbound.nickname") + ": Building a new socket manager since the old one closed [s=" + s + "]");
                }
                if (s != null) {
                    tunnel.removeSession(s);
                }
                socketManager = I2PTunnelClientBase.buildSocketManager(tunnel, pkf);
            } else if (_log.shouldLog(20)) {
                _log.info(tunnel.getClientOptions().getProperty("inbound.nickname") + ": Not building a new socket manager since the old one is open [s=" + s + "]");
            }
        } else {
            if (_log.shouldLog(20)) {
                _log.info(tunnel.getClientOptions().getProperty("inbound.nickname") + ": Building a new socket manager since there is no other one");
            }
            socketManager = I2PTunnelClientBase.buildSocketManager(tunnel, pkf);
        }
        return socketManager;
    }

    protected I2PSocketManager buildSocketManager() {
        return I2PTunnelClientBase.buildSocketManager(this.getTunnel(), this.privKeyFile);
    }

    protected static I2PSocketManager buildSocketManager(I2PTunnel tunnel) {
        return I2PTunnelClientBase.buildSocketManager(tunnel, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected static I2PSocketManager buildSocketManager(I2PTunnel tunnel, String pkf) {
        props = new Properties();
        props.putAll((Map<?, ?>)tunnel.getClientOptions());
        portNum = 7654;
        if (tunnel.port != null) {
            try {
                portNum = Integer.parseInt(tunnel.port);
            }
            catch (NumberFormatException nfe) {
                I2PTunnelClientBase._log.log(50, "Invalid port specified [" + tunnel.port + "], reverting to " + portNum);
            }
        }
        sockManager = null;
        while (sockManager == null) {
            block19: {
                if (pkf != null) {
                    fis = null;
                    try {
                        fis = new FileInputStream(pkf);
                        sockManager = I2PSocketManagerFactory.createManager(fis, tunnel.host, portNum, props);
                        var8_9 = null;
                        ** if (fis == null) goto lbl-1000
                    }
                    catch (Throwable var7_11) {
                        var8_9 = null;
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (IOException ioe) {
                                // empty catch block
                            }
                        }
                        throw var7_11;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            fis.close();
                        }
                        catch (IOException ioe) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block19;
                        catch (IOException ioe) {
                            I2PTunnelClientBase._log.error("Error opening key file", ioe);
                            var8_9 = null;
                            if (fis != null) {
                                try {
                                    fis.close();
                                }
                                catch (IOException ioe) {}
                            }
                            break block19;
                        }
                    }
                }
                sockManager = I2PSocketManagerFactory.createManager(tunnel.host, portNum, props);
            }
            if (sockManager != null) continue;
            I2PTunnelClientBase._log.log(50, "Unable to create socket manager");
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException ie) {}
        }
        sockManager.setName("Client");
        if (I2PTunnelClientBase._log.shouldLog(20)) {
            I2PTunnelClientBase._log.info(tunnel.getClientOptions().getProperty("inbound.nickname") + ": Built a new socket manager [s=" + sockManager.getSession() + "]");
        }
        tunnel.addSession(sockManager.getSession());
        return sockManager;
    }

    public final int getLocalPort() {
        return this.localPort;
    }

    protected final InetAddress getListenHost(Logging l) {
        try {
            return InetAddress.getByName(this.getTunnel().listenHost);
        }
        catch (UnknownHostException uhe) {
            l.log("Could not find listen host to bind to [" + this.getTunnel().host + "]");
            _log.error("Error finding host to bind", uhe);
            this.notifyEvent("openBaseClientResult", "error");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void startRunning() {
        Object object = this.startLock;
        synchronized (object) {
            this.startRunning = true;
            this.startLock.notify();
        }
    }

    protected I2PSocketOptions getDefaultOptions() {
        Properties defaultOpts = this.getTunnel().getClientOptions();
        I2PSocketOptions opts = this.sockMgr.buildOptions(defaultOpts);
        if (!defaultOpts.containsKey("i2p.streaming.connectTimeout")) {
            opts.setConnectTimeout(60000L);
        }
        return opts;
    }

    protected I2PSocketOptions getDefaultOptions(Properties overrides) {
        Properties defaultOpts = this.getTunnel().getClientOptions();
        defaultOpts.putAll((Map<?, ?>)overrides);
        I2PSocketOptions opts = this.sockMgr.buildOptions(defaultOpts);
        if (!defaultOpts.containsKey("i2p.streaming.connectTimeout")) {
            opts.setConnectTimeout(60000L);
        }
        return opts;
    }

    public I2PSocket createI2PSocket(Destination dest) throws I2PException, ConnectException, NoRouteToHostException, InterruptedIOException {
        this.verifySocketManager();
        return this.createI2PSocket(dest, this.getDefaultOptions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public I2PSocket createI2PSocket(Destination dest, I2PSocketOptions opt) throws I2PException, ConnectException, NoRouteToHostException, InterruptedIOException {
        this.verifySocketManager();
        I2PSocket i2ps = this.sockMgr.connect(dest, opt);
        Object object = this.sockLock;
        synchronized (object) {
            this.mySockets.add(i2ps);
        }
        return i2ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        try {
            InetAddress addr = this.getListenHost(this.l);
            if (addr == null) {
                this.open = false;
                Object object = this;
                synchronized (object) {
                    this.notifyAll();
                }
                object = this._waitingSockets;
                synchronized (object) {
                    this._waitingSockets.notifyAll();
                }
                return;
            }
            this.ss = new ServerSocket(this.localPort, 0, addr);
            if (this.localPort == 0) {
                this.localPort = this.ss.getLocalPort();
            }
            this.notifyEvent("clientLocalPort", new Integer(this.ss.getLocalPort()));
            this.l.log("Listening for clients on port " + this.localPort + " of " + this.getTunnel().listenHost);
            Object object = this;
            synchronized (object) {
                this.listenerReady = true;
                this.notify();
            }
            object = this.startLock;
            synchronized (object) {
                while (!this.startRunning) {
                    try {
                        this.startLock.wait();
                    }
                    catch (InterruptedException ie) {}
                }
            }
            while (true) {
                Socket s = this.ss.accept();
                long before = System.currentTimeMillis();
                this.manageConnection(s);
                long total = System.currentTimeMillis() - before;
                this._context.statManager().addRateData("i2ptunnel.client.manageTime", total, total);
            }
        }
        catch (IOException ex) {
            if (this.open) {
                _log.error("Error listening for connections on " + this.localPort, ex);
                this.notifyEvent("openBaseClientResult", "error");
            }
            Object object = this.sockLock;
            synchronized (object) {
                this.mySockets.clear();
            }
            this.open = false;
            object = this;
            synchronized (object) {
                this.notifyAll();
            }
            List list = this._waitingSockets;
            synchronized (list) {
                this._waitingSockets.notifyAll();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void manageConnection(Socket s) {
        if (s == null) {
            return;
        }
        if (this._numConnectionBuilders <= 0) {
            new I2PThread(new BlockingRunner(s), "Clinet run").start();
            return;
        }
        if (this._maxWaitTime > 0) {
            SimpleScheduler.getInstance().addEvent(new CloseEvent(s), this._maxWaitTime);
        }
        List list = this._waitingSockets;
        synchronized (list) {
            this._waitingSockets.add(s);
            this._waitingSockets.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close(boolean forced) {
        if (!this.open) {
            return true;
        }
        Object object = this.sockLock;
        synchronized (object) {
            if (this.sockMgr != null) {
                this.mySockets.retainAll(this.sockMgr.listSockets());
                if (!forced && this.mySockets.size() != 0) {
                    this.l.log("There are still active connections!");
                    _log.debug("can't close: there are still active connections!");
                    Iterator it = this.mySockets.iterator();
                    while (it.hasNext()) {
                        this.l.log("->" + it.next());
                    }
                    return false;
                }
                I2PSession session = this.sockMgr.getSession();
                if (session != null) {
                    this.getTunnel().removeSession(session);
                }
            }
            this.l.log("Closing client " + this.toString());
            this.open = false;
            try {
                if (this.ss != null) {
                    this.ss.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return false;
            }
            this.l.log("Client closed.");
        }
        object = this._waitingSockets;
        synchronized (object) {
            this._waitingSockets.notifyAll();
        }
        return true;
    }

    public static void closeSocket(Socket s) {
        try {
            s.close();
        }
        catch (IOException ex) {
            _log.error("Could not close socket", ex);
        }
    }

    protected abstract void clientConnectionRun(Socket var1);

    private class TunnelConnectionBuilder
    implements Runnable {
        private TunnelConnectionBuilder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Socket s = null;
            while (I2PTunnelClientBase.this.open) {
                try {
                    List list = I2PTunnelClientBase.this._waitingSockets;
                    synchronized (list) {
                        if (I2PTunnelClientBase.this._waitingSockets.size() <= 0) {
                            I2PTunnelClientBase.this._waitingSockets.wait();
                        } else {
                            s = (Socket)I2PTunnelClientBase.this._waitingSockets.remove(0);
                        }
                    }
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                if (s != null) {
                    long before = System.currentTimeMillis();
                    I2PTunnelClientBase.this.clientConnectionRun(s);
                    long total = System.currentTimeMillis() - before;
                    I2PTunnelClientBase.this._context.statManager().addRateData("i2ptunnel.client.buildRunTime", total, 0L);
                }
                s = null;
            }
        }
    }

    private class CloseEvent
    implements SimpleTimer.TimedEvent {
        private Socket _s;

        public CloseEvent(Socket s) {
            this._s = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void timeReached() {
            int remaining = 0;
            boolean stillWaiting = false;
            List list = I2PTunnelClientBase.this._waitingSockets;
            synchronized (list) {
                stillWaiting = I2PTunnelClientBase.this._waitingSockets.remove(this._s);
                remaining = I2PTunnelClientBase.this._waitingSockets.size();
            }
            if (stillWaiting) {
                try {
                    this._s.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (_log.shouldLog(20)) {
                    I2PTunnelClientBase.this._context.statManager().addRateData("i2ptunnel.client.closeBacklog", remaining, 0L);
                    _log.info("Closed a waiting socket because of backlog");
                }
            } else {
                I2PTunnelClientBase.this._context.statManager().addRateData("i2ptunnel.client.closeNoBacklog", remaining, 0L);
            }
        }
    }

    private class BlockingRunner
    implements Runnable {
        private Socket _s;

        public BlockingRunner(Socket s) {
            this._s = s;
        }

        public void run() {
            I2PTunnelClientBase.this.clientConnectionRun(this._s);
        }
    }
}

