/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.I2PClient;
import net.i2p.client.I2PClientFactory;
import net.i2p.client.I2PSession;
import net.i2p.data.Base64;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.i2ptunnel.I2PTunnelClient;
import net.i2p.i2ptunnel.I2PTunnelConnectClient;
import net.i2p.i2ptunnel.I2PTunnelGUI;
import net.i2p.i2ptunnel.I2PTunnelHTTPClient;
import net.i2p.i2ptunnel.I2PTunnelHTTPServer;
import net.i2p.i2ptunnel.I2PTunnelIRCClient;
import net.i2p.i2ptunnel.I2PTunnelIRCServer;
import net.i2p.i2ptunnel.I2PTunnelServer;
import net.i2p.i2ptunnel.I2PTunnelTask;
import net.i2p.i2ptunnel.I2Ping;
import net.i2p.i2ptunnel.Logging;
import net.i2p.i2ptunnel.socks.I2PSOCKSTunnel;
import net.i2p.i2ptunnel.streamr.StreamrConsumer;
import net.i2p.i2ptunnel.streamr.StreamrProducer;
import net.i2p.util.EventDispatcher;
import net.i2p.util.EventDispatcherImpl;
import net.i2p.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class I2PTunnel
implements Logging,
EventDispatcher {
    private Log _log;
    private EventDispatcherImpl _event;
    private I2PAppContext _context;
    private static long __tunnelId = 0L;
    private long _tunnelId;
    private Properties _clientOptions;
    private final List<I2PSession> _sessions;
    public static final int PACKET_DELAY = 100;
    public boolean ownDest = false;
    public String port = System.getProperty("i2cp.tcp.port", "7654");
    public String host;
    public String listenHost = this.host = System.getProperty("i2cp.tcp.host", "127.0.0.1");
    public long readTimeout = -1L;
    private static final String[] nocli_args = new String[]{"-nocli", "-die"};
    private final List tasks = new ArrayList();
    private int next_task_id = 1;
    private final Set listeners = new HashSet();

    public static void main(String[] args) throws IOException {
        new I2PTunnel(args);
    }

    public I2PTunnel() {
        this(nocli_args);
    }

    public I2PTunnel(String[] args) {
        this(args, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public I2PTunnel(String[] args, ConnectionEventListener lsnr) {
        this._context = I2PAppContext.getGlobalContext();
        this._tunnelId = ++__tunnelId;
        this._log = this._context.logManager().getLog(I2PTunnel.class);
        this._event = new EventDispatcherImpl();
        Properties p = new Properties();
        p.putAll((Map<?, ?>)System.getProperties());
        this._clientOptions = p;
        this._sessions = new ArrayList<I2PSession>(1);
        this.addConnectionEventListener(lsnr);
        boolean gui = true;
        boolean checkRunByE = true;
        boolean cli = true;
        boolean dontDie = true;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-die")) {
                dontDie = false;
                gui = false;
                cli = false;
                checkRunByE = false;
                continue;
            }
            if (args[i].equals("-nogui")) {
                gui = false;
                this._log.warn(this.getPrefix() + "The `-nogui' option of I2PTunnel is deprecated.\n" + "Use `-cli', `-nocli' (aka `-wait') or `-die' instead.");
                continue;
            }
            if (args[i].equals("-cli")) {
                gui = false;
                cli = true;
                checkRunByE = false;
                continue;
            }
            if (args[i].equals("-nocli") || args[i].equals("-wait")) {
                gui = false;
                cli = false;
                checkRunByE = false;
                continue;
            }
            if (args[i].equals("-e")) {
                this.runCommand(args[i + 1], this);
                ++i;
                if (!checkRunByE) continue;
                checkRunByE = false;
                cli = false;
                continue;
            }
            if (new File(args[i]).exists()) {
                this.runCommand("run " + args[i], this);
                continue;
            }
            System.out.println("Unknown parameter " + args[i]);
        }
        if (gui) {
            new I2PTunnelGUI(this);
        } else if (cli) {
            try {
                System.out.println("Enter 'help' for help.");
                BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
                while (true) {
                    System.out.print("I2PTunnel>");
                    String cmd = r.readLine();
                    if (cmd != null) {
                        this.runCommand(cmd, this);
                        continue;
                    }
                    break;
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        while (dontDie) {
            I2PTunnel i2PTunnel = this;
            synchronized (i2PTunnel) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<I2PSession> getSessions() {
        List<I2PSession> list = this._sessions;
        synchronized (list) {
            return new ArrayList<I2PSession>(this._sessions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSession(I2PSession session) {
        if (session == null) {
            return;
        }
        List<I2PSession> list = this._sessions;
        synchronized (list) {
            if (!this._sessions.contains(session)) {
                this._sessions.add(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSession(I2PSession session) {
        if (session == null) {
            return;
        }
        List<I2PSession> list = this._sessions;
        synchronized (list) {
            this._sessions.remove(session);
        }
    }

    public Properties getClientOptions() {
        return this._clientOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addtask(I2PTunnelTask tsk) {
        tsk.setTunnel(this);
        if (tsk.isOpen()) {
            tsk.setId(this.next_task_id);
            ++this.next_task_id;
            List list = this.tasks;
            synchronized (list) {
                this.tasks.add(tsk);
            }
        }
    }

    private static String[] split(String src, String delim) {
        StringTokenizer tok = new StringTokenizer(src, delim);
        String[] vals = new String[tok.countTokens()];
        for (int i = 0; i < vals.length; ++i) {
            vals[i] = tok.nextToken();
        }
        return vals;
    }

    public void runCommand(String cmd, Logging l) {
        if (cmd.indexOf(" ") == -1) {
            cmd = cmd + " ";
        }
        int iii = cmd.indexOf(" ");
        String cmdname = cmd.substring(0, iii).toLowerCase();
        String allargs = cmd.substring(iii + 1);
        String[] args = I2PTunnel.split(allargs, " ");
        if ("help".equals(cmdname)) {
            this.runHelp(l);
        } else if ("clientoptions".equals(cmdname)) {
            this.runClientOptions(args, l);
        } else if ("server".equals(cmdname)) {
            this.runServer(args, l);
        } else if ("httpserver".equals(cmdname)) {
            this.runHttpServer(args, l);
        } else if ("ircserver".equals(cmdname)) {
            this.runIrcServer(args, l);
        } else if ("textserver".equals(cmdname)) {
            this.runTextServer(args, l);
        } else if ("client".equals(cmdname)) {
            this.runClient(args, l);
        } else if ("httpclient".equals(cmdname)) {
            this.runHttpClient(args, l);
        } else if ("ircclient".equals(cmdname)) {
            this.runIrcClient(args, l);
        } else if ("sockstunnel".equals(cmdname)) {
            this.runSOCKSTunnel(args, l);
        } else if ("connectclient".equals(cmdname)) {
            this.runConnectClient(args, l);
        } else if ("streamrclient".equals(cmdname)) {
            this.runStreamrClient(args, l);
        } else if ("streamrserver".equals(cmdname)) {
            this.runStreamrServer(args, l);
        } else if ("config".equals(cmdname)) {
            this.runConfig(args, l);
        } else if ("listen_on".equals(cmdname)) {
            this.runListenOn(args, l);
        } else if ("read_timeout".equals(cmdname)) {
            this.runReadTimeout(args, l);
        } else if ("genkeys".equals(cmdname)) {
            this.runGenKeys(args, l);
        } else if ("gentextkeys".equals(cmdname)) {
            this.runGenTextKeys(l);
        } else if (cmdname.equals("quit")) {
            this.runQuit(l);
        } else if (cmdname.equals("list")) {
            this.runList(l);
        } else if (cmdname.equals("close")) {
            this.runClose(args, l);
        } else if (cmdname.equals("run")) {
            this.runRun(args, l);
        } else if (cmdname.equals("lookup")) {
            this.runLookup(args, l);
        } else if (cmdname.equals("ping")) {
            this.runPing(allargs, l);
        } else if (cmdname.equals("owndest")) {
            this.runOwnDest(args, l);
        } else {
            l.log("Unknown command [" + cmdname + "]");
        }
    }

    public void runHelp(Logging l) {
        l.log("Command list:");
        l.log("config <i2phost> <i2pport>");
        l.log("listen_on <ip>");
        l.log("clientoptions[ key=value]*");
        l.log("read_timeout <msecs>");
        l.log("owndest yes|no");
        l.log("ping <args>");
        l.log("server <host> <port> <privkeyfile>");
        l.log("httpserver <host> <port> <spoofedhost> <privkeyfile>");
        l.log("textserver <host> <port> <privkey>");
        l.log("genkeys <privkeyfile> [<pubkeyfile>]");
        l.log("gentextkeys");
        l.log("client <port> <pubkey>[,<pubkey,...]|file:<pubkeyfile> [<sharedClient>]");
        l.log("ircclient <port> <pubkey>[,<pubkey,...]|file:<pubkeyfile> [<sharedClient>]");
        l.log("httpclient <port> [<sharedClient>] [<proxy>]");
        l.log("connectclient <port> [<sharedClient>] [<proxy>]");
        l.log("lookup <name>");
        l.log("quit");
        l.log("close [forced] <jobnumber>|all");
        l.log("list");
        l.log("run <commandfile>");
    }

    public void runClientOptions(String[] args, Logging l) {
        this._clientOptions.clear();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                int index = args[i].indexOf(61);
                if (index <= 0) continue;
                String key = args[i].substring(0, index);
                String val = args[i].substring(index + 1);
                this._clientOptions.setProperty(key, val);
            }
        }
        this.notifyEvent("clientoptions_onResult", "ok");
    }

    public void runServer(String[] args, Logging l) {
        if (args.length == 3) {
            InetAddress serverHost = null;
            int portNum = -1;
            File privKeyFile = null;
            try {
                serverHost = InetAddress.getByName(args[0]);
            }
            catch (UnknownHostException uhe) {
                l.log("unknown host");
                this._log.error(this.getPrefix() + "Error resolving " + args[0], uhe);
                this.notifyEvent("serverTaskId", -1);
                return;
            }
            try {
                portNum = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException nfe) {
                l.log("invalid port");
                this._log.error(this.getPrefix() + "Port specified is not valid: " + args[1], nfe);
                this.notifyEvent("serverTaskId", -1);
                return;
            }
            privKeyFile = new File(args[2]);
            if (!privKeyFile.isAbsolute()) {
                privKeyFile = new File(this._context.getConfigDir(), args[2]);
            }
            if (!privKeyFile.canRead()) {
                l.log("private key file does not exist");
                this._log.error(this.getPrefix() + "Private key file does not exist or is not readable: " + args[2]);
                this.notifyEvent("serverTaskId", -1);
                return;
            }
            I2PTunnelServer serv = new I2PTunnelServer(serverHost, portNum, privKeyFile, args[2], l, (EventDispatcher)this, this);
            serv.setReadTimeout(this.readTimeout);
            serv.startRunning();
            this.addtask(serv);
            this.notifyEvent("serverTaskId", serv.getId());
            return;
        }
        l.log("server <host> <port> <privkeyfile>");
        l.log("  creates a server that sends all incoming data\n  of its destination to host:port.");
        this.notifyEvent("serverTaskId", -1);
    }

    public void runIrcServer(String[] args, Logging l) {
        if (args.length == 3) {
            InetAddress serverHost = null;
            int portNum = -1;
            File privKeyFile = null;
            try {
                serverHost = InetAddress.getByName(args[0]);
            }
            catch (UnknownHostException uhe) {
                l.log("unknown host");
                this._log.error(this.getPrefix() + "Error resolving " + args[0], uhe);
                this.notifyEvent("serverTaskId", -1);
                return;
            }
            try {
                portNum = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException nfe) {
                l.log("invalid port");
                this._log.error(this.getPrefix() + "Port specified is not valid: " + args[1], nfe);
                this.notifyEvent("serverTaskId", -1);
                return;
            }
            privKeyFile = new File(args[2]);
            if (!privKeyFile.isAbsolute()) {
                privKeyFile = new File(this._context.getConfigDir(), args[2]);
            }
            if (!privKeyFile.canRead()) {
                l.log("private key file does not exist");
                this._log.error(this.getPrefix() + "Private key file does not exist or is not readable: " + args[2]);
                this.notifyEvent("serverTaskId", -1);
                return;
            }
            I2PTunnelIRCServer serv = new I2PTunnelIRCServer(serverHost, portNum, privKeyFile, args[2], l, (EventDispatcher)this, this);
            serv.setReadTimeout(this.readTimeout);
            serv.startRunning();
            this.addtask(serv);
            this.notifyEvent("serverTaskId", serv.getId());
            return;
        }
        l.log("server <host> <port> <privkeyfile>");
        l.log("  creates a server that sends all incoming data\n  of its destination to host:port.");
        this.notifyEvent("serverTaskId", -1);
    }

    public void runHttpServer(String[] args, Logging l) {
        if (args.length == 4) {
            InetAddress serverHost = null;
            int portNum = -1;
            File privKeyFile = null;
            try {
                serverHost = InetAddress.getByName(args[0]);
            }
            catch (UnknownHostException uhe) {
                l.log("unknown host");
                this._log.error(this.getPrefix() + "Error resolving " + args[0], uhe);
                this.notifyEvent("serverTaskId", -1);
                return;
            }
            try {
                portNum = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException nfe) {
                l.log("invalid port");
                this._log.error(this.getPrefix() + "Port specified is not valid: " + args[1], nfe);
                this.notifyEvent("serverTaskId", -1);
                return;
            }
            String spoofedHost = args[2];
            privKeyFile = new File(args[3]);
            if (!privKeyFile.isAbsolute()) {
                privKeyFile = new File(this._context.getConfigDir(), args[3]);
            }
            if (!privKeyFile.canRead()) {
                l.log("private key file does not exist");
                this._log.error(this.getPrefix() + "Private key file does not exist or is not readable: " + args[3]);
                this.notifyEvent("serverTaskId", -1);
                return;
            }
            I2PTunnelHTTPServer serv = new I2PTunnelHTTPServer(serverHost, portNum, privKeyFile, args[3], spoofedHost, l, (EventDispatcher)this, this);
            serv.setReadTimeout(this.readTimeout);
            serv.startRunning();
            this.addtask(serv);
            this.notifyEvent("serverTaskId", serv.getId());
            return;
        }
        l.log("httpserver <host> <port> <spoofedhost> <privkeyfile>");
        l.log("  creates an HTTP server that sends all incoming data\n  of its destination to host:port., filtering the HTTP\n  headers so it looks like the request is to the spoofed host.");
        this.notifyEvent("serverTaskId", -1);
    }

    public void runTextServer(String[] args, Logging l) {
        if (args.length == 3) {
            InetAddress serverHost = null;
            int portNum = -1;
            try {
                serverHost = InetAddress.getByName(args[0]);
            }
            catch (UnknownHostException uhe) {
                l.log("unknown host");
                this._log.error(this.getPrefix() + "Error resolving " + args[0], uhe);
                this.notifyEvent("serverTaskId", -1);
                return;
            }
            try {
                portNum = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException nfe) {
                l.log("invalid port");
                this._log.error(this.getPrefix() + "Port specified is not valid: " + args[1], nfe);
                this.notifyEvent("serverTaskId", -1);
                return;
            }
            I2PTunnelServer serv = new I2PTunnelServer(serverHost, portNum, args[2], l, this, this);
            serv.setReadTimeout(this.readTimeout);
            serv.startRunning();
            this.addtask(serv);
            this.notifyEvent("serverTaskId", serv.getId());
        } else {
            l.log("textserver <host> <port> <privkey>");
            l.log("  creates a server that sends all incoming data\n  of its destination to host:port.");
            this.notifyEvent("textserverTaskId", -1);
        }
    }

    public void runClient(String[] args, Logging l) {
        boolean isShared = true;
        if (args.length >= 3) {
            isShared = Boolean.valueOf(args[2].trim());
        }
        if (args.length >= 2) {
            int portNum = -1;
            try {
                portNum = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException nfe) {
                l.log("invalid port");
                this._log.error(this.getPrefix() + "Port specified is not valid: " + args[0], nfe);
                this.notifyEvent("clientTaskId", -1);
                return;
            }
            this.ownDest = !isShared;
            try {
                String privateKeyFile = null;
                if (args.length >= 4) {
                    privateKeyFile = args[3];
                }
                I2PTunnelClient task = new I2PTunnelClient(portNum, args[1], l, this.ownDest, this, this, privateKeyFile);
                this.addtask(task);
                this.notifyEvent("clientTaskId", task.getId());
            }
            catch (IllegalArgumentException iae) {
                this._log.error(this.getPrefix() + "Invalid I2PTunnel config to create a client [" + this.host + ":" + this.port + "]", iae);
                l.log("Invalid I2PTunnel configuration [" + this.host + ":" + this.port + "]");
                this.notifyEvent("clientTaskId", -1);
            }
        } else {
            l.log("client <port> <pubkey>[,<pubkey>]|file:<pubkeyfile>[ <sharedClient>] [<privKeyFile>]");
            l.log("  creates a client that forwards port to the pubkey.\n  use 0 as port to get a free port assigned.  If you specify\n  a comma delimited list of pubkeys, it will rotate among them\n  randomlyl. sharedClient indicates if this client shares \n   with other clients (true of false)");
            this.notifyEvent("clientTaskId", -1);
        }
    }

    public void runHttpClient(String[] args, Logging l) {
        if (args.length >= 1 && args.length <= 3) {
            int clientPort = -1;
            try {
                clientPort = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException nfe) {
                l.log("invalid port");
                this._log.error(this.getPrefix() + "Port specified is not valid: " + args[0], nfe);
                this.notifyEvent("httpclientTaskId", -1);
                return;
            }
            String proxy = "";
            boolean isShared = true;
            if (args.length > 1) {
                if ("true".equalsIgnoreCase(args[1].trim())) {
                    isShared = true;
                    if (args.length == 3) {
                        proxy = args[2];
                    }
                } else if ("false".equalsIgnoreCase(args[1].trim())) {
                    this._log.warn("args[1] == [" + args[1] + "] and rejected explicitly");
                    isShared = false;
                    if (args.length == 3) {
                        proxy = args[2];
                    }
                } else if (args.length == 3) {
                    isShared = false;
                    proxy = args[2];
                    this._log.warn("args[1] == [" + args[1] + "] but rejected");
                } else {
                    isShared = true;
                    proxy = args[1];
                }
            }
            this.ownDest = !isShared;
            try {
                I2PTunnelHTTPClient task = new I2PTunnelHTTPClient(clientPort, l, this.ownDest, proxy, this, this);
                this.addtask(task);
                this.notifyEvent("httpclientTaskId", task.getId());
            }
            catch (IllegalArgumentException iae) {
                this._log.error(this.getPrefix() + "Invalid I2PTunnel config to create an httpclient [" + this.host + ":" + clientPort + "]", iae);
                l.log("Invalid I2PTunnel configuration [" + this.host + ":" + clientPort + "]");
                this.notifyEvent("httpclientTaskId", -1);
            }
        } else {
            l.log("httpclient <port> [<sharedClient>] [<proxy>]");
            l.log("  creates a client that distributes HTTP requests.");
            l.log("  <sharedClient> (optional) indicates if this client shares tunnels with other clients (true of false)");
            l.log("  <proxy> (optional) indicates a proxy server to be used");
            l.log("  when trying to access an address out of the .i2p domain");
            this.notifyEvent("httpclientTaskId", -1);
        }
    }

    public void runConnectClient(String[] args, Logging l) {
        if (args.length >= 1 && args.length <= 3) {
            int _port = -1;
            try {
                _port = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException nfe) {
                this._log.error(this.getPrefix() + "Port specified is not valid: " + args[0], nfe);
                return;
            }
            String proxy = "";
            boolean isShared = true;
            if (args.length > 1) {
                if ("true".equalsIgnoreCase(args[1].trim())) {
                    isShared = true;
                    if (args.length == 3) {
                        proxy = args[2];
                    }
                } else if ("false".equalsIgnoreCase(args[1].trim())) {
                    this._log.warn("args[1] == [" + args[1] + "] and rejected explicitly");
                    isShared = false;
                    if (args.length == 3) {
                        proxy = args[2];
                    }
                } else if (args.length == 3) {
                    isShared = false;
                    proxy = args[2];
                    this._log.warn("args[1] == [" + args[1] + "] but rejected");
                } else {
                    isShared = true;
                    proxy = args[1];
                }
            }
            this.ownDest = !isShared;
            try {
                I2PTunnelConnectClient task = new I2PTunnelConnectClient(_port, l, this.ownDest, proxy, this, this);
                this.addtask(task);
            }
            catch (IllegalArgumentException iae) {
                this._log.error(this.getPrefix() + "Invalid I2PTunnel config to create an httpclient [" + this.host + ":" + _port + "]", iae);
            }
        } else {
            l.log("connectclient <port> [<sharedClient>] [<proxy>]");
            l.log("  creates a client that for SSL/HTTPS requests.");
            l.log("  <sharedClient> (optional) indicates if this client shares tunnels with other clients (true of false)");
            l.log("  <proxy> (optional) indicates a proxy server to be used");
            l.log("  when trying to access an address out of the .i2p domain");
        }
    }

    public void runIrcClient(String[] args, Logging l) {
        if (args.length >= 2) {
            int _port = -1;
            try {
                _port = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException nfe) {
                l.log("invalid port");
                this._log.error(this.getPrefix() + "Port specified is not valid: " + args[0], nfe);
                this.notifyEvent("ircclientTaskId", -1);
                return;
            }
            boolean isShared = true;
            if (args.length > 2) {
                if ("true".equalsIgnoreCase(args[2].trim())) {
                    isShared = true;
                } else if ("false".equalsIgnoreCase(args[2].trim())) {
                    this._log.warn("args[2] == [" + args[2] + "] and rejected explicitly");
                    isShared = false;
                } else {
                    isShared = true;
                }
            }
            this.ownDest = !isShared;
            try {
                String privateKeyFile = null;
                if (args.length >= 4) {
                    privateKeyFile = args[3];
                }
                I2PTunnelIRCClient task = new I2PTunnelIRCClient(_port, args[1], l, this.ownDest, this, this, privateKeyFile);
                this.addtask(task);
                this.notifyEvent("ircclientTaskId", task.getId());
            }
            catch (IllegalArgumentException iae) {
                this._log.error(this.getPrefix() + "Invalid I2PTunnel config to create an ircclient [" + this.host + ":" + _port + "]", iae);
                l.log("Invalid I2PTunnel configuration [" + this.host + ":" + _port + "]");
                this.notifyEvent("ircclientTaskId", -1);
            }
        } else {
            l.log("ircclient <port> [<sharedClient> [<privKeyFile>]]");
            l.log("  creates a client that filter IRC protocol.");
            l.log("  <sharedClient> (optional) indicates if this client shares tunnels with other clients (true of false)");
            this.notifyEvent("ircclientTaskId", -1);
        }
    }

    public void runSOCKSTunnel(String[] args, Logging l) {
        if (args.length >= 1 && args.length <= 2) {
            int _port = -1;
            try {
                _port = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException nfe) {
                l.log("invalid port");
                this._log.error(this.getPrefix() + "Port specified is not valid: " + args[0], nfe);
                this.notifyEvent("sockstunnelTaskId", -1);
                return;
            }
            boolean isShared = false;
            if (args.length > 1) {
                isShared = "true".equalsIgnoreCase(args[1].trim());
            }
            this.ownDest = !isShared;
            I2PSOCKSTunnel task = new I2PSOCKSTunnel(_port, l, this.ownDest, this, this);
            this.addtask(task);
            this.notifyEvent("sockstunnelTaskId", task.getId());
        } else {
            l.log("sockstunnel <port>");
            l.log("  creates a tunnel that distributes SOCKS requests.");
            this.notifyEvent("sockstunnelTaskId", -1);
        }
    }

    public void runStreamrClient(String[] args, Logging l) {
        if (args.length == 3) {
            InetAddress _host;
            try {
                _host = InetAddress.getByName(args[0]);
            }
            catch (UnknownHostException uhe) {
                l.log("unknown host");
                this._log.error(this.getPrefix() + "Error resolving " + args[0], uhe);
                this.notifyEvent("streamrtunnelTaskId", -1);
                return;
            }
            int _port = -1;
            try {
                _port = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException nfe) {
                l.log("invalid port");
                this._log.error(this.getPrefix() + "Port specified is not valid: " + args[0], nfe);
                this.notifyEvent("streamrtunnelTaskId", -1);
                return;
            }
            StreamrConsumer task = new StreamrConsumer(_host, _port, args[2], l, this, this);
            task.startRunning();
            this.addtask(task);
            this.notifyEvent("streamrtunnelTaskId", task.getId());
        } else {
            l.log("streamrclient <host> <port> <destination>");
            l.log("  creates a tunnel that receives streaming data.");
            this.notifyEvent("streamrtunnelTaskId", -1);
        }
    }

    public void runStreamrServer(String[] args, Logging l) {
        if (args.length == 2) {
            int _port = -1;
            try {
                _port = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException nfe) {
                l.log("invalid port");
                this._log.error(this.getPrefix() + "Port specified is not valid: " + args[0], nfe);
                this.notifyEvent("streamrtunnelTaskId", -1);
                return;
            }
            File privKeyFile = new File(args[1]);
            if (!privKeyFile.isAbsolute()) {
                privKeyFile = new File(this._context.getConfigDir(), args[1]);
            }
            if (!privKeyFile.canRead()) {
                l.log("private key file does not exist");
                this._log.error(this.getPrefix() + "Private key file does not exist or is not readable: " + args[3]);
                this.notifyEvent("serverTaskId", -1);
                return;
            }
            StreamrProducer task = new StreamrProducer(_port, privKeyFile, args[1], l, (EventDispatcher)this, this);
            task.startRunning();
            this.addtask(task);
            this.notifyEvent("streamrtunnelTaskId", task.getId());
        } else {
            l.log("streamrserver <port> <privkeyfile>");
            l.log("  creates a tunnel that sends streaming data.");
            this.notifyEvent("streamrtunnelTaskId", -1);
        }
    }

    public void runConfig(String[] args, Logging l) {
        if (args.length == 2) {
            this.listenHost = this.host = args[0];
            this.port = args[1];
            this.notifyEvent("configResult", "ok");
        } else {
            l.log("config <i2phost> <i2pport>");
            l.log("  sets the connection to the i2p router.");
            this.notifyEvent("configResult", "error");
        }
    }

    public void runOwnDest(String[] args, Logging l) {
        if (args.length == 1 && (args[0].equalsIgnoreCase("yes") || args[0].equalsIgnoreCase("no"))) {
            this.ownDest = args[0].equalsIgnoreCase("yes");
            this.notifyEvent("owndestResult", "ok");
        } else {
            l.log("owndest yes|no");
            l.log("  Specifies whether to use its own destination \n  for each outgoing tunnel");
            this.notifyEvent("owndestResult", "error");
        }
    }

    public void runListenOn(String[] args, Logging l) {
        if (args.length == 1) {
            this.listenHost = args[0];
            this.notifyEvent("listen_onResult", "ok");
        } else {
            l.log("listen_on <ip>");
            l.log("  sets the interface to listen for the I2PClient.");
            this.notifyEvent("listen_onResult", "error");
        }
    }

    public void runReadTimeout(String[] args, Logging l) {
        if (args.length == 1) {
            try {
                this.readTimeout = Long.parseLong(args[0]);
            }
            catch (NumberFormatException e) {
                this.notifyEvent("read_timeoutResult", "error");
            }
            this.notifyEvent("read_timeoutResult", "ok");
        } else {
            l.log("read_timeout <msecs>");
            l.log("  sets the read timeout (in milliseconds) for I2P connections\n  Negative values will make the connections wait forever");
            this.notifyEvent("read_timeoutResult", "error");
        }
    }

    public void runGenKeys(String[] args, Logging l) {
        FileOutputStream pubdest = null;
        if (args.length == 2) {
            try {
                pubdest = new FileOutputStream(args[1]);
            }
            catch (IOException ioe) {
                l.log("Error opening output stream");
                this._log.error(this.getPrefix() + "Error generating keys to out", ioe);
                this.notifyEvent("genkeysResult", "error");
                return;
            }
        } else if (args.length != 1) {
            l.log("genkeys <privkeyfile> [<pubkeyfile>]");
            l.log("   creates a new keypair and prints the public key.\n   if pubkeyfile is given, saves the public key there.\n   if the privkeyfile already exists, just print/savethe pubkey.");
            this.notifyEvent("genkeysResult", "error");
        }
        try {
            File privKeyFile = new File(args[0]);
            if (privKeyFile.exists()) {
                l.log("File already exists.");
                I2PTunnel.showKey(new FileInputStream(privKeyFile), pubdest, l);
            } else {
                I2PTunnel.makeKey(new FileOutputStream(privKeyFile), pubdest, l);
            }
            this.notifyEvent("genkeysResult", "ok");
        }
        catch (IOException ioe) {
            l.log("Error generating keys - " + ioe.getMessage());
            this.notifyEvent("genkeysResult", "error");
            this._log.error(this.getPrefix() + "Error generating keys", ioe);
        }
    }

    public void runGenTextKeys(Logging l) {
        ByteArrayOutputStream privkey = new ByteArrayOutputStream(512);
        ByteArrayOutputStream pubkey = new ByteArrayOutputStream(512);
        I2PTunnel.makeKey(privkey, pubkey, l);
        l.log("Private key: " + Base64.encode(privkey.toByteArray()));
        this.notifyEvent("privateKey", Base64.encode(privkey.toByteArray()));
        this.notifyEvent("publicDestination", Base64.encode(pubkey.toByteArray()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runQuit(Logging l) {
        this.purgetasks(l);
        List list = this.tasks;
        synchronized (list) {
            if (this.tasks.isEmpty()) {
                System.exit(0);
            }
        }
        l.log("There are running tasks. Try 'list'.");
        this.notifyEvent("quitResult", "error");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runList(Logging l) {
        this.purgetasks(l);
        List list = this.tasks;
        synchronized (list) {
            for (int i = 0; i < this.tasks.size(); ++i) {
                I2PTunnelTask t = (I2PTunnelTask)this.tasks.get(i);
                l.log("[" + t.getId() + "] " + t.toString());
            }
        }
        this.notifyEvent("listDone", "done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runClose(String[] args, Logging l) {
        if (args.length == 0 || args.length > 2) {
            l.log("close [forced] <jobnumber>|all");
            l.log("   stop running tasks. either only one or all.\n   use 'forced' to also stop tasks with active connections.\n   use the 'list' command to show the job numbers");
            this.notifyEvent("closeResult", "error");
        } else {
            int argindex = 0;
            boolean forced = false;
            if (args[argindex].equalsIgnoreCase("forced")) {
                forced = true;
                ++argindex;
            }
            if (args[argindex].equalsIgnoreCase("all")) {
                LinkedList curTasks = null;
                List list = this.tasks;
                synchronized (list) {
                    curTasks = new LinkedList(this.tasks);
                }
                boolean error = false;
                for (int i = 0; i < curTasks.size(); ++i) {
                    I2PTunnelTask t = (I2PTunnelTask)curTasks.get(i);
                    if (!this.closetask(t, forced, l)) {
                        this.notifyEvent("closeResult", "error");
                        error = true;
                        continue;
                    }
                    if (error) continue;
                    this.notifyEvent("closeResult", "ok");
                }
            } else {
                try {
                    if (!this.closetask(Integer.parseInt(args[argindex]), forced, l)) {
                        this.notifyEvent("closeResult", "error");
                    }
                    this.notifyEvent("closeResult", "ok");
                }
                catch (NumberFormatException ex) {
                    l.log("Incorrect job number: " + args[argindex]);
                    this.notifyEvent("closeResult", "error");
                }
            }
        }
    }

    public void runRun(String[] args, Logging l) {
        if (args.length == 1) {
            try {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(args[0]));
                while ((line = br.readLine()) != null) {
                    this.runCommand(line, l);
                }
                br.close();
                this.notifyEvent("runResult", "ok");
            }
            catch (IOException ioe) {
                l.log("IO error running the file");
                this._log.error(this.getPrefix() + "Error running the file", ioe);
                this.notifyEvent("runResult", "error");
            }
        } else {
            l.log("run <commandfile>");
            l.log("   loads commandfile and runs each line in it. \n   You can also give the filename on the commandline.");
            this.notifyEvent("runResult", "error");
        }
    }

    public void runLookup(String[] args, Logging l) {
        if (args.length != 1) {
            l.log("lookup <name>");
            l.log("   try to resolve the name into a destination key");
            this.notifyEvent("lookupResult", "invalidUsage");
        } else {
            try {
                Destination dest = I2PTunnel.destFromName(args[0]);
                if (dest == null) {
                    l.log("Unknown host");
                    this.notifyEvent("lookupResult", "unkown host");
                } else {
                    l.log(dest.toBase64());
                    this.notifyEvent("lookupResult", dest.toBase64());
                }
            }
            catch (DataFormatException dfe) {
                l.log("Unknown or invalid host");
                this.notifyEvent("lookupResult", "invalid host");
            }
        }
    }

    public void runPing(String allargs, Logging l) {
        if (allargs.length() != 0) {
            I2Ping task = new I2Ping(allargs, l, false, this, this);
            this.addtask(task);
            this.notifyEvent("pingTaskId", task.getId());
        } else {
            l.log("ping <opts> <dest>");
            l.log("ping <opts> -h (pings all hosts in hosts.txt)");
            l.log("ping <opts> -l <destlistfile> (pings a list of hosts in a file)");
            l.log("   Options:\n     -c (require 5 consecutive pings to report success)\n     -m maxSimultaneousPings (default 10)\n     -n numberOfPings (default 3)\n     -t timeout (ms, default 5000)\n");
            l.log("   Tests communication with peers.\n");
            this.notifyEvent("pingTaskId", -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean closetask(int num, boolean forced, Logging l) {
        boolean closed = false;
        this._log.debug(this.getPrefix() + "closetask(): looking for task " + num);
        List list = this.tasks;
        synchronized (list) {
            for (I2PTunnelTask t : this.tasks) {
                int id = t.getId();
                this._log.debug(this.getPrefix() + "closetask(): parsing task " + id + " (" + t.toString() + ")");
                if (id == num) {
                    closed = this.closetask(t, forced, l);
                    break;
                }
                if (id <= num) continue;
                break;
            }
        }
        return closed;
    }

    private boolean closetask(I2PTunnelTask t, boolean forced, Logging l) {
        l.log("Closing task " + t.getId() + (forced ? " forced..." : "..."));
        if (t.close(forced)) {
            l.log("Task " + t.getId() + " closed.");
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgetasks(Logging l) {
        List list = this.tasks;
        synchronized (list) {
            Iterator it = this.tasks.iterator();
            while (it.hasNext()) {
                I2PTunnelTask t = (I2PTunnelTask)it.next();
                if (t.isOpen()) continue;
                this._log.debug(this.getPrefix() + "Purging inactive tunnel: [" + t.getId() + "] " + t.toString());
                it.remove();
            }
        }
    }

    @Override
    public void log(String s) {
        System.out.println(s);
        this._log.info(this.getPrefix() + "Display: " + s);
    }

    public static void makeKey(OutputStream writeTo, OutputStream pubDest, Logging l) {
        try {
            l.log("Generating new keys...");
            I2PClient client = I2PClientFactory.createClient();
            Destination d = client.createDestination(writeTo);
            l.log("Secret key saved.");
            l.log("Public key: " + d.toBase64());
            writeTo.flush();
            writeTo.close();
            I2PTunnel.writePubKey(d, pubDest, l);
        }
        catch (I2PException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void showKey(InputStream readFrom, OutputStream pubDest, Logging l) {
        try {
            Destination d = new Destination();
            d.readBytes(readFrom);
            l.log("Public key: " + d.toBase64());
            readFrom.close();
            I2PTunnel.writePubKey(d, pubDest, l);
        }
        catch (I2PException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static void writePubKey(Destination d, OutputStream o, Logging l) throws I2PException, IOException {
        if (o == null) {
            return;
        }
        d.writeBytes(o);
        l.log("Public key saved.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static Destination destFromName(String name) throws DataFormatException {
        if (name == null || name.trim().length() <= 0) {
            throw new DataFormatException("Empty destination provided");
        }
        ctx = I2PAppContext.getGlobalContext();
        log = ctx.logManager().getLog(I2PTunnel.class);
        if (name.startsWith("file:")) {
            block19: {
                result = new Destination();
                content = null;
                in = null;
                try {
                    in = new FileInputStream(name.substring("file:".length()));
                    buf = new byte[1024];
                    read = DataHelper.read(in, buf);
                    content = new byte[read];
                    System.arraycopy(buf, 0, content, 0, read);
                    var9_14 = null;
                    ** if (in == null) goto lbl-1000
                }
                catch (Throwable var8_20) {
                    var9_16 = null;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException io) {
                            // empty catch block
                        }
                    }
                    throw var8_20;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        in.close();
                    }
                    catch (IOException io) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block19;
                    catch (IOException ioe) {
                        System.out.println(ioe.getMessage());
                        read = null;
                        var9_15 = null;
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException io) {
                                // empty catch block
                            }
                        }
                        return read;
                    }
                }
            }
            try {
                result.fromByteArray(content);
                return result;
            }
            catch (Exception ex) {
                if (log.shouldLog(20)) {
                    log.info("File is not a binary destination - trying base64");
                }
                try {
                    decoded = Base64.decode(new String(content));
                    result.fromByteArray(decoded);
                    return result;
                }
                catch (DataFormatException dfe) {
                    if (log.shouldLog(30)) {
                        log.warn("File is not a base64 destination either - failing!");
                    }
                    return null;
                }
            }
        }
        inst = ctx.namingService();
        return inst.lookup(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionEventListener(ConnectionEventListener lsnr) {
        if (lsnr == null) {
            return;
        }
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(lsnr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionEventListener(ConnectionEventListener lsnr) {
        if (lsnr == null) {
            return;
        }
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(lsnr);
        }
    }

    private String getPrefix() {
        return 91L + this._tunnelId + "]: ";
    }

    public I2PAppContext getContext() {
        return this._context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void routerDisconnected() {
        this._log.error(this.getPrefix() + "Router disconnected - firing notification events");
        Set set = this.listeners;
        synchronized (set) {
            for (ConnectionEventListener lsnr : this.listeners) {
                if (lsnr == null) continue;
                lsnr.routerDisconnected();
            }
        }
    }

    @Override
    public EventDispatcher getEventDispatcher() {
        return this._event;
    }

    @Override
    public void attachEventDispatcher(EventDispatcher e) {
        this._event.attachEventDispatcher(e.getEventDispatcher());
    }

    @Override
    public void detachEventDispatcher(EventDispatcher e) {
        this._event.detachEventDispatcher(e.getEventDispatcher());
    }

    @Override
    public void notifyEvent(String e, Object a) {
        this._event.notifyEvent(e, a);
    }

    @Override
    public Object getEventValue(String n) {
        return this._event.getEventValue(n);
    }

    @Override
    public Set getEvents() {
        return this._event.getEvents();
    }

    @Override
    public void ignoreEvents() {
        this._event.ignoreEvents();
    }

    @Override
    public void unIgnoreEvents() {
        this._event.unIgnoreEvents();
    }

    @Override
    public Object waitEventValue(String n) {
        return this._event.waitEventValue(n);
    }

    public static interface ConnectionEventListener {
        public void routerDisconnected();
    }
}

