/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel;

import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.zip.GZIPInputStream;
import net.i2p.I2PAppContext;
import net.i2p.data.ByteArray;
import net.i2p.util.ByteCache;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

class HTTPResponseOutputStream
extends FilterOutputStream {
    private I2PAppContext _context = I2PAppContext.getGlobalContext();
    private Log _log;
    private ByteCache _cache;
    protected ByteArray _headerBuffer;
    private boolean _headerWritten;
    private byte[] _buf1;
    protected boolean _gzip;
    private long _dataWritten;
    private InternalGZIPInputStream _in;
    private static final int CACHE_SIZE = 8192;
    private static final byte NL = 10;

    public HTTPResponseOutputStream(OutputStream raw) {
        super(raw);
        this._context.statManager().createRateStat("i2ptunnel.httpCompressionRatio", "ratio of compressed size to decompressed size after transfer", "I2PTunnel", new long[]{60000L, 1800000L});
        this._context.statManager().createRateStat("i2ptunnel.httpCompressed", "compressed size transferred", "I2PTunnel", new long[]{60000L, 1800000L});
        this._context.statManager().createRateStat("i2ptunnel.httpExpanded", "size transferred after expansion", "I2PTunnel", new long[]{60000L, 1800000L});
        this._log = this._context.logManager().getLog(this.getClass());
        this._cache = ByteCache.getInstance(8, 8192);
        this._headerBuffer = this._cache.acquire();
        this._headerWritten = false;
        this._gzip = false;
        this._dataWritten = 0L;
        this._buf1 = new byte[1];
    }

    public void write(int c) throws IOException {
        this._buf1[0] = (byte)c;
        this.write(this._buf1, 0, 1);
    }

    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void write(byte[] buf, int off, int len) throws IOException {
        if (this._headerWritten) {
            this.out.write(buf, off, len);
            this._dataWritten += (long)len;
            return;
        }
        for (int i = 0; i < len; ++i) {
            this.ensureCapacity();
            this._headerBuffer.getData()[this._headerBuffer.getValid()] = buf[off + i];
            this._headerBuffer.setValid(this._headerBuffer.getValid() + 1);
            if (!this.headerReceived()) continue;
            this.writeHeader();
            this._headerWritten = true;
            if (i + 1 < len) {
                this.out.write(buf, off + i + 1, len - i - 1);
                this._dataWritten += (long)(len - i - 1);
            }
            return;
        }
    }

    private void ensureCapacity() {
        if (this._headerBuffer.getValid() + 1 >= this._headerBuffer.getData().length) {
            int newSize = (int)((double)this._headerBuffer.getData().length * 1.5);
            ByteArray newBuf = new ByteArray(new byte[newSize]);
            System.arraycopy(this._headerBuffer.getData(), 0, newBuf.getData(), 0, this._headerBuffer.getValid());
            newBuf.setValid(this._headerBuffer.getValid());
            newBuf.setOffset(0);
            if (this._headerBuffer.getData().length == 8192) {
                this._cache.release(this._headerBuffer);
            }
            this._headerBuffer = newBuf;
        }
    }

    private boolean headerReceived() {
        if (this._headerBuffer.getValid() < 3) {
            return false;
        }
        byte first = this._headerBuffer.getData()[this._headerBuffer.getValid() - 3];
        byte second = this._headerBuffer.getData()[this._headerBuffer.getValid() - 2];
        byte third = this._headerBuffer.getData()[this._headerBuffer.getValid() - 1];
        return this.isNL(second) && this.isNL(third) || this.isNL(first) && this.isNL(third);
    }

    protected String filterResponseLine(String line) {
        return line;
    }

    private boolean isNL(byte b) {
        return b == 10;
    }

    private void writeHeader() throws IOException {
        String responseLine = null;
        boolean connectionSent = false;
        boolean proxyConnectionSent = false;
        int lastEnd = -1;
        for (int i = 0; i < this._headerBuffer.getValid(); ++i) {
            if (!this.isNL(this._headerBuffer.getData()[i])) continue;
            if (lastEnd == -1) {
                responseLine = new String(this._headerBuffer.getData(), 0, i + 1);
                responseLine = this.filterResponseLine(responseLine);
                responseLine = responseLine.trim() + "\r\n";
                this.out.write(responseLine.getBytes());
            } else {
                for (int j = lastEnd + 1; j < i; ++j) {
                    if (this._headerBuffer.getData()[j] != 58) continue;
                    int keyLen = j - (lastEnd + 1);
                    int valLen = i - (j + 1);
                    if (keyLen <= 0 || valLen < 0) {
                        throw new IOException("Invalid header @ " + j);
                    }
                    String key = new String(this._headerBuffer.getData(), lastEnd + 1, keyLen);
                    String val = null;
                    val = valLen == 0 ? "" : new String(this._headerBuffer.getData(), j + 2, valLen).trim();
                    if (this._log.shouldLog(20)) {
                        this._log.info("Response header [" + key + "] = [" + val + "]");
                    }
                    if ("Connection".equalsIgnoreCase(key)) {
                        this.out.write("Connection: close\r\n".getBytes());
                        connectionSent = true;
                        break;
                    }
                    if ("Proxy-Connection".equalsIgnoreCase(key)) {
                        this.out.write("Proxy-Connection: close\r\n".getBytes());
                        proxyConnectionSent = true;
                        break;
                    }
                    if ("Content-encoding".equalsIgnoreCase(key) && "x-i2p-gzip".equalsIgnoreCase(val)) {
                        this._gzip = true;
                        break;
                    }
                    this.out.write((key.trim() + ": " + val.trim() + "\r\n").getBytes());
                    break;
                }
            }
            lastEnd = i;
        }
        if (!connectionSent) {
            this.out.write("Connection: close\r\n".getBytes());
        }
        if (!proxyConnectionSent) {
            this.out.write("Proxy-Connection: close\r\n".getBytes());
        }
        this.finishHeaders();
        boolean shouldCompress = this.shouldCompress();
        if (this._log.shouldLog(20)) {
            this._log.info("After headers: gzip? " + this._gzip + " compress? " + shouldCompress);
        }
        if (this._headerBuffer.getData().length == 8192) {
            this._cache.release(this._headerBuffer);
        } else {
            this._headerBuffer = null;
        }
        if (shouldCompress) {
            this.beginProcessing();
        }
    }

    protected boolean shouldCompress() {
        return this._gzip;
    }

    protected void finishHeaders() throws IOException {
        this.out.write("\r\n".getBytes());
    }

    public void close() throws IOException {
        this.out.close();
    }

    protected void beginProcessing() throws IOException {
        PipedInputStream pi = new PipedInputStream();
        PipedOutputStream po = new PipedOutputStream(pi);
        new I2PThread(new Pusher(pi, this.out), "HTTP decompresser").start();
        this.out = po;
    }

    public String toString() {
        return super.toString() + ": " + this._in;
    }

    public static void main(String[] args) {
        String simple = "HTTP/1.1 200 OK\nfoo: bar\nbaz: bat\n\nhi ho, this is the body";
        String filtered = "HTTP/1.1 200 OK\nConnection: keep-alive\nfoo: bar\nbaz: bat\n\nhi ho, this is the body";
        String winfilter = "HTTP/1.1 200 OK\r\nConnection: keep-alive\r\nfoo: bar\r\nbaz: bat\r\n\r\nhi ho, this is the body";
        String minimal = "HTTP/1.1 200 OK\n\nhi ho, this is the body";
        String winmin = "HTTP/1.1 200 OK\r\n\r\nhi ho, this is the body";
        String invalid1 = "HTTP/1.1 200 OK\n";
        String invalid2 = "HTTP/1.1 200 OK";
        String invalid3 = "HTTP 200 OK\r\n";
        String invalid4 = "HTTP 200 OK\r";
        String invalid5 = "HTTP/1.1 200 OK\r\nI am broken, and I smell\r\n\r\n";
        String invalid6 = "HTTP/1.1 200 OK\r\n:I am broken, and I smell\r\n\r\n";
        String invalid7 = "HTTP/1.1 200 OK\nI am broken, and I smell:\n:asdf\n:\n\n";
        String large = "HTTP/1.1 200 OK\nLast-modified: Tue, 25 Nov 2003 12:05:38 GMT\nExpires: Tue, 25 Nov 2003 12:05:38 GMT\nContent-length: 32\n\nhi ho, this is the body";
        String blankval = "HTTP/1.0 200 OK\nA:\n\n";
        HTTPResponseOutputStream.test("Simple", simple, true);
        HTTPResponseOutputStream.test("Filtered", filtered, true);
        HTTPResponseOutputStream.test("Filtered windows", winfilter, true);
        HTTPResponseOutputStream.test("Minimal", minimal, true);
        HTTPResponseOutputStream.test("Windows", winmin, true);
        HTTPResponseOutputStream.test("Large", large, true);
        HTTPResponseOutputStream.test("Blank whitespace", blankval, true);
        HTTPResponseOutputStream.test("Invalid (short headers)", invalid1, true);
        HTTPResponseOutputStream.test("Invalid (no headers)", invalid2, true);
        HTTPResponseOutputStream.test("Invalid (windows with short headers)", invalid3, true);
        HTTPResponseOutputStream.test("Invalid (windows no headers)", invalid4, true);
        HTTPResponseOutputStream.test("Invalid (bad headers)", invalid5, true);
        HTTPResponseOutputStream.test("Invalid (bad headers2)", invalid6, false);
        HTTPResponseOutputStream.test("Invalid (bad headers3)", invalid7, false);
    }

    private static void test(String name, String orig, boolean shouldPass) {
        System.out.println("====Testing: " + name + "\n" + orig + "\n------------");
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
            HTTPResponseOutputStream resp = new HTTPResponseOutputStream(baos);
            resp.write(orig.getBytes());
            resp.flush();
            String received = new String(baos.toByteArray());
            System.out.println(received);
        }
        catch (Exception e) {
            if (shouldPass) {
                e.printStackTrace();
            }
            System.out.println("Properly fails with " + e.getMessage());
        }
    }

    private class InternalGZIPInputStream
    extends GZIPInputStream {
        public InternalGZIPInputStream(InputStream in) throws IOException {
            super(in);
        }

        public long getTotalRead() {
            try {
                return this.inf.getTotalIn();
            }
            catch (Exception e) {
                return 0L;
            }
        }

        public long getTotalExpanded() {
            try {
                return this.inf.getTotalOut();
            }
            catch (Exception e) {
                return 0L;
            }
        }

        public long getRemaining() {
            try {
                return this.inf.getRemaining();
            }
            catch (Exception e) {
                return 0L;
            }
        }

        public boolean getFinished() {
            try {
                return this.inf.finished();
            }
            catch (Exception e) {
                return true;
            }
        }

        public String toString() {
            return "Read: " + this.getTotalRead() + " expanded: " + this.getTotalExpanded() + " remaining: " + this.getRemaining() + " finished: " + this.getFinished();
        }
    }

    private class Pusher
    implements Runnable {
        private InputStream _inRaw;
        private OutputStream _out;

        public Pusher(InputStream in, OutputStream out) {
            this._inRaw = in;
            this._out = out;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            long start;
            block19: {
                IOException ioe2222;
                Object to = null;
                HTTPResponseOutputStream.this._in = null;
                start = System.currentTimeMillis();
                long written = 0L;
                try {
                    block18: {
                        HTTPResponseOutputStream.this._in = new InternalGZIPInputStream(this._inRaw);
                        byte[] buf = new byte[8192];
                        int read = -1;
                        while ((read = HTTPResponseOutputStream.this._in.read(buf)) != -1) {
                            if (HTTPResponseOutputStream.this._log.shouldLog(10)) {
                                HTTPResponseOutputStream.this._log.debug("Read " + read + " and writing it to the browser/streams");
                            }
                            this._out.write(buf, 0, read);
                            this._out.flush();
                            written += (long)read;
                        }
                        if (!HTTPResponseOutputStream.this._log.shouldLog(20)) break block18;
                        HTTPResponseOutputStream.this._log.info("Decompressed: " + written + ", " + HTTPResponseOutputStream.this._in.getTotalRead() + "/" + HTTPResponseOutputStream.this._in.getTotalExpanded());
                    }
                    Object var9_8 = null;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    if (HTTPResponseOutputStream.this._log.shouldLog(30) && HTTPResponseOutputStream.this._in != null) {
                        HTTPResponseOutputStream.this._log.warn("After decompression, written=" + written + (HTTPResponseOutputStream.this._in != null ? " read=" + HTTPResponseOutputStream.this._in.getTotalRead() + ", expanded=" + HTTPResponseOutputStream.this._in.getTotalExpanded() + ", remaining=" + HTTPResponseOutputStream.this._in.getRemaining() + ", finished=" + HTTPResponseOutputStream.this._in.getFinished() : ""));
                    }
                    if (this._out != null) {
                        try {
                            this._out.close();
                        }
                        catch (IOException ioe2222) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                if (HTTPResponseOutputStream.this._log.shouldLog(30) && HTTPResponseOutputStream.this._in != null) {
                    HTTPResponseOutputStream.this._log.warn("After decompression, written=" + written + (HTTPResponseOutputStream.this._in != null ? " read=" + HTTPResponseOutputStream.this._in.getTotalRead() + ", expanded=" + HTTPResponseOutputStream.this._in.getTotalExpanded() + ", remaining=" + HTTPResponseOutputStream.this._in.getRemaining() + ", finished=" + HTTPResponseOutputStream.this._in.getFinished() : ""));
                }
                if (this._out != null) {
                    try {
                        this._out.close();
                    }
                    catch (IOException ioe2222) {}
                }
                break block19;
                {
                    catch (IOException ioe3) {
                        if (HTTPResponseOutputStream.this._log.shouldLog(30)) {
                            HTTPResponseOutputStream.this._log.warn("Error decompressing: " + written + ", " + (HTTPResponseOutputStream.this._in != null ? HTTPResponseOutputStream.this._in.getTotalRead() + "/" + HTTPResponseOutputStream.this._in.getTotalExpanded() : ""), ioe3);
                        }
                        Object var9_9 = null;
                        if (HTTPResponseOutputStream.this._log.shouldLog(30) && HTTPResponseOutputStream.this._in != null) {
                            HTTPResponseOutputStream.this._log.warn("After decompression, written=" + written + (HTTPResponseOutputStream.this._in != null ? " read=" + HTTPResponseOutputStream.this._in.getTotalRead() + ", expanded=" + HTTPResponseOutputStream.this._in.getTotalExpanded() + ", remaining=" + HTTPResponseOutputStream.this._in.getRemaining() + ", finished=" + HTTPResponseOutputStream.this._in.getFinished() : ""));
                        }
                        if (this._out != null) {
                            try {
                                this._out.close();
                            }
                            catch (IOException ioe2222) {}
                        }
                    }
                }
            }
            long end = System.currentTimeMillis();
            double compressed = HTTPResponseOutputStream.this._in != null ? HTTPResponseOutputStream.this._in.getTotalRead() : 0L;
            double expanded = HTTPResponseOutputStream.this._in != null ? HTTPResponseOutputStream.this._in.getTotalExpanded() : 0L;
            double ratio = 0.0;
            if (expanded > 0.0) {
                ratio = compressed / expanded;
            }
            HTTPResponseOutputStream.this._context.statManager().addRateData("i2ptunnel.httpCompressionRatio", (int)(100.0 * ratio), end - start);
            HTTPResponseOutputStream.this._context.statManager().addRateData("i2ptunnel.httpCompressed", (long)compressed, end - start);
            HTTPResponseOutputStream.this._context.statManager().addRateData("i2ptunnel.httpExpanded", (long)expanded, end - start);
        }
    }
}

