/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import net.i2p.I2PAppContext;
import net.i2p.client.I2PClientFactory;
import net.i2p.client.streaming.I2PServerSocket;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketManager;
import net.i2p.client.streaming.I2PSocketManagerFactory;
import net.i2p.data.Destination;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

public class TestSwarm {
    private I2PAppContext _context;
    private Log _log;
    private String _destFile;
    private String[] _peerDestFiles;
    private String _conOptions;
    private I2PSocketManager _manager;
    private boolean _dead;
    private static volatile long __conId = 0L;
    static /* synthetic */ Class class$net$i2p$client$streaming$TestSwarm;

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Usage: TestSwarm myDestFile [peerDestFile ]*");
            return;
        }
        I2PAppContext ctx = new I2PAppContext();
        String[] files = new String[args.length - 1];
        System.arraycopy(args, 1, files, 0, files.length);
        TestSwarm swarm = new TestSwarm(ctx, args[0], files);
        swarm.startup();
    }

    public TestSwarm(I2PAppContext ctx, String destFile, String[] peerDestFiles) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(class$net$i2p$client$streaming$TestSwarm == null ? (class$net$i2p$client$streaming$TestSwarm = TestSwarm.class$("net.i2p.client.streaming.TestSwarm")) : class$net$i2p$client$streaming$TestSwarm);
        this._dead = false;
        this._destFile = destFile;
        this._peerDestFiles = peerDestFiles;
        this._conOptions = "";
    }

    public void startup() {
        this._log.debug("Starting up");
        File keys = new File(this._destFile);
        if (!keys.exists()) {
            try {
                I2PClientFactory.createClient().createDestination((OutputStream)new FileOutputStream(keys));
            }
            catch (Exception e) {
                this._log.error("Error creating a new destination on " + keys, (Throwable)e);
                return;
            }
        }
        try {
            this._manager = I2PSocketManagerFactory.createManager(new FileInputStream(this._destFile), null, -1, null);
        }
        catch (Exception e) {
            this._log.error("Error creatign the manager", (Throwable)e);
            return;
        }
        I2PThread listener = new I2PThread((Runnable)new Listener(), "Listener");
        listener.start();
        this.connectWithPeers();
    }

    private void connectWithPeers() {
        if (this._peerDestFiles != null) {
            for (int i = 0; i < this._peerDestFiles.length; ++i) {
                try {
                    FileInputStream fin = new FileInputStream(this._peerDestFiles[i]);
                    Destination dest = new Destination();
                    dest.readBytes((InputStream)fin);
                    I2PThread flooder = new I2PThread((Runnable)new Flooder(dest), "Flooder+" + dest.calculateHash().toBase64().substring(0, 4));
                    flooder.start();
                    continue;
                }
                catch (Exception e) {
                    this._log.error("Unable to read the peer from " + this._peerDestFiles[i], (Throwable)e);
                }
            }
        }
    }

    private boolean shouldSend() {
        return Boolean.valueOf(this._context.getProperty("shouldSend", "false"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Flooder
    implements Runnable {
        private Destination _remoteDestination;
        private I2PSocket _socket;
        private boolean _closed;
        private long _started;
        private long _totalSent;
        private long _totalReceived;
        private long _lastReceived;
        private long _lastReceivedOn;
        private long _connectionId;

        public Flooder(Destination dest) {
            this._socket = null;
            this._remoteDestination = dest;
            this._connectionId = ++__conId;
            this._closed = false;
            this._lastReceived = -1L;
            this._lastReceivedOn = TestSwarm.this._context.clock().now();
            TestSwarm.this._context.statManager().createRateStat("swarm." + this._connectionId + ".totalReceived", "Data size received", "swarm", new long[]{30000L, 60000L, 300000L});
            TestSwarm.this._context.statManager().createRateStat("swarm." + this._connectionId + ".totalSent", "Data size sent", "swarm", new long[]{30000L, 60000L, 300000L});
            TestSwarm.this._context.statManager().createRateStat("swarm." + this._connectionId + ".started", "When we start", "swarm", new long[]{300000L});
            TestSwarm.this._context.statManager().createRateStat("swarm." + this._connectionId + ".lifetime", "How long we talk to a peer", "swarm", new long[]{300000L});
        }

        public Flooder(I2PSocket socket) {
            this._socket = socket;
            this._remoteDestination = socket.getPeerDestination();
            this._connectionId = ++__conId;
            this._closed = false;
            this._lastReceived = -1L;
            this._lastReceivedOn = TestSwarm.this._context.clock().now();
            TestSwarm.this._context.statManager().createRateStat("swarm." + this._connectionId + ".totalReceived", "Data size received", "swarm", new long[]{30000L, 60000L, 300000L});
            TestSwarm.this._context.statManager().createRateStat("swarm." + this._connectionId + ".totalSent", "Data size sent", "swarm", new long[]{30000L, 60000L, 300000L});
            TestSwarm.this._context.statManager().createRateStat("swarm." + this._connectionId + ".started", "When we start", "swarm", new long[]{300000L});
            TestSwarm.this._context.statManager().createRateStat("swarm." + this._connectionId + ".lifetime", "How long we talk to a peer", "swarm", new long[]{300000L});
        }

        public long getConnectionId() {
            return this._connectionId;
        }

        public Destination getDestination() {
            return this._remoteDestination;
        }

        public void run() {
            this._started = TestSwarm.this._context.clock().now();
            TestSwarm.this._context.statManager().addRateData("swarm." + this._connectionId + ".started", 1L, 0L);
            byte[] data = new byte[4096];
            TestSwarm.this._context.random().nextBytes(data);
            long value = 0L;
            long lastSend = TestSwarm.this._context.clock().now();
            if (this._socket == null) {
                try {
                    this._socket = TestSwarm.this._manager.connect(this._remoteDestination);
                }
                catch (Exception e) {
                    TestSwarm.this._log.error("Error connecting to " + this._remoteDestination.calculateHash().toBase64().substring(0, 4));
                    return;
                }
            }
            I2PThread floodListener = new I2PThread((Runnable)new FloodListener(), "FloodListener" + this._connectionId);
            floodListener.start();
            try {
                OutputStream out = this._socket.getOutputStream();
                while (!this._closed) {
                    if (TestSwarm.this.shouldSend()) {
                        long now;
                        out.write(data);
                        this._totalSent += (long)data.length;
                        TestSwarm.this._context.statManager().addRateData("swarm." + this._connectionId + ".totalSent", this._totalSent, 0L);
                        lastSend = now = TestSwarm.this._context.clock().now();
                        continue;
                    }
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException ie) {}
                }
            }
            catch (Exception e) {
                TestSwarm.this._log.error("Error sending", (Throwable)e);
            }
        }

        private class FloodListener
        implements Runnable {
            private FloodListener() {
            }

            public void run() {
                long lastRead;
                long now = lastRead = System.currentTimeMillis();
                try {
                    InputStream in = Flooder.this._socket.getInputStream();
                    byte[] buf = new byte[8192];
                    int read = 0;
                    while ((read = in.read(buf)) != -1) {
                        now = System.currentTimeMillis();
                        Flooder.this._totalReceived += read;
                        TestSwarm.this._context.statManager().addRateData("swarm." + Flooder.this.getConnectionId() + ".totalReceived", Flooder.this._totalReceived, 0L);
                        lastRead = now;
                    }
                }
                catch (Exception e) {
                    TestSwarm.this._log.error("Error listening to the flood", (Throwable)e);
                }
            }
        }
    }

    private class Listener
    implements Runnable {
        private Listener() {
        }

        public void run() {
            try {
                I2PServerSocket ss = TestSwarm.this._manager.getServerSocket();
                I2PSocket s = null;
                while ((s = ss.accept()) != null) {
                    I2PThread flooder = new I2PThread((Runnable)new Flooder(s), "Flooder-" + s.getPeerDestination().calculateHash().toBase64().substring(0, 4));
                    flooder.start();
                }
            }
            catch (Exception e) {
                TestSwarm.this._log.error("Error listening", (Throwable)e);
            }
        }
    }
}

