/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel.pool;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.RouterInfo;
import net.i2p.data.TunnelId;
import net.i2p.router.ClientTunnelSettings;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.TunnelManagerFacade;
import net.i2p.router.TunnelPoolSettings;
import net.i2p.router.tunnel.HopConfig;
import net.i2p.router.tunnel.pool.BuildExecutor;
import net.i2p.router.tunnel.pool.ClientPeerSelector;
import net.i2p.router.tunnel.pool.ExploratoryPeerSelector;
import net.i2p.router.tunnel.pool.PooledTunnelCreatorConfig;
import net.i2p.router.tunnel.pool.TestJob;
import net.i2p.router.tunnel.pool.TunnelPool;
import net.i2p.stat.RateStat;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;
import net.i2p.util.ObjectCounter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TunnelPoolManager
implements TunnelManagerFacade {
    private RouterContext _context;
    private Log _log;
    private final Map<Hash, TunnelPool> _clientInboundPools;
    private final Map<Hash, TunnelPool> _clientOutboundPools;
    private TunnelPool _inboundExploratory;
    private TunnelPool _outboundExploratory;
    private BuildExecutor _executor;
    private boolean _isShutdown;
    private static final int DEFAULT_MAX_PCT_TUNNELS = 33;

    public TunnelPoolManager(RouterContext ctx) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(TunnelPoolManager.class);
        this._clientInboundPools = new HashMap<Hash, TunnelPool>(4);
        this._clientOutboundPools = new HashMap<Hash, TunnelPool>(4);
        this._isShutdown = false;
        this._executor = new BuildExecutor(ctx, this);
        I2PThread execThread = new I2PThread((Runnable)this._executor, "BuildExecutor");
        execThread.setDaemon(true);
        execThread.start();
        ctx.statManager().createRateStat("tunnel.testSuccessTime", "How long do successful tunnel tests take?", "Tunnels", new long[]{60000L, 600000L, 3600000L, 10800000L, 86400000L});
        ctx.statManager().createRateStat("tunnel.participatingTunnels", "How many tunnels are we participating in?", "Tunnels", new long[]{60000L, 600000L, 3600000L, 10800000L, 86400000L});
    }

    @Override
    public TunnelInfo selectInboundTunnel() {
        TunnelPool pool = this._inboundExploratory;
        if (pool == null) {
            return null;
        }
        TunnelInfo info = pool.selectTunnel();
        if (info == null) {
            this._inboundExploratory.buildFallback();
            info = this._inboundExploratory.selectTunnel();
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TunnelInfo selectInboundTunnel(Hash destination) {
        if (destination == null) {
            return this.selectInboundTunnel();
        }
        TunnelPool pool = null;
        Map<Hash, TunnelPool> map = this._clientInboundPools;
        synchronized (map) {
            pool = this._clientInboundPools.get(destination);
        }
        if (pool != null) {
            return pool.selectTunnel();
        }
        if (this._log.shouldLog(50)) {
            this._log.log(50, "wtf, want the inbound tunnel for " + destination.calculateHash().toBase64() + " but there isn't a pool?");
        }
        return null;
    }

    @Override
    public TunnelInfo selectOutboundTunnel() {
        TunnelPool pool = this._outboundExploratory;
        if (pool == null) {
            return null;
        }
        TunnelInfo info = pool.selectTunnel();
        if (info == null) {
            pool.buildFallback();
            info = pool.selectTunnel();
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TunnelInfo selectOutboundTunnel(Hash destination) {
        if (destination == null) {
            return this.selectOutboundTunnel();
        }
        TunnelPool pool = null;
        Map<Hash, TunnelPool> map = this._clientOutboundPools;
        synchronized (map) {
            pool = this._clientOutboundPools.get(destination);
        }
        if (pool != null) {
            return pool.selectTunnel();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TunnelInfo getTunnelInfo(TunnelId id) {
        TunnelInfo info = null;
        Map<Hash, TunnelPool> map = this._clientInboundPools;
        synchronized (map) {
            for (TunnelPool pool : this._clientInboundPools.values()) {
                info = pool.getTunnel(id);
                if (info == null) continue;
                return info;
            }
        }
        info = this._inboundExploratory.getTunnel(id);
        if (info != null) {
            return info;
        }
        info = this._outboundExploratory.getTunnel(id);
        if (info != null) {
            return info;
        }
        return null;
    }

    @Override
    public int getFreeTunnelCount() {
        if (this._inboundExploratory == null) {
            return 0;
        }
        return this._inboundExploratory.size();
    }

    @Override
    public int getOutboundTunnelCount() {
        if (this._outboundExploratory == null) {
            return 0;
        }
        return this._outboundExploratory.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInboundClientTunnelCount() {
        int count = 0;
        ArrayList<Hash> destinations = null;
        Map<Hash, TunnelPool> map = this._clientInboundPools;
        synchronized (map) {
            destinations = new ArrayList<Hash>(this._clientInboundPools.keySet());
        }
        for (int i = 0; i < destinations.size(); ++i) {
            Hash client = (Hash)destinations.get(i);
            TunnelPool pool = null;
            Map<Hash, TunnelPool> map2 = this._clientInboundPools;
            synchronized (map2) {
                pool = this._clientInboundPools.get(client);
            }
            count += pool.listTunnels().size();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getOutboundClientTunnelCount() {
        int count = 0;
        ArrayList<Hash> destinations = null;
        Map<Hash, TunnelPool> map = this._clientInboundPools;
        synchronized (map) {
            destinations = new ArrayList<Hash>(this._clientOutboundPools.keySet());
        }
        for (int i = 0; i < destinations.size(); ++i) {
            Hash client = (Hash)destinations.get(i);
            TunnelPool pool = null;
            Map<Hash, TunnelPool> map2 = this._clientOutboundPools;
            synchronized (map2) {
                pool = this._clientOutboundPools.get(client);
            }
            count += pool.listTunnels().size();
        }
        return count;
    }

    @Override
    public int getParticipatingCount() {
        return this._context.tunnelDispatcher().getParticipatingCount();
    }

    @Override
    public long getLastParticipatingExpiration() {
        return this._context.tunnelDispatcher().getLastParticipatingExpiration();
    }

    @Override
    public boolean isValidTunnel(Hash client, TunnelInfo tunnel) {
        if (tunnel.getExpiration() < this._context.clock().now()) {
            return false;
        }
        TunnelPool pool = tunnel.isInbound() ? this._clientInboundPools.get(client) : this._clientOutboundPools.get(client);
        if (pool == null) {
            return false;
        }
        return pool.listTunnels().contains(tunnel);
    }

    @Override
    public TunnelPoolSettings getInboundSettings() {
        return this._inboundExploratory.getSettings();
    }

    @Override
    public TunnelPoolSettings getOutboundSettings() {
        return this._outboundExploratory.getSettings();
    }

    @Override
    public void setInboundSettings(TunnelPoolSettings settings) {
        this._inboundExploratory.setSettings(settings);
    }

    @Override
    public void setOutboundSettings(TunnelPoolSettings settings) {
        this._outboundExploratory.setSettings(settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TunnelPoolSettings getInboundSettings(Hash client) {
        TunnelPool pool = null;
        Map<Hash, TunnelPool> map = this._clientInboundPools;
        synchronized (map) {
            pool = this._clientInboundPools.get(client);
        }
        if (pool != null) {
            return pool.getSettings();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TunnelPoolSettings getOutboundSettings(Hash client) {
        TunnelPool pool = null;
        Map<Hash, TunnelPool> map = this._clientOutboundPools;
        synchronized (map) {
            pool = this._clientOutboundPools.get(client);
        }
        if (pool != null) {
            return pool.getSettings();
        }
        return null;
    }

    @Override
    public void setInboundSettings(Hash client, TunnelPoolSettings settings) {
        this.setSettings(this._clientInboundPools, client, settings);
    }

    @Override
    public void setOutboundSettings(Hash client, TunnelPoolSettings settings) {
        this.setSettings(this._clientOutboundPools, client, settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSettings(Map<Hash, TunnelPool> pools, Hash client, TunnelPoolSettings settings) {
        TunnelPool pool = null;
        Map<Hash, TunnelPool> map = pools;
        synchronized (map) {
            pool = pools.get(client);
        }
        if (pool != null) {
            settings.setDestination(client);
            pool.setSettings(settings);
        }
    }

    @Override
    public void restart() {
        this.shutdown();
        this.startup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildTunnels(Destination client, ClientTunnelSettings settings) {
        if (this._log.shouldLog(10)) {
            this._log.debug("Building tunnels for the client " + client.calculateHash().toBase64() + ": " + settings);
        }
        Hash dest = client.calculateHash();
        settings.getInboundSettings().setDestination(dest);
        settings.getOutboundSettings().setDestination(dest);
        TunnelPool inbound = null;
        TunnelPool outbound = null;
        Map<Hash, TunnelPool> map = this._clientInboundPools;
        synchronized (map) {
            inbound = this._clientInboundPools.get(dest);
            if (inbound == null) {
                inbound = new TunnelPool(this._context, this, settings.getInboundSettings(), new ClientPeerSelector());
                this._clientInboundPools.put(dest, inbound);
            } else {
                inbound.setSettings(settings.getInboundSettings());
            }
        }
        map = this._clientOutboundPools;
        synchronized (map) {
            outbound = this._clientOutboundPools.get(dest);
            if (outbound == null) {
                outbound = new TunnelPool(this._context, this, settings.getOutboundSettings(), new ClientPeerSelector());
                this._clientOutboundPools.put(dest, outbound);
            } else {
                outbound.setSettings(settings.getOutboundSettings());
            }
        }
        inbound.startup();
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        outbound.startup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTunnels(Hash destination) {
        if (destination == null) {
            return;
        }
        if (this._context.clientManager().isLocal(destination) && this._log.shouldLog(50)) {
            this._log.log(50, "wtf, why are you removing the pool for " + destination.toBase64(), (Throwable)new Exception("i did it"));
        }
        TunnelPool inbound = null;
        TunnelPool outbound = null;
        Map<Hash, TunnelPool> map = this._clientInboundPools;
        synchronized (map) {
            inbound = this._clientInboundPools.remove(destination);
        }
        map = this._clientOutboundPools;
        synchronized (map) {
            outbound = this._clientOutboundPools.remove(destination);
        }
        if (inbound != null) {
            inbound.shutdown();
        }
        if (outbound != null) {
            outbound.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void buildComplete(PooledTunnelCreatorConfig cfg) {
        if (cfg.getLength() > 1 && !this._context.router().gracefulShutdownInProgress() && !Boolean.valueOf(this._context.getProperty("router.disableTunnelTesting")).booleanValue()) {
            TunnelPool pool = cfg.getTunnelPool();
            if (pool == null) {
                this._log.error("How does this not have a pool?  " + cfg, (Throwable)new Exception("baf"));
                if (cfg.getDestination() != null) {
                    if (cfg.isInbound()) {
                        Map<Hash, TunnelPool> map = this._clientInboundPools;
                        synchronized (map) {
                            pool = this._clientInboundPools.get(cfg.getDestination());
                        }
                    } else {
                        Map<Hash, TunnelPool> map = this._clientOutboundPools;
                        synchronized (map) {
                            pool = this._clientOutboundPools.get(cfg.getDestination());
                        }
                    }
                } else {
                    pool = cfg.isInbound() ? this._inboundExploratory : this._outboundExploratory;
                }
                cfg.setTunnelPool(pool);
            }
            this._context.jobQueue().addJob(new TestJob(this._context, cfg, pool));
        }
    }

    void buildComplete() {
    }

    @Override
    public void startup() {
        this._isShutdown = false;
        if (!this._executor.isRunning()) {
            I2PThread t = new I2PThread((Runnable)this._executor, "BuildExecutor");
            t.setDaemon(true);
            t.start();
        }
        ExploratoryPeerSelector selector = new ExploratoryPeerSelector();
        TunnelPoolSettings inboundSettings = new TunnelPoolSettings();
        inboundSettings.setIsExploratory(true);
        inboundSettings.setIsInbound(true);
        this._inboundExploratory = new TunnelPool(this._context, this, inboundSettings, selector);
        this._inboundExploratory.startup();
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        TunnelPoolSettings outboundSettings = new TunnelPoolSettings();
        outboundSettings.setIsExploratory(true);
        outboundSettings.setIsInbound(false);
        this._outboundExploratory = new TunnelPool(this._context, this, outboundSettings, selector);
        this._outboundExploratory.startup();
        this._context.jobQueue().addJob(new BootstrapPool(this._context, this._inboundExploratory));
        this._context.jobQueue().addJob(new BootstrapPool(this._context, this._outboundExploratory));
    }

    @Override
    public void shutdown() {
        if (this._inboundExploratory != null) {
            this._inboundExploratory.shutdown();
        }
        if (this._outboundExploratory != null) {
            this._outboundExploratory.shutdown();
        }
        this._isShutdown = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void listPools(List<TunnelPool> out) {
        Map<Hash, TunnelPool> map = this._clientInboundPools;
        synchronized (map) {
            out.addAll(this._clientInboundPools.values());
        }
        map = this._clientOutboundPools;
        synchronized (map) {
            out.addAll(this._clientOutboundPools.values());
        }
        if (this._inboundExploratory != null) {
            out.add(this._inboundExploratory);
        }
        if (this._outboundExploratory != null) {
            out.add(this._outboundExploratory);
        }
    }

    void tunnelFailed() {
        this._executor.repoll();
    }

    BuildExecutor getExecutor() {
        return this._executor;
    }

    boolean isShutdown() {
        return this._isShutdown;
    }

    @Override
    public int getInboundBuildQueueSize() {
        return this._executor.getInboundBuildQueueSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renderStatusHTML(Writer out) throws IOException {
        out.write("<div class=\"wideload\"><h2><a name=\"exploratory\" ></a>Exploratory tunnels (<a href=\"/configtunnels.jsp#exploratory\">config</a>):</h2>\n");
        this.renderPool(out, this._inboundExploratory, this._outboundExploratory);
        ArrayList<Hash> destinations = null;
        Map<Hash, TunnelPool> map = this._clientInboundPools;
        synchronized (map) {
            destinations = new ArrayList<Hash>(this._clientInboundPools.keySet());
        }
        for (int i = 0; i < destinations.size(); ++i) {
            String name;
            Hash client = (Hash)destinations.get(i);
            TunnelPool in = null;
            TunnelPool outPool = null;
            Map<Hash, TunnelPool> map2 = this._clientInboundPools;
            synchronized (map2) {
                in = this._clientInboundPools.get(client);
            }
            map2 = this._clientOutboundPools;
            synchronized (map2) {
                outPool = this._clientOutboundPools.get(client);
            }
            String string = name = in != null ? in.getSettings().getDestinationNickname() : null;
            if (name == null && outPool != null) {
                name = outPool.getSettings().getDestinationNickname();
            }
            if (name == null) {
                name = client.toBase64().substring(0, 4);
            }
            out.write("<h2><a name=\"" + client.toBase64().substring(0, 4) + "\" ></a>Client tunnels for " + name);
            if (this._context.clientManager().isLocal(client)) {
                out.write(" (<a href=\"/configtunnels.jsp#" + client.toBase64().substring(0, 4) + "\">config</a>):</h2>\n");
            } else {
                out.write(" (dead):</h2>\n");
            }
            this.renderPool(out, in, outPool);
        }
        List<HopConfig> participating = this._context.tunnelDispatcher().listParticipatingTunnels();
        Collections.sort(participating, new TunnelComparator());
        out.write("<h2><a name=\"participating\"></a>Participating tunnels:</h2><table>\n");
        out.write("<tr><th>Receive on</th><th>From</th><th>Send on</th><th>To</th><th>Expiration</th><th>Usage</th><th>Rate</th><th>Role</th></tr>\n");
        long processed = 0L;
        RateStat rs = this._context.statManager().getRate("tunnel.participatingMessageCount");
        if (rs != null) {
            processed = (long)rs.getRate(600000L).getLifetimeTotalValue();
        }
        int inactive = 0;
        for (int i = 0; i < participating.size(); ++i) {
            HopConfig cfg = participating.get(i);
            if (cfg.getProcessedMessagesCount() <= 0L) {
                ++inactive;
                continue;
            }
            out.write("<tr>");
            if (cfg.getReceiveTunnel() != null) {
                out.write(" <td class=\"cells\" align=\"center\">" + cfg.getReceiveTunnel().getTunnelId() + "</td>");
            } else {
                out.write(" <td class=\"cells\" align=\"center\">n/a</td>");
            }
            if (cfg.getReceiveFrom() != null) {
                out.write(" <td class=\"cells\" align=\"right\">" + this.netDbLink(cfg.getReceiveFrom()) + "</td>");
            } else {
                out.write(" <td class=\"cells\" align=\"center\">&nbsp;</td>");
            }
            if (cfg.getSendTunnel() != null) {
                out.write(" <td class=\"cells\" align=\"center\">" + cfg.getSendTunnel().getTunnelId() + "</td>");
            } else {
                out.write(" <td class=\"cells\" align=\"center\">&nbsp;</td>");
            }
            if (cfg.getSendTo() != null) {
                out.write(" <td class=\"cells\" align=\"center\">" + this.netDbLink(cfg.getSendTo()) + "</td>");
            } else {
                out.write(" <td class=\"cells\" align=\"center\">&nbsp;</td>");
            }
            long timeLeft = cfg.getExpiration() - this._context.clock().now();
            if (timeLeft > 0L) {
                out.write(" <td class=\"cells\" align=\"center\">" + DataHelper.formatDuration((long)timeLeft) + "</td>");
            } else {
                out.write(" <td class=\"cells\" align=\"center\">(grace period)</td>");
            }
            out.write(" <td class=\"cells\" align=\"center\">" + cfg.getProcessedMessagesCount() + "KB</td>");
            int lifetime = (int)((this._context.clock().now() - cfg.getCreation()) / 1000L);
            if (lifetime <= 0) {
                lifetime = 1;
            }
            if (lifetime > 600) {
                lifetime = 600;
            }
            int bps = 1024 * (int)cfg.getProcessedMessagesCount() / lifetime;
            out.write(" <td class=\"cells\" align=\"center\">" + bps + "Bps</td>");
            if (cfg.getSendTo() == null) {
                out.write(" <td class=\"cells\" align=\"center\">Outbound Endpoint</td>");
            } else if (cfg.getReceiveFrom() == null) {
                out.write(" <td class=\"cells\" align=\"center\">Inbound Gateway</td>");
            } else {
                out.write(" <td class=\"cells\" align=\"center\">Participant</td>");
            }
            out.write("</tr>\n");
            processed += cfg.getProcessedMessagesCount();
        }
        out.write("</table>\n");
        out.write("<div class=\"statusnotes\"><b>Inactive participating tunnels: " + inactive + "</b></div>\n");
        out.write("<div class=\"statusnotes\"><b>Lifetime bandwidth usage: " + DataHelper.formatSize((long)(processed * 1024L)) + "B</b></div>\n");
        this.renderPeers(out);
    }

    private void renderPool(Writer out, TunnelPool in, TunnelPool outPool) throws IOException {
        TunnelInfo info;
        int i;
        List<TunnelInfo> tunnels = null;
        tunnels = in == null ? new ArrayList<TunnelInfo>() : in.listTunnels();
        if (outPool != null) {
            tunnels.addAll(outPool.listTunnels());
        }
        long processedIn = in != null ? in.getLifetimeProcessed() : 0L;
        long processedOut = outPool != null ? outPool.getLifetimeProcessed() : 0L;
        int live = 0;
        int maxLength = 1;
        for (i = 0; i < tunnels.size(); ++i) {
            info = tunnels.get(i);
            if (info.getLength() <= maxLength) continue;
            maxLength = info.getLength();
        }
        out.write("<table><tr><th>In/Out</th><th>Expiry</th><th>Usage</th><th>Gateway</th>");
        if (maxLength > 3) {
            out.write("<th align=\"center\" colspan=\"" + (maxLength - 2));
            out.write("\">Participants</th>");
        } else if (maxLength == 3) {
            out.write("<th>Participant</th>");
        }
        if (maxLength > 1) {
            out.write("<th>Endpoint</th>");
        }
        out.write("</tr>\n");
        for (i = 0; i < tunnels.size(); ++i) {
            info = tunnels.get(i);
            long timeLeft = info.getExpiration() - this._context.clock().now();
            if (timeLeft <= 0L) continue;
            ++live;
            if (info.isInbound()) {
                out.write("<tr> <td class=\"cells\" align=\"center\"><img src=\"/themes/console/images/inbound.png\" alt=\"Inbound\" title=\"Inbound\"></td>");
            } else {
                out.write("<tr> <td class=\"cells\" align=\"center\"><img src=\"/themes/console/images/outbound.png\" alt=\"Outbound\" title=\"Outbound\"></td>");
            }
            out.write(" <td class=\"cells\" align=\"center\">" + DataHelper.formatDuration((long)timeLeft) + "</td>\n");
            out.write(" <td class=\"cells\" align=\"center\">" + info.getProcessedMessagesCount() + "KB</td>\n");
            for (int j = 0; j < info.getLength(); ++j) {
                TunnelId id;
                Hash peer = info.getPeer(j);
                TunnelId tunnelId = id = info.isInbound() ? info.getReceiveTunnelId(j) : info.getSendTunnelId(j);
                if (this._context.routerHash().equals((Object)peer)) {
                    out.write(" <td class=\"cells\" align=\"center\">" + (id == null ? "" : "" + id) + "</td>");
                } else {
                    String cap = this.getCapacity(peer);
                    out.write(" <td class=\"cells\" align=\"center\">" + this.netDbLink(peer) + (id == null ? "" : " " + id) + cap + "</td>");
                }
                if (info.getLength() >= maxLength || info.getLength() != 1 && j != info.getLength() - 2) continue;
                for (int k = info.getLength(); k < maxLength; ++k) {
                    out.write(" <td class=\"cells\" align=\"center\">&nbsp;</td>");
                }
            }
            out.write("</tr>\n");
            if (info.isInbound()) {
                processedIn += info.getProcessedMessagesCount();
                continue;
            }
            processedOut += info.getProcessedMessagesCount();
        }
        out.write("</table>\n");
        if (in != null) {
            List pending = in.listPending();
            if (pending.size() > 0) {
                out.write("<div class=\"statusnotes\"><center><b>Build in progress: " + pending.size() + " inbound</b></center></div>\n");
            }
            live += pending.size();
        }
        if (outPool != null) {
            List pending = outPool.listPending();
            if (pending.size() > 0) {
                out.write("<div class=\"statusnotes\"><center><b>Build in progress: " + pending.size() + " outbound</b></center></div>\n");
            }
            live += pending.size();
        }
        if (live <= 0) {
            out.write("<div class=\"statusnotes\"><center><b>No tunnels; waiting for the grace period to end.</center></b></div>\n");
        }
        out.write("<div class=\"statusnotes\"><center><b>Lifetime bandwidth usage: " + DataHelper.formatSize((long)(processedIn * 1024L)) + "B in, " + DataHelper.formatSize((long)(processedOut * 1024L)) + "B out</b></center></div>");
    }

    private void renderPeers(Writer out) throws IOException {
        ObjectCounter lc = new ObjectCounter();
        int tunnelCount = this.countTunnelsPerPeer((ObjectCounter<Hash>)lc);
        ObjectCounter pc = new ObjectCounter();
        int partCount = this.countParticipatingPerPeer((ObjectCounter<Hash>)pc);
        HashSet peers = new HashSet(lc.objects());
        peers.addAll(pc.objects());
        ArrayList peerList = new ArrayList(peers);
        Collections.sort(peerList, new HashComparator());
        out.write("<h2><a name=\"peers\"></a>Tunnel Counts By Peer:</h2>\n");
        out.write("<table><tr><th>Peer</th><th>Expl. + Client</th><th>% of total</th><th>Part. from + to</th><th>% of total</th></tr>\n");
        for (Hash h : peerList) {
            out.write("<tr> <td class=\"cells\" align=\"center\">");
            out.write(this.netDbLink(h));
            out.write(" <td class=\"cells\" align=\"center\">" + lc.count((Object)h));
            out.write(" <td class=\"cells\" align=\"center\">");
            if (tunnelCount > 0) {
                out.write("" + lc.count((Object)h) * 100 / tunnelCount);
            } else {
                out.write(48);
            }
            out.write(" <td class=\"cells\" align=\"center\">" + pc.count((Object)h));
            out.write(" <td class=\"cells\" align=\"center\">");
            if (partCount > 0) {
                out.write("" + pc.count((Object)h) * 100 / partCount);
            } else {
                out.write(48);
            }
            out.write(10);
        }
        out.write("<tr class=\"tablefooter\"> <td align=\"center\"><b>Tunnels</b> <td align=\"center\"><b>" + tunnelCount);
        out.write("</b> <td>&nbsp;</td> <td align=\"center\"><b>" + partCount);
        out.write("</b> <td>&nbsp;</td></tr></table></div>\n");
    }

    private int countTunnelsPerPeer(ObjectCounter<Hash> lc) {
        ArrayList<TunnelPool> pools = new ArrayList<TunnelPool>();
        this.listPools(pools);
        int tunnelCount = 0;
        for (TunnelPool tp : pools) {
            for (TunnelInfo info : tp.listTunnels()) {
                if (info.getLength() <= 1) continue;
                ++tunnelCount;
                for (int j = 0; j < info.getLength(); ++j) {
                    Hash peer = info.getPeer(j);
                    if (this._context.routerHash().equals((Object)peer)) continue;
                    lc.increment((Object)peer);
                }
            }
        }
        return tunnelCount;
    }

    @Override
    public Set<Hash> selectPeersInTooManyTunnels() {
        ObjectCounter lc = new ObjectCounter();
        int tunnelCount = this.countTunnelsPerPeer((ObjectCounter<Hash>)lc);
        HashSet<Hash> rv = new HashSet<Hash>();
        if (tunnelCount >= 4 && this._context.router().getUptime() > 600000L) {
            int max = this._context.getProperty("router.maxTunnelPercentage", 33);
            for (Hash h : lc.objects()) {
                if (lc.count((Object)h) <= 0 || (lc.count((Object)h) + 1) * 100 / (tunnelCount + 1) <= max) continue;
                rv.add(h);
            }
        }
        return rv;
    }

    private int countParticipatingPerPeer(ObjectCounter<Hash> pc) {
        List<HopConfig> participating = this._context.tunnelDispatcher().listParticipatingTunnels();
        for (HopConfig cfg : participating) {
            Hash to;
            Hash from = cfg.getReceiveFrom();
            if (from != null) {
                pc.increment((Object)from);
            }
            if ((to = cfg.getSendTo()) == null) continue;
            pc.increment((Object)to);
        }
        return participating.size();
    }

    private String getCapacity(Hash peer) {
        RouterInfo info = this._context.netDb().lookupRouterInfoLocally(peer);
        if (info != null) {
            String caps = info.getCapabilities();
            for (char c = 'K'; c <= 'O'; c = (char)((char)(c + 1))) {
                if (caps.indexOf(c) < 0) continue;
                return " " + c;
            }
        }
        return "";
    }

    private String netDbLink(Hash peer) {
        return this._context.commSystem().renderPeerHTML(peer);
    }

    class HashComparator
    implements Comparator {
        HashComparator() {
        }

        public int compare(Object l, Object r) {
            return ((Hash)l).toBase64().compareTo(((Hash)r).toBase64());
        }
    }

    class TunnelComparator
    implements Comparator {
        TunnelComparator() {
        }

        public int compare(Object l, Object r) {
            return (int)(((HopConfig)r).getProcessedMessagesCount() - ((HopConfig)l).getProcessedMessagesCount());
        }
    }

    private static class BootstrapPool
    extends JobImpl {
        private TunnelPool _pool;

        public BootstrapPool(RouterContext ctx, TunnelPool pool) {
            super(ctx);
            this._pool = pool;
            this.getTiming().setStartAfter(ctx.clock().now() + 30000L);
        }

        public String getName() {
            return "Bootstrap tunnel pool";
        }

        public void runJob() {
            this._pool.buildFallback();
        }
    }
}

