/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel.pool;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.i2p.data.Hash;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelPoolSettings;
import net.i2p.router.tunnel.pool.TunnelPeerSelector;
import net.i2p.stat.Rate;
import net.i2p.stat.RateStat;
import net.i2p.util.Log;

class ExploratoryPeerSelector
extends TunnelPeerSelector {
    private static final int MIN_NONFAILING_PCT = 25;

    ExploratoryPeerSelector() {
    }

    public List selectPeers(RouterContext ctx, TunnelPoolSettings settings) {
        Log l = ctx.logManager().getLog(this.getClass());
        int length = this.getLength(ctx, settings);
        if (length < 0) {
            if (l.shouldLog(10)) {
                l.debug("Length requested is zero: " + settings);
            }
            return null;
        }
        Set exclude = this.getExclude(ctx, settings.isInbound(), settings.isExploratory());
        exclude.add(ctx.routerHash());
        HashSet matches = new HashSet(length);
        boolean exploreHighCap = this.shouldPickHighCap(ctx);
        if (exploreHighCap) {
            ctx.profileOrganizer().selectHighCapacityPeers(length, exclude, matches);
        } else if (ctx.commSystem().haveHighOutboundCapacity()) {
            ctx.profileOrganizer().selectNotFailingPeers(length, exclude, matches, false);
        } else {
            ctx.profileOrganizer().selectActiveNotFailingPeers(length, exclude, matches);
        }
        if (l.shouldLog(10)) {
            l.debug("profileOrganizer.selectNotFailing(" + length + ") found " + matches);
        }
        matches.remove(ctx.routerHash());
        ArrayList<Hash> rv = new ArrayList<Hash>(matches);
        if (rv.size() > 1) {
            this.orderPeers(rv, settings.getRandomKey());
        }
        if (settings.isInbound()) {
            rv.add(0, ctx.routerHash());
        } else {
            rv.add(ctx.routerHash());
        }
        return rv;
    }

    private boolean shouldPickHighCap(RouterContext ctx) {
        int failPct;
        if (Boolean.valueOf(ctx.getProperty("router.exploreHighCapacity", "false")).booleanValue()) {
            return true;
        }
        if (ctx.router().getUptime() <= 300000L) {
            return true;
        }
        if (ctx.router().gracefulShutdownInProgress()) {
            return true;
        }
        if (ctx.router().getUptime() <= 660000L) {
            failPct = 75;
        } else {
            failPct = this.getExploratoryFailPercentage(ctx);
            Log l = ctx.logManager().getLog(this.getClass());
            if (l.shouldLog(10)) {
                l.debug("Normalized Fail pct: " + failPct);
            }
            if (failPct > 75) {
                failPct = 75;
            }
        }
        return failPct >= ctx.random().nextInt(100);
    }

    private int getExploratoryFailPercentage(RouterContext ctx) {
        int c = this.getFailPercentage(ctx, "Client");
        int e = this.getFailPercentage(ctx, "Exploratory");
        Log l = ctx.logManager().getLog(this.getClass());
        if (l.shouldLog(10)) {
            l.debug("Client, Expl. Fail pct: " + c + ", " + e);
        }
        if (e <= c || e <= 25) {
            return 0;
        }
        if (c >= 90) {
            return 75;
        }
        return 100 * (e - c) / (100 - c);
    }

    private int getFailPercentage(RouterContext ctx, String t) {
        String pfx = "tunnel.build" + t;
        int timeout = this.getEvents(ctx, pfx + "Expire", 600000L);
        int reject = this.getEvents(ctx, pfx + "Reject", 600000L);
        int accept = this.getEvents(ctx, pfx + "Success", 600000L);
        if (accept + reject + timeout <= 0) {
            return 0;
        }
        double pct = (double)(reject + timeout) / (double)(accept + reject + timeout);
        return (int)(100.0 * pct);
    }

    private int getEvents(RouterContext ctx, String stat, long period) {
        RateStat rs = ctx.statManager().getRate(stat);
        if (rs == null) {
            return 0;
        }
        Rate r = rs.getRate(period);
        if (r == null) {
            return 0;
        }
        return (int)(r.getLastEventCount() + r.getCurrentEventCount());
    }
}

