/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel.pool;

import java.util.ArrayList;
import java.util.List;
import net.i2p.data.Base64;
import net.i2p.data.ByteArray;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.RouterIdentity;
import net.i2p.data.RouterInfo;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.BuildRequestRecord;
import net.i2p.data.i2np.BuildResponseRecord;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.TunnelBuildMessage;
import net.i2p.data.i2np.TunnelBuildReplyMessage;
import net.i2p.data.i2np.TunnelGatewayMessage;
import net.i2p.router.HandlerJobBuilder;
import net.i2p.router.Job;
import net.i2p.router.JobImpl;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.tunnel.BuildMessageProcessor;
import net.i2p.router.tunnel.BuildReplyHandler;
import net.i2p.router.tunnel.HopConfig;
import net.i2p.router.tunnel.pool.BuildExecutor;
import net.i2p.router.tunnel.pool.ExpireJob;
import net.i2p.router.tunnel.pool.PooledTunnelCreatorConfig;
import net.i2p.stat.Rate;
import net.i2p.stat.RateStat;
import net.i2p.util.Log;

class BuildHandler {
    private RouterContext _context;
    private Log _log;
    private BuildExecutor _exec;
    private Job _buildMessageHandlerJob;
    private Job _buildReplyMessageHandlerJob;
    private final List _inboundBuildMessages;
    private final List _inboundBuildReplyMessages;
    private final List _inboundBuildEndMessages;
    private BuildMessageProcessor _processor;
    private static final int MAX_HANDLE_AT_ONCE = 2;
    private static final int NEXT_HOP_LOOKUP_TIMEOUT = 5000;
    private static final int MAX_PROACTIVE_DROPS = 240;
    private static final boolean DROP_ALL_REQUESTS = false;
    private static final boolean HANDLE_REPLIES_INLINE = true;

    public BuildHandler(RouterContext ctx, BuildExecutor exec) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(this.getClass());
        this._exec = exec;
        this._inboundBuildMessages = new ArrayList(16);
        this._inboundBuildReplyMessages = new ArrayList(16);
        this._inboundBuildEndMessages = new ArrayList(16);
        this._context.statManager().createRateStat("tunnel.reject.10", "How often we reject a tunnel probabalistically", "Tunnels", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("tunnel.reject.20", "How often we reject a tunnel because of transient overload", "Tunnels", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("tunnel.reject.30", "How often we reject a tunnel because of bandwidth overload", "Tunnels", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("tunnel.reject.50", "How often we reject a tunnel because of a critical issue (shutdown, etc)", "Tunnels", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("tunnel.decryptRequestTime", "How long it takes to decrypt a new tunnel build request", "Tunnels", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("tunnel.rejectTimeout", "How often we reject a tunnel because we can't find the next hop", "Tunnels", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("tunnel.rejectTimeout2", "How often we fail a tunnel because we can't contact the next hop", "Tunnels", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("tunnel.rejectOverloaded", "How long we had to wait before processing the request (when it was rejected)", "Tunnels", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("tunnel.acceptLoad", "Delay before processing the accepted request", "Tunnels", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("tunnel.dropConnLimits", "Drop instead of reject due to conn limits", "Tunnels", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("tunnel.dropLoad", "How long we had to wait before finally giving up on an inbound request (period is queue count)?", "Tunnels", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("tunnel.dropLoadDelay", "How long we had to wait before finally giving up on an inbound request?", "Tunnels", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("tunnel.dropLoadBacklog", "How many requests were pending when they were so lagged that we had to drop a new inbound request??", "Tunnels", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("tunnel.dropLoadProactive", "What the estimated queue time was when we dropped an inbound request (period is num pending)", "Tunnels", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("tunnel.dropLoadProactiveAbort", "How often we would have proactively dropped a request, but allowed it through?", "Tunnels", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("tunnel.handleRemaining", "How many pending inbound requests were left on the queue after one pass?", "Tunnels", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("tunnel.buildReplyTooSlow", "How often a tunnel build reply came back after we had given up waiting for it?", "Tunnels", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("tunnel.receiveRejectionProbabalistic", "How often we are rejected probabalistically?", "Tunnels", new long[]{600000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("tunnel.receiveRejectionTransient", "How often we are rejected due to transient overload?", "Tunnels", new long[]{600000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("tunnel.receiveRejectionBandwidth", "How often we are rejected due to bandwidth overload?", "Tunnels", new long[]{600000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("tunnel.receiveRejectionCritical", "How often we are rejected due to critical failure?", "Tunnels", new long[]{600000L, 3600000L, 86400000L});
        this._processor = new BuildMessageProcessor(ctx);
        this._buildMessageHandlerJob = new TunnelBuildMessageHandlerJob(ctx);
        this._buildReplyMessageHandlerJob = new TunnelBuildReplyMessageHandlerJob(ctx);
        ctx.inNetMessagePool().registerHandlerJobBuilder(21, new TunnelBuildMessageHandlerJobBuilder());
        ctx.inNetMessagePool().registerHandlerJobBuilder(22, new TunnelBuildReplyMessageHandlerJobBuilder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int handleInboundRequests() {
        int toHandle;
        int dropExpired = 0;
        int remaining = 0;
        ArrayList handled = null;
        long beforeFindHandled = System.currentTimeMillis();
        List list = this._inboundBuildMessages;
        synchronized (list) {
            toHandle = this._inboundBuildMessages.size();
            if (toHandle > 0) {
                if (toHandle > 2) {
                    toHandle = 2;
                }
                handled = new ArrayList(toHandle);
                long dropBefore = System.currentTimeMillis() - 2500L;
                do {
                    BuildMessageState state = (BuildMessageState)this._inboundBuildMessages.get(0);
                    if (state.recvTime > dropBefore) break;
                    this._inboundBuildMessages.remove(0);
                    ++dropExpired;
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Not even trying to handle/decrypt the request " + state.msg.getUniqueId() + ", since we received it a long time ago: " + (System.currentTimeMillis() - state.recvTime));
                    }
                    this._context.statManager().addRateData("tunnel.dropLoadDelay", System.currentTimeMillis() - state.recvTime, 0L);
                } while (this._inboundBuildMessages.size() > 0);
                if (dropExpired > 0) {
                    this._context.throttle().setTunnelStatus("Dropping tunnel requests: Too slow");
                }
                for (int i = 0; i < toHandle && this._inboundBuildMessages.size() > 0; ++i) {
                    handled.add(this._inboundBuildMessages.remove(0));
                }
            }
            remaining = this._inboundBuildMessages.size();
        }
        if (handled != null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Handling " + handled.size() + " requests (took " + (System.currentTimeMillis() - beforeFindHandled) + "ms to find them)");
            }
            for (int i = 0; i < handled.size(); ++i) {
                BuildMessageState state = (BuildMessageState)handled.get(i);
                long beforeHandle = System.currentTimeMillis();
                long actualTime = this.handleRequest(state);
                if (!this._log.shouldLog(10)) continue;
                this._log.debug("Handle took " + (System.currentTimeMillis() - beforeHandle) + "/" + actualTime + " (" + i + " out of " + handled.size() + " with " + remaining + " remaining)");
            }
            handled.clear();
        }
        List i = this._inboundBuildEndMessages;
        synchronized (i) {
            toHandle = this._inboundBuildEndMessages.size();
            if (toHandle > 0) {
                if (handled == null) {
                    handled = new ArrayList(this._inboundBuildEndMessages);
                } else {
                    handled.addAll(this._inboundBuildEndMessages);
                }
                this._inboundBuildEndMessages.clear();
            }
        }
        if (handled != null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Handling " + handled.size() + " requests that are actually replies");
            }
            for (int i2 = 0; i2 < handled.size(); ++i2) {
                BuildEndMessageState state = (BuildEndMessageState)handled.get(i2);
                this.handleRequestAsInboundEndpoint(state);
            }
        }
        if (remaining > 0) {
            this._context.statManager().addRateData("tunnel.handleRemaining", (long)remaining, 0L);
        }
        return remaining;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleInboundReplies() {
        ArrayList handled = null;
        List list = this._inboundBuildReplyMessages;
        synchronized (list) {
            int toHandle = this._inboundBuildReplyMessages.size();
            if (toHandle > 0) {
                handled = new ArrayList(this._inboundBuildReplyMessages);
                this._inboundBuildReplyMessages.clear();
            }
        }
        if (handled != null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Handling " + handled.size() + " replies");
            }
            for (int i = 0; i < handled.size(); ++i) {
                BuildReplyMessageState state = (BuildReplyMessageState)handled.get(i);
                this.handleReply(state);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleReply(BuildReplyMessageState state) {
        long replyMessageId = state.msg.getUniqueId();
        PooledTunnelCreatorConfig cfg = null;
        List building = this._exec.locked_getCurrentlyBuilding();
        StringBuilder buf = null;
        List list = building;
        synchronized (list) {
            for (int i = 0; i < building.size(); ++i) {
                PooledTunnelCreatorConfig cur = (PooledTunnelCreatorConfig)building.get(i);
                if (cur.getReplyMessageId() != replyMessageId) continue;
                building.remove(i);
                cfg = cur;
                break;
            }
            if (cfg == null && this._log.shouldLog(10)) {
                buf = new StringBuilder(building.toString());
            }
        }
        if (cfg == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("The reply " + replyMessageId + " did not match any pending tunnels");
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("Pending tunnels: " + buf.toString());
            }
            this._context.statManager().addRateData("tunnel.buildReplyTooSlow", 1L, 0L);
        } else {
            this.handleReply(state.msg, cfg, System.currentTimeMillis() - state.recvTime);
        }
    }

    private void handleReply(TunnelBuildReplyMessage msg, PooledTunnelCreatorConfig cfg, long delay) {
        List order;
        BuildReplyHandler handler;
        int[] statuses;
        long requestedOn = cfg.getExpiration() - 600000L;
        long rtt = this._context.clock().now() - requestedOn;
        if (this._log.shouldLog(10)) {
            this._log.debug(msg.getUniqueId() + ": Handling the reply after " + rtt + ", delayed " + delay + " waiting for " + cfg);
        }
        if ((statuses = (handler = new BuildReplyHandler()).decrypt(this._context, msg, cfg, order = cfg.getReplyOrder())) != null) {
            boolean allAgree = true;
            for (int i = 0; i < cfg.getLength(); ++i) {
                Hash peer = cfg.getPeer(i);
                int record = order.indexOf(i);
                if (record < 0) {
                    this._log.error("Bad status index " + i);
                    this._exec.buildComplete(cfg, cfg.getTunnelPool());
                    return;
                }
                int howBad = statuses[record];
                if (!peer.toBase64().equals(this._context.routerHash().toBase64())) {
                    RouterInfo ri = this._context.netDb().lookupRouterInfoLocally(peer);
                    String bwTier = "Unknown";
                    if (ri != null) {
                        bwTier = ri.getBandwidthTier();
                    } else if (this._log.shouldLog(30)) {
                        this._log.warn("Failed detecting bwTier, null routerInfo for: " + peer);
                    }
                    if (howBad == 0) {
                        this._context.statManager().addRateData("tunnel.tierAgree" + bwTier, 1L, 0L);
                    } else {
                        this._context.statManager().addRateData("tunnel.tierReject" + bwTier, 1L, 0L);
                    }
                    if (this._log.shouldLog(20)) {
                        this._log.info(msg.getUniqueId() + ": Peer " + peer.toBase64() + " replied with status " + howBad);
                    }
                }
                if (howBad == 0) {
                    this._context.profileManager().tunnelJoined(peer, rtt);
                    continue;
                }
                allAgree = false;
                switch (howBad) {
                    case 30: {
                        this._context.statManager().addRateData("tunnel.receiveRejectionBandwidth", 1L, 0L);
                        break;
                    }
                    case 20: {
                        this._context.statManager().addRateData("tunnel.receiveRejectionTransient", 1L, 0L);
                        break;
                    }
                    case 10: {
                        this._context.statManager().addRateData("tunnel.receiveRejectionProbabalistic", 1L, 0L);
                        break;
                    }
                    default: {
                        this._context.statManager().addRateData("tunnel.receiveRejectionCritical", 1L, 0L);
                    }
                }
                this._context.profileManager().tunnelRejected(peer, rtt, howBad);
                this._context.messageHistory().tunnelParticipantRejected(peer, "peer rejected after " + rtt + " with " + howBad + ": " + cfg.toString());
            }
            this._exec.buildComplete(cfg, cfg.getTunnelPool());
            if (allAgree) {
                if (cfg.isInbound()) {
                    this._context.tunnelDispatcher().joinInbound(cfg);
                } else {
                    this._context.tunnelDispatcher().joinOutbound(cfg);
                }
                cfg.getTunnelPool().addTunnel(cfg);
                this._exec.buildSuccessful(cfg);
                ExpireJob expireJob = new ExpireJob(this._context, cfg, cfg.getTunnelPool());
                cfg.setExpireJob(expireJob);
                this._context.jobQueue().addJob(expireJob);
                if (cfg.getDestination() == null) {
                    this._context.statManager().addRateData("tunnel.buildExploratorySuccess", rtt, rtt);
                } else {
                    this._context.statManager().addRateData("tunnel.buildClientSuccess", rtt, rtt);
                }
            } else if (cfg.getDestination() == null) {
                this._context.statManager().addRateData("tunnel.buildExploratoryReject", rtt, rtt);
            } else {
                this._context.statManager().addRateData("tunnel.buildClientReject", rtt, rtt);
            }
        } else {
            if (this._log.shouldLog(30)) {
                this._log.warn(msg.getUniqueId() + ": Tunnel reply could not be decrypted for tunnel " + cfg);
            }
            this._exec.buildComplete(cfg, cfg.getTunnelPool());
        }
    }

    private long handleRequest(BuildMessageState state) {
        long timeSinceReceived = System.currentTimeMillis() - state.recvTime;
        if (this._log.shouldLog(10)) {
            this._log.debug(state.msg.getUniqueId() + ": handling request after " + timeSinceReceived);
        }
        if (timeSinceReceived > 30000L) {
            this._context.throttle().setTunnelStatus("Dropping tunnel requests: Overloaded");
            if (this._log.shouldLog(30)) {
                this._log.warn("Not even trying to handle/decrypt the request " + state.msg.getUniqueId() + ", since we received it a long time ago: " + timeSinceReceived);
            }
            this._context.statManager().addRateData("tunnel.dropLoadDelay", timeSinceReceived, 0L);
            return -1L;
        }
        long beforeDecrypt = System.currentTimeMillis();
        BuildRequestRecord req = this._processor.decrypt(this._context, state.msg, this._context.routerHash(), this._context.keyManager().getPrivateKey());
        long decryptTime = System.currentTimeMillis() - beforeDecrypt;
        this._context.statManager().addRateData("tunnel.decryptRequestTime", decryptTime, decryptTime);
        if (decryptTime > 500L) {
            this._log.warn("Took too long to decrypt the request: " + decryptTime + " for message " + state.msg.getUniqueId() + " received " + (timeSinceReceived + decryptTime) + " ago");
        }
        if (req == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("The request " + state.msg.getUniqueId() + " could not be decrypted");
            }
            return -1L;
        }
        long beforeLookup = System.currentTimeMillis();
        Hash nextPeer = req.readNextIdentity();
        long readPeerTime = System.currentTimeMillis() - beforeLookup;
        RouterInfo nextPeerInfo = this._context.netDb().lookupRouterInfoLocally(nextPeer);
        long lookupTime = System.currentTimeMillis() - beforeLookup;
        if (lookupTime > 500L) {
            this._log.warn("Took too long to lookup the request: " + lookupTime + "/" + readPeerTime + " for message " + state.msg.getUniqueId() + " received " + (timeSinceReceived + decryptTime) + " ago");
        }
        if (nextPeerInfo == null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Request " + state.msg.getUniqueId() + "/" + req.readReceiveTunnelId() + "/" + req.readNextTunnelId() + " handled, looking for the next peer " + nextPeer.toBase64());
            }
            this._context.netDb().lookupRouterInfo(nextPeer, new HandleReq(this._context, state, req, nextPeer), new TimeoutReq(this._context, state, req, nextPeer), 5000L);
            return -1L;
        }
        long beforeHandle = System.currentTimeMillis();
        this.handleReq(nextPeerInfo, state, req, nextPeer);
        long handleTime = System.currentTimeMillis() - beforeHandle;
        if (this._log.shouldLog(10)) {
            this._log.debug("Request " + state.msg.getUniqueId() + " handled and we know the next peer " + nextPeer.toBase64() + " after " + handleTime + "/" + decryptTime + "/" + lookupTime + "/" + timeSinceReceived);
        }
        return handleTime;
    }

    private void handleRequestAsInboundEndpoint(BuildEndMessageState state) {
        TunnelBuildReplyMessage msg = new TunnelBuildReplyMessage(this._context);
        for (int i = 0; i < 8; ++i) {
            msg.setRecord(i, state.msg.getRecord(i));
        }
        msg.setUniqueId(state.msg.getUniqueId());
        this.handleReply(msg, state.cfg, System.currentTimeMillis() - state.recvTime);
    }

    private int countProactiveDrops() {
        int dropped = 0;
        dropped += this.countEvents("tunnel.dropLoadProactive", 60000L);
        dropped += this.countEvents("tunnel.dropLoad", 60000L);
        dropped += this.countEvents("tunnel.dropLoadBacklog", 60000L);
        return dropped += this.countEvents("tunnel.dropLoadDelay", 60000L);
    }

    private int countEvents(String stat, long period) {
        Rate r;
        RateStat rs = this._context.statManager().getRate(stat);
        if (rs != null && (r = rs.getRate(period)) != null) {
            return (int)r.getCurrentEventCount();
        }
        return 0;
    }

    private void handleReq(RouterInfo nextPeerInfo, BuildMessageState state, BuildRequestRecord req, Hash nextPeer) {
        long ourId = req.readReceiveTunnelId();
        long nextId = req.readNextTunnelId();
        boolean isInGW = req.readIsInboundGateway();
        boolean isOutEnd = req.readIsOutboundEndpoint();
        long time = req.readRequestTime();
        long now = this._context.clock().now() / 3600000L * 3600000L;
        int ourSlot = -1;
        int response = this._context.throttle().acceptTunnelRequest();
        if (this._context.tunnelManager().getTunnelInfo(new TunnelId(ourId)) != null) {
            if (this._log.shouldLog(40)) {
                this._log.error("Already participating in a tunnel with the given Id (" + ourId + "), so gotta reject");
            }
            if (response == 0) {
                response = 10;
            }
        }
        int proactiveDrops = this.countProactiveDrops();
        long recvDelay = System.currentTimeMillis() - state.recvTime;
        if (response == 0) {
            float pDrop = (float)recvDelay / 30000.0f;
            pDrop = (float)Math.pow(pDrop, 16.0);
            if (this._context.random().nextFloat() < pDrop) {
                this._context.statManager().addRateData("tunnel.rejectOverloaded", recvDelay, (long)proactiveDrops);
                this._context.throttle().setTunnelStatus("Rejecting tunnels: Request overload");
                response = 20;
            } else {
                this._context.statManager().addRateData("tunnel.acceptLoad", recvDelay, recvDelay);
            }
        }
        RouterInfo ri = this._context.router().getRouterInfo();
        if (response == 0 && (ri == null || ri.getBandwidthTier().charAt(0) != 'O') && (isInGW && !this._context.commSystem().haveInboundCapacity(87) || isOutEnd && !this._context.commSystem().haveOutboundCapacity(87))) {
            this._context.throttle().setTunnelStatus("Rejecting tunnels: Connection limit");
            response = 30;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Responding to " + state.msg.getUniqueId() + "/" + ourId + " after " + recvDelay + "/" + proactiveDrops + " with " + response + " from " + (state.fromHash != null ? state.fromHash.toBase64() : (state.from != null ? state.from.calculateHash().toBase64() : "tunnel")));
        }
        HopConfig cfg = null;
        if (response == 0) {
            cfg = new HopConfig();
            cfg.setCreation(this._context.clock().now());
            cfg.setExpiration(this._context.clock().now() + 600000L);
            cfg.setIVKey(req.readIVKey());
            cfg.setLayerKey(req.readLayerKey());
            if (isInGW) {
                cfg.setReceiveFrom(null);
            } else if (state.fromHash != null) {
                cfg.setReceiveFrom(state.fromHash);
            } else if (state.from != null) {
                cfg.setReceiveFrom(state.from.calculateHash());
            } else {
                return;
            }
            cfg.setReceiveTunnelId(DataHelper.toLong((int)4, (long)ourId));
            if (isOutEnd) {
                cfg.setSendTo(null);
                cfg.setSendTunnelId(null);
            } else {
                cfg.setSendTo(req.readNextIdentity());
                cfg.setSendTunnelId(DataHelper.toLong((int)4, (long)nextId));
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("Joining " + state.msg.getUniqueId() + "/" + cfg.getReceiveTunnel() + "/" + recvDelay + " as " + (isOutEnd ? "outbound endpoint" : (isInGW ? "inbound gw" : "participant")));
            }
            if (isOutEnd) {
                this._context.tunnelDispatcher().joinOutboundEndpoint(cfg);
            } else if (isInGW) {
                this._context.tunnelDispatcher().joinInboundGateway(cfg);
            } else {
                this._context.tunnelDispatcher().joinParticipant(cfg);
            }
        } else {
            this._context.statManager().addRateData("tunnel.reject." + response, 1L, 1L);
            this._context.messageHistory().tunnelRejected(state.fromHash, new TunnelId(ourId), req.readNextIdentity(), "rejecting for " + response + ": " + state.msg.getUniqueId() + "/" + ourId + "/" + req.readNextTunnelId() + " delay " + recvDelay + " as " + (isOutEnd ? "outbound endpoint" : (isInGW ? "inbound gw" : "participant")));
        }
        if (!(response == 0 || this._context.routerHash().equals((Object)nextPeer) || this._context.commSystem().haveOutboundCapacity(81) || this._context.commSystem().isEstablished(nextPeer))) {
            this._context.statManager().addRateData("tunnel.dropConnLimits", 1L, 0L);
            return;
        }
        BuildResponseRecord resp = new BuildResponseRecord();
        byte[] reply = resp.create(this._context, response, req.readReplyKey(), req.readReplyIV(), state.msg.getUniqueId());
        for (int j = 0; j < 8; ++j) {
            if (state.msg.getRecord(j) != null) continue;
            ourSlot = j;
            state.msg.setRecord(j, new ByteArray(reply));
            break;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Read slot " + ourSlot + " containing our hop @ " + this._context.routerHash().toBase64() + " accepted? " + response + " receiving on " + ourId + " sending to " + nextId + " on " + nextPeer.toBase64() + " inGW? " + isInGW + " outEnd? " + isOutEnd + " time difference " + (now - time) + " recvDelay " + recvDelay + " replyMessage " + req.readReplyMessageId() + " replyKey " + req.readReplyKey().toBase64() + " replyIV " + Base64.encode((byte[])req.readReplyIV()));
        }
        if (!isOutEnd) {
            state.msg.setUniqueId(req.readReplyMessageId());
            state.msg.setMessageExpiration(this._context.clock().now() + 10000L);
            OutNetMessage msg = new OutNetMessage(this._context);
            msg.setMessage(state.msg);
            msg.setExpiration(state.msg.getMessageExpiration());
            msg.setPriority(300);
            msg.setTarget(nextPeerInfo);
            if (response == 0) {
                msg.setOnFailedSendJob(new TunnelBuildNextHopFailJob(this._context, cfg));
            }
            this._context.outNetMessagePool().add(msg);
        } else {
            TunnelBuildReplyMessage replyMsg = new TunnelBuildReplyMessage(this._context);
            int i = 0;
            while (true) {
                TunnelBuildMessage cfr_ignored_0 = state.msg;
                if (i >= 8) break;
                replyMsg.setRecord(i, state.msg.getRecord(i));
                ++i;
            }
            replyMsg.setUniqueId(req.readReplyMessageId());
            replyMsg.setMessageExpiration(this._context.clock().now() + 10000L);
            TunnelGatewayMessage m = new TunnelGatewayMessage(this._context);
            m.setMessage(replyMsg);
            m.setMessageExpiration(replyMsg.getMessageExpiration());
            m.setTunnelId(new TunnelId(nextId));
            if (this._context.routerHash().equals((Object)nextPeer)) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("We are the reply gateway for " + nextId + " when replying to replyMessage " + req.readReplyMessageId());
                }
                this._context.tunnelDispatcher().dispatch(m);
            } else {
                OutNetMessage outMsg = new OutNetMessage(this._context);
                outMsg.setExpiration(m.getMessageExpiration());
                outMsg.setMessage(m);
                outMsg.setPriority(300);
                outMsg.setTarget(nextPeerInfo);
                if (response == 0) {
                    outMsg.setOnFailedSendJob(new TunnelBuildNextHopFailJob(this._context, cfg));
                }
                this._context.outNetMessagePool().add(outMsg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInboundBuildQueueSize() {
        List list = this._inboundBuildMessages;
        synchronized (list) {
            return this._inboundBuildMessages.size();
        }
    }

    private boolean allowProactiveDrop() {
        String allow = this._context.getProperty("router.allowProactiveDrop", "true");
        boolean rv = false;
        if (allow == null || Boolean.valueOf(allow).booleanValue()) {
            rv = true;
        }
        if (!rv) {
            this._context.statManager().addRateData("tunnel.dropLoadProactiveAbort", 1L, 0L);
        }
        return rv;
    }

    private int estimateQueueTime(int numPendingMessages) {
        int decryptTime = 200;
        RateStat rs = this._context.statManager().getRate("tunnel.decryptRequestTime");
        if (rs != null) {
            Rate r = rs.getRate(60000L);
            double avg = 0.0;
            if (r != null) {
                avg = r.getAverageValue();
            }
            if (avg > 0.0) {
                decryptTime = (int)avg;
            } else {
                avg = rs.getLifetimeAverageValue();
                if (avg > 0.0) {
                    decryptTime = (int)avg;
                }
            }
        }
        float estimatedQueueTime = numPendingMessages * decryptTime;
        return (int)(estimatedQueueTime *= 1.2f);
    }

    private static class TunnelBuildNextHopFailJob
    extends JobImpl {
        HopConfig _cfg;

        private TunnelBuildNextHopFailJob(RouterContext ctx, HopConfig cfg) {
            super(ctx);
            this._cfg = cfg;
        }

        public String getName() {
            return "Timeout contacting next peer for tunnel join";
        }

        public void runJob() {
            this.getContext().tunnelDispatcher().remove(this._cfg);
            this.getContext().statManager().addRateData("tunnel.rejectTimeout2", 1L, 0L);
        }
    }

    private static class TunnelBuildReplyMessageHandlerJob
    extends JobImpl {
        private TunnelBuildReplyMessageHandlerJob(RouterContext ctx) {
            super(ctx);
        }

        public void runJob() {
        }

        public String getName() {
            return "Receive tunnel build reply message";
        }
    }

    private static class TunnelBuildMessageHandlerJob
    extends JobImpl {
        private TunnelBuildMessageHandlerJob(RouterContext ctx) {
            super(ctx);
        }

        public void runJob() {
        }

        public String getName() {
            return "Receive tunnel build message";
        }
    }

    private static class BuildEndMessageState {
        TunnelBuildMessage msg;
        PooledTunnelCreatorConfig cfg;
        long recvTime;

        public BuildEndMessageState(PooledTunnelCreatorConfig c, I2NPMessage m) {
            this.cfg = c;
            this.msg = (TunnelBuildMessage)m;
            this.recvTime = System.currentTimeMillis();
        }
    }

    private static class BuildReplyMessageState {
        TunnelBuildReplyMessage msg;
        long recvTime;

        public BuildReplyMessageState(I2NPMessage m) {
            this.msg = (TunnelBuildReplyMessage)m;
            this.recvTime = System.currentTimeMillis();
        }
    }

    private static class BuildMessageState {
        TunnelBuildMessage msg;
        RouterIdentity from;
        Hash fromHash;
        long recvTime;

        public BuildMessageState(I2NPMessage m, RouterIdentity f, Hash h) {
            this.msg = (TunnelBuildMessage)m;
            this.from = f;
            this.fromHash = h;
            this.recvTime = System.currentTimeMillis();
        }
    }

    private class TunnelBuildReplyMessageHandlerJobBuilder
    implements HandlerJobBuilder {
        private TunnelBuildReplyMessageHandlerJobBuilder() {
        }

        public Job createJob(I2NPMessage receivedMessage, RouterIdentity from, Hash fromHash) {
            if (BuildHandler.this._log.shouldLog(10)) {
                BuildHandler.this._log.debug("Receive tunnel build reply message " + receivedMessage.getUniqueId() + " from " + (fromHash != null ? fromHash.toBase64() : (from != null ? from.calculateHash().toBase64() : "a tunnel")));
            }
            BuildHandler.this.handleReply(new BuildReplyMessageState(receivedMessage));
            return BuildHandler.this._buildReplyMessageHandlerJob;
        }
    }

    private class TunnelBuildMessageHandlerJobBuilder
    implements HandlerJobBuilder {
        private TunnelBuildMessageHandlerJobBuilder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Job createJob(I2NPMessage receivedMessage, RouterIdentity from, Hash fromHash) {
            long reqId = receivedMessage.getUniqueId();
            PooledTunnelCreatorConfig cfg = null;
            List building = BuildHandler.this._exec.locked_getCurrentlyBuilding();
            ArrayList<Long> ids = new ArrayList<Long>();
            List list = building;
            synchronized (list) {
                for (int i = 0; i < building.size(); ++i) {
                    PooledTunnelCreatorConfig cur = (PooledTunnelCreatorConfig)building.get(i);
                    ids.add(new Long(cur.getReplyMessageId()));
                    if (cur.isInbound() && cur.getReplyMessageId() == reqId) {
                        building.remove(i);
                        cfg = cur;
                        break;
                    }
                    if (cur.getReplyMessageId() != reqId) continue;
                    BuildHandler.this._log.error("received it, but its not inbound? " + cur);
                }
            }
            if (BuildHandler.this._log.shouldLog(10)) {
                BuildHandler.this._log.debug("Receive tunnel build message " + reqId + " from " + (from != null ? from.calculateHash().toBase64() : (fromHash != null ? fromHash.toBase64() : "tunnels")) + ", waiting ids: " + ids + ", found matching tunnel? " + (cfg != null), null);
            }
            if (cfg != null) {
                BuildEndMessageState state = new BuildEndMessageState(cfg, receivedMessage);
                BuildHandler.this.handleRequestAsInboundEndpoint(state);
            } else if (BuildHandler.this._exec.wasRecentlyBuilding(reqId)) {
                if (BuildHandler.this._log.shouldLog(30)) {
                    BuildHandler.this._log.warn("Dropping the reply " + reqId + ", as we used to be building that");
                }
            } else {
                list = BuildHandler.this._inboundBuildMessages;
                synchronized (list) {
                    boolean removed = false;
                    int dropped = 0;
                    for (int i = 0; i < BuildHandler.this._inboundBuildMessages.size(); ++i) {
                        BuildMessageState cur = (BuildMessageState)BuildHandler.this._inboundBuildMessages.get(i);
                        long age = System.currentTimeMillis() - cur.recvTime;
                        if (age < 2500L) continue;
                        BuildHandler.this._inboundBuildMessages.remove(i);
                        --i;
                        ++dropped;
                        BuildHandler.this._context.statManager().addRateData("tunnel.dropLoad", age, (long)BuildHandler.this._inboundBuildMessages.size());
                    }
                    if (dropped > 0) {
                        BuildHandler.this._context.throttle().setTunnelStatus("Dropping tunnel requests: High load");
                        BuildHandler.this._context.statManager().addRateData("tunnel.dropLoadBacklog", (long)BuildHandler.this._inboundBuildMessages.size(), (long)BuildHandler.this._inboundBuildMessages.size());
                    } else {
                        float f;
                        int queueTime = BuildHandler.this.estimateQueueTime(BuildHandler.this._inboundBuildMessages.size());
                        float pDrop = (float)queueTime / 30000.0f;
                        if ((pDrop = (float)Math.pow(pDrop, 16.0)) > (f = BuildHandler.this._context.random().nextFloat()) && BuildHandler.this.allowProactiveDrop()) {
                            BuildHandler.this._context.throttle().setTunnelStatus("Dropping tunnel requests: Queue time");
                            BuildHandler.this._context.statManager().addRateData("tunnel.dropLoadProactive", (long)queueTime, (long)BuildHandler.this._inboundBuildMessages.size());
                        } else {
                            BuildHandler.this._inboundBuildMessages.add(new BuildMessageState(receivedMessage, from, fromHash));
                        }
                    }
                }
                BuildHandler.this._exec.repoll();
            }
            return BuildHandler.this._buildMessageHandlerJob;
        }
    }

    private static class TimeoutReq
    extends JobImpl {
        private BuildMessageState _state;
        private BuildRequestRecord _req;
        private Hash _nextPeer;

        TimeoutReq(RouterContext ctx, BuildMessageState state, BuildRequestRecord req, Hash nextPeer) {
            super(ctx);
            this._state = state;
            this._req = req;
            this._nextPeer = nextPeer;
        }

        public String getName() {
            return "Timeout looking for next peer for tunnel join";
        }

        public void runJob() {
            this.getContext().statManager().addRateData("tunnel.rejectTimeout", 1L, 0L);
            this.getContext().messageHistory().tunnelRejected(this._state.fromHash, new TunnelId(this._req.readReceiveTunnelId()), this._nextPeer, "rejected because we couldn't find " + this._nextPeer.toBase64() + ": " + this._state.msg.getUniqueId() + "/" + this._req.readNextTunnelId());
        }
    }

    private class HandleReq
    extends JobImpl {
        private BuildMessageState _state;
        private BuildRequestRecord _req;
        private Hash _nextPeer;

        HandleReq(RouterContext ctx, BuildMessageState state, BuildRequestRecord req, Hash nextPeer) {
            super(ctx);
            this._state = state;
            this._req = req;
            this._nextPeer = nextPeer;
        }

        public String getName() {
            return "Deferred tunnel join processing";
        }

        public void runJob() {
            RouterInfo ri;
            if (BuildHandler.this._log.shouldLog(10)) {
                BuildHandler.this._log.debug("Request " + this._state.msg.getUniqueId() + " handled with a successful deferred lookup for the next peer " + this._nextPeer.toBase64());
            }
            if ((ri = this.getContext().netDb().lookupRouterInfoLocally(this._nextPeer)) != null) {
                BuildHandler.this.handleReq(ri, this._state, this._req, this._nextPeer);
            } else {
                BuildHandler.this._log.error("Deferred successfully, but we couldnt find " + this._nextPeer.toBase64() + "?");
            }
        }
    }
}

