/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import java.util.ArrayList;
import java.util.List;
import net.i2p.router.RouterContext;
import net.i2p.router.tunnel.PumpedTunnelGateway;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

public class TunnelGatewayPumper
implements Runnable {
    private RouterContext _context;
    private Log _log;
    private final List _wantsPumping;
    private boolean _stop;

    public TunnelGatewayPumper(RouterContext ctx) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(this.getClass());
        this._wantsPumping = new ArrayList(64);
        this._stop = false;
        for (int i = 0; i < 4; ++i) {
            new I2PThread((Runnable)this, "GW pumper " + i, true).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopPumping() {
        this._stop = true;
        List list = this._wantsPumping;
        synchronized (list) {
            this._wantsPumping.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wantsPumping(PumpedTunnelGateway gw) {
        List list = this._wantsPumping;
        synchronized (list) {
            this._wantsPumping.add(gw);
            this._wantsPumping.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        PumpedTunnelGateway gw = null;
        ArrayList queueBuf = new ArrayList(32);
        while (!this._stop) {
            try {
                List list = this._wantsPumping;
                synchronized (list) {
                    if (this._wantsPumping.size() > 0) {
                        gw = (PumpedTunnelGateway)this._wantsPumping.remove(0);
                    } else {
                        this._wantsPumping.wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (gw == null) continue;
            gw.pump(queueBuf);
            gw = null;
        }
    }
}

