/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import net.i2p.data.Base64;
import net.i2p.data.Hash;
import net.i2p.data.TunnelId;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.tunnel.HopConfig;

public class TunnelCreatorConfig
implements TunnelInfo {
    protected RouterContext _context;
    private Hash _destination;
    private HopConfig[] _config;
    private Hash[] _peers;
    private long _expiration;
    private List _order;
    private long _replyMessageId;
    private boolean _isInbound;
    private long _messagesProcessed;
    private volatile long _verifiedBytesTransferred;
    private boolean _failed;
    private int _failures;
    private static final int THROUGHPUT_COUNT = 3;
    private final double[] _peakThroughput = new double[3];
    private volatile long _peakThroughputCurrentTotal;
    private volatile long _peakThroughputLastCoallesce = System.currentTimeMillis();
    private static final int MAX_CONSECUTIVE_TEST_FAILURES = 3;
    private static final SimpleDateFormat _fmt = new SimpleDateFormat("HH:mm:ss", Locale.UK);

    public TunnelCreatorConfig(RouterContext ctx, int length, boolean isInbound) {
        this(ctx, length, isInbound, null);
    }

    public TunnelCreatorConfig(RouterContext ctx, int length, boolean isInbound, Hash destination) {
        this._context = ctx;
        if (length <= 0) {
            throw new IllegalArgumentException("0 length?  0 hop tunnels are 1 length!");
        }
        this._config = new HopConfig[length];
        this._peers = new Hash[length];
        for (int i = 0; i < length; ++i) {
            this._config[i] = new HopConfig();
        }
        this._isInbound = isInbound;
        this._destination = destination;
        this._messagesProcessed = 0L;
        this._verifiedBytesTransferred = 0L;
        this._failed = false;
        this._failures = 0;
    }

    public int getLength() {
        return this._config.length;
    }

    public Properties getOptions() {
        return null;
    }

    public HopConfig getConfig(int hop) {
        return this._config[hop];
    }

    public TunnelId getReceiveTunnelId(int hop) {
        return this._config[hop].getReceiveTunnel();
    }

    public TunnelId getSendTunnelId(int hop) {
        return this._config[hop].getSendTunnel();
    }

    public Hash getPeer(int hop) {
        return this._peers[hop];
    }

    public void setPeer(int hop, Hash peer) {
        this._peers[hop] = peer;
    }

    public boolean isInbound() {
        return this._isInbound;
    }

    public Hash getDestination() {
        return this._destination;
    }

    public long getExpiration() {
        return this._expiration;
    }

    public void setExpiration(long when) {
        this._expiration = when;
    }

    public List getReplyOrder() {
        return this._order;
    }

    public void setReplyOrder(List order) {
        this._order = order;
    }

    public long getReplyMessageId() {
        return this._replyMessageId;
    }

    public void setReplyMessageId(long id) {
        this._replyMessageId = id;
    }

    public void incrementProcessedMessages() {
        ++this._messagesProcessed;
    }

    public long getProcessedMessagesCount() {
        return this._messagesProcessed;
    }

    public void incrementVerifiedBytesTransferred(int bytes) {
        this._verifiedBytesTransferred += (long)bytes;
        this._peakThroughputCurrentTotal += (long)bytes;
        long now = System.currentTimeMillis();
        long timeSince = now - this._peakThroughputLastCoallesce;
        if (timeSince >= 60000L) {
            long tot = this._peakThroughputCurrentTotal;
            double normalized = (double)tot * 60.0 * 1000.0 / (double)timeSince;
            this._peakThroughputLastCoallesce = now;
            this._peakThroughputCurrentTotal = 0L;
            if (this._context != null) {
                for (int i = 0; i < this._peers.length; ++i) {
                    this._context.profileManager().tunnelDataPushed1m(this._peers[i], (int)normalized);
                }
            }
        }
    }

    public long getVerifiedBytesTransferred() {
        return this._verifiedBytesTransferred;
    }

    public double getPeakThroughputKBps() {
        double rv = 0.0;
        for (int i = 0; i < 3; ++i) {
            rv += this._peakThroughput[i];
        }
        return rv /= 184320.0;
    }

    public void setPeakThroughputKBps(double kBps) {
        this._peakThroughput[0] = kBps * 60.0 * 1024.0;
    }

    public boolean tunnelFailed() {
        ++this._failures;
        if (this._failures > 3) {
            this._failed = true;
            return false;
        }
        return true;
    }

    public boolean getTunnelFailed() {
        return this._failed;
    }

    public int getTunnelFailures() {
        return this._failures;
    }

    public void testSuccessful(int ms) {
        if (!this._failed) {
            this._failures = 0;
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        if (this._isInbound) {
            buf.append("inbound");
        } else {
            buf.append("outbound");
        }
        if (this._destination == null) {
            buf.append(" exploratory");
        }
        buf.append(": ");
        for (int i = 0; i < this._peers.length; ++i) {
            buf.append(this._peers[i].toBase64().substring(0, 4));
            buf.append(':');
            if (this._config[i].getReceiveTunnel() != null) {
                buf.append(this._config[i].getReceiveTunnel());
            } else {
                buf.append('x');
            }
            buf.append('.');
            if (this._config[i].getSendTunnel() != null) {
                buf.append(this._config[i].getSendTunnel());
            } else {
                buf.append('x');
            }
            if (i + 1 >= this._peers.length) continue;
            buf.append("...");
        }
        buf.append(" expiring on ").append(this.getExpirationString());
        if (this._destination != null) {
            buf.append(" for ").append(Base64.encode((byte[])this._destination.getData(), (int)0, (int)3));
        }
        if (this._replyMessageId > 0L) {
            buf.append(" replyMessageId ").append(this._replyMessageId);
        }
        buf.append(" with ").append(this._messagesProcessed).append("/").append(this._verifiedBytesTransferred).append(" msgs/bytes");
        buf.append(" with ").append(this._failures).append(" failures");
        return buf.toString();
    }

    private String getExpirationString() {
        return TunnelCreatorConfig.format(this._expiration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String format(long date) {
        Date d = new Date(date);
        SimpleDateFormat simpleDateFormat = _fmt;
        synchronized (simpleDateFormat) {
            return _fmt.format(d);
        }
    }
}

