/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.data.Base64;
import net.i2p.data.ByteArray;
import net.i2p.data.DataHelper;
import net.i2p.router.tunnel.TunnelGateway;
import net.i2p.util.ByteCache;
import net.i2p.util.Log;

public class TrivialPreprocessor
implements TunnelGateway.QueuePreprocessor {
    protected I2PAppContext _context;
    private Log _log;
    public static final int PREPROCESSED_SIZE = 1024;
    protected static final int IV_SIZE = 16;
    protected static final ByteCache _dataCache = ByteCache.getInstance((int)32, (int)1024);
    protected static final ByteCache _ivCache = ByteCache.getInstance((int)128, (int)16);
    protected static final ByteCache _hashCache = ByteCache.getInstance((int)128, (int)32);
    private static final byte MASK_IS_SUBSEQUENT = -128;
    private static final byte MASK_TYPE = 96;
    private static final byte MASK_FRAGMENTED = 8;
    private static final byte MASK_EXTENDED = 4;
    private static final byte MASK_TUNNEL = 32;
    private static final byte MASK_ROUTER = 64;

    public TrivialPreprocessor(I2PAppContext ctx) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(TrivialPreprocessor.class);
    }

    public long getDelayAmount() {
        return 0L;
    }

    public boolean preprocessQueue(List pending, TunnelGateway.Sender sender, TunnelGateway.Receiver rec) {
        long begin = System.currentTimeMillis();
        StringBuilder buf = null;
        if (this._log.shouldLog(10)) {
            buf = new StringBuilder(256);
            buf.append("Trivial preprocessing of ").append(pending.size()).append(" ");
        }
        while (pending.size() > 0) {
            TunnelGateway.Pending msg = (TunnelGateway.Pending)pending.remove(0);
            long beforePreproc = System.currentTimeMillis();
            byte[][] preprocessed = this.preprocess(msg);
            long afterPreproc = System.currentTimeMillis();
            if (buf != null) {
                buf.append("preprocessed into " + preprocessed.length + " fragments after " + (afterPreproc - beforePreproc) + ". ");
            }
            for (int i = 0; i < preprocessed.length; ++i) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Preprocessed: fragment " + i + "/" + (preprocessed.length - 1) + " in " + msg.getMessageId() + ": " + " send through " + sender + " receive with " + rec);
                }
                long beforeSend = System.currentTimeMillis();
                long id = sender.sendPreprocessed(preprocessed[i], rec);
                long afterSend = System.currentTimeMillis();
                if (buf != null) {
                    buf.append("send of " + msg.getMessageId() + " took " + (afterSend - beforeSend) + ". ");
                }
                msg.addMessageId(id);
            }
            this.notePreprocessing(msg.getMessageId(), msg.getFragmentNumber(), preprocessed.length, msg.getMessageIds(), null);
            if (preprocessed.length != msg.getFragmentNumber() + 1) {
                throw new RuntimeException("wtf, preprocessed " + msg.getMessageId() + " into " + msg.getFragmentNumber() + "/" + preprocessed.length + " fragments, size = " + msg.getData().length);
            }
            if (buf == null) continue;
            buf.append("all fragments sent after " + (System.currentTimeMillis() - afterPreproc) + ". ");
        }
        if (buf != null) {
            buf.append("queue preprocessed after " + (System.currentTimeMillis() - begin) + ".");
            this._log.debug(buf.toString());
        }
        return false;
    }

    protected void notePreprocessing(long messageId, int numFragments, int totalLength, List messageIds, String msg) {
    }

    private byte[][] preprocess(TunnelGateway.Pending msg) {
        ArrayList<byte[]> fragments = new ArrayList<byte[]>(1);
        while (msg.getOffset() < msg.getData().length) {
            fragments.add(this.preprocessFragment(msg));
        }
        byte[][] rv = new byte[fragments.size()][];
        for (int i = 0; i < fragments.size(); ++i) {
            rv[i] = (byte[])fragments.get(i);
        }
        return rv;
    }

    private byte[] preprocessFragment(TunnelGateway.Pending msg) {
        byte[] target = _dataCache.acquire().getData();
        int offset = 0;
        offset = msg.getOffset() <= 0 ? this.writeFirstFragment(msg, target, offset) : this.writeSubsequentFragment(msg, target, offset);
        this.preprocess(target, offset);
        return target;
    }

    protected void preprocess(byte[] fragments, int fragmentLength) {
        int numPadBytes;
        ByteArray ivBuf = _ivCache.acquire();
        byte[] iv = ivBuf.getData();
        this._context.random().nextBytes(iv);
        System.arraycopy(iv, 0, fragments, fragmentLength, 16);
        ByteArray hashBuf = _hashCache.acquire();
        this._context.sha().calculateHash(fragments, 0, fragmentLength + 16, hashBuf.getData(), 0);
        int distance = 1024 - fragmentLength;
        System.arraycopy(fragments, 0, fragments, distance, fragmentLength);
        Arrays.fill(fragments, 0, distance, (byte)0);
        int offset = 0;
        System.arraycopy(iv, 0, fragments, offset, 16);
        System.arraycopy(hashBuf.getData(), 0, fragments, offset += 16, 4);
        offset += 4;
        _hashCache.release(hashBuf);
        _ivCache.release(ivBuf);
        int paddingRemaining = numPadBytes = 1003 - fragmentLength;
        while (paddingRemaining > 0) {
            byte b = (byte)(this._context.random().nextInt() & 0xFF);
            if (b == 0) continue;
            fragments[offset] = b;
            ++offset;
            --paddingRemaining;
        }
        fragments[offset] = 0;
        ++offset;
        if (this._log.shouldLog(10)) {
            this._log.debug("Preprocessing beginning of the fragment instructions at " + offset);
        }
    }

    protected int writeFirstFragment(TunnelGateway.Pending msg, byte[] target, int offset) {
        boolean fragmented = false;
        int origOffset = offset;
        int instructionsLength = this.getInstructionsSize(msg);
        int payloadLength = msg.getData().length - msg.getOffset();
        if (offset + payloadLength + instructionsLength + 16 + 1 + 4 > 1024) {
            fragmented = true;
            payloadLength = 1003 - (instructionsLength += 4) - offset;
            if (payloadLength <= 0) {
                throw new RuntimeException("Fragment too small! payloadLen=" + payloadLength + " target.length=" + target.length + " offset=" + offset + " msg.length=" + msg.getData().length + " msg.offset=" + msg.getOffset() + " instructionsLength=" + instructionsLength + " for " + msg);
            }
        }
        if (payloadLength <= 0) {
            throw new RuntimeException("Full size too small! payloadLen=" + payloadLength + " target.length=" + target.length + " offset=" + offset + " msg.length=" + msg.getData().length + " msg.offset=" + msg.getOffset() + " instructionsLength=" + instructionsLength + " for " + msg);
        }
        target[offset] = 0;
        if (msg.getToTunnel() != null) {
            int n = offset;
            target[n] = (byte)(target[n] | 0x20);
        } else if (msg.getToRouter() != null) {
            int n = offset;
            target[n] = (byte)(target[n] | 0x40);
        }
        if (fragmented) {
            int n = offset;
            target[n] = (byte)(target[n] | 8);
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("CONTROL: " + Integer.toHexString(target[offset]));
        }
        ++offset;
        if (msg.getToTunnel() != null) {
            DataHelper.toLong((byte[])target, (int)offset, (int)4, (long)msg.getToTunnel().getTunnelId());
            offset += 4;
        }
        if (msg.getToRouter() != null) {
            System.arraycopy(msg.getToRouter().getData(), 0, target, offset, 32);
            offset += 32;
        }
        if (fragmented) {
            DataHelper.toLong((byte[])target, (int)offset, (int)4, (long)msg.getMessageId());
            if (this._log.shouldLog(10)) {
                this._log.debug("writing messageId= " + msg.getMessageId() + " at offset " + offset);
            }
            offset += 4;
        }
        DataHelper.toLong((byte[])target, (int)offset, (int)2, (long)payloadLength);
        System.arraycopy(msg.getData(), msg.getOffset(), target, offset += 2, payloadLength);
        if (this._log.shouldLog(10)) {
            this._log.debug("initial fragment[" + msg.getMessageId() + "/" + msg.getFragmentNumber() + "/" + (1024 - offset - payloadLength) + "/" + payloadLength + "]: ");
        }
        offset += payloadLength;
        msg.setOffset(msg.getOffset() + payloadLength);
        if (fragmented) {
            msg.incrementFragmentNumber();
        }
        return offset;
    }

    protected int writeSubsequentFragment(TunnelGateway.Pending msg, byte[] target, int offset) {
        boolean isLast = true;
        int instructionsLength = this.getInstructionsSize(msg);
        int payloadLength = msg.getData().length - msg.getOffset();
        if (payloadLength + instructionsLength + 16 + 1 + 4 > 1024) {
            isLast = false;
            payloadLength = 1003 - instructionsLength;
        }
        target[offset] = 0;
        int n = offset;
        target[n] = (byte)(target[n] | 0xFFFFFF80);
        int n2 = offset;
        target[n2] = (byte)(target[n2] | (byte)(msg.getFragmentNumber() << 1));
        if (isLast) {
            int n3 = offset;
            target[n3] = (byte)(target[n3] | 1);
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("CONTROL: " + Integer.toHexString(target[offset]) + "/" + Base64.encode((byte[])target, (int)offset, (int)1) + " at offset " + offset);
        }
        DataHelper.toLong((byte[])target, (int)(++offset), (int)4, (long)msg.getMessageId());
        DataHelper.toLong((byte[])target, (int)(offset += 4), (int)2, (long)payloadLength);
        System.arraycopy(msg.getData(), msg.getOffset(), target, offset += 2, payloadLength);
        if (this._log.shouldLog(10)) {
            this._log.debug("subsequent fragment[" + msg.getMessageId() + "/" + msg.getFragmentNumber() + "/" + offset + "/" + payloadLength + "]: ");
        }
        offset += payloadLength;
        if (!isLast) {
            msg.incrementFragmentNumber();
        }
        msg.setOffset(msg.getOffset() + payloadLength);
        return offset;
    }

    protected int getInstructionsSize(TunnelGateway.Pending msg) {
        if (msg.getFragmentNumber() > 0) {
            return 7;
        }
        int header = 1;
        if (msg.getToTunnel() != null) {
            header += 4;
        }
        if (msg.getToRouter() != null) {
            header += 32;
        }
        return header += 2;
    }

    protected int getInstructionAugmentationSize(TunnelGateway.Pending msg, int offset, int instructionsSize) {
        int payloadLength = msg.getData().length - msg.getOffset();
        if (offset + payloadLength + instructionsSize + 16 + 1 + 4 > 1024) {
            return 4;
        }
        return 0;
    }
}

