/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import net.i2p.data.Hash;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.TunnelDataMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.tunnel.FragmentHandler;
import net.i2p.router.tunnel.HopConfig;
import net.i2p.router.tunnel.HopProcessor;
import net.i2p.router.tunnel.OutboundMessageDistributor;
import net.i2p.router.tunnel.RouterFragmentHandler;
import net.i2p.util.Log;

public class OutboundTunnelEndpoint {
    private RouterContext _context;
    private Log _log;
    private HopConfig _config;
    private HopProcessor _processor;
    private FragmentHandler _handler;
    private OutboundMessageDistributor _outDistributor;

    public OutboundTunnelEndpoint(RouterContext ctx, HopConfig config, HopProcessor processor) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(OutboundTunnelEndpoint.class);
        this._config = config;
        this._processor = processor;
        this._handler = new RouterFragmentHandler(ctx, (FragmentHandler.DefragmentedReceiver)new DefragmentedHandler());
        this._outDistributor = new OutboundMessageDistributor(ctx, 200);
    }

    public void dispatch(TunnelDataMessage msg, Hash recvFrom) {
        this._config.incrementProcessedMessages();
        this._processor.process(msg.getData(), 0, msg.getData().length, recvFrom);
        this._handler.receiveTunnelMessage(msg.getData(), 0, msg.getData().length);
    }

    private class DefragmentedHandler
    implements FragmentHandler.DefragmentedReceiver {
        private DefragmentedHandler() {
        }

        public void receiveComplete(I2NPMessage msg, Hash toRouter, TunnelId toTunnel) {
            if (OutboundTunnelEndpoint.this._log.shouldLog(10)) {
                OutboundTunnelEndpoint.this._log.debug("outbound tunnel " + OutboundTunnelEndpoint.this._config + " received a full message: " + msg + " to be forwarded on to " + (toRouter != null ? toRouter.toBase64().substring(0, 4) : "") + (toTunnel != null ? toTunnel.getTunnelId() + "" : ""));
            }
            if (!OutboundTunnelEndpoint.this._context.routerHash().equals((Object)toRouter) && OutboundTunnelEndpoint.this._context.tunnelDispatcher().shouldDropParticipatingMessage("OBEP " + msg.getType(), msg.getMessageSize())) {
                return;
            }
            OutboundTunnelEndpoint.this._config.incrementSentMessages();
            OutboundTunnelEndpoint.this._outDistributor.distribute(msg, toRouter, toTunnel);
        }
    }
}

