/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.router.tunnel.HashSetIVValidator;
import net.i2p.router.tunnel.HopConfig;
import net.i2p.router.tunnel.IVValidator;
import net.i2p.util.ByteCache;
import net.i2p.util.Log;

public class HopProcessor {
    protected I2PAppContext _context;
    private Log _log;
    protected HopConfig _config;
    private IVValidator _validator;
    static final boolean USE_ENCRYPTION = true;
    static final boolean USE_DOUBLE_IV_ENCRYPTION = true;
    static final int IV_LENGTH = 16;
    private static final ByteCache _cache = ByteCache.getInstance((int)128, (int)16);

    public HopProcessor(I2PAppContext ctx, HopConfig config) {
        this(ctx, config, HopProcessor.createValidator());
    }

    public HopProcessor(I2PAppContext ctx, HopConfig config, IVValidator validator) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(HopProcessor.class);
        this._config = config;
        this._validator = validator;
    }

    protected static IVValidator createValidator() {
        return new HashSetIVValidator();
    }

    public boolean process(byte[] orig, int offset, int length, Hash prev) {
        boolean okIV;
        if (prev != null) {
            if (this._config.getReceiveFrom() == null) {
                this._config.setReceiveFrom(prev);
            }
            if (!this._config.getReceiveFrom().equals((Object)prev)) {
                if (this._log.shouldLog(40)) {
                    this._log.error("Invalid previous peer - attempted hostile loop?  from " + prev + ", expected " + this._config.getReceiveFrom());
                }
                return false;
            }
        }
        if (!(okIV = this._validator.receiveIV(orig, offset, orig, offset + 16))) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Invalid IV received on tunnel " + this._config.getReceiveTunnelId());
            }
            return false;
        }
        if (this._log.shouldLog(10)) {
            // empty if block
        }
        this.updateIV(orig, offset);
        this.encrypt(orig, offset, length);
        this.updateIV(orig, offset);
        if (this._log.shouldLog(10)) {
            // empty if block
        }
        return true;
    }

    private final void encrypt(byte[] data, int offset, int length) {
        for (int off = offset + 16; off < length; off += 16) {
            DataHelper.xor((byte[])data, (int)(off - 16), (byte[])data, (int)off, (byte[])data, (int)off, (int)16);
            this._context.aes().encryptBlock(data, off, this._config.getLayerKey(), data, off);
        }
    }

    private final void updateIV(byte[] orig, int offset) {
        this._context.aes().encryptBlock(orig, offset, this._config.getIVKey(), orig, offset);
    }
}

