/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import net.i2p.I2PAppContext;
import net.i2p.data.Base64;
import net.i2p.data.ByteArray;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.DataMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.I2NPMessageHandler;
import net.i2p.util.ByteCache;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer;

public class FragmentedMessage {
    private I2PAppContext _context;
    private Log _log;
    private long _messageId;
    private Hash _toRouter;
    private TunnelId _toTunnel;
    private ByteArray[] _fragments;
    private boolean _lastReceived;
    private int _highFragmentNum;
    private long _createdOn;
    private boolean _completed;
    private long _releasedAfter;
    private SimpleTimer.TimedEvent _expireEvent;
    private static final ByteCache _cache = ByteCache.getInstance((int)512, (int)1024);
    private static final int MAX_FRAGMENTS = 64;

    public FragmentedMessage(I2PAppContext ctx) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(FragmentedMessage.class);
        this._messageId = -1L;
        this._toRouter = null;
        this._toTunnel = null;
        this._fragments = new ByteArray[64];
        this._lastReceived = false;
        this._highFragmentNum = -1;
        this._releasedAfter = -1L;
        this._createdOn = ctx.clock().now();
        this._expireEvent = null;
        this._completed = false;
    }

    public boolean receive(long messageId, int fragmentNum, byte[] payload, int offset, int length, boolean isLast) {
        if (fragmentNum < 0) {
            if (this._log.shouldLog(40)) {
                this._log.error("Fragment # == " + fragmentNum + " for messageId " + messageId);
            }
            return false;
        }
        if (payload == null) {
            if (this._log.shouldLog(40)) {
                this._log.error("Payload is null for messageId " + messageId);
            }
            return false;
        }
        if (length <= 0) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Length is impossible (" + length + ") for messageId " + messageId);
            }
            return false;
        }
        if (offset + length > payload.length) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Length is impossible (" + length + "/" + offset + " out of " + payload.length + ") for messageId " + messageId);
            }
            return false;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Receive message " + messageId + " fragment " + fragmentNum + " with " + length + " bytes (last? " + isLast + ") offset = " + offset);
        }
        this._messageId = messageId;
        ByteArray ba = _cache.acquire();
        System.arraycopy(payload, offset, ba.getData(), 0, length);
        ba.setValid(length);
        ba.setOffset(0);
        if (this._log.shouldLog(10)) {
            this._log.debug("fragment[" + fragmentNum + "/" + offset + "/" + length + "]: " + Base64.encode((byte[])ba.getData(), (int)ba.getOffset(), (int)ba.getValid()));
        }
        this._fragments[fragmentNum] = ba;
        boolean bl = this._lastReceived = this._lastReceived || isLast;
        if (fragmentNum > this._highFragmentNum) {
            this._highFragmentNum = fragmentNum;
        }
        if (isLast && fragmentNum <= 0) {
            if (this._log.shouldLog(40)) {
                this._log.error("hmm, isLast and fragmentNum=" + fragmentNum + " for message " + messageId);
            }
            return false;
        }
        return true;
    }

    public boolean receive(long messageId, byte[] payload, int offset, int length, boolean isLast, Hash toRouter, TunnelId toTunnel) {
        if (payload == null) {
            if (this._log.shouldLog(40)) {
                this._log.error("Payload is null for messageId " + messageId);
            }
            return false;
        }
        if (length <= 0) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Length is impossible (" + length + ") for messageId " + messageId);
            }
            return false;
        }
        if (offset + length > payload.length) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Length is impossible (" + length + "/" + offset + " out of " + payload.length + ") for messageId " + messageId);
            }
            return false;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Receive message " + messageId + " with " + length + " bytes (last? " + isLast + ") targetting " + toRouter + " / " + toTunnel + " offset=" + offset);
        }
        this._messageId = messageId;
        ByteArray ba = _cache.acquire();
        System.arraycopy(payload, offset, ba.getData(), 0, length);
        ba.setValid(length);
        ba.setOffset(0);
        if (this._log.shouldLog(10)) {
            this._log.debug("fragment[0/" + offset + "/" + length + "]: " + Base64.encode((byte[])ba.getData(), (int)ba.getOffset(), (int)ba.getValid()));
        }
        this._fragments[0] = ba;
        this._lastReceived = this._lastReceived || isLast;
        this._toRouter = toRouter;
        this._toTunnel = toTunnel;
        if (this._highFragmentNum < 0) {
            this._highFragmentNum = 0;
        }
        return true;
    }

    public long getMessageId() {
        return this._messageId;
    }

    public Hash getTargetRouter() {
        return this._toRouter;
    }

    public TunnelId getTargetTunnel() {
        return this._toTunnel;
    }

    public int getFragmentCount() {
        int found = 0;
        for (int i = 0; i < this._fragments.length; ++i) {
            if (this._fragments[i] == null) continue;
            ++found;
        }
        return found;
    }

    SimpleTimer.TimedEvent getExpireEvent() {
        return this._expireEvent;
    }

    void setExpireEvent(SimpleTimer.TimedEvent evt) {
        this._expireEvent = evt;
    }

    public boolean isComplete() {
        if (!this._lastReceived) {
            return false;
        }
        for (int i = 0; i <= this._highFragmentNum; ++i) {
            if (this._fragments[i] != null) continue;
            return false;
        }
        return true;
    }

    public int getCompleteSize() {
        if (!this._lastReceived) {
            throw new IllegalStateException("wtf, don't get the completed size when we're not complete");
        }
        int size = 0;
        for (int i = 0; i <= this._highFragmentNum; ++i) {
            ByteArray ba = this._fragments[i];
            if (ba == null) {
                throw new IllegalStateException("wtf, don't get the completed size when we're not complete - null fragment i=" + i + " of " + this._highFragmentNum);
            }
            size += ba.getValid();
        }
        return size;
    }

    public long getLifetime() {
        return this._context.clock().now() - this._createdOn;
    }

    public boolean getReleased() {
        return this._completed;
    }

    public void writeComplete(OutputStream out) throws IOException {
        for (int i = 0; i <= this._highFragmentNum; ++i) {
            ByteArray ba = this._fragments[i];
            out.write(ba.getData(), ba.getOffset(), ba.getValid());
        }
        this._completed = true;
    }

    public void writeComplete(byte[] target, int offset) {
        for (int i = 0; i <= this._highFragmentNum; ++i) {
            ByteArray ba = this._fragments[i];
            System.arraycopy(ba.getData(), ba.getOffset(), target, offset, ba.getValid());
            offset += ba.getValid();
        }
        this._completed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toByteArray() {
        FragmentedMessage fragmentedMessage = this;
        synchronized (fragmentedMessage) {
            if (this._releasedAfter > 0L) {
                return null;
            }
            byte[] rv = new byte[this.getCompleteSize()];
            this.writeComplete(rv, 0);
            this.releaseFragments();
            return rv;
        }
    }

    public long getReleasedAfter() {
        return this._releasedAfter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failed() {
        FragmentedMessage fragmentedMessage = this;
        synchronized (fragmentedMessage) {
            this.releaseFragments();
        }
    }

    private void releaseFragments() {
        this._releasedAfter = this.getLifetime();
        for (int i = 0; i <= this._highFragmentNum; ++i) {
            ByteArray ba = this._fragments[i];
            if (ba == null || ba.getData().length != 1024) continue;
            _cache.release(ba);
            this._fragments[i] = null;
        }
    }

    public InputStream getInputStream() {
        return new FragmentInputStream();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("Fragments for ").append(this._messageId).append(": ");
        for (int i = 0; i <= this._highFragmentNum; ++i) {
            ByteArray ba = this._fragments[i];
            if (ba != null) {
                buf.append(i).append(":").append(ba.getValid()).append(" bytes ");
                continue;
            }
            buf.append(i).append(": missing ");
        }
        buf.append(" highest received: ").append(this._highFragmentNum);
        buf.append(" last received? ").append(this._lastReceived);
        buf.append(" lifetime: ").append(DataHelper.formatDuration((long)(this._context.clock().now() - this._createdOn)));
        if (this._toRouter != null) {
            buf.append(" targetting ").append(this._toRouter.toBase64().substring(0, 4));
            if (this._toTunnel != null) {
                buf.append(":").append(this._toTunnel.getTunnelId());
            }
        }
        if (this._completed) {
            buf.append(" completed");
        }
        if (this._releasedAfter > 0L) {
            buf.append(" released after " + DataHelper.formatDuration((long)this._releasedAfter));
        }
        return buf.toString();
    }

    public static void main(String[] args) {
        try {
            I2PAppContext ctx = I2PAppContext.getGlobalContext();
            DataMessage m = new DataMessage(ctx);
            m.setData(new byte[1024]);
            Arrays.fill(m.getData(), (byte)-1);
            m.setMessageExpiration(ctx.clock().now() + 60000L);
            m.setUniqueId(ctx.random().nextLong(0xFFFFFFFFL));
            byte[] data = m.toByteArray();
            I2NPMessage r0 = new I2NPMessageHandler(ctx).readMessage(data);
            System.out.println("peq? " + r0.equals(m));
            FragmentedMessage msg = new FragmentedMessage(ctx);
            msg.receive(m.getUniqueId(), data, 0, 500, false, null, null);
            msg.receive(m.getUniqueId(), 1, data, 500, 500, false);
            msg.receive(m.getUniqueId(), 2, data, 1000, data.length - 1000, true);
            if (!msg.isComplete()) {
                throw new RuntimeException("Not complete?");
            }
            byte[] recv = msg.toByteArray();
            I2NPMessage r = new I2NPMessageHandler(ctx).readMessage(recv);
            System.out.println("eq? " + m.equals(r));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class FragmentInputStream
    extends InputStream {
        private int _fragment = 0;
        private int _offset = 0;

        public int read() throws IOException {
            ByteArray ba;
            while (true) {
                if ((ba = FragmentedMessage.this._fragments[this._fragment]) == null) {
                    return -1;
                }
                if (this._offset < ba.getValid()) break;
                ++this._fragment;
                this._offset = 0;
            }
            byte rv = ba.getData()[ba.getOffset() + this._offset];
            ++this._offset;
            return rv;
        }
    }
}

