/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.i2p.I2PAppContext;
import net.i2p.data.Base64;
import net.i2p.data.ByteArray;
import net.i2p.data.Hash;
import net.i2p.data.PublicKey;
import net.i2p.data.RouterInfo;
import net.i2p.data.SessionKey;
import net.i2p.data.i2np.BuildRequestRecord;
import net.i2p.data.i2np.TunnelBuildMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.tunnel.HopConfig;
import net.i2p.router.tunnel.TunnelCreatorConfig;
import net.i2p.util.Log;

public class BuildMessageGenerator {
    public static final Integer[] ORDER = new Integer[8];

    public TunnelBuildMessage createInbound(RouterContext ctx, TunnelCreatorConfig cfg) {
        return this.create(ctx, cfg, null, -1L);
    }

    public TunnelBuildMessage createOutbound(RouterContext ctx, TunnelCreatorConfig cfg, Hash replyRouter, long replyTunnel) {
        return this.create(ctx, cfg, replyRouter, replyTunnel);
    }

    private TunnelBuildMessage create(RouterContext ctx, TunnelCreatorConfig cfg, Hash replyRouter, long replyTunnel) {
        int i;
        TunnelBuildMessage msg = new TunnelBuildMessage(ctx);
        ArrayList<Integer> order = new ArrayList<Integer>(ORDER.length);
        for (i = 0; i < ORDER.length; ++i) {
            order.add(ORDER[i]);
        }
        Collections.shuffle(order, (Random)ctx.random());
        for (i = 0; i < ORDER.length; ++i) {
            int hop = (Integer)order.get(i);
            Hash peer = cfg.getPeer(hop);
            RouterInfo ri = ctx.netDb().lookupRouterInfoLocally(peer);
            if (ri == null) {
                return null;
            }
            this.createRecord(i, hop, msg, cfg, replyRouter, replyTunnel, ctx, ri.getIdentity().getPublicKey());
        }
        this.layeredEncrypt(ctx, msg, cfg, order);
        return msg;
    }

    public void createRecord(int recordNum, int hop, TunnelBuildMessage msg, TunnelCreatorConfig cfg, Hash replyRouter, long replyTunnel, I2PAppContext ctx, PublicKey peerKey) {
        byte[] encrypted = new byte[528];
        Log log = ctx.logManager().getLog(this.getClass());
        if (peerKey != null) {
            BuildRequestRecord req = null;
            req = !cfg.isInbound() && hop + 1 == cfg.getLength() ? this.createUnencryptedRecord(ctx, cfg, hop, replyRouter, replyTunnel) : this.createUnencryptedRecord(ctx, cfg, hop, null, -1L);
            Hash peer = cfg.getPeer(hop);
            if (log.shouldLog(10)) {
                log.debug("Record " + recordNum + "/" + hop + "/" + peer.toBase64() + ": unencrypted = " + Base64.encode((byte[])req.getData().getData()));
            }
            req.encryptRecord(ctx, peerKey, peer, encrypted, 0);
        } else {
            if (log.shouldLog(10)) {
                log.debug("Record " + recordNum + "/" + hop + "/ is blank/random");
            }
            ctx.random().nextBytes(encrypted);
        }
        msg.setRecord(recordNum, new ByteArray(encrypted));
    }

    private BuildRequestRecord createUnencryptedRecord(I2PAppContext ctx, TunnelCreatorConfig cfg, int hop, Hash replyRouter, long replyTunnel) {
        Log log = ctx.logManager().getLog(BuildMessageGenerator.class);
        if (hop < cfg.getLength()) {
            HopConfig hopConfig = cfg.getConfig(hop);
            Hash peer = cfg.getPeer(hop);
            long recvTunnelId = -1L;
            recvTunnelId = cfg.isInbound() || hop > 0 ? hopConfig.getReceiveTunnel().getTunnelId() : 0L;
            long nextTunnelId = -1L;
            Hash nextPeer = null;
            if (hop + 1 < cfg.getLength()) {
                nextTunnelId = cfg.getConfig(hop + 1).getReceiveTunnel().getTunnelId();
                nextPeer = cfg.getPeer(hop + 1);
            } else if (replyTunnel >= 0L && replyRouter != null) {
                nextTunnelId = replyTunnel;
                nextPeer = replyRouter;
            } else {
                nextTunnelId = 0L;
                nextPeer = peer;
            }
            SessionKey layerKey = hopConfig.getLayerKey();
            SessionKey ivKey = hopConfig.getIVKey();
            SessionKey replyKey = hopConfig.getReplyKey();
            byte[] iv = hopConfig.getReplyIV().getData();
            if (iv == null || iv.length != 16) {
                iv = new byte[16];
                ctx.random().nextBytes(iv);
                hopConfig.getReplyIV().setData(iv);
            }
            boolean isInGW = cfg.isInbound() && hop == 0;
            boolean isOutEnd = !cfg.isInbound() && hop + 1 >= cfg.getLength();
            long nextMsgId = -1L;
            nextMsgId = isOutEnd || cfg.isInbound() && hop + 2 >= cfg.getLength() ? cfg.getReplyMessageId() : ctx.random().nextLong(0xFFFFFFFFL);
            if (log.shouldLog(10)) {
                log.debug("Hop " + hop + " has the next message ID of " + nextMsgId + " for " + cfg + " with replyKey " + replyKey.toBase64() + " and replyIV " + Base64.encode((byte[])iv));
            }
            BuildRequestRecord rec = new BuildRequestRecord();
            rec.createRecord(ctx, recvTunnelId, peer, nextTunnelId, nextPeer, nextMsgId, layerKey, ivKey, replyKey, iv, isInGW, isOutEnd);
            return rec;
        }
        return null;
    }

    public void layeredEncrypt(I2PAppContext ctx, TunnelBuildMessage msg, TunnelCreatorConfig cfg, List order) {
        Log log = ctx.logManager().getLog(BuildMessageGenerator.class);
        for (int i = 0; i < 8; ++i) {
            ByteArray rec = msg.getRecord(i);
            Integer hopNum = (Integer)order.get(i);
            int hop = hopNum;
            if (BuildMessageGenerator.isBlank(cfg, hop) || !cfg.isInbound() && hop == 1) {
                if (!log.shouldLog(10)) continue;
                log.debug(msg.getUniqueId() + ": not pre-decrypting record " + i + "/" + hop + " for " + cfg);
                continue;
            }
            if (log.shouldLog(10)) {
                log.debug(msg.getUniqueId() + ": pre-decrypting record " + i + "/" + hop + " for " + cfg);
            }
            int stop = cfg.isInbound() ? 0 : 1;
            for (int j = hop - 1; j >= stop; --j) {
                HopConfig hopConfig = cfg.getConfig(j);
                SessionKey key = hopConfig.getReplyKey();
                byte[] iv = hopConfig.getReplyIV().getData();
                int off = rec.getOffset();
                if (log.shouldLog(10)) {
                    log.debug(msg.getUniqueId() + ": pre-decrypting record " + i + "/" + hop + " for " + cfg + " with " + key.toBase64() + "/" + Base64.encode((byte[])iv));
                }
                ctx.aes().decrypt(rec.getData(), off, rec.getData(), off, key, iv, 528);
            }
        }
        if (log.shouldLog(10)) {
            log.debug(msg.getUniqueId() + ": done pre-decrypting all records for " + cfg);
        }
    }

    public static boolean isBlank(TunnelCreatorConfig cfg, int hop) {
        if (cfg.isInbound()) {
            return hop + 1 >= cfg.getLength();
        }
        if (hop == 0) {
            return true;
        }
        return hop >= cfg.getLength();
    }

    static {
        for (int i = 0; i < ORDER.length; ++i) {
            BuildMessageGenerator.ORDER[i] = i;
        }
    }
}

