/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import java.util.List;
import java.util.Properties;
import net.i2p.router.RouterContext;
import net.i2p.router.tunnel.BatchedPreprocessor;
import net.i2p.router.tunnel.HopConfig;
import net.i2p.router.tunnel.TunnelCreatorConfig;

public class BatchedRouterPreprocessor
extends BatchedPreprocessor {
    private RouterContext _routerContext;
    private TunnelCreatorConfig _config;
    private HopConfig _hopConfig;
    public static final String PROP_BATCH_FREQUENCY = "batchFrequency";
    public static final String PROP_ROUTER_BATCH_FREQUENCY = "router.batchFrequency";
    public static final int DEFAULT_BATCH_FREQUENCY = 100;

    public BatchedRouterPreprocessor(RouterContext ctx) {
        this(ctx, (HopConfig)null);
    }

    public BatchedRouterPreprocessor(RouterContext ctx, TunnelCreatorConfig cfg) {
        super(ctx, BatchedRouterPreprocessor.getName(cfg));
        this._routerContext = ctx;
        this._config = cfg;
    }

    public BatchedRouterPreprocessor(RouterContext ctx, HopConfig cfg) {
        super(ctx, BatchedRouterPreprocessor.getName(cfg));
        this._routerContext = ctx;
        this._hopConfig = cfg;
    }

    private static String getName(HopConfig cfg) {
        if (cfg == null) {
            return "[unknown]";
        }
        if (cfg.getReceiveTunnel() != null) {
            return cfg.getReceiveTunnel().getTunnelId() + "";
        }
        if (cfg.getSendTunnel() != null) {
            return cfg.getSendTunnel().getTunnelId() + "";
        }
        return "[n/a]";
    }

    private static String getName(TunnelCreatorConfig cfg) {
        if (cfg == null) {
            return "[unknown]";
        }
        if (cfg.getReceiveTunnelId(0) != null) {
            return cfg.getReceiveTunnelId(0).getTunnelId() + "";
        }
        if (cfg.getSendTunnelId(0) != null) {
            return cfg.getSendTunnelId(0).getTunnelId() + "";
        }
        return "[n/a]";
    }

    protected long getSendDelay() {
        Properties opts;
        String freq = null;
        if (this._config != null && (opts = this._config.getOptions()) != null) {
            freq = opts.getProperty(PROP_BATCH_FREQUENCY);
        }
        if (freq == null) {
            freq = this._routerContext.getProperty(PROP_ROUTER_BATCH_FREQUENCY);
        }
        if (freq != null) {
            try {
                return Integer.parseInt(freq);
            }
            catch (NumberFormatException nfe) {
                return 100L;
            }
        }
        return 100L;
    }

    protected void notePreprocessing(long messageId, int numFragments, int totalLength, List messageIds, String msg) {
        if (this._config != null) {
            this._routerContext.messageHistory().fragmentMessage(messageId, numFragments, totalLength, messageIds, this._config, msg);
        } else {
            this._routerContext.messageHistory().fragmentMessage(messageId, numFragments, totalLength, messageIds, this._hopConfig, msg);
        }
    }
}

