/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.router.tunnel.TrivialPreprocessor;
import net.i2p.router.tunnel.TunnelGateway;
import net.i2p.util.Log;

public class BatchedPreprocessor
extends TrivialPreprocessor {
    private Log _log;
    private long _pendingSince;
    private String _name;
    private static final int FULL_SIZE = 1003;
    private static final boolean DISABLE_BATCHING = false;
    static long DEFAULT_DELAY = 100L;
    private static final int FORCE_BATCH_FLUSH = 50;

    public BatchedPreprocessor(I2PAppContext ctx, String name) {
        super(ctx);
        this._log = ctx.logManager().getLog(BatchedPreprocessor.class);
        this._name = name;
        this._pendingSince = 0L;
        ctx.statManager().createRateStat("tunnel.batchMultipleCount", "How many messages are batched into a tunnel message", "Tunnels", new long[]{600000L, 3600000L, 86400000L});
        ctx.statManager().createRateStat("tunnel.batchDelay", "How many messages were pending when the batching waited", "Tunnels", new long[]{600000L, 3600000L, 86400000L});
        ctx.statManager().createRateStat("tunnel.batchDelaySent", "How many messages were flushed when the batching delay completed", "Tunnels", new long[]{600000L, 3600000L, 86400000L});
        ctx.statManager().createRateStat("tunnel.batchCount", "How many groups of messages were flushed together", "Tunnels", new long[]{60000L, 600000L, 3600000L, 86400000L});
        ctx.statManager().createRateStat("tunnel.batchDelayAmount", "How long we should wait before flushing the batch", "Tunnels", new long[]{60000L, 600000L, 3600000L, 86400000L});
        ctx.statManager().createRateStat("tunnel.batchFlushRemaining", "How many messages remain after flushing", "Tunnels", new long[]{60000L, 600000L, 3600000L, 86400000L});
        ctx.statManager().createRateStat("tunnel.writeDelay", "How long after a message reaches the gateway is it processed (lifetime is size)", "Tunnels", new long[]{60000L, 600000L, 3600000L, 86400000L});
    }

    protected long getSendDelay() {
        return DEFAULT_DELAY;
    }

    public long getDelayAmount() {
        return this.getDelayAmount(true);
    }

    private long getDelayAmount(boolean shouldStat) {
        long rv = -1L;
        long defaultAmount = this.getSendDelay();
        if (this._pendingSince > 0L) {
            rv = this._pendingSince + defaultAmount - this._context.clock().now();
        }
        if (rv > defaultAmount) {
            rv = defaultAmount;
        }
        if (shouldStat) {
            this._context.statManager().addRateData("tunnel.batchDelayAmount", rv, 0L);
        }
        return rv;
    }

    public boolean preprocessQueue(List pending, TunnelGateway.Sender sender, TunnelGateway.Receiver rec) {
        StringBuilder timingBuf = null;
        if (this._log.shouldLog(10)) {
            this._log.debug("Preprocess queue with " + pending.size() + " to send");
            timingBuf = new StringBuilder(128);
            timingBuf.append("Preprocess with " + pending.size() + " to send. ");
        }
        long start = System.currentTimeMillis();
        int batchCount = 0;
        int beforeLooping = pending.size();
        while (pending.size() > 0) {
            int allocated = 0;
            long beforePendingLoop = System.currentTimeMillis();
            for (int i = 0; i < pending.size(); ++i) {
                long pendingStart = System.currentTimeMillis();
                TunnelGateway.Pending msg = (TunnelGateway.Pending)pending.get(i);
                int instructionsSize = this.getInstructionsSize(msg);
                instructionsSize += this.getInstructionAugmentationSize(msg, allocated, instructionsSize);
                int curWanted = msg.getData().length - msg.getOffset() + instructionsSize;
                if (this._log.shouldLog(10)) {
                    this._log.debug("pending " + i + "/" + pending.size() + " (" + msg.getMessageId() + ") curWanted=" + curWanted + " instructionSize=" + instructionsSize + " allocated=" + allocated);
                }
                if ((allocated += curWanted) >= 1003) {
                    if (allocated - curWanted + instructionsSize >= 1003) {
                        msg = (TunnelGateway.Pending)pending.get(--i);
                        allocated -= curWanted;
                        if (this._log.shouldLog(10)) {
                            this._log.debug("Pushback of " + curWanted + " (message " + (i + 1) + " in " + pending + ")");
                        }
                    }
                    if (this._pendingSince > 0L) {
                        long waited = this._context.clock().now() - this._pendingSince;
                        this._context.statManager().addRateData("tunnel.batchDelaySent", (long)pending.size(), waited);
                    }
                    long beforeSend = System.currentTimeMillis();
                    this._pendingSince = 0L;
                    this.send(pending, 0, i, sender, rec);
                    long afterSend = System.currentTimeMillis();
                    if (this._log.shouldLog(20)) {
                        this._log.info("Allocated=" + allocated + " so we sent " + (i + 1) + " (last complete? " + (msg.getOffset() >= msg.getData().length) + ", off=" + msg.getOffset() + ", count=" + pending.size() + ")");
                    }
                    for (int j = 0; j < i; ++j) {
                        TunnelGateway.Pending cur = (TunnelGateway.Pending)pending.remove(0);
                        if (cur.getOffset() < cur.getData().length) {
                            throw new IllegalArgumentException("i=" + i + " j=" + j + " off=" + cur.getOffset() + " len=" + cur.getData().length + " alloc=" + allocated);
                        }
                        if (timingBuf != null) {
                            timingBuf.append(" sent " + cur);
                        }
                        this.notePreprocessing(cur.getMessageId(), cur.getFragmentNumber(), cur.getData().length, cur.getMessageIds(), "flushed allocated");
                        this._context.statManager().addRateData("tunnel.writeDelay", cur.getLifetime(), (long)cur.getData().length);
                    }
                    if (msg.getOffset() >= msg.getData().length) {
                        TunnelGateway.Pending cur = (TunnelGateway.Pending)pending.remove(0);
                        if (timingBuf != null) {
                            timingBuf.append(" sent perfect fit " + cur).append(".");
                        }
                        this.notePreprocessing(cur.getMessageId(), cur.getFragmentNumber(), msg.getData().length, msg.getMessageIds(), "flushed tail, remaining: " + pending);
                        this._context.statManager().addRateData("tunnel.writeDelay", cur.getLifetime(), (long)cur.getData().length);
                    }
                    if (i > 0) {
                        this._context.statManager().addRateData("tunnel.batchMultipleCount", (long)(i + 1), 0L);
                    }
                    allocated = 0;
                    ++batchCount;
                    long pendingEnd = System.currentTimeMillis();
                    if (timingBuf == null) break;
                    timingBuf.append(" After sending " + (i + 1) + "/" + pending.size() + " in " + (afterSend - beforeSend) + " after " + (beforeSend - pendingStart) + " since " + (beforeSend - beforePendingLoop) + "/" + (beforeSend - start) + " pending current " + (pendingEnd - pendingStart)).append(".");
                    break;
                }
                if (timingBuf == null) continue;
                timingBuf.append(" After pending loop " + (System.currentTimeMillis() - beforePendingLoop)).append(".");
            }
            long afterCleared = System.currentTimeMillis();
            if (this._log.shouldLog(20)) {
                this.display(allocated, pending, "after looping to clear " + (beforeLooping - pending.size()));
            }
            long afterDisplayed = System.currentTimeMillis();
            if (allocated > 0) {
                if (pending.size() > 50 || this._pendingSince > 0L && this.getDelayAmount() <= 0L) {
                    if (pending.size() > 1) {
                        this._context.statManager().addRateData("tunnel.batchMultipleCount", (long)pending.size(), 0L);
                    }
                    this._context.statManager().addRateData("tunnel.batchDelaySent", (long)pending.size(), 0L);
                    this.send(pending, 0, pending.size() - 1, sender, rec);
                    int beforeSize = pending.size();
                    for (int i = 0; i < pending.size(); ++i) {
                        TunnelGateway.Pending cur = (TunnelGateway.Pending)pending.get(i);
                        if (cur.getOffset() < cur.getData().length) continue;
                        pending.remove(i);
                        this.notePreprocessing(cur.getMessageId(), cur.getFragmentNumber(), cur.getData().length, cur.getMessageIds(), "flushed remaining");
                        this._context.statManager().addRateData("tunnel.writeDelay", cur.getLifetime(), (long)cur.getData().length);
                        --i;
                    }
                    if (pending.size() > 0) {
                        this._pendingSince = this._context.clock().now();
                        this._context.statManager().addRateData("tunnel.batchFlushRemaining", (long)pending.size(), (long)beforeSize);
                        this.display(allocated, pending, "flushed, some remain");
                        if (timingBuf != null) {
                            timingBuf.append(" flushed, some remain (displayed to now: " + (System.currentTimeMillis() - afterDisplayed) + ")");
                            timingBuf.append(" total time: " + (System.currentTimeMillis() - start));
                            this._log.debug(timingBuf.toString());
                        }
                        return true;
                    }
                    long delayAmount = this._context.clock().now() - this._pendingSince;
                    this._pendingSince = 0L;
                    if (batchCount > 1) {
                        this._context.statManager().addRateData("tunnel.batchCount", (long)batchCount, 0L);
                    }
                    if (this._log.shouldLog(20)) {
                        this.display(allocated, pending, "flushed " + beforeSize + ", no remaining after " + delayAmount);
                    }
                    if (timingBuf != null) {
                        timingBuf.append(" flushed, none remain (displayed to now: " + (System.currentTimeMillis() - afterDisplayed) + ")");
                        timingBuf.append(" total time: " + (System.currentTimeMillis() - start));
                        this._log.debug(timingBuf.toString());
                    }
                    return false;
                }
                this._context.statManager().addRateData("tunnel.batchDelay", (long)pending.size(), 0L);
                if (this._pendingSince <= 0L) {
                    this._pendingSince = this._context.clock().now();
                }
                if (batchCount > 1) {
                    this._context.statManager().addRateData("tunnel.batchCount", (long)batchCount, 0L);
                }
                this.display(allocated, pending, "dont flush");
                if (timingBuf != null) {
                    timingBuf.append(" dont flush (displayed to now: " + (System.currentTimeMillis() - afterDisplayed) + ")");
                    timingBuf.append(" total time: " + (System.currentTimeMillis() - start));
                    this._log.debug(timingBuf.toString());
                }
                return true;
            }
            if (timingBuf == null) continue;
            timingBuf.append(" Keep looping");
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Sent everything on the list (pending=" + pending.size() + ")");
        }
        if (timingBuf != null) {
            timingBuf.append(" total time: " + (System.currentTimeMillis() - start));
        }
        if (timingBuf != null) {
            this._log.debug(timingBuf.toString());
        }
        return false;
    }

    private void display(long allocated, List pending, String title) {
        if (this._log.shouldLog(20)) {
            long highestDelay = 0L;
            StringBuilder buf = new StringBuilder();
            buf.append(this._name).append(": ");
            buf.append(title);
            buf.append(" allocated: ").append(allocated);
            buf.append(" pending: ").append(pending.size());
            if (this._pendingSince > 0L) {
                buf.append(" delay: ").append(this.getDelayAmount(false));
            }
            for (int i = 0; i < pending.size(); ++i) {
                TunnelGateway.Pending curPending = (TunnelGateway.Pending)pending.get(i);
                buf.append(" pending[").append(i).append("]: ");
                buf.append(curPending.getOffset()).append("/").append(curPending.getData().length).append('/');
                buf.append(curPending.getLifetime());
                if (curPending.getLifetime() <= highestDelay) continue;
                highestDelay = curPending.getLifetime();
            }
            this._log.info(buf.toString());
        }
    }

    protected void send(List pending, int startAt, int sendThrough, TunnelGateway.Sender sender, TunnelGateway.Receiver rec) {
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending " + startAt + ":" + sendThrough + " out of " + pending);
        }
        byte[] preprocessed = _dataCache.acquire().getData();
        int offset = 0;
        if ((offset = this.writeFragments(pending, startAt, sendThrough, preprocessed, offset)) <= 0) {
            StringBuilder buf = new StringBuilder(128);
            buf.append("wtf, written offset is ").append(offset);
            buf.append(" for ").append(startAt).append(" through ").append(sendThrough);
            for (int i = startAt; i <= sendThrough; ++i) {
                buf.append(" ").append(pending.get(i).toString());
            }
            this._log.log(50, buf.toString());
            return;
        }
        try {
            this.preprocess(preprocessed, offset);
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            if (this._log.shouldLog(40)) {
                this._log.error("Error preprocessing the messages (offset=" + offset + " start=" + startAt + " through=" + sendThrough + " pending=" + pending.size() + " preproc=" + preprocessed.length);
            }
            return;
        }
        long msgId = sender.sendPreprocessed(preprocessed, rec);
        for (int i = 0; i < pending.size(); ++i) {
            TunnelGateway.Pending cur = (TunnelGateway.Pending)pending.get(i);
            cur.addMessageId(msgId);
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Sent " + startAt + ":" + sendThrough + " out of " + pending + " in message " + msgId);
        }
    }

    private int writeFragments(List pending, int startAt, int sendThrough, byte[] target, int offset) {
        for (int i = startAt; i <= sendThrough; ++i) {
            TunnelGateway.Pending msg = (TunnelGateway.Pending)pending.get(i);
            int prevOffset = offset;
            if (msg.getOffset() == 0) {
                offset = this.writeFirstFragment(msg, target, offset);
                if (!this._log.shouldLog(10)) continue;
                this._log.debug("writing " + msg.getMessageId() + " fragment 0, ending at " + offset + " prev " + prevOffset + " leaving " + (msg.getData().length - msg.getOffset()) + " bytes for later");
                continue;
            }
            offset = this.writeSubsequentFragment(msg, target, offset);
            if (!this._log.shouldLog(10)) continue;
            this._log.debug("writing " + msg.getMessageId() + " fragment " + (msg.getFragmentNumber() - 1) + ", ending at " + offset + " prev " + prevOffset + " leaving " + (msg.getData().length - msg.getOffset()) + " bytes for later");
        }
        return offset;
    }
}

