/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.net.InetAddress;
import net.i2p.I2PAppContext;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.data.SessionKey;
import net.i2p.router.transport.udp.ACKBitfield;
import net.i2p.router.transport.udp.PacketBuilder;
import net.i2p.router.transport.udp.UDPPacket;
import net.i2p.util.Log;

public class UDPPacketReader {
    private I2PAppContext _context;
    private Log _log;
    private byte[] _message;
    private int _payloadBeginOffset;
    private int _payloadLength;
    private SessionRequestReader _sessionRequestReader;
    private SessionCreatedReader _sessionCreatedReader;
    private SessionConfirmedReader _sessionConfirmedReader;
    private DataReader _dataReader;
    private PeerTestReader _peerTestReader;
    private RelayRequestReader _relayRequestReader;
    private RelayIntroReader _relayIntroReader;
    private RelayResponseReader _relayResponseReader;
    private static final int KEYING_MATERIAL_LENGTH = 64;

    public UDPPacketReader(I2PAppContext ctx) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(UDPPacketReader.class);
        this._sessionRequestReader = new SessionRequestReader();
        this._sessionCreatedReader = new SessionCreatedReader();
        this._sessionConfirmedReader = new SessionConfirmedReader();
        this._dataReader = new DataReader();
        this._peerTestReader = new PeerTestReader();
        this._relayRequestReader = new RelayRequestReader();
        this._relayIntroReader = new RelayIntroReader();
        this._relayResponseReader = new RelayResponseReader();
    }

    public void initialize(UDPPacket packet) {
        int off = packet.getPacket().getOffset();
        int len = packet.getPacket().getLength();
        this.initialize(packet.getPacket().getData(), off += 32, len -= 32);
    }

    public void initialize(byte[] message, int payloadOffset, int payloadLength) {
        this._message = message;
        this._payloadBeginOffset = payloadOffset;
        this._payloadLength = payloadLength;
    }

    public int readPayloadType() {
        return (this._message[this._payloadBeginOffset] & 0xFF) >>> 4;
    }

    public boolean readRekeying() {
        return (this._message[this._payloadBeginOffset] & 8) != 0;
    }

    public boolean readExtendedOptionsIncluded() {
        return (this._message[this._payloadBeginOffset] & 4) != 0;
    }

    public long readTimestamp() {
        return DataHelper.fromLong((byte[])this._message, (int)(this._payloadBeginOffset + 1), (int)4);
    }

    public void readKeyingMaterial(byte[] target, int targetOffset) {
        if (!this.readRekeying()) {
            throw new IllegalStateException("This packet is not rekeying!");
        }
        System.arraycopy(this._message, this._payloadBeginOffset + 1 + 4, target, targetOffset, 64);
    }

    private int readBodyOffset() {
        int offset = this._payloadBeginOffset + 1 + 4;
        if (this.readRekeying()) {
            offset += 64;
        }
        if (this.readExtendedOptionsIncluded()) {
            int optionsSize = (int)DataHelper.fromLong((byte[])this._message, (int)offset, (int)1);
            offset += optionsSize + 1;
        }
        return offset;
    }

    public SessionRequestReader getSessionRequestReader() {
        return this._sessionRequestReader;
    }

    public SessionCreatedReader getSessionCreatedReader() {
        return this._sessionCreatedReader;
    }

    public SessionConfirmedReader getSessionConfirmedReader() {
        return this._sessionConfirmedReader;
    }

    public DataReader getDataReader() {
        return this._dataReader;
    }

    public PeerTestReader getPeerTestReader() {
        return this._peerTestReader;
    }

    public RelayRequestReader getRelayRequestReader() {
        return this._relayRequestReader;
    }

    public RelayIntroReader getRelayIntroReader() {
        return this._relayIntroReader;
    }

    public RelayResponseReader getRelayResponseReader() {
        return this._relayResponseReader;
    }

    public String toString() {
        switch (this.readPayloadType()) {
            case 6: {
                return this._dataReader.toString();
            }
            case 2: {
                return "Session confirmed packet";
            }
            case 1: {
                return "Session created packet";
            }
            case 0: {
                return "Session request packet";
            }
            case 7: {
                return "Peer test packet";
            }
            case 5: {
                return "Relay intro packet";
            }
            case 3: {
                return "Relay request packet";
            }
            case 4: {
                return "Relay response packet";
            }
        }
        return "Other packet type...";
    }

    public void toRawString(StringBuilder buf) {
        if (this._message != null) {
            buf.append(Base64.encode((byte[])this._message, (int)this._payloadBeginOffset, (int)this._payloadLength));
        }
    }

    public static void main(String[] args) {
        I2PAppContext ctx = I2PAppContext.getGlobalContext();
        try {
            PacketBuilder b = new PacketBuilder(ctx, null);
            InetAddress introHost = InetAddress.getLocalHost();
            int introPort = 1234;
            byte[] introKey = new byte[32];
            ctx.random().nextBytes(introKey);
            long introTag = ctx.random().nextLong(0xFFFFFFFFL);
            long introNonce = ctx.random().nextLong(0xFFFFFFFFL);
            SessionKey ourIntroKey = ctx.keyGenerator().generateSessionKey();
            UDPPacket packet = b.buildRelayRequest(introHost, introPort, introKey, introTag, ourIntroKey, introNonce, false);
            UDPPacketReader r = new UDPPacketReader(ctx);
            r.initialize(packet);
            RelayRequestReader reader = r.getRelayRequestReader();
            System.out.println("Nonce: " + reader.readNonce() + " / " + introNonce);
            System.out.println("Tag  : " + reader.readTag() + " / " + introTag);
            byte[] readKey = new byte[32];
            reader.readAliceIntroKey(readKey, 0);
            System.out.println("Key  : " + Base64.encode((byte[])readKey) + " / " + ourIntroKey.toBase64());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class RelayResponseReader {
        public int readCharlieIPSize() {
            int offset = UDPPacketReader.this.readBodyOffset();
            return (int)DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)offset, (int)1);
        }

        public void readCharlieIP(byte[] target, int targetOffset) {
            int offset = UDPPacketReader.this.readBodyOffset();
            int size = (int)DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)offset, (int)1);
            System.arraycopy(UDPPacketReader.this._message, ++offset, target, targetOffset, size);
        }

        public int readCharliePort() {
            int offset = UDPPacketReader.this.readBodyOffset();
            offset = (int)((long)offset + DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)offset, (int)1));
            return (int)DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)(++offset), (int)2);
        }

        public int readAliceIPSize() {
            int offset = UDPPacketReader.this.readBodyOffset();
            offset = (int)((long)offset + DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)offset, (int)1));
            ++offset;
            return (int)DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)(offset += 2), (int)1);
        }

        public void readAliceIP(byte[] target, int targetOffset) {
            int offset = UDPPacketReader.this.readBodyOffset();
            offset = (int)((long)offset + DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)offset, (int)1));
            ++offset;
            int sz = (int)DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)(offset += 2), (int)1);
            System.arraycopy(UDPPacketReader.this._message, ++offset, target, targetOffset, sz);
        }

        public int readAlicePort() {
            int offset = UDPPacketReader.this.readBodyOffset();
            offset = (int)((long)offset + DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)offset, (int)1));
            ++offset;
            int sz = (int)DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)(offset += 2), (int)1);
            ++offset;
            return (int)DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)(offset += sz), (int)2);
        }

        public long readNonce() {
            int offset = UDPPacketReader.this.readBodyOffset();
            offset = (int)((long)offset + DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)offset, (int)1));
            ++offset;
            int sz = (int)DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)(offset += 2), (int)1);
            ++offset;
            offset += sz;
            return DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)(offset += 2), (int)4);
        }
    }

    public class RelayIntroReader {
        public int readIPSize() {
            int offset = UDPPacketReader.this.readBodyOffset();
            return (int)DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)offset, (int)1);
        }

        public void readIP(byte[] target, int targetOffset) {
            int offset = UDPPacketReader.this.readBodyOffset();
            int size = (int)DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)offset, (int)1);
            System.arraycopy(UDPPacketReader.this._message, ++offset, target, targetOffset, size);
        }

        public int readPort() {
            int offset = UDPPacketReader.this.readBodyOffset();
            offset = (int)((long)offset + DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)offset, (int)1));
            return (int)DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)(++offset), (int)2);
        }

        public int readChallengeSize() {
            int offset = UDPPacketReader.this.readBodyOffset();
            offset = (int)((long)offset + DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)offset, (int)1));
            ++offset;
            return (int)DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)(offset += 2), (int)1);
        }

        public void readChallengeSize(byte[] target, int targetOffset) {
            int offset = UDPPacketReader.this.readBodyOffset();
            offset = (int)((long)offset + DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)offset, (int)1));
            ++offset;
            int sz = (int)DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)(offset += 2), (int)1);
            System.arraycopy(UDPPacketReader.this._message, ++offset, target, targetOffset, sz);
        }
    }

    public class RelayRequestReader {
        public long readTag() {
            long rv = DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)UDPPacketReader.this.readBodyOffset(), (int)4);
            if (UDPPacketReader.this._log.shouldLog(10)) {
                UDPPacketReader.this._log.debug("read alice tag: " + rv);
            }
            return rv;
        }

        public int readIPSize() {
            int offset = UDPPacketReader.this.readBodyOffset() + 4;
            int rv = (int)DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)offset, (int)1);
            if (UDPPacketReader.this._log.shouldLog(10)) {
                UDPPacketReader.this._log.debug("read alice ip size: " + rv);
            }
            return rv;
        }

        public void readIP(byte[] target, int targetOffset) {
            int offset = UDPPacketReader.this.readBodyOffset() + 4;
            int size = (int)DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)offset, (int)1);
            System.arraycopy(UDPPacketReader.this._message, ++offset, target, targetOffset, size);
            if (UDPPacketReader.this._log.shouldLog(10)) {
                UDPPacketReader.this._log.debug("read alice ip: " + Base64.encode((byte[])target, (int)targetOffset, (int)size));
            }
        }

        public int readPort() {
            int offset = UDPPacketReader.this.readBodyOffset() + 4;
            offset = (int)((long)offset + DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)offset, (int)1));
            int rv = (int)DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)(++offset), (int)2);
            if (UDPPacketReader.this._log.shouldLog(10)) {
                UDPPacketReader.this._log.debug("read alice port: " + rv);
            }
            return rv;
        }

        public int readChallengeSize() {
            int offset = UDPPacketReader.this.readBodyOffset() + 4;
            offset = (int)((long)offset + DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)offset, (int)1));
            ++offset;
            int rv = (int)DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)(offset += 2), (int)1);
            if (UDPPacketReader.this._log.shouldLog(10)) {
                UDPPacketReader.this._log.debug("read challenge size: " + rv);
            }
            return rv;
        }

        public void readChallengeSize(byte[] target, int targetOffset) {
            int offset = UDPPacketReader.this.readBodyOffset() + 4;
            offset = (int)((long)offset + DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)offset, (int)1));
            ++offset;
            int sz = (int)DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)(offset += 2), (int)1);
            System.arraycopy(UDPPacketReader.this._message, ++offset, target, targetOffset, sz);
            if (UDPPacketReader.this._log.shouldLog(10)) {
                UDPPacketReader.this._log.debug("read challenge data: " + Base64.encode((byte[])target));
            }
        }

        public void readAliceIntroKey(byte[] target, int targetOffset) {
            int offset = UDPPacketReader.this.readBodyOffset() + 4;
            offset = (int)((long)offset + DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)offset, (int)1));
            ++offset;
            int sz = (int)DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)(offset += 2), (int)1);
            ++offset;
            System.arraycopy(UDPPacketReader.this._message, offset += sz, target, targetOffset, 32);
            if (UDPPacketReader.this._log.shouldLog(10)) {
                UDPPacketReader.this._log.debug("read alice intro key: " + Base64.encode((byte[])target, (int)targetOffset, (int)32) + " packet size: " + UDPPacketReader.this._payloadLength + " off: " + offset + " data: " + Base64.encode((byte[])UDPPacketReader.this._message));
            }
        }

        public long readNonce() {
            int offset = UDPPacketReader.this.readBodyOffset() + 4;
            offset = (int)((long)offset + DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)offset, (int)1));
            ++offset;
            int sz = (int)DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)(offset += 2), (int)1);
            ++offset;
            offset += sz;
            long rv = DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)(offset += 32), (int)4);
            if (UDPPacketReader.this._log.shouldLog(10)) {
                UDPPacketReader.this._log.debug("read request nonce: " + rv);
            }
            return rv;
        }
    }

    public class PeerTestReader {
        private static final int NONCE_LENGTH = 4;

        public long readNonce() {
            int readOffset = UDPPacketReader.this.readBodyOffset();
            return DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)readOffset, (int)4);
        }

        public int readIPSize() {
            int offset = UDPPacketReader.this.readBodyOffset() + 4;
            return (int)DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)offset, (int)1);
        }

        public void readIP(byte[] target, int targetOffset) {
            int offset = UDPPacketReader.this.readBodyOffset() + 4;
            int size = (int)DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)offset, (int)1);
            System.arraycopy(UDPPacketReader.this._message, ++offset, target, targetOffset, size);
        }

        public int readPort() {
            int offset = UDPPacketReader.this.readBodyOffset() + 4;
            int size = (int)DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)offset, (int)1);
            ++offset;
            return (int)DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)(offset += size), (int)2);
        }

        public void readIntroKey(byte[] target, int targetOffset) {
            int offset = UDPPacketReader.this.readBodyOffset() + 4;
            int size = (int)DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)offset, (int)1);
            ++offset;
            offset += size;
            System.arraycopy(UDPPacketReader.this._message, offset += 2, target, targetOffset, 32);
        }
    }

    private class PacketACKBitfield
    implements ACKBitfield {
        private int _start;
        private int _bitfieldStart;
        private int _bitfieldSize;

        public PacketACKBitfield(int start) {
            this._start = start;
            this._bitfieldStart = start + 4;
            this._bitfieldSize = 1;
            while ((UDPPacketReader.this._message[this._bitfieldStart + this._bitfieldSize - 1] & 0xFFFFFF80) != 0) {
                ++this._bitfieldSize;
            }
        }

        public long getMessageId() {
            return DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)this._start, (int)4);
        }

        public int getByteLength() {
            return 4 + this._bitfieldSize;
        }

        public int fragmentCount() {
            return this._bitfieldSize * 7;
        }

        public boolean receivedComplete() {
            return false;
        }

        public boolean received(int fragmentNum) {
            if (fragmentNum < 0 || fragmentNum >= this._bitfieldSize * 7) {
                return false;
            }
            int byteNum = this._bitfieldStart + fragmentNum / 7;
            int flagNum = fragmentNum % 7;
            return (UDPPacketReader.this._message[byteNum] & 1 << flagNum) != 0;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(64);
            buf.append("Read partial ACK of ");
            buf.append(this.getMessageId());
            buf.append(" with ACKs for: ");
            int numFrags = this.fragmentCount();
            for (int i = 0; i < numFrags; ++i) {
                if (this.received(i)) {
                    buf.append(i).append(" ");
                    continue;
                }
                buf.append('!').append(i).append(" ");
            }
            return buf.toString();
        }
    }

    public class DataReader {
        public int getPacketSize() {
            return UDPPacketReader.this._payloadLength;
        }

        public boolean readACKsIncluded() {
            return this.flagSet((byte)-128);
        }

        public boolean readACKBitfieldsIncluded() {
            return this.flagSet((byte)64);
        }

        public boolean readECN() {
            return this.flagSet((byte)16);
        }

        public boolean readWantPreviousACKs() {
            return this.flagSet((byte)8);
        }

        public boolean readReplyRequested() {
            return this.flagSet((byte)4);
        }

        public boolean readExtendedDataIncluded() {
            return this.flagSet((byte)2);
        }

        public int readACKCount() {
            if (!this.readACKsIncluded()) {
                return 0;
            }
            int off = UDPPacketReader.this.readBodyOffset() + 1;
            return (int)DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)off, (int)1);
        }

        public long readACK(int index) {
            if (!this.readACKsIncluded()) {
                return -1L;
            }
            int off = UDPPacketReader.this.readBodyOffset() + 1;
            return DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)(++off + 4 * index), (int)4);
        }

        public ACKBitfield[] readACKBitfields() {
            if (!this.readACKBitfieldsIncluded()) {
                return null;
            }
            int off = UDPPacketReader.this.readBodyOffset() + 1;
            if (this.readACKsIncluded()) {
                int numACKs = (int)DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)off, (int)1);
                ++off;
                off += 4 * numACKs;
            }
            int numBitfields = (int)DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)off, (int)1);
            ++off;
            ACKBitfield[] rv = new PacketACKBitfield[numBitfields];
            for (int i = 0; i < numBitfields; ++i) {
                rv[i] = new PacketACKBitfield(off);
                off += ((PacketACKBitfield)rv[i]).getByteLength();
            }
            return rv;
        }

        public int readFragmentCount() {
            int off = UDPPacketReader.this.readBodyOffset() + 1;
            if (this.readACKsIncluded()) {
                int numACKs = (int)DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)off, (int)1);
                ++off;
                off += 4 * numACKs;
            }
            if (this.readACKBitfieldsIncluded()) {
                int numBitfields = (int)DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)off, (int)1);
                ++off;
                for (int i = 0; i < numBitfields; ++i) {
                    PacketACKBitfield bf = new PacketACKBitfield(off);
                    off += bf.getByteLength();
                }
            }
            if (this.readExtendedDataIncluded()) {
                int size = (int)DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)off, (int)1);
                ++off;
                off += size;
            }
            return UDPPacketReader.this._message[off];
        }

        public long readMessageId(int fragmentNum) {
            int fragmentBegin = this.getFragmentBegin(fragmentNum);
            return DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)fragmentBegin, (int)4);
        }

        public int readMessageFragmentNum(int fragmentNum) {
            int off = this.getFragmentBegin(fragmentNum);
            return (UDPPacketReader.this._message[off += 4] & 0xFF) >>> 1;
        }

        public boolean readMessageIsLast(int fragmentNum) {
            int off = this.getFragmentBegin(fragmentNum);
            return (UDPPacketReader.this._message[off += 4] & 1) != 0;
        }

        public int readMessageFragmentSize(int fragmentNum) {
            int off = this.getFragmentBegin(fragmentNum);
            off += 4;
            return (int)DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)(++off), (int)2) & 0x3FFF;
        }

        public void readMessageFragment(int fragmentNum, byte[] target, int targetOffset) {
            int off = this.getFragmentBegin(fragmentNum);
            off += 4;
            int size = (int)DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)(++off), (int)2) & 0x3FFF;
            System.arraycopy(UDPPacketReader.this._message, off += 2, target, targetOffset, size);
        }

        private int getFragmentBegin(int fragmentNum) {
            int off = UDPPacketReader.this.readBodyOffset() + 1;
            if (this.readACKsIncluded()) {
                int numACKs = (int)DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)off, (int)1);
                ++off;
                off += 4 * numACKs;
            }
            if (this.readACKBitfieldsIncluded()) {
                int numBitfields = (int)DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)off, (int)1);
                ++off;
                PacketACKBitfield[] bf = new PacketACKBitfield[numBitfields];
                for (int i = 0; i < numBitfields; ++i) {
                    bf[i] = new PacketACKBitfield(off);
                    off += bf[i].getByteLength();
                }
            }
            if (this.readExtendedDataIncluded()) {
                int size = (int)DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)off, (int)1);
                ++off;
                off += size;
            }
            ++off;
            if (fragmentNum == 0) {
                return off;
            }
            for (int i = 0; i < fragmentNum; ++i) {
                off += 5;
                off += (int)DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)off, (int)2) & 0x3FFF;
                off += 2;
            }
            return off;
        }

        private boolean flagSet(byte flag) {
            int flagOffset = UDPPacketReader.this.readBodyOffset();
            return (UDPPacketReader.this._message[flagOffset] & flag) != 0;
        }

        public String toString() {
            int i;
            StringBuilder buf = new StringBuilder(256);
            long msAgo = UDPPacketReader.this._context.clock().now() - UDPPacketReader.this.readTimestamp() * 1000L;
            buf.append("Data packet sent ").append(msAgo).append("ms ago ");
            buf.append("IV ");
            buf.append(Base64.encode((byte[])UDPPacketReader.this._message, (int)(UDPPacketReader.this._payloadBeginOffset - 16), (int)16));
            buf.append(" ");
            int off = UDPPacketReader.this.readBodyOffset() + 1;
            if (this.readACKsIncluded()) {
                int numACKs = (int)DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)off, (int)1);
                ++off;
                buf.append("with ACKs for ");
                for (i = 0; i < numACKs; ++i) {
                    buf.append(DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)off, (int)4)).append(' ');
                    off += 4;
                }
            }
            if (this.readACKBitfieldsIncluded()) {
                int numBitfields = (int)DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)off, (int)1);
                ++off;
                buf.append("with partial ACKs for ");
                for (i = 0; i < numBitfields; ++i) {
                    PacketACKBitfield bf = new PacketACKBitfield(off);
                    buf.append(bf.getMessageId()).append(' ');
                    off += bf.getByteLength();
                }
            }
            if (this.readExtendedDataIncluded()) {
                int size = (int)DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)off, (int)1);
                ++off;
                buf.append("with extended size of ");
                buf.append(size);
                buf.append(' ');
                off += size;
            }
            int numFragments = (int)DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)off, (int)1);
            ++off;
            buf.append("with fragmentCount of ");
            buf.append(numFragments);
            buf.append(' ');
            for (i = 0; i < numFragments; ++i) {
                buf.append("containing messageId ");
                buf.append(DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)off, (int)4));
                int fragNum = (UDPPacketReader.this._message[off += 4] & 0xFF) >>> 1;
                boolean isLast = (UDPPacketReader.this._message[off] & 1) != 0;
                buf.append(" frag# ").append(fragNum);
                buf.append(" isLast? ").append(isLast);
                buf.append(" info ").append(UDPPacketReader.this._message[++off - 1]);
                int size = (int)DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)off, (int)2) & 0x3FFF;
                buf.append(" with ").append(size).append(" bytes");
                buf.append(' ');
                off += size;
                off += 2;
            }
            return buf.toString();
        }

        public void toRawString(StringBuilder buf) {
            UDPPacketReader.this.toRawString(buf);
            buf.append(" payload: ");
            int off = this.getFragmentBegin(0);
            off += 4;
            int size = (int)DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)(++off), (int)2) & 0x3FFF;
            buf.append(Base64.encode((byte[])UDPPacketReader.this._message, (int)(off += 2), (int)size));
        }
    }

    public class SessionConfirmedReader {
        public int readCurrentFragmentNum() {
            int readOffset = UDPPacketReader.this.readBodyOffset();
            return (UDPPacketReader.this._message[readOffset] & 0xFF) >>> 4;
        }

        public int readTotalFragmentNum() {
            int readOffset = UDPPacketReader.this.readBodyOffset();
            return UDPPacketReader.this._message[readOffset] & 0xF;
        }

        public int readCurrentFragmentSize() {
            int readOffset = UDPPacketReader.this.readBodyOffset() + 1;
            return (int)DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)readOffset, (int)2);
        }

        public void readFragmentData(byte[] target, int targetOffset) {
            int readOffset = UDPPacketReader.this.readBodyOffset() + 1 + 2;
            int len = this.readCurrentFragmentSize();
            System.arraycopy(UDPPacketReader.this._message, readOffset, target, targetOffset, len);
        }

        public long readFinalFragmentSignedOnTime() {
            if (this.readCurrentFragmentNum() != this.readTotalFragmentNum() - 1) {
                throw new IllegalStateException("This is not the final fragment");
            }
            int readOffset = UDPPacketReader.this.readBodyOffset() + 1 + 2 + this.readCurrentFragmentSize();
            return DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)readOffset, (int)4);
        }

        public void readFinalSignature(byte[] target, int targetOffset) {
            if (this.readCurrentFragmentNum() != this.readTotalFragmentNum() - 1) {
                throw new IllegalStateException("This is not the final fragment");
            }
            int readOffset = UDPPacketReader.this._payloadBeginOffset + UDPPacketReader.this._payloadLength - 40;
            System.arraycopy(UDPPacketReader.this._message, readOffset, target, targetOffset, 40);
        }
    }

    public class SessionCreatedReader {
        public static final int Y_LENGTH = 256;

        public void readY(byte[] target, int targetOffset) {
            int readOffset = UDPPacketReader.this.readBodyOffset();
            System.arraycopy(UDPPacketReader.this._message, readOffset, target, targetOffset, 256);
        }

        public int readIPSize() {
            int offset = UDPPacketReader.this.readBodyOffset() + 256;
            return (int)DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)offset, (int)1);
        }

        public void readIP(byte[] target, int targetOffset) {
            int offset = UDPPacketReader.this.readBodyOffset() + 256;
            int size = (int)DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)offset, (int)1);
            System.arraycopy(UDPPacketReader.this._message, ++offset, target, targetOffset, size);
        }

        public int readPort() {
            int offset = UDPPacketReader.this.readBodyOffset() + 256 + 1 + this.readIPSize();
            return (int)DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)offset, (int)2);
        }

        public long readRelayTag() {
            int offset = UDPPacketReader.this.readBodyOffset() + 256 + 1 + this.readIPSize() + 2;
            return DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)offset, (int)4);
        }

        public long readSignedOnTime() {
            int offset = UDPPacketReader.this.readBodyOffset() + 256 + 1 + this.readIPSize() + 2 + 4;
            long rv = DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)offset, (int)4);
            if (UDPPacketReader.this._log.shouldLog(10)) {
                UDPPacketReader.this._log.debug("Signed on time offset: " + offset + " val: " + rv + "\nRawCreated: " + Base64.encode((byte[])UDPPacketReader.this._message, (int)UDPPacketReader.this._payloadBeginOffset, (int)UDPPacketReader.this._payloadLength));
            }
            return rv;
        }

        public void readEncryptedSignature(byte[] target, int targetOffset) {
            int offset = UDPPacketReader.this.readBodyOffset() + 256 + 1 + this.readIPSize() + 2 + 4 + 4;
            System.arraycopy(UDPPacketReader.this._message, offset, target, targetOffset, 48);
        }

        public void readIV(byte[] target, int targetOffset) {
            int offset = UDPPacketReader.this._payloadBeginOffset - 16;
            System.arraycopy(UDPPacketReader.this._message, offset, target, targetOffset, 16);
        }
    }

    public class SessionRequestReader {
        public static final int X_LENGTH = 256;

        public void readX(byte[] target, int targetOffset) {
            int readOffset = UDPPacketReader.this.readBodyOffset();
            System.arraycopy(UDPPacketReader.this._message, readOffset, target, targetOffset, 256);
        }

        public int readIPSize() {
            int offset = UDPPacketReader.this.readBodyOffset() + 256;
            return (int)DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)offset, (int)1);
        }

        public void readIP(byte[] target, int targetOffset) {
            int offset = UDPPacketReader.this.readBodyOffset() + 256;
            int size = (int)DataHelper.fromLong((byte[])UDPPacketReader.this._message, (int)offset, (int)1);
            System.arraycopy(UDPPacketReader.this._message, ++offset, target, targetOffset, size);
        }
    }
}

