/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.util.ArrayList;
import java.util.List;
import net.i2p.data.RouterInfo;
import net.i2p.data.i2np.DataMessage;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.udp.PeerState;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

class UDPFlooder
implements Runnable {
    private RouterContext _context;
    private Log _log;
    private UDPTransport _transport;
    private final List _peers;
    private boolean _alive;
    private static final byte[] _floodData = new byte[4096];

    public UDPFlooder(RouterContext ctx, UDPTransport transport) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(UDPFlooder.class);
        this._transport = transport;
        this._peers = new ArrayList(4);
        ctx.random().nextBytes(_floodData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPeer(PeerState peer) {
        List list = this._peers;
        synchronized (list) {
            if (!this._peers.contains(peer)) {
                this._peers.add(peer);
            }
            this._peers.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePeer(PeerState peer) {
        List list = this._peers;
        synchronized (list) {
            while (this._peers.remove(peer)) {
            }
            this._peers.notifyAll();
        }
    }

    public void startup() {
        this._alive = true;
        I2PThread t = new I2PThread((Runnable)this, "flooder");
        t.setDaemon(true);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this._alive = false;
        List list = this._peers;
        synchronized (list) {
            this._peers.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        long nextSend = this._context.clock().now();
        while (this._alive) {
            long fd;
            long delay;
            try {
                List list = this._peers;
                synchronized (list) {
                    if (this._peers.size() <= 0) {
                        this._peers.wait();
                    }
                }
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            long now = this._context.clock().now();
            if (now >= nextSend) {
                for (int i = 0; i < this._peers.size(); ++i) {
                    PeerState peer = (PeerState)this._peers.get(i);
                    DataMessage m = new DataMessage(this._context);
                    byte[] data = _floodData;
                    m.setData(data);
                    m.setMessageExpiration(this._context.clock().now() + 10000L);
                    m.setUniqueId(this._context.random().nextLong(0xFFFFFFFFL));
                    OutNetMessage msg = new OutNetMessage(this._context);
                    msg.setMessage(m);
                    msg.setExpiration(m.getMessageExpiration());
                    msg.setPriority(500);
                    RouterInfo to = this._context.netDb().lookupRouterInfoLocally(peer.getRemotePeer());
                    if (to == null) continue;
                    msg.setTarget(to);
                    this._transport.send(msg);
                }
                nextSend = now + this.calcFloodDelay();
            }
            if ((delay = nextSend - now) <= 0L) continue;
            if (delay > 10000L && delay > (fd = this.calcFloodDelay())) {
                nextSend = now + fd;
                delay = fd;
            }
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException ie) {}
        }
    }

    private long calcFloodDelay() {
        try {
            return Long.parseLong(this._context.getProperty("udp.floodDelay", "300000"));
        }
        catch (Exception e) {
            return 300000L;
        }
    }
}

