/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import net.i2p.data.Base64;
import net.i2p.data.DataHelper;

final class RemoteHostId {
    private byte[] _ip;
    private int _port;
    private byte[] _peerHash;

    public RemoteHostId(byte[] ip, int port) {
        this._ip = ip;
        this._port = port;
    }

    public RemoteHostId(byte[] peerHash) {
        this._peerHash = peerHash;
    }

    public byte[] getIP() {
        return this._ip;
    }

    public int getPort() {
        return this._port;
    }

    public byte[] getPeerHash() {
        return this._peerHash;
    }

    public int hashCode() {
        int i;
        int rv = 0;
        for (i = 0; this._ip != null && i < this._ip.length; ++i) {
            rv += this._ip[i] << i;
        }
        for (i = 0; this._peerHash != null && i < this._peerHash.length; ++i) {
            rv += this._peerHash[i] << i;
        }
        return rv += this._port;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            throw new NullPointerException("obj is null");
        }
        if (!(obj instanceof RemoteHostId)) {
            throw new ClassCastException("obj is a " + obj.getClass().getName());
        }
        RemoteHostId id = (RemoteHostId)obj;
        return this._port == id.getPort() && DataHelper.eq((byte[])this._ip, (byte[])id.getIP()) && DataHelper.eq((byte[])this._peerHash, (byte[])id.getPeerHash());
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includePort) {
        if (this._ip != null) {
            if (includePort) {
                return RemoteHostId.toString(this._ip) + ':' + this._port;
            }
            return RemoteHostId.toString(this._ip);
        }
        return Base64.encode((byte[])this._peerHash);
    }

    public static String toString(byte[] ip) {
        StringBuilder buf = new StringBuilder(ip.length + 5);
        for (int i = 0; i < ip.length; ++i) {
            buf.append(ip[i] & 0xFF);
            if (i + 1 >= ip.length) continue;
            buf.append('.');
        }
        return buf.toString();
    }

    public String toHostString() {
        return this.toString(false);
    }
}

