/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.net.InetAddress;
import net.i2p.data.SessionKey;

class PeerTestState {
    private long _testNonce;
    private short _ourRole;
    private InetAddress _aliceIP;
    private int _alicePort;
    private InetAddress _bobIP;
    private int _bobPort;
    private InetAddress _charlieIP;
    private int _charliePort;
    private InetAddress _aliceIPFromCharlie;
    private int _alicePortFromCharlie;
    private SessionKey _aliceIntroKey;
    private SessionKey _charlieIntroKey;
    private SessionKey _bobCipherKey;
    private SessionKey _bobMACKey;
    private long _beginTime;
    private long _lastSendTime;
    private long _receiveAliceTime;
    private long _receiveBobTime;
    private long _receiveCharlieTime;
    private int _packetsRelayed;
    public static final short ALICE = 1;
    public static final short BOB = 2;
    public static final short CHARLIE = 3;

    PeerTestState() {
    }

    public synchronized long getNonce() {
        return this._testNonce;
    }

    public synchronized void setNonce(long nonce) {
        this._testNonce = nonce;
    }

    public synchronized short getOurRole() {
        return this._ourRole;
    }

    public synchronized void setOurRole(short role) {
        this._ourRole = role;
    }

    public synchronized InetAddress getAliceIP() {
        return this._aliceIP;
    }

    public synchronized void setAliceIP(InetAddress ip) {
        this._aliceIP = ip;
    }

    public synchronized InetAddress getBobIP() {
        return this._bobIP;
    }

    public synchronized void setBobIP(InetAddress ip) {
        this._bobIP = ip;
    }

    public synchronized InetAddress getCharlieIP() {
        return this._charlieIP;
    }

    public synchronized void setCharlieIP(InetAddress ip) {
        this._charlieIP = ip;
    }

    public synchronized InetAddress getAliceIPFromCharlie() {
        return this._aliceIPFromCharlie;
    }

    public synchronized void setAliceIPFromCharlie(InetAddress ip) {
        this._aliceIPFromCharlie = ip;
    }

    public synchronized int getAlicePort() {
        return this._alicePort;
    }

    public synchronized void setAlicePort(int alicePort) {
        this._alicePort = alicePort;
    }

    public synchronized int getBobPort() {
        return this._bobPort;
    }

    public synchronized void setBobPort(int bobPort) {
        this._bobPort = bobPort;
    }

    public synchronized int getCharliePort() {
        return this._charliePort;
    }

    public synchronized void setCharliePort(int charliePort) {
        this._charliePort = charliePort;
    }

    public synchronized int getAlicePortFromCharlie() {
        return this._alicePortFromCharlie;
    }

    public synchronized void setAlicePortFromCharlie(int alicePortFromCharlie) {
        this._alicePortFromCharlie = alicePortFromCharlie;
    }

    public synchronized SessionKey getAliceIntroKey() {
        return this._aliceIntroKey;
    }

    public synchronized void setAliceIntroKey(SessionKey key) {
        this._aliceIntroKey = key;
    }

    public synchronized SessionKey getCharlieIntroKey() {
        return this._charlieIntroKey;
    }

    public synchronized void setCharlieIntroKey(SessionKey key) {
        this._charlieIntroKey = key;
    }

    public synchronized SessionKey getBobCipherKey() {
        return this._bobCipherKey;
    }

    public synchronized void setBobCipherKey(SessionKey key) {
        this._bobCipherKey = key;
    }

    public synchronized SessionKey getBobMACKey() {
        return this._bobMACKey;
    }

    public synchronized void setBobMACKey(SessionKey key) {
        this._bobMACKey = key;
    }

    public synchronized long getBeginTime() {
        return this._beginTime;
    }

    public synchronized void setBeginTime(long when) {
        this._beginTime = when;
    }

    public synchronized long getLastSendTime() {
        return this._lastSendTime;
    }

    public synchronized void setLastSendTime(long when) {
        this._lastSendTime = when;
    }

    public synchronized long getReceiveAliceTime() {
        return this._receiveAliceTime;
    }

    public synchronized void setReceiveAliceTime(long when) {
        this._receiveAliceTime = when;
    }

    public synchronized long getReceiveBobTime() {
        return this._receiveBobTime;
    }

    public synchronized void setReceiveBobTime(long when) {
        this._receiveBobTime = when;
    }

    public synchronized long getReceiveCharlieTime() {
        return this._receiveCharlieTime;
    }

    public synchronized void setReceiveCharlieTime(long when) {
        this._receiveCharlieTime = when;
    }

    public int getPacketsRelayed() {
        return this._packetsRelayed;
    }

    public void incrementPacketsRelayed() {
        ++this._packetsRelayed;
    }

    public synchronized String toString() {
        StringBuilder buf = new StringBuilder(512);
        buf.append("Role: ");
        if (this._ourRole == 1) {
            buf.append("Alice");
        } else if (this._ourRole == 2) {
            buf.append("Bob");
        } else if (this._ourRole == 3) {
            buf.append("Charlie");
        } else {
            buf.append("unkown!");
        }
        if (this._aliceIP != null) {
            buf.append(" alice: ").append(this._aliceIP).append(':').append(this._alicePort);
        }
        if (this._aliceIPFromCharlie != null) {
            buf.append(" (fromCharlie ").append(this._aliceIPFromCharlie).append(':').append(this._alicePortFromCharlie).append(')');
        }
        if (this._bobIP != null) {
            buf.append(" bob: ").append(this._bobIP).append(':').append(this._bobPort);
        }
        if (this._charlieIP != null) {
            buf.append(" charlie: ").append(this._charlieIP).append(':').append(this._charliePort);
        }
        buf.append(" last send after ").append(this._lastSendTime - this._beginTime).append("ms");
        if (this._receiveAliceTime > 0L) {
            buf.append(" receive from alice after ").append(this._receiveAliceTime - this._beginTime).append("ms");
        }
        if (this._receiveBobTime > 0L) {
            buf.append(" receive from bob after ").append(this._receiveBobTime - this._beginTime).append("ms");
        }
        if (this._receiveCharlieTime > 0L) {
            buf.append(" receive from charlie after ").append(this._receiveCharlieTime - this._beginTime).append("ms");
        }
        buf.append(" packets relayed: ").append(this._packetsRelayed);
        return buf.toString();
    }
}

