/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.i2p.data.Base64;
import net.i2p.data.RouterAddress;
import net.i2p.data.RouterInfo;
import net.i2p.data.SessionKey;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.udp.PacketBuilder;
import net.i2p.router.transport.udp.PeerState;
import net.i2p.router.transport.udp.RemoteHostId;
import net.i2p.router.transport.udp.UDPAddress;
import net.i2p.router.transport.udp.UDPPacketReader;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.util.Log;

public class IntroductionManager {
    private RouterContext _context;
    private Log _log;
    private UDPTransport _transport;
    private PacketBuilder _builder;
    private Map _outbound;
    private final List _inbound;

    public IntroductionManager(RouterContext ctx, UDPTransport transport) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(IntroductionManager.class);
        this._transport = transport;
        this._builder = new PacketBuilder(ctx, transport);
        this._outbound = Collections.synchronizedMap(new HashMap(128));
        this._inbound = new ArrayList(128);
        ctx.statManager().createRateStat("udp.receiveRelayIntro", "How often we get a relayed request for us to talk to someone?", "udp", UDPTransport.RATES);
        ctx.statManager().createRateStat("udp.receiveRelayRequest", "How often we receive a good request to relay to someone else?", "udp", UDPTransport.RATES);
        ctx.statManager().createRateStat("udp.receiveRelayRequestBadTag", "Received relay requests with bad/expired tag", "udp", UDPTransport.RATES);
    }

    public void reset() {
        this._inbound.clear();
        this._outbound.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(PeerState peer) {
        if (peer == null) {
            return;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Adding peer " + peer.getRemoteHostId() + ", weRelayToThemAs " + peer.getWeRelayToThemAs() + ", theyRelayToUsAs " + peer.getTheyRelayToUsAs());
        }
        if (peer.getWeRelayToThemAs() > 0L) {
            this._outbound.put(new Long(peer.getWeRelayToThemAs()), peer);
        }
        if (peer.getTheyRelayToUsAs() > 0L) {
            List list = this._inbound;
            synchronized (list) {
                if (!this._inbound.contains(peer)) {
                    this._inbound.add(peer);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(PeerState peer) {
        if (peer == null) {
            return;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("removing peer " + peer.getRemoteHostId() + ", weRelayToThemAs " + peer.getWeRelayToThemAs() + ", theyRelayToUsAs " + peer.getTheyRelayToUsAs());
        }
        if (peer.getWeRelayToThemAs() > 0L) {
            this._outbound.remove(new Long(peer.getWeRelayToThemAs()));
        }
        if (peer.getTheyRelayToUsAs() > 0L) {
            List list = this._inbound;
            synchronized (list) {
                this._inbound.remove(peer);
            }
        }
    }

    public PeerState get(long id) {
        return (PeerState)this._outbound.get(new Long(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int pickInbound(Properties ssuOptions, int howMany) {
        ArrayList peers = null;
        int start = this._context.random().nextInt(Integer.MAX_VALUE);
        List list = this._inbound;
        synchronized (list) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Picking inbound out of " + this._inbound.size());
            }
            if (this._inbound.size() <= 0) {
                return 0;
            }
            peers = new ArrayList(this._inbound);
        }
        int sz = peers.size();
        start %= sz;
        int found = 0;
        long inactivityCutoff = this._context.clock().now() - 900000L;
        for (int i = 0; i < sz && found < howMany; ++i) {
            PeerState cur = (PeerState)peers.get((start + i) % sz);
            RouterInfo ri = this._context.netDb().lookupRouterInfoLocally(cur.getRemotePeer());
            if (ri == null) {
                if (!this._log.shouldLog(20)) continue;
                this._log.info("Picked peer has no local routerInfo: " + cur);
                continue;
            }
            RouterAddress ra = ri.getTargetAddress("SSU");
            if (ra == null) {
                if (!this._log.shouldLog(20)) continue;
                this._log.info("Picked peer has no SSU address: " + ri);
                continue;
            }
            if (this._context.profileOrganizer().isFailing(cur.getRemotePeer()) || this._context.shitlist().isShitlisted(cur.getRemotePeer()) || this._transport.wasUnreachable(cur.getRemotePeer())) {
                if (!this._log.shouldLog(20)) continue;
                this._log.info("Peer is failing, shistlisted or was unreachable: " + cur);
                continue;
            }
            if (cur.getLastReceiveTime() < inactivityCutoff || cur.getLastSendTime() < inactivityCutoff) {
                if (!this._log.shouldLog(20)) continue;
                this._log.info("Peer is idle too long: " + cur);
                continue;
            }
            if (this._log.shouldLog(20)) {
                this._log.info("Picking introducer: " + cur);
            }
            cur.setIntroducerTime();
            UDPAddress ura = new UDPAddress(ra);
            ssuOptions.setProperty("ihost" + found, cur.getRemoteHostId().toHostString());
            ssuOptions.setProperty("iport" + found, String.valueOf(cur.getRemotePort()));
            ssuOptions.setProperty("ikey" + found, Base64.encode((byte[])ura.getIntroKey()));
            ssuOptions.setProperty("itag" + found, String.valueOf(cur.getTheyRelayToUsAs()));
            ++found;
        }
        long pingCutoff = this._context.clock().now() - 0x6DDD00L;
        inactivityCutoff = this._context.clock().now() - 450000L;
        for (int i = 0; i < sz; ++i) {
            PeerState cur = (PeerState)peers.get(i);
            if (cur.getIntroducerTime() <= pingCutoff || cur.getLastSendTime() >= inactivityCutoff) continue;
            if (this._log.shouldLog(20)) {
                this._log.info("Pinging introducer: " + cur);
            }
            cur.setLastSendTime(this._context.clock().now());
            this._transport.send(this._builder.buildPing(cur));
        }
        return found;
    }

    public void receiveRelayIntro(RemoteHostId bob, UDPPacketReader reader) {
        if (this._context.router().isHidden()) {
            return;
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Receive relay intro from " + bob);
        }
        this._context.statManager().addRateData("udp.receiveRelayIntro", 1L, 0L);
        this._transport.send(this._builder.buildHolePunch(reader));
    }

    public void receiveRelayRequest(RemoteHostId alice, UDPPacketReader reader) {
        if (this._context.router().isHidden()) {
            return;
        }
        long tag = reader.getRelayRequestReader().readTag();
        PeerState charlie = this._transport.getPeerState(tag);
        if (this._log.shouldLog(20)) {
            this._log.info("Receive relay request from " + alice + " for tag " + tag + " and relaying with " + charlie);
        }
        if (charlie == null) {
            this._context.statManager().addRateData("udp.receiveRelayRequestBadTag", 1L, 0L);
            return;
        }
        this._context.statManager().addRateData("udp.receiveRelayRequest", 1L, 0L);
        byte[] key = new byte[32];
        reader.getRelayRequestReader().readAliceIntroKey(key, 0);
        SessionKey aliceIntroKey = new SessionKey(key);
        this._transport.send(this._builder.buildRelayIntro(alice, charlie, reader.getRelayRequestReader()));
        this._transport.send(this._builder.buildRelayResponse(alice, charlie, reader.getRelayRequestReader().readNonce(), aliceIntroKey));
    }
}

