/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.i2p.crypto.DHSessionKeyBuilder;
import net.i2p.data.Base64;
import net.i2p.data.Hash;
import net.i2p.data.RouterAddress;
import net.i2p.data.RouterIdentity;
import net.i2p.data.SessionKey;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.DeliveryStatusMessage;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.udp.InboundEstablishState;
import net.i2p.router.transport.udp.OutboundEstablishState;
import net.i2p.router.transport.udp.PacketBuilder;
import net.i2p.router.transport.udp.PeerState;
import net.i2p.router.transport.udp.RemoteHostId;
import net.i2p.router.transport.udp.UDPAddress;
import net.i2p.router.transport.udp.UDPPacket;
import net.i2p.router.transport.udp.UDPPacketReader;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;
import net.i2p.util.SimpleScheduler;
import net.i2p.util.SimpleTimer;

public class EstablishmentManager {
    private RouterContext _context;
    private Log _log;
    private UDPTransport _transport;
    private PacketBuilder _builder;
    private final Map _inboundStates;
    private final Map _outboundStates;
    private final Map _queuedOutbound;
    private final Map _liveIntroductions;
    private boolean _alive;
    private final Object _activityLock;
    private int _activity;
    private static final int DEFAULT_MAX_CONCURRENT_ESTABLISH = 10;
    public static final String PROP_MAX_CONCURRENT_ESTABLISH = "i2np.udp.maxConcurrentEstablish";
    private static final int MAX_QUEUED_OUTBOUND = 10000;
    private static final int MAX_QUEUED_PER_PEER = 3;
    private static final int MAX_ESTABLISH_TIME = 30000;
    public static final long MAX_TAG_VALUE = 0xFFFFFFFFL;
    private static final long MAX_NONCE = 0xFFFFFFFFL;
    private static final int INTRO_ATTEMPT_TIMEOUT = 3000;

    public EstablishmentManager(RouterContext ctx, UDPTransport transport) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(EstablishmentManager.class);
        this._transport = transport;
        this._builder = new PacketBuilder(ctx, transport);
        this._inboundStates = new HashMap(32);
        this._outboundStates = new HashMap(32);
        this._queuedOutbound = new HashMap(32);
        this._liveIntroductions = new HashMap(32);
        this._activityLock = new Object();
        this._context.statManager().createRateStat("udp.inboundEstablishTime", "How long it takes for a new inbound session to be established", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.outboundEstablishTime", "How long it takes for a new outbound session to be established", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.inboundEstablishFailedState", "What state a failed inbound establishment request fails in", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.outboundEstablishFailedState", "What state a failed outbound establishment request fails in", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendIntroRelayRequest", "How often we send a relay request to reach a peer", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendIntroRelayTimeout", "How often a relay request times out before getting a response (due to the target or intro peer being offline)", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.receiveIntroRelayResponse", "How long it took to receive a relay response", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.establishRejected", "How many pending outbound connections are there when we refuse to add any more?", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.establishOverflow", "How many messages were queued up on a pending connection when it was too much?", "udp", UDPTransport.RATES);
    }

    public void startup() {
        this._alive = true;
        I2PThread t = new I2PThread((Runnable)new Establisher(), "UDP Establisher");
        t.setDaemon(true);
        t.start();
    }

    public void shutdown() {
        this._alive = false;
        this.notifyActivity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InboundEstablishState getInboundState(RemoteHostId from) {
        Map map = this._inboundStates;
        synchronized (map) {
            InboundEstablishState state = (InboundEstablishState)this._inboundStates.get(from);
            return state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OutboundEstablishState getOutboundState(RemoteHostId from) {
        Map map = this._outboundStates;
        synchronized (map) {
            OutboundEstablishState state = (OutboundEstablishState)this._outboundStates.get(from);
            return state;
        }
    }

    private int getMaxConcurrentEstablish() {
        String val = this._context.getProperty(PROP_MAX_CONCURRENT_ESTABLISH);
        if (val != null) {
            try {
                return Integer.parseInt(val);
            }
            catch (NumberFormatException nfe) {
                return 10;
            }
        }
        return 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void establish(OutNetMessage msg) {
        RouterAddress ra = msg.getTarget().getTargetAddress(this._transport.getStyle());
        if (ra == null) {
            this._transport.failed(msg, "Remote peer has no address, cannot establish");
            return;
        }
        if (msg.getTarget().getNetworkId() != 2) {
            this._context.shitlist().shitlistRouter(msg.getTarget().getIdentity().calculateHash());
            this._transport.markUnreachable(msg.getTarget().getIdentity().calculateHash());
            this._transport.failed(msg, "Remote peer is on the wrong network, cannot establish");
            return;
        }
        UDPAddress addr = new UDPAddress(ra);
        RemoteHostId to = null;
        InetAddress remAddr = addr.getHostAddress();
        int port = addr.getPort();
        if (remAddr != null && port > 0) {
            to = new RemoteHostId(remAddr.getAddress(), port);
            if (!this._transport.isValid(to.getIP())) {
                this._transport.failed(msg, "Remote peer's IP isn't valid");
                this._transport.markUnreachable(msg.getTarget().getIdentity().calculateHash());
                return;
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("Add outbound establish state to: " + to);
            }
        } else {
            if (this._log.shouldLog(10)) {
                this._log.debug("Add indirect outbound establish state to: " + addr);
            }
            to = new RemoteHostId(msg.getTarget().getIdentity().calculateHash().getData());
        }
        OutboundEstablishState state = null;
        int deferred = 0;
        boolean rejected = false;
        int queueCount = 0;
        Map map = this._outboundStates;
        synchronized (map) {
            List<OutNetMessage> queued;
            state = (OutboundEstablishState)this._outboundStates.get(to);
            if (state == null) {
                if (this._outboundStates.size() >= this.getMaxConcurrentEstablish()) {
                    queued = (List)this._queuedOutbound.get(to);
                    if (queued == null) {
                        queued = new ArrayList<OutNetMessage>(1);
                        if (this._queuedOutbound.size() > 10000) {
                            rejected = true;
                        } else {
                            this._queuedOutbound.put(to, queued);
                        }
                    }
                    if ((queueCount = queued.size()) < 3 && !rejected) {
                        queued.add(msg);
                    }
                    deferred = this._queuedOutbound.size();
                } else {
                    state = new OutboundEstablishState(this._context, remAddr, port, msg.getTarget().getIdentity(), new SessionKey(addr.getIntroKey()), addr);
                    this._outboundStates.put(to, state);
                    SimpleScheduler.getInstance().addEvent((SimpleTimer.TimedEvent)new Expire(to, state), 10000L);
                }
            }
            if (state != null) {
                state.addMessage(msg);
                queued = (ArrayList<OutNetMessage>)this._queuedOutbound.remove(to);
                if (queued != null) {
                    for (int i = 0; i < queued.size(); ++i) {
                        state.addMessage((OutNetMessage)queued.get(i));
                    }
                }
            }
        }
        if (rejected) {
            this._transport.failed(msg, "Too many pending outbound connections");
            this._context.statManager().addRateData("udp.establishRejected", (long)deferred, 0L);
            return;
        }
        if (queueCount >= 3) {
            this._transport.failed(msg, "Too many pending messages for the given peer");
            this._context.statManager().addRateData("udp.establishOverflow", (long)queueCount, (long)deferred);
            return;
        }
        if (deferred > 0) {
            msg.timestamp("too many deferred establishers: " + deferred);
        } else if (state != null) {
            msg.timestamp("establish state already waiting " + state.getLifetime());
        }
        this.notifyActivity();
    }

    private int getMaxInboundEstablishers() {
        return this.getMaxConcurrentEstablish() / 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receiveSessionRequest(RemoteHostId from, UDPPacketReader reader) {
        if (!this._transport.isValid(from.getIP())) {
            return;
        }
        int maxInbound = this.getMaxInboundEstablishers();
        boolean isNew = false;
        InboundEstablishState state = null;
        Map map = this._inboundStates;
        synchronized (map) {
            if (this._inboundStates.size() >= maxInbound) {
                return;
            }
            state = (InboundEstablishState)this._inboundStates.get(from);
            if (state == null) {
                if (this._context.blocklist().isBlocklisted(from.getIP())) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Receive session request from blocklisted IP: " + from);
                    }
                    return;
                }
                if (!this._transport.allowConnection()) {
                    return;
                }
                state = new InboundEstablishState(this._context, from.getIP(), from.getPort(), this._transport.getLocalPort());
                state.receiveSessionRequest(reader.getSessionRequestReader());
                isNew = true;
                this._inboundStates.put(from, state);
            }
        }
        if (isNew) {
            if (!this._context.router().isHidden() && !this._transport.introducersRequired() && this._transport.haveCapacity()) {
                long tag = this._context.random().nextLong(0xFFFFFFFFL);
                state.setSentRelayTag(tag);
                if (this._log.shouldLog(20)) {
                    this._log.info("Received session request from " + from + ", sending relay tag " + tag);
                }
            } else if (this._log.shouldLog(20)) {
                this._log.info("Received session request, but our status is " + this._transport.getReachabilityStatus());
            }
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Receive session request from: " + state.getRemoteHostId().toString());
        }
        this.notifyActivity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receiveSessionConfirmed(RemoteHostId from, UDPPacketReader reader) {
        InboundEstablishState state = null;
        Map map = this._inboundStates;
        synchronized (map) {
            state = (InboundEstablishState)this._inboundStates.get(from);
        }
        if (state != null) {
            state.receiveSessionConfirmed(reader.getSessionConfirmedReader());
            this.notifyActivity();
            if (this._log.shouldLog(10)) {
                this._log.debug("Receive session confirmed from: " + state.getRemoteHostId().toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receiveSessionCreated(RemoteHostId from, UDPPacketReader reader) {
        OutboundEstablishState state = null;
        Map map = this._outboundStates;
        synchronized (map) {
            state = (OutboundEstablishState)this._outboundStates.get(from);
        }
        if (state != null) {
            state.receiveSessionCreated(reader.getSessionCreatedReader());
            this.notifyActivity();
            if (this._log.shouldLog(10)) {
                this._log.debug("Receive session created from: " + state.getRemoteHostId().toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PeerState receiveData(OutboundEstablishState state) {
        state.dataReceived();
        Map map = this._outboundStates;
        synchronized (map) {
            List queued;
            this._outboundStates.remove(state.getRemoteHostId());
            if (this._queuedOutbound.size() > 0 && (queued = (List)this._queuedOutbound.remove(state.getRemoteHostId())) != null) {
                for (int i = 0; i < queued.size(); ++i) {
                    state.addMessage((OutNetMessage)queued.get(i));
                }
            }
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Outbound established completely!  yay: " + state);
        }
        PeerState peer = this.handleCompletelyEstablished(state);
        this.notifyActivity();
        return peer;
    }

    private int locked_admitQueued() {
        int admitted = 0;
        while (this._queuedOutbound.size() > 0 && this._outboundStates.size() < this.getMaxConcurrentEstablish()) {
            RemoteHostId to = (RemoteHostId)this._queuedOutbound.keySet().iterator().next();
            List queued = (List)this._queuedOutbound.remove(to);
            if (queued.size() <= 0) continue;
            OutNetMessage msg = (OutNetMessage)queued.get(0);
            RouterAddress ra = msg.getTarget().getTargetAddress(this._transport.getStyle());
            if (ra == null) {
                for (int i = 0; i < queued.size(); ++i) {
                    this._transport.failed((OutNetMessage)queued.get(i), "Cannot admit to the queue, as it has no address");
                }
                continue;
            }
            UDPAddress addr = new UDPAddress(ra);
            InetAddress remAddr = addr.getHostAddress();
            int port = addr.getPort();
            OutboundEstablishState qstate = new OutboundEstablishState(this._context, remAddr, port, msg.getTarget().getIdentity(), new SessionKey(addr.getIntroKey()), addr);
            this._outboundStates.put(to, qstate);
            SimpleScheduler.getInstance().addEvent((SimpleTimer.TimedEvent)new Expire(to, qstate), 10000L);
            for (int i = 0; i < queued.size(); ++i) {
                OutNetMessage m = (OutNetMessage)queued.get(i);
                m.timestamp("no longer deferred... establishing");
                qstate.addMessage(m);
            }
            ++admitted;
        }
        return admitted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyActivity() {
        Object object = this._activityLock;
        synchronized (object) {
            ++this._activity;
            this._activityLock.notifyAll();
        }
    }

    private void handleCompletelyEstablished(InboundEstablishState state) {
        if (state.complete()) {
            return;
        }
        long now = this._context.clock().now();
        RouterIdentity remote = state.getConfirmedIdentity();
        PeerState peer = new PeerState(this._context, this._transport);
        peer.setCurrentCipherKey(state.getCipherKey());
        peer.setCurrentMACKey(state.getMACKey());
        peer.setCurrentReceiveSecond(now - now % 1000L);
        peer.setKeyEstablishedTime(now);
        peer.setLastReceiveTime(now);
        peer.setLastSendTime(now);
        peer.setRemoteAddress(state.getSentIP(), state.getSentPort());
        peer.setRemotePeer(remote.calculateHash());
        peer.setWeRelayToThemAs(state.getSentRelayTag());
        peer.setTheyRelayToUsAs(0L);
        peer.setInbound();
        if (this._log.shouldLog(10)) {
            this._log.debug("Handle completely established (inbound): " + state.getRemoteHostId().toString() + " - " + peer.getRemotePeer().toBase64());
        }
        this._transport.addRemotePeerState(peer);
        this._transport.inboundConnectionReceived();
        this._transport.setIP(remote.calculateHash(), state.getSentIP());
        this._context.statManager().addRateData("udp.inboundEstablishTime", state.getLifetime(), 0L);
        this.sendInboundComplete(peer);
    }

    private void sendInboundComplete(PeerState peer) {
        if (this._log.shouldLog(20)) {
            this._log.info("Completing to the peer after confirm: " + peer);
        }
        DeliveryStatusMessage dsm = new DeliveryStatusMessage(this._context);
        dsm.setArrival(2L);
        dsm.setMessageExpiration(this._context.clock().now() + 10000L);
        dsm.setMessageId(this._context.random().nextLong(0xFFFFFFFFL));
        this._transport.send(dsm, peer);
        SimpleScheduler.getInstance().addEvent((SimpleTimer.TimedEvent)new PublishToNewInbound(peer), 0L);
    }

    private PeerState handleCompletelyEstablished(OutboundEstablishState state) {
        OutNetMessage msg;
        RouterIdentity rem;
        if (state.complete() && (rem = state.getRemoteIdentity()) != null) {
            return this._transport.getPeerState(rem.getHash());
        }
        long now = this._context.clock().now();
        RouterIdentity remote = state.getRemoteIdentity();
        PeerState peer = new PeerState(this._context, this._transport);
        peer.setCurrentCipherKey(state.getCipherKey());
        peer.setCurrentMACKey(state.getMACKey());
        peer.setCurrentReceiveSecond(now - now % 1000L);
        peer.setKeyEstablishedTime(now);
        peer.setLastReceiveTime(now);
        peer.setLastSendTime(now);
        peer.setRemoteAddress(state.getSentIP(), state.getSentPort());
        peer.setRemotePeer(remote.calculateHash());
        peer.setTheyRelayToUsAs(state.getReceivedRelayTag());
        peer.setWeRelayToThemAs(0L);
        if (this._log.shouldLog(10)) {
            this._log.debug("Handle completely established (outbound): " + state.getRemoteHostId().toString() + " - " + peer.getRemotePeer().toBase64());
        }
        this._transport.addRemotePeerState(peer);
        this._transport.setIP(remote.calculateHash(), state.getSentIP());
        this._context.statManager().addRateData("udp.outboundEstablishTime", state.getLifetime(), 0L);
        this.sendOurInfo(peer, false);
        int i = 0;
        while ((msg = state.getNextQueuedMessage()) != null) {
            if (now - 60000L > msg.getExpiration()) {
                msg.timestamp("took too long but established...");
                this._transport.failed(msg, "Took too long to establish, but it was established");
            } else {
                msg.timestamp("session fully established and sent " + i);
                this._transport.send(msg);
            }
            ++i;
        }
        return peer;
    }

    private void sendOurInfo(PeerState peer, boolean isInbound) {
        if (this._log.shouldLog(20)) {
            this._log.info("Publishing to the peer after confirm: " + (isInbound ? " inbound con from " + peer : "outbound con to " + peer));
        }
        DatabaseStoreMessage m = new DatabaseStoreMessage(this._context);
        m.setKey(this._context.routerHash());
        m.setRouterInfo(this._context.router().getRouterInfo());
        m.setMessageExpiration(this._context.clock().now() + 10000L);
        this._transport.send(m, peer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCreated(InboundEstablishState state) {
        long now = this._context.clock().now();
        if (!this._transport.introducersRequired() && this._transport.haveCapacity()) {
            if (state.getSentRelayTag() < 0L) {
                state.setSentRelayTag(this._context.random().nextLong(0xFFFFFFFFL));
            }
        } else {
            state.setSentRelayTag(0L);
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Send created to: " + state.getRemoteHostId().toString());
        }
        try {
            state.generateSessionKey();
        }
        catch (DHSessionKeyBuilder.InvalidPublicParameterException ippe) {
            if (this._log.shouldLog(40)) {
                this._log.error("Peer " + state.getRemoteHostId() + " sent us an invalid DH parameter (or were spoofed)", (Throwable)ippe);
            }
            Map map = this._inboundStates;
            synchronized (map) {
                this._inboundStates.remove(state.getRemoteHostId());
            }
            return;
        }
        this._transport.send(this._builder.buildSessionCreatedPacket(state, this._transport.getExternalPort(), this._transport.getIntroKey()));
        state.setNextSendTime(now + 1000L);
    }

    private void sendRequest(OutboundEstablishState state) {
        UDPPacket packet;
        if (this._log.shouldLog(10)) {
            this._log.debug("Send request to: " + state.getRemoteHostId().toString());
        }
        if ((packet = this._builder.buildSessionRequestPacket(state)) != null) {
            this._transport.send(packet);
        } else if (this._log.shouldLog(30)) {
            this._log.warn("Unable to build a session request packet for " + state.getRemoteHostId());
        }
        state.requestSent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePendingIntro(OutboundEstablishState state) {
        long nonce = this._context.random().nextLong(0xFFFFFFFFL);
        while (true) {
            Map map = this._liveIntroductions;
            synchronized (map) {
                OutboundEstablishState old = this._liveIntroductions.put(new Long(nonce), state);
                if (old == null) {
                    break;
                }
                nonce = this._context.random().nextLong(0xFFFFFFFFL);
            }
        }
        SimpleScheduler.getInstance().addEvent((SimpleTimer.TimedEvent)new FailIntroduction(state, nonce), 3000L);
        state.setIntroNonce(nonce);
        this._context.statManager().addRateData("udp.sendIntroRelayRequest", 1L, 0L);
        UDPPacket[] requests = this._builder.buildRelayRequest(this._transport, state, this._transport.getIntroKey());
        for (int i = 0; i < requests.length; ++i) {
            if (requests[i] == null) continue;
            this._transport.send(requests[i]);
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Send intro for " + state.getRemoteHostId().toString() + " with our intro key as " + this._transport.getIntroKey().toBase64());
        }
        state.introSent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveRelayResponse(RemoteHostId bob, UDPPacketReader reader) {
        long nonce = reader.getRelayResponseReader().readNonce();
        OutboundEstablishState state = null;
        Map map = this._liveIntroductions;
        synchronized (map) {
            state = (OutboundEstablishState)this._liveIntroductions.remove(new Long(nonce));
        }
        if (state == null) {
            return;
        }
        int sz = reader.getRelayResponseReader().readCharlieIPSize();
        byte[] ip = new byte[sz];
        reader.getRelayResponseReader().readCharlieIP(ip, 0);
        InetAddress addr = null;
        try {
            addr = InetAddress.getByAddress(ip);
        }
        catch (UnknownHostException uhe) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Introducer for " + state + " (" + bob + ") sent us an invalid IP for our targer: " + Base64.encode((byte[])ip), (Throwable)uhe);
            }
            state.introductionFailed();
            this.notifyActivity();
            return;
        }
        this._context.statManager().addRateData("udp.receiveIntroRelayResponse", state.getLifetime(), 0L);
        int port = reader.getRelayResponseReader().readCharliePort();
        if (this._log.shouldLog(20)) {
            this._log.info("Received relay intro for " + state.getRemoteIdentity().calculateHash().toBase64() + " - they are on " + addr.toString() + ":" + port + " (according to " + bob.toString(true) + ")");
        }
        RemoteHostId oldId = state.getRemoteHostId();
        state.introduced(addr, ip, port);
        Map map2 = this._outboundStates;
        synchronized (map2) {
            this._outboundStates.remove(oldId);
            this._outboundStates.put(state.getRemoteHostId(), state);
        }
        this.notifyActivity();
    }

    private void sendConfirmation(OutboundEstablishState state) {
        boolean valid = state.validateSessionCreated();
        if (!valid) {
            return;
        }
        if (!this._transport.isValid(state.getReceivedIP()) || !this._transport.isValid(state.getRemoteHostId().getIP())) {
            state.fail();
            return;
        }
        this._transport.externalAddressReceived(state.getRemoteIdentity().calculateHash(), state.getReceivedIP(), state.getReceivedPort());
        state.prepareSessionConfirmed();
        UDPPacket[] packets = this._builder.buildSessionConfirmedPackets(state, this._context.router().getRouterInfo().getIdentity());
        if (this._log.shouldLog(10)) {
            this._log.debug("Send confirm to: " + state.getRemoteHostId().toString());
        }
        for (int i = 0; i < packets.length; ++i) {
            this._transport.send(packets[i]);
        }
        state.confirmedPacketsSent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long handleInbound() {
        long now = this._context.clock().now();
        long nextSendTime = -1L;
        InboundEstablishState inboundState = null;
        Map map = this._inboundStates;
        synchronized (map) {
            Iterator iter = this._inboundStates.values().iterator();
            while (iter.hasNext()) {
                InboundEstablishState cur = (InboundEstablishState)iter.next();
                if (cur.getState() == 4) {
                    iter.remove();
                    inboundState = cur;
                    if (!this._log.shouldLog(10)) break;
                    this._log.debug("Removing completely confirmed inbound state");
                    break;
                }
                if (cur.getLifetime() > 30000L) {
                    iter.remove();
                    this._context.statManager().addRateData("udp.inboundEstablishFailedState", (long)cur.getState(), cur.getLifetime());
                    if (!this._log.shouldLog(10)) continue;
                    this._log.debug("Removing expired inbound state");
                    continue;
                }
                if (cur.getState() == 5) {
                    iter.remove();
                    this._context.statManager().addRateData("udp.inboundEstablishFailedState", (long)cur.getState(), cur.getLifetime());
                    continue;
                }
                if (cur.getNextSendTime() <= now) {
                    inboundState = cur;
                    break;
                }
                long when = -1L;
                when = cur.getNextSendTime() <= 0L ? cur.getEstablishBeginTime() + 30000L : cur.getNextSendTime();
                if (when >= nextSendTime) continue;
                nextSendTime = when;
            }
        }
        if (inboundState != null) {
            switch (inboundState.getState()) {
                case 1: {
                    this.sendCreated(inboundState);
                    break;
                }
                case 2: 
                case 3: {
                    if (inboundState.getNextSendTime() > now) break;
                    this.sendCreated(inboundState);
                    break;
                }
                case 4: {
                    RouterIdentity remote = inboundState.getConfirmedIdentity();
                    if (remote != null) {
                        if (this._context.shitlist().isShitlistedForever(remote.calculateHash())) {
                            if (this._log.shouldLog(30)) {
                                this._log.warn("Dropping inbound connection from permanently shitlisted peer: " + remote.calculateHash().toBase64());
                            }
                            this._context.blocklist().add(inboundState.getSentIP());
                            inboundState.fail();
                            break;
                        }
                        this.handleCompletelyEstablished(inboundState);
                        break;
                    }
                    if (this._log.shouldLog(30)) {
                        this._log.warn("confirmed with invalid? " + inboundState);
                    }
                    inboundState.fail();
                    break;
                }
                case 5: {
                    break;
                }
                default: {
                    if (!this._log.shouldLog(40)) break;
                    this._log.error("hrm, state is unknown for " + inboundState);
                }
            }
            nextSendTime = now;
        }
        return nextSendTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long handleOutbound() {
        long now = this._context.clock().now();
        long nextSendTime = -1L;
        OutboundEstablishState outboundState = null;
        Map map = this._outboundStates;
        synchronized (map) {
            Iterator iter = this._outboundStates.values().iterator();
            while (iter.hasNext()) {
                OutboundEstablishState cur = (OutboundEstablishState)iter.next();
                if (cur == null) continue;
                if (cur.getState() == 4) {
                    iter.remove();
                    outboundState = cur;
                    if (!this._log.shouldLog(10)) break;
                    this._log.debug("Removing confirmed outbound: " + cur);
                    break;
                }
                if (cur.getLifetime() > 30000L) {
                    iter.remove();
                    outboundState = cur;
                    this._context.statManager().addRateData("udp.outboundEstablishFailedState", (long)cur.getState(), cur.getLifetime());
                    if (!this._log.shouldLog(10)) break;
                    this._log.debug("Removing expired outbound: " + cur);
                    break;
                }
                if (cur.getNextSendTime() <= now) {
                    outboundState = cur;
                    break;
                }
                long when = -1L;
                when = cur.getNextSendTime() <= 0L ? cur.getEstablishBeginTime() + 30000L : cur.getNextSendTime();
                if (nextSendTime > 0L && when >= nextSendTime) continue;
                nextSendTime = when;
            }
        }
        if (outboundState != null) {
            if (outboundState.getLifetime() > 30000L) {
                this.processExpired(outboundState);
            } else {
                switch (outboundState.getState()) {
                    case 0: {
                        this.sendRequest(outboundState);
                        break;
                    }
                    case 1: {
                        if (outboundState.getNextSendTime() > now) break;
                        this.sendRequest(outboundState);
                        break;
                    }
                    case 2: 
                    case 3: {
                        if (outboundState.getNextSendTime() > now) break;
                        this.sendConfirmation(outboundState);
                        break;
                    }
                    case 4: {
                        this.handleCompletelyEstablished(outboundState);
                        break;
                    }
                    case 5: {
                        this.handlePendingIntro(outboundState);
                        break;
                    }
                }
            }
            nextSendTime = now;
        }
        return nextSendTime;
    }

    private void processExpired(OutboundEstablishState outboundState) {
        if (outboundState.getState() != 4) {
            OutNetMessage msg;
            if (this._log.shouldLog(30)) {
                this._log.warn("Lifetime of expired outbound establish: " + outboundState.getLifetime());
            }
            while ((msg = outboundState.getNextQueuedMessage()) != null) {
                this._transport.failed(msg, "Expired during failed establish");
            }
            String err = null;
            switch (outboundState.getState()) {
                case 3: {
                    err = "Took too long to establish remote connection (confirmed partially)";
                    break;
                }
                case 2: {
                    err = "Took too long to establish remote connection (created received)";
                    break;
                }
                case 1: {
                    err = "Took too long to establish remote connection (request sent)";
                    break;
                }
                case 5: {
                    err = "Took too long to establish remote connection (intro failed)";
                    break;
                }
                default: {
                    err = "Took too long to establish remote connection (unknown state)";
                }
            }
            Hash peer = outboundState.getRemoteIdentity().calculateHash();
            this._transport.markUnreachable(peer);
            this._transport.dropPeer(peer, false, err);
        } else {
            OutNetMessage msg;
            while ((msg = outboundState.getNextQueuedMessage()) != null) {
                this._transport.send(msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPass() {
        this._activity = 0;
        long now = this._context.clock().now();
        long nextSendTime = -1L;
        long nextSendInbound = this.handleInbound();
        long nextSendOutbound = this.handleOutbound();
        if (nextSendInbound > 0L) {
            nextSendTime = nextSendInbound;
        }
        if (nextSendTime < 0L || nextSendOutbound < nextSendTime) {
            nextSendTime = nextSendOutbound;
        }
        long delay = nextSendTime - now;
        if (nextSendTime == -1L || delay > 0L) {
            if (delay > 1000L) {
                delay = 1000L;
            }
            boolean interrupted = false;
            try {
                Object object = this._activityLock;
                synchronized (object) {
                    if (this._activity > 0) {
                        return;
                    }
                    if (nextSendTime == -1L) {
                        this._activityLock.wait(1000L);
                    } else {
                        this._activityLock.wait(delay);
                    }
                }
            }
            catch (InterruptedException ie) {
                interrupted = true;
            }
        }
    }

    private class Establisher
    implements Runnable {
        private Establisher() {
        }

        public void run() {
            while (EstablishmentManager.this._alive) {
                try {
                    EstablishmentManager.this.doPass();
                }
                catch (OutOfMemoryError oom) {
                    throw oom;
                }
                catch (RuntimeException re) {
                    EstablishmentManager.this._log.log(50, "Error in the establisher", (Throwable)re);
                }
            }
        }
    }

    private class FailIntroduction
    implements SimpleTimer.TimedEvent {
        private long _nonce;
        private OutboundEstablishState _state;

        public FailIntroduction(OutboundEstablishState state, long nonce) {
            this._nonce = nonce;
            this._state = state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void timeReached() {
            OutboundEstablishState removed = null;
            Map map = EstablishmentManager.this._liveIntroductions;
            synchronized (map) {
                removed = (OutboundEstablishState)EstablishmentManager.this._liveIntroductions.remove(new Long(this._nonce));
                if (removed != this._state) {
                    EstablishmentManager.this._liveIntroductions.put(new Long(this._nonce), removed);
                    removed = null;
                }
            }
            if (removed != null) {
                if (EstablishmentManager.this._log.shouldLog(10)) {
                    EstablishmentManager.this._log.debug("Send intro for " + this._state.getRemoteHostId().toString() + " timed out");
                }
                EstablishmentManager.this._context.statManager().addRateData("udp.sendIntroRelayTimeout", 1L, 0L);
                EstablishmentManager.this.notifyActivity();
            }
        }
    }

    private class PublishToNewInbound
    implements SimpleTimer.TimedEvent {
        private PeerState _peer;

        public PublishToNewInbound(PeerState peer) {
            this._peer = peer;
        }

        public void timeReached() {
            Hash peer = this._peer.getRemotePeer();
            if (peer != null && !EstablishmentManager.this._context.shitlist().isShitlisted(peer) && !EstablishmentManager.this._transport.isUnreachable(peer)) {
                if (EstablishmentManager.this._log.shouldLog(20)) {
                    EstablishmentManager.this._log.info("Publishing to the peer after confirm plus delay (without shitlist): " + peer.toBase64());
                }
                EstablishmentManager.this.sendOurInfo(this._peer, true);
            } else if (EstablishmentManager.this._log.shouldLog(30)) {
                EstablishmentManager.this._log.warn("NOT publishing to the peer after confirm plus delay (WITH shitlist): " + (peer != null ? peer.toBase64() : "unknown"));
            }
            this._peer = null;
        }
    }

    private class Expire
    implements SimpleTimer.TimedEvent {
        private RemoteHostId _to;
        private OutboundEstablishState _state;

        public Expire(RemoteHostId to, OutboundEstablishState state) {
            this._to = to;
            this._state = state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void timeReached() {
            Object removed = null;
            Map map = EstablishmentManager.this._outboundStates;
            synchronized (map) {
                removed = EstablishmentManager.this._outboundStates.remove(this._to);
                if (removed != null && removed != this._state) {
                    EstablishmentManager.this._outboundStates.put(this._to, removed);
                    removed = null;
                }
            }
            if (removed != null) {
                EstablishmentManager.this._context.statManager().addRateData("udp.outboundEstablishFailedState", (long)this._state.getState(), this._state.getLifetime());
                if (EstablishmentManager.this._log.shouldLog(30)) {
                    EstablishmentManager.this._log.warn("Timing out expired outbound: " + this._state);
                }
                EstablishmentManager.this.processExpired(this._state);
            }
        }
    }
}

