/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.ntcp;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.ntcp.EstablishState;
import net.i2p.router.transport.ntcp.NTCPConnection;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

class Reader {
    private RouterContext _context;
    private Log _log;
    private final List _pendingConnections;
    private List _liveReads;
    private List _readAfterLive;
    private List _runners;

    public Reader(RouterContext ctx) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(this.getClass());
        this._pendingConnections = new ArrayList(16);
        this._runners = new ArrayList(5);
        this._liveReads = new ArrayList(5);
        this._readAfterLive = new ArrayList();
    }

    public void startReading(int numReaders) {
        for (int i = 0; i < numReaders; ++i) {
            Runner r = new Runner();
            I2PThread t = new I2PThread((Runnable)r, "NTCP read " + i, true);
            this._runners.add(r);
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopReading() {
        while (this._runners.size() > 0) {
            Runner r = (Runner)this._runners.remove(0);
            r.stop();
        }
        List list = this._pendingConnections;
        synchronized (list) {
            this._readAfterLive.clear();
            this._pendingConnections.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wantsRead(NTCPConnection con) {
        boolean already = false;
        List list = this._pendingConnections;
        synchronized (list) {
            if (this._liveReads.contains(con)) {
                if (!this._readAfterLive.contains(con)) {
                    this._readAfterLive.add(con);
                }
                already = true;
            } else if (!this._pendingConnections.contains(con)) {
                this._pendingConnections.add(con);
            }
            this._pendingConnections.notifyAll();
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("wantsRead: " + con + " already live? " + already);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionClosed(NTCPConnection con) {
        List list = this._pendingConnections;
        synchronized (list) {
            this._readAfterLive.remove(con);
            this._pendingConnections.remove(con);
            this._pendingConnections.notifyAll();
        }
    }

    private void processRead(NTCPConnection con) {
        if (con.isClosed()) {
            return;
        }
        ByteBuffer buf = null;
        while (!con.isClosed() && !con.isEstablished() && (buf = con.getNextReadBuf()) != null) {
            EstablishState est = con.getEstablishState();
            if (this._log.shouldLog(10)) {
                this._log.debug("Processing read buffer as an establishment for " + con + " with [" + est + "]");
            }
            if (est == null) {
                if (!con.isEstablished()) {
                    throw new RuntimeException("connection was not established, yet the establish state is null for " + con);
                }
                if (!this._log.shouldLog(40)) break;
                this._log.error("no establishment state but " + con + " is established... race?");
                break;
            }
            if (est.isComplete()) {
                if (!this._log.shouldLog(40)) break;
                this._log.error("establishment state [" + est + "] is complete, yet the connection isn't established? " + con.isEstablished() + " (inbound? " + con.isInbound() + " " + con + ")");
                break;
            }
            est.receive(buf);
            if (est.isCorrupt()) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("closing connection on establishment because: " + est.getError(), (Throwable)est.getException());
                }
                if (!est.getFailedBySkew()) {
                    this._context.statManager().addRateData("ntcp.receiveCorruptEstablishment", 1L, 0L);
                }
                con.close();
                return;
            }
            if (buf.remaining() <= 0) {
                con.removeReadBuf(buf);
            }
            if (!est.isComplete() || est.getExtraBytes() == null) continue;
            con.recvEncryptedI2NP(ByteBuffer.wrap(est.getExtraBytes()));
        }
        while (!con.isClosed() && (buf = con.getNextReadBuf()) != null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Processing read buffer as part of an i2np message (" + buf.remaining() + " bytes)");
            }
            con.recvEncryptedI2NP(buf);
            con.removeReadBuf(buf);
        }
    }

    private class Runner
    implements Runnable {
        private boolean _stop = false;

        public void stop() {
            this._stop = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (Reader.this._log.shouldLog(20)) {
                Reader.this._log.info("Starting reader");
            }
            NTCPConnection con = null;
            while (!this._stop) {
                try {
                    List list = Reader.this._pendingConnections;
                    synchronized (list) {
                        boolean keepReading;
                        boolean bl = keepReading = con != null && Reader.this._readAfterLive.remove(con);
                        if (!keepReading) {
                            Reader.this._liveReads.remove(con);
                            con = null;
                            if (Reader.this._pendingConnections.size() <= 0) {
                                Reader.this._pendingConnections.wait();
                            } else {
                                con = (NTCPConnection)Reader.this._pendingConnections.remove(0);
                                Reader.this._liveReads.add(con);
                            }
                        }
                    }
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                if (this._stop || con == null) continue;
                if (Reader.this._log.shouldLog(10)) {
                    Reader.this._log.debug("begin read for " + con);
                }
                try {
                    Reader.this.processRead(con);
                }
                catch (RuntimeException re) {
                    Reader.this._log.log(50, "Error in the ntcp reader", (Throwable)re);
                }
                if (!Reader.this._log.shouldLog(10)) continue;
                Reader.this._log.debug("end read for " + con);
            }
            if (Reader.this._log.shouldLog(20)) {
                Reader.this._log.info("Stopping reader");
            }
        }
    }
}

