/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.ntcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.RouterAddress;
import net.i2p.data.RouterIdentity;
import net.i2p.data.RouterInfo;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.CommSystemFacadeImpl;
import net.i2p.router.transport.Transport;
import net.i2p.router.transport.TransportBid;
import net.i2p.router.transport.TransportImpl;
import net.i2p.router.transport.ntcp.EventPumper;
import net.i2p.router.transport.ntcp.NTCPAddress;
import net.i2p.router.transport.ntcp.NTCPConnection;
import net.i2p.router.transport.ntcp.NTCPSendFinisher;
import net.i2p.router.transport.ntcp.Reader;
import net.i2p.router.transport.ntcp.Writer;
import net.i2p.util.Log;

public class NTCPTransport
extends TransportImpl {
    private Log _log;
    private SharedBid _fastBid;
    private SharedBid _slowBid;
    private SharedBid _nearCapacityBid;
    private SharedBid _transientFail;
    private final Object _conLock;
    private Map<Hash, NTCPConnection> _conByIdent;
    private NTCPAddress _myAddress;
    private EventPumper _pumper;
    private Reader _reader;
    private Writer _writer;
    private final List _establishing;
    private List _sent;
    private NTCPSendFinisher _finisher;
    private static final long[] RATES = new long[]{600000L};
    private static final int NUM_CONCURRENT_READERS = 3;
    private static final int NUM_CONCURRENT_WRITERS = 3;
    public static final int ESTABLISH_TIMEOUT = 10000;
    public static final String STYLE = "NTCP";
    private static final NumberFormat _rateFmt = new DecimalFormat("#,##0.00");

    public NTCPTransport(RouterContext ctx) {
        super(ctx);
        this._log = ctx.logManager().getLog(this.getClass());
        this._context.statManager().createRateStat("ntcp.sendTime", "Total message lifetime when sent completely", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.transmitTime", "How long after message preparation before the message was fully sent", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.sendQueueSize", "How many messages were ahead of the current one on the connection's queue when it was first added", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.receiveTime", "How long it takes to receive an inbound message", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.receiveSize", "How large the received message was", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.sendBacklogTime", "How long the head of the send queue has been waiting when we fail to add a new one to the queue (period is the number of messages queued)", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.failsafeWrites", "How many times do we need to proactively add in an extra nio write to a peer at any given failsafe pass?", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.failsafeCloses", "How many times do we need to proactively close an idle connection to a peer at any given failsafe pass?", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.failsafeInvalid", "How many times do we close a connection to a peer to work around a JVM bug?", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.accept", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.attemptShitlistedPeer", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.attemptUnreachablePeer", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.closeOnBacklog", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.connectFailedIOE", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.connectFailedInvalidPort", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.bidRejectedLocalAddress", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.bidRejectedNoNTCPAddress", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.connectFailedTimeout", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.connectFailedTimeoutIOE", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.connectFailedUnresolved", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.connectImmediate", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.connectSuccessful", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.corruptDecryptedI2NP", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.corruptI2NPCRC", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.corruptI2NPIME", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.corruptI2NPIOE", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.corruptMetaCRC", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.corruptSkew", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.corruptTooLargeI2NP", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.dontSendOnBacklog", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.inboundCheckConnection", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.inboundEstablished", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.inboundEstablishedDuplicate", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.infoMessageEnqueued", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.floodInfoMessageEnqueued", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.invalidDH", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.invalidHXY", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.invalidHXxorBIH", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.invalidInboundDFE", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.invalidInboundIOE", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.invalidInboundSignature", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.invalidInboundSize", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.invalidInboundSkew", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.invalidSignature", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.liveReadBufs", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.multipleCloseOnRemove", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.outboundEstablishFailed", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.outboundFailedIOEImmediate", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.invalidOutboundSkew", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.noBidTooLargeI2NP", "send size", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.prepBufCache", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.queuedRecv", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.read", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.readEOF", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.readError", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.receiveCorruptEstablishment", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.receiveMeta", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.registerConnect", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.throttledReadComplete", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.throttledWriteComplete", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.wantsQueuedWrite", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.write", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.writeError", "", "ntcp", RATES);
        this._establishing = new ArrayList(4);
        this._conLock = new Object();
        this._conByIdent = new HashMap<Hash, NTCPConnection>(64);
        this._sent = new ArrayList(4);
        this._finisher = new NTCPSendFinisher(ctx, this);
        this._pumper = new EventPumper(ctx, this);
        this._reader = new Reader(ctx);
        this._writer = new Writer(ctx);
        this._fastBid = new SharedBid(25);
        this._slowBid = new SharedBid(70);
        this._nearCapacityBid = new SharedBid(90);
        this._transientFail = new SharedBid(999999);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void inboundEstablished(NTCPConnection con) {
        this._context.statManager().addRateData("ntcp.inboundEstablished", 1L, 0L);
        this.markReachable(con.getRemotePeer().calculateHash(), true);
        NTCPConnection old = null;
        Object object = this._conLock;
        synchronized (object) {
            old = this._conByIdent.put(con.getRemotePeer().calculateHash(), con);
        }
        if (old != null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Old connection closed: " + old + " replaced by " + con);
            }
            this._context.statManager().addRateData("ntcp.inboundEstablishedDuplicate", old.getUptime(), 0L);
            old.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void outboundMessageReady() {
        OutNetMessage msg = this.getNextMessage();
        if (msg != null) {
            RouterIdentity ident = msg.getTarget().getIdentity();
            Hash ih = ident.calculateHash();
            NTCPConnection con = null;
            boolean isNew = false;
            Object object = this._conLock;
            synchronized (object) {
                con = this._conByIdent.get(ih);
                if (con == null) {
                    isNew = true;
                    RouterAddress addr = msg.getTarget().getTargetAddress(STYLE);
                    if (addr != null) {
                        NTCPAddress naddr = new NTCPAddress(addr);
                        con = new NTCPConnection(this._context, this, ident, naddr);
                        if (this._log.shouldLog(10)) {
                            this._log.debug("Send on a new con: " + con + " at " + addr + " for " + ih.toBase64());
                        }
                        this._conByIdent.put(ih, con);
                    } else {
                        this._log.error("we bid on a peer who doesn't have an ntcp address? " + msg.getTarget());
                        return;
                    }
                }
            }
            if (isNew) {
                con.enqueueInfoMessage();
                con.send(msg);
                try {
                    SocketChannel channel = SocketChannel.open();
                    con.setChannel(channel);
                    channel.configureBlocking(false);
                    this._pumper.registerConnect(con);
                }
                catch (IOException ioe) {
                    if (this._log.shouldLog(40)) {
                        this._log.error("Error opening a channel", (Throwable)ioe);
                    }
                    this._context.statManager().addRateData("ntcp.outboundFailedIOEImmediate", 1L, 0L);
                    con.close();
                }
            } else {
                con.send(msg);
            }
        }
    }

    public void afterSend(OutNetMessage msg, boolean sendSuccessful, boolean allowRequeue, long msToSend) {
        super.afterSend(msg, sendSuccessful, allowRequeue, msToSend);
    }

    public TransportBid bid(RouterInfo toAddress, long dataSize) {
        if (!this.isAlive()) {
            return null;
        }
        if (dataSize > 16378L) {
            this._context.statManager().addRateData("ntcp.noBidTooLargeI2NP", dataSize, 0L);
            return null;
        }
        Hash peer = toAddress.getIdentity().calculateHash();
        if (this._context.shitlist().isShitlisted(peer, STYLE)) {
            this._context.statManager().addRateData("ntcp.attemptShitlistedPeer", 1L, 0L);
            return null;
        }
        if (this.isUnreachable(peer)) {
            this._context.statManager().addRateData("ntcp.attemptUnreachablePeer", 1L, 0L);
            return null;
        }
        boolean established = this.isEstablished(toAddress.getIdentity());
        if (established) {
            if (this._log.shouldLog(10)) {
                this._log.debug("fast bid when trying to send to " + peer.toBase64() + " as its already established");
            }
            return this._fastBid;
        }
        RouterAddress addr = toAddress.getTargetAddress(STYLE);
        if (addr == null) {
            this.markUnreachable(peer);
            this._context.statManager().addRateData("ntcp.bidRejectedNoNTCPAddress", 1L, 0L);
            if (this._log.shouldLog(10)) {
                this._log.debug("no bid when trying to send to " + peer.toBase64() + " as they don't have an ntcp address");
            }
            return null;
        }
        NTCPAddress naddr = new NTCPAddress(addr);
        if (naddr.getPort() <= 0 || naddr.getHost() == null) {
            this._context.statManager().addRateData("ntcp.connectFailedInvalidPort", 1L, 0L);
            this.markUnreachable(peer);
            if (this._log.shouldLog(10)) {
                this._log.debug("no bid when trying to send to " + peer.toBase64() + " as they don't have a valid ntcp address");
            }
            return null;
        }
        if (!naddr.isPubliclyRoutable() && !this._context.getProperty("i2np.ntcp.allowLocal", "false").equals("true")) {
            this._context.statManager().addRateData("ntcp.bidRejectedLocalAddress", 1L, 0L);
            this.markUnreachable(peer);
            if (this._log.shouldLog(10)) {
                this._log.debug("no bid when trying to send to " + peer.toBase64() + " as they have a private ntcp address");
            }
            return null;
        }
        if (!this.allowConnection()) {
            if (this._log.shouldLog(30)) {
                this._log.warn("no bid when trying to send to " + peer.toBase64() + ", max connection limit reached");
            }
            return this._transientFail;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("slow bid when trying to send to " + peer.toBase64());
        }
        if (this.haveCapacity()) {
            return this._slowBid;
        }
        return this._nearCapacityBid;
    }

    public boolean allowConnection() {
        return this.countActivePeers() < this.getMaxConnections();
    }

    void sendComplete(OutNetMessage msg) {
        this._finisher.add(msg);
    }

    private boolean isEstablished(RouterIdentity peer) {
        return this.isEstablished(peer.calculateHash());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEstablished(Hash dest) {
        Object object = this._conLock;
        synchronized (object) {
            NTCPConnection con = this._conByIdent.get(dest);
            return con != null && con.isEstablished() && !con.isClosed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBacklogged(Hash dest) {
        Object object = this._conLock;
        synchronized (object) {
            NTCPConnection con = this._conByIdent.get(dest);
            return con != null && con.isEstablished() && con.tooBacklogged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCon(NTCPConnection con) {
        NTCPConnection removed = null;
        Object object = this._conLock;
        synchronized (object) {
            RouterIdentity ident = con.getRemotePeer();
            if (ident != null) {
                removed = this._conByIdent.remove(ident.calculateHash());
            }
        }
        if (removed != null && removed != con) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Multiple connections on remove, closing " + removed + " (already closed " + con + ")");
            }
            this._context.statManager().addRateData("ntcp.multipleCloseOnRemove", removed.getUptime(), 0L);
            removed.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countActivePeers() {
        Object object = this._conLock;
        synchronized (object) {
            return this._conByIdent.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countActiveSendPeers() {
        int active = 0;
        Object object = this._conLock;
        synchronized (object) {
            for (NTCPConnection con : this._conByIdent.values()) {
                if (con.getTimeSinceSend() > 60000L && con.getTimeSinceReceive() > 60000L) continue;
                ++active;
            }
        }
        return active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getClockSkews() {
        Vector<NTCPConnection> peers = new Vector<NTCPConnection>();
        Vector<Long> skews = new Vector<Long>();
        Object object = this._conLock;
        synchronized (object) {
            peers.addAll(this._conByIdent.values());
        }
        for (NTCPConnection con : peers) {
            skews.addElement(new Long(con.getClockSkew()));
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("NTCP transport returning " + skews.size() + " peer clock skews.");
        }
        return skews;
    }

    public synchronized RouterAddress startListening() {
        if (this._log.shouldLog(30)) {
            this._log.warn("Starting ntcp transport listening");
        }
        this._finisher.start();
        this._pumper.startPumping();
        this._reader.startReading(3);
        this._writer.startWriting(3);
        this.configureLocalAddress();
        return this.bindAddress();
    }

    public synchronized RouterAddress restartListening(RouterAddress addr) {
        if (this._log.shouldLog(30)) {
            this._log.warn("Restarting ntcp transport listening");
        }
        this._finisher.start();
        this._pumper.startPumping();
        this._reader.startReading(3);
        this._writer.startWriting(3);
        this._myAddress = addr == null ? null : new NTCPAddress(addr);
        return this.bindAddress();
    }

    public boolean isAlive() {
        return this._pumper.isAlive();
    }

    private RouterAddress bindAddress() {
        if (this._myAddress != null) {
            try {
                ServerSocketChannel chan = ServerSocketChannel.open();
                chan.configureBlocking(false);
                InetSocketAddress addr = null;
                addr = new InetSocketAddress(this._myAddress.getPort());
                chan.socket().bind(addr);
                if (this._log.shouldLog(20)) {
                    this._log.info("Listening on " + addr);
                }
                this._pumper.register(chan);
            }
            catch (IOException ioe) {
                this._log.error("Error listening", (Throwable)ioe);
            }
        } else if (this._log.shouldLog(20)) {
            this._log.info("Outbound NTCP connections only - no listener configured");
        }
        if (this._myAddress != null) {
            RouterAddress rv = this._myAddress.toRouterAddress();
            if (rv != null) {
                this.replaceAddress(rv);
            }
            return rv;
        }
        return null;
    }

    Reader getReader() {
        return this._reader;
    }

    Writer getWriter() {
        return this._writer;
    }

    public String getStyle() {
        return STYLE;
    }

    EventPumper getPumper() {
        return this._pumper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void establishing(NTCPConnection con) {
        List list = this._establishing;
        synchronized (list) {
            this._establishing.add(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void expireTimedOut() {
        ArrayList<NTCPConnection> expired = null;
        List list = this._establishing;
        synchronized (list) {
            for (int i = 0; i < this._establishing.size(); ++i) {
                NTCPConnection con = (NTCPConnection)this._establishing.get(i);
                if (con.isClosed()) {
                    this._establishing.remove(i);
                    --i;
                    continue;
                }
                if (con.isEstablished()) {
                    this._establishing.remove(i);
                    --i;
                    continue;
                }
                if (con.getTimeSinceCreated() <= 10000L) continue;
                this._establishing.remove(i);
                --i;
                if (expired == null) {
                    expired = new ArrayList<NTCPConnection>(2);
                }
                expired.add(con);
            }
        }
        for (int i = 0; expired != null && i < expired.size(); ++i) {
            ((NTCPConnection)expired.get(i)).close();
        }
        if (expired != null && expired.size() > 0) {
            this._context.statManager().addRateData("ntcp.outboundEstablishFailed", (long)expired.size(), 0L);
        }
    }

    private void configureLocalAddress() {
        RouterContext ctx = this.getContext();
        if (ctx == null) {
            System.err.println("NIO transport has no context?");
        } else {
            RouterAddress ra = CommSystemFacadeImpl.createNTCPAddress(ctx);
            if (ra != null) {
                NTCPAddress addr = new NTCPAddress(ra);
                if (addr.getPort() <= 0) {
                    this._myAddress = null;
                    if (this._log.shouldLog(40)) {
                        this._log.error("NTCP address is outbound only, since the NTCP configuration is invalid");
                    }
                } else {
                    this._myAddress = addr;
                    this.replaceAddress(ra);
                    if (this._log.shouldLog(20)) {
                        this._log.info("NTCP address configured: " + this._myAddress);
                    }
                }
            } else if (this._log.shouldLog(20)) {
                this._log.info("NTCP address is outbound only");
            }
        }
    }

    public void forwardPortStatus(int port, boolean success, String reason) {
        if (this._log.shouldLog(30)) {
            if (success) {
                this._log.warn("UPnP has opened the NTCP port: " + port);
            } else {
                this._log.warn("UPnP has failed to open the NTCP port: " + port + " reason: " + reason);
            }
        }
    }

    public int getRequestedPort() {
        return this._context.getProperty("i2np.ntcp.port", -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getReachabilityStatus() {
        if (this.isAlive() && this._myAddress != null) {
            Object object = this._conLock;
            synchronized (object) {
                for (NTCPConnection con : this._conByIdent.values()) {
                    if (!con.isInbound()) continue;
                    return 0;
                }
            }
        }
        return 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stopListening() {
        if (this._log.shouldLog(30)) {
            this._log.warn("Stopping ntcp transport");
        }
        this._pumper.stopPumping();
        this._writer.stopWriting();
        this._reader.stopReading();
        this._finisher.stop();
        HashMap<Hash, NTCPConnection> cons = null;
        Object object = this._conLock;
        synchronized (object) {
            cons = new HashMap<Hash, NTCPConnection>(this._conByIdent);
            this._conByIdent.clear();
        }
        for (NTCPConnection con : cons.values()) {
            con.close();
        }
        this.replaceAddress(null);
    }

    public void renderStatusHTML(java.io.Writer out, int sortFlags) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderStatusHTML(java.io.Writer out, String urlBase, int sortFlags) throws IOException {
        TreeSet<NTCPConnection> peers = new TreeSet<NTCPConnection>(this.getComparator(sortFlags));
        Object object = this._conLock;
        synchronized (object) {
            peers.addAll(this._conByIdent.values());
        }
        long offsetTotal = 0L;
        boolean bpsIn = false;
        boolean bpsOut = false;
        long uptimeMsTotal = 0L;
        long sendTotal = 0L;
        long recvTotal = 0L;
        boolean numPeers = false;
        float bpsSend = 0.0f;
        float bpsRecv = 0.0f;
        long totalUptime = 0L;
        long totalSend = 0L;
        long totalRecv = 0L;
        StringBuilder buf = new StringBuilder(512);
        buf.append("<p><b id=\"ntcpcon\"><h3>NTCP connections: ").append(peers.size());
        buf.append(". Limit: ").append(this.getMaxConnections());
        buf.append(". Timeout: ").append(DataHelper.formatDuration((long)this._pumper.getIdleTimeout()));
        buf.append(".</b></h3>\n<div class=\"wideload\"><table>\n<tr><th><a href=\"#def.peer\">Peer</a></th><th>Dir</th><th align=\"right\"><a href=\"#def.idle\">Idle</a></th><th align=\"right\"><a href=\"#def.rate\">In/Out</a></th><th align=\"right\"><a href=\"#def.up\">Up</a></th><th align=\"right\"><a href=\"#def.skew\">Skew</a></th><th align=\"right\"><a href=\"#def.send\">TX</a></th><th align=\"right\"><a href=\"#def.recv\">RX</a></th><th>Out queue</th><th>Backlogged?</th><th>Reading?</th> </tr>\n");
        out.write(buf.toString());
        buf.setLength(0);
        for (NTCPConnection con : peers) {
            buf.append("<tr> <td class=\"cells\" align=\"left\" nowrap>");
            buf.append(this._context.commSystem().renderPeerHTML(con.getRemotePeer().calculateHash()));
            buf.append("</td> <td class=\"cells\" align=\"center\">");
            if (con.isInbound()) {
                buf.append("<img src=\"/themes/console/images/inbound.png\" alt=\"Inbound\" title=\"Inbound\"/>");
            } else {
                buf.append("<img src=\"/themes/console/images/outbound.png\" alt=\"Outbound\" title=\"Outbound\"/>");
            }
            buf.append("</td> <td class=\"cells\" align=\"right\">");
            buf.append(con.getTimeSinceReceive() / 1000L);
            buf.append("s/").append(con.getTimeSinceSend() / 1000L);
            buf.append("s</td> <td class=\"cells\" align=\"center\">");
            if (con.getTimeSinceReceive() < 10000L) {
                buf.append(NTCPTransport.formatRate(con.getRecvRate() / 1024.0f));
                bpsRecv += con.getRecvRate();
            } else {
                buf.append(NTCPTransport.formatRate(0.0f));
            }
            buf.append("/");
            if (con.getTimeSinceSend() < 10000L) {
                buf.append(NTCPTransport.formatRate(con.getSendRate() / 1024.0f));
                bpsSend += con.getSendRate();
            } else {
                buf.append(NTCPTransport.formatRate(0.0f));
            }
            buf.append("K/s");
            buf.append("</td> <td class=\"cells\" align=\"center\">").append(DataHelper.formatDuration((long)con.getUptime()));
            totalUptime += con.getUptime();
            offsetTotal += con.getClockSkew();
            buf.append("</td> <td class=\"cells\" align=\"center\">").append(con.getClockSkew());
            buf.append("s</td> <td class=\"cells\" align=\"center\">").append(con.getMessagesSent());
            totalSend += con.getMessagesSent();
            buf.append("</td> <td class=\"cells\" align=\"center\">").append(con.getMessagesReceived());
            totalRecv += con.getMessagesReceived();
            long outQueue = con.getOutboundQueueSize();
            if (outQueue <= 0L) {
                buf.append("</td> <td class=\"cells\" align=\"center\">No messages");
            } else {
                buf.append("</td> <td class=\"cells\" align=\"center\">").append(outQueue).append(" message");
                if (outQueue > 1L) {
                    buf.append("s");
                }
            }
            buf.append("</td> <td class=\"cells\" align=\"center\">").append(con.getConsecutiveBacklog() > 0 ? "true" : "false");
            long readTime = con.getReadTime();
            if (readTime <= 0L) {
                buf.append("</td> <td class=\"cells\" align=\"center\">No");
            } else {
                buf.append("</td> <td class=\"cells\">For ").append(DataHelper.formatDuration((long)readTime));
            }
            buf.append("</td></tr>\n");
            out.write(buf.toString());
            buf.setLength(0);
        }
        if (peers.size() > 0) {
            buf.append("<tr class=\"tablefooter\"> <td align=\"center\"><b>").append(peers.size()).append(" peers</b></td> <td>&nbsp;</td> <td>&nbsp;");
            buf.append("</td> <td align=\"center\"><b>").append(NTCPTransport.formatRate(bpsRecv / 1024.0f)).append("/").append(NTCPTransport.formatRate(bpsSend / 1024.0f)).append("K/s</b>");
            buf.append("</td> <td align=\"center\"><b>").append(DataHelper.formatDuration((long)(totalUptime / (long)peers.size())));
            buf.append("</b></td> <td align=\"center\"><b>").append(peers.size() > 0 ? DataHelper.formatDuration((long)(offsetTotal * 1000L / (long)peers.size())) : "0ms");
            buf.append("</b></td> <td align=\"center\"><b>").append(totalSend).append("</b></td> <td align=\"center\"><b>").append(totalRecv);
            buf.append("</b></td> <td>&nbsp;</td> <td>&nbsp;</td> <td>&nbsp;</td></tr>\n");
        }
        buf.append("</table></div></p>\n");
        out.write(buf.toString());
        buf.setLength(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String formatRate(float rate) {
        NumberFormat numberFormat = _rateFmt;
        synchronized (numberFormat) {
            return _rateFmt.format(rate);
        }
    }

    private Comparator getComparator(int sortFlags) {
        Comparator rv = null;
        switch (Math.abs(sortFlags)) {
            default: 
        }
        rv = AlphaComparator.instance();
        if (sortFlags < 0) {
            rv = new InverseComparator(rv);
        }
        return rv;
    }

    private class SharedBid
    extends TransportBid {
        public SharedBid(int ms) {
            this.setLatencyMs(ms);
        }

        public Transport getTransport() {
            return NTCPTransport.this;
        }

        public String toString() {
            return "NTCP bid @ " + this.getLatencyMs();
        }
    }

    private static class PeerComparator
    implements Comparator {
        private PeerComparator() {
        }

        public int compare(Object lhs, Object rhs) {
            if (lhs == null || rhs == null || !(lhs instanceof NTCPConnection) || !(rhs instanceof NTCPConnection)) {
                throw new IllegalArgumentException("rhs = " + rhs + " lhs = " + lhs);
            }
            return this.compare((NTCPConnection)lhs, (NTCPConnection)rhs);
        }

        protected int compare(NTCPConnection l, NTCPConnection r) {
            return l.getRemotePeer().calculateHash().toBase64().compareTo(r.getRemotePeer().calculateHash().toBase64());
        }
    }

    private static class InverseComparator
    implements Comparator {
        private Comparator _comp;

        public InverseComparator(Comparator comp) {
            this._comp = comp;
        }

        public int compare(Object lhs, Object rhs) {
            return -1 * this._comp.compare(lhs, rhs);
        }
    }

    private static class AlphaComparator
    extends PeerComparator {
        private static final AlphaComparator _instance = new AlphaComparator();

        private AlphaComparator() {
        }

        public static final AlphaComparator instance() {
            return _instance;
        }
    }
}

