/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.ntcp;

import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.i2p.I2PAppContext;
import net.i2p.router.OutNetMessage;
import net.i2p.router.transport.ntcp.NTCPTransport;
import net.i2p.util.Log;

public class NTCPSendFinisher {
    private static final int THREADS = 4;
    private I2PAppContext _context;
    private NTCPTransport _transport;
    private Log _log;
    private int _count;
    private ThreadPoolExecutor _executor;

    public NTCPSendFinisher(I2PAppContext context, NTCPTransport transport) {
        this._context = context;
        this._log = this._context.logManager().getLog(NTCPSendFinisher.class);
        this._transport = transport;
    }

    public void start() {
        this._count = 0;
        this._executor = new CustomThreadPoolExecutor();
    }

    public void stop() {
        if (this._executor != null) {
            this._executor.shutdownNow();
        }
    }

    public void add(OutNetMessage msg) {
        this._executor.execute(new RunnableEvent(msg));
    }

    private class RunnableEvent
    implements Runnable {
        private OutNetMessage _msg;

        public RunnableEvent(OutNetMessage msg) {
            this._msg = msg;
        }

        public void run() {
            try {
                NTCPSendFinisher.this._transport.afterSend(this._msg, true, false, this._msg.getSendTime());
            }
            catch (Throwable t) {
                NTCPSendFinisher.this._log.log(50, " wtf, afterSend borked", t);
            }
        }
    }

    private class CustomThreadFactory
    implements ThreadFactory {
        private CustomThreadFactory() {
        }

        public Thread newThread(Runnable r) {
            Thread rv = Executors.defaultThreadFactory().newThread(r);
            rv.setName("NTCPSendFinisher " + ++NTCPSendFinisher.this._count + '/' + 4);
            rv.setDaemon(true);
            return rv;
        }
    }

    private class CustomThreadPoolExecutor
    extends ThreadPoolExecutor {
        public CustomThreadPoolExecutor() {
            super(4, 4, 1000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new CustomThreadFactory());
        }
    }
}

