/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.ntcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.NoConnectionPendingException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.UnresolvedAddressException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.i2p.data.RouterIdentity;
import net.i2p.data.RouterInfo;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.FIFOBandwidthLimiter;
import net.i2p.router.transport.ntcp.NTCPAddress;
import net.i2p.router.transport.ntcp.NTCPConnection;
import net.i2p.router.transport.ntcp.NTCPTransport;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

public class EventPumper
implements Runnable {
    private RouterContext _context;
    private Log _log;
    private volatile boolean _alive;
    private Selector _selector;
    private final List _bufCache;
    private final List _wantsRead = new ArrayList(16);
    private final List _wantsWrite = new ArrayList(4);
    private final List _wantsRegister = new ArrayList(1);
    private final List _wantsConRegister = new ArrayList(4);
    private NTCPTransport _transport;
    private long _expireIdleWriteTime;
    private static final int BUF_SIZE = 8192;
    private static final int MAX_CACHE_SIZE = 64;
    private static final long FAILSAFE_ITERATION_FREQ = 2000L;
    private static final long MIN_EXPIRE_IDLE_TIME = 180000L;
    private static final long MAX_EXPIRE_IDLE_TIME = 900000L;
    private static final int MIN_BUFS = 5;
    private static int NUM_BUFS = 5;
    private static int __liveBufs = 0;
    private static int __consecutiveExtra;
    private long _lastExpired;

    public EventPumper(RouterContext ctx, NTCPTransport transport) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(this.getClass());
        this._transport = transport;
        this._alive = false;
        this._bufCache = new ArrayList(64);
        this._expireIdleWriteTime = 900000L;
    }

    public synchronized void startPumping() {
        if (this._log.shouldLog(20)) {
            this._log.info("Starting pumper");
        }
        try {
            this._selector = Selector.open();
            this._alive = true;
            new I2PThread((Runnable)this, "NTCP Pumper", true).start();
        }
        catch (IOException ioe) {
            this._log.log(50, "Error opening the NTCP selector", (Throwable)ioe);
        }
        catch (InternalError jlie) {
            this._log.log(50, "Error opening the NTCP selector", (Throwable)jlie);
        }
    }

    public synchronized void stopPumping() {
        this._alive = false;
        if (this._selector != null && this._selector.isOpen()) {
            this._selector.wakeup();
        }
    }

    public boolean isAlive() {
        return this._alive || this._selector != null && this._selector.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(ServerSocketChannel chan) {
        if (this._log.shouldLog(10)) {
            this._log.debug("Registering server socket channel");
        }
        List list = this._wantsRegister;
        synchronized (list) {
            this._wantsRegister.add(chan);
        }
        this._selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConnect(NTCPConnection con) {
        if (this._log.shouldLog(10)) {
            this._log.debug("Registering outbound connection");
        }
        this._context.statManager().addRateData("ntcp.registerConnect", 1L, 0L);
        List list = this._wantsConRegister;
        synchronized (list) {
            this._wantsConRegister.add(con);
        }
        this._selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        long lastFailsafeIteration = System.currentTimeMillis();
        ArrayList bufList = new ArrayList(16);
        while (this._alive && this._selector.isOpen()) {
            try {
                int count;
                block40: {
                    this.runDelayedEvents(bufList);
                    count = 0;
                    try {
                        count = this._selector.select(200L);
                    }
                    catch (IOException ioe) {
                        if (!this._log.shouldLog(30)) break block40;
                        this._log.warn("Error selecting", (Throwable)ioe);
                    }
                }
                if (count <= 0) continue;
                if (this._log.shouldLog(10)) {
                    this._log.debug("select returned " + count);
                }
                Set<SelectionKey> selected = null;
                try {
                    selected = this._selector.selectedKeys();
                }
                catch (ClosedSelectorException cse) {
                    continue;
                }
                this.processKeys(selected);
                selected.clear();
                if (lastFailsafeIteration + 2000L >= System.currentTimeMillis()) continue;
                lastFailsafeIteration = System.currentTimeMillis();
                try {
                    Set<SelectionKey> all = this._selector.keys();
                    int failsafeWrites = 0;
                    int failsafeCloses = 0;
                    int failsafeInvalid = 0;
                    this._expireIdleWriteTime = this._transport.haveCapacity() ? Math.min(this._expireIdleWriteTime + 1000L, 900000L) : Math.max(this._expireIdleWriteTime - 3000L, 180000L);
                    Iterator<SelectionKey> iter = all.iterator();
                    while (iter.hasNext()) {
                        try {
                            SelectionKey key = iter.next();
                            Object att = key.attachment();
                            if (!(att instanceof NTCPConnection)) continue;
                            NTCPConnection con = (NTCPConnection)att;
                            if (!key.isValid() && !((SocketChannel)key.channel()).isConnectionPending() && con.getTimeSinceCreated() > 20000L) {
                                if (this._log.shouldLog(30)) {
                                    this._log.warn("Invalid key " + con);
                                }
                                con.close();
                                ++failsafeInvalid;
                                continue;
                            }
                            if (con.getWriteBufCount() > 0 && (key.interestOps() & 4) == 0) {
                                key.interestOps(4 | key.interestOps());
                                ++failsafeWrites;
                            }
                            if (con.getTimeSinceSend() <= this._expireIdleWriteTime || con.getTimeSinceReceive() <= this._expireIdleWriteTime) continue;
                            con.close();
                            ++failsafeCloses;
                        }
                        catch (CancelledKeyException cke) {}
                    }
                    if (failsafeWrites > 0) {
                        this._context.statManager().addRateData("ntcp.failsafeWrites", (long)failsafeWrites, 0L);
                    }
                    if (failsafeCloses > 0) {
                        this._context.statManager().addRateData("ntcp.failsafeCloses", (long)failsafeCloses, 0L);
                    }
                    if (failsafeInvalid <= 0) continue;
                    this._context.statManager().addRateData("ntcp.failsafeInvalid", (long)failsafeInvalid, 0L);
                }
                catch (ClosedSelectorException cse) {
                }
            }
            catch (RuntimeException re) {
                this._log.log(50, "Error in the event pumper", (Throwable)re);
            }
        }
        try {
            if (this._selector.isOpen()) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Closing down the event pumper with selection keys remaining");
                }
                Set<SelectionKey> keys = this._selector.keys();
                for (SelectionKey key : keys) {
                    try {
                        Object att = key.attachment();
                        if (att instanceof ServerSocketChannel) {
                            ServerSocketChannel chan = (ServerSocketChannel)att;
                            chan.close();
                            key.cancel();
                            continue;
                        }
                        if (!(att instanceof NTCPConnection)) continue;
                        NTCPConnection con = (NTCPConnection)att;
                        con.close();
                        key.cancel();
                    }
                    catch (Exception ke) {
                        this._log.error("Error closing key " + key + " on pumper shutdown", (Throwable)ke);
                    }
                }
                this._selector.close();
            } else if (this._log.shouldLog(10)) {
                this._log.debug("Closing down the event pumper with no selection keys remaining");
            }
        }
        catch (Exception e) {
            this._log.error("Error closing keys on pumper shutdown", (Throwable)e);
        }
        List list = this._wantsConRegister;
        synchronized (list) {
            this._wantsConRegister.clear();
        }
        list = this._wantsRead;
        synchronized (list) {
            this._wantsRead.clear();
        }
        list = this._wantsRegister;
        synchronized (list) {
            this._wantsRegister.clear();
        }
        list = this._wantsWrite;
        synchronized (list) {
            this._wantsWrite.clear();
        }
    }

    private void processKeys(Set selected) {
        Iterator iter = selected.iterator();
        while (iter.hasNext()) {
            try {
                boolean write;
                SelectionKey key = (SelectionKey)iter.next();
                int ops = key.readyOps();
                boolean accept = (ops & 0x10) != 0;
                boolean connect = (ops & 8) != 0;
                boolean read = (ops & 1) != 0;
                boolean bl = write = (ops & 4) != 0;
                if (this._log.shouldLog(10)) {
                    this._log.debug("ready ops for : " + key + " accept? " + accept + " connect? " + connect + " read? " + read + "/" + ((key.interestOps() & 1) != 0) + " write? " + write + "/" + ((key.interestOps() & 4) != 0) + " on " + key.attachment());
                }
                if (accept) {
                    this._context.statManager().addRateData("ntcp.accept", 1L, 0L);
                    this.processAccept(key);
                }
                if (connect) {
                    key.interestOps(key.interestOps() & 0xFFFFFFF7);
                    this.processConnect(key);
                }
                if (read) {
                    this._context.statManager().addRateData("ntcp.read", 1L, 0L);
                    key.interestOps(key.interestOps() & 0xFFFFFFFE);
                    this.processRead(key);
                }
                if (!write) continue;
                this._context.statManager().addRateData("ntcp.write", 1L, 0L);
                key.interestOps(key.interestOps() & 0xFFFFFFFB);
                this.processWrite(key);
            }
            catch (CancelledKeyException cke) {
                if (!this._log.shouldLog(10)) continue;
                this._log.debug("key cancelled");
            }
        }
    }

    public void wantsWrite(NTCPConnection con, byte[] data) {
        ByteBuffer buf = ByteBuffer.wrap(data);
        FIFOBandwidthLimiter.Request req = this._context.bandwidthLimiter().requestOutbound(data.length, "NTCP write", null, null);
        if (req.getPendingOutboundRequested() > 0) {
            if (this._log.shouldLog(20)) {
                this._log.info("queued write on " + con + " for " + data.length);
            }
            this._context.statManager().addRateData("ntcp.wantsQueuedWrite", 1L, 0L);
            con.queuedWrite(buf, req);
        } else {
            if (this._log.shouldLog(20)) {
                this._log.info("fully allocated write on " + con + " for " + data.length);
            }
            con.write(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wantsWrite(NTCPConnection con) {
        if (this._log.shouldLog(20)) {
            this._log.info("Before adding wants to write on " + con);
        }
        List list = this._wantsWrite;
        synchronized (list) {
            if (!this._wantsWrite.contains(con)) {
                this._wantsWrite.add(con);
            }
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Wants to write on " + con);
        }
        this._selector.wakeup();
        if (this._log.shouldLog(10)) {
            this._log.debug("selector awoken for write");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wantsRead(NTCPConnection con) {
        List list = this._wantsRead;
        synchronized (list) {
            if (!this._wantsRead.contains(con)) {
                this._wantsRead.add(con);
            }
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("wants to read on " + con);
        }
        this._selector.wakeup();
        if (this._log.shouldLog(10)) {
            this._log.debug("selector awoken for read");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ByteBuffer acquireBuf() {
        ByteBuffer rv = null;
        List list = this._bufCache;
        synchronized (list) {
            if (this._bufCache.size() > 0) {
                rv = (ByteBuffer)this._bufCache.remove(0);
            }
        }
        if (rv == null) {
            rv = ByteBuffer.allocate(8192);
            NUM_BUFS = ++__liveBufs;
            if (this._log.shouldLog(10)) {
                this._log.debug("creating a new read buffer " + System.identityHashCode(rv) + " with " + __liveBufs + " live: " + rv);
            }
            this._context.statManager().addRateData("ntcp.liveReadBufs", (long)NUM_BUFS, 0L);
        } else if (this._log.shouldLog(10)) {
            this._log.debug("acquiring existing read buffer " + System.identityHashCode(rv) + " with " + __liveBufs + " live: " + rv);
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseBuf(ByteBuffer buf) {
        if (this._log.shouldLog(10)) {
            this._log.debug("releasing read buffer " + System.identityHashCode(buf) + " with " + __liveBufs + " live: " + buf);
        }
        buf.clear();
        int extra = 0;
        boolean cached = false;
        List list = this._bufCache;
        synchronized (list) {
            if (this._bufCache.size() < NUM_BUFS) {
                extra = this._bufCache.size();
                this._bufCache.add(buf);
                cached = true;
                if (extra > 5 && ++__consecutiveExtra >= 20) {
                    NUM_BUFS = Math.max(NUM_BUFS - 1, 5);
                    __consecutiveExtra = 0;
                }
            } else {
                --__liveBufs;
            }
        }
        if (cached && this._log.shouldLog(10)) {
            this._log.debug("read buffer " + System.identityHashCode(buf) + " cached with " + __liveBufs + " live");
        }
    }

    private void processAccept(SelectionKey key) {
        block12: {
            if (this._log.shouldLog(10)) {
                this._log.debug("processing accept");
            }
            ServerSocketChannel servChan = (ServerSocketChannel)key.attachment();
            try {
                SocketChannel chan = servChan.accept();
                chan.configureBlocking(false);
                if (!this._transport.allowConnection()) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Receive session request but at connection limit: " + chan.socket().getInetAddress());
                    }
                    try {
                        chan.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    return;
                }
                if (this._context.blocklist().isBlocklisted(chan.socket().getInetAddress().getAddress())) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Receive session request from blocklisted IP: " + chan.socket().getInetAddress());
                    }
                    try {
                        chan.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    return;
                }
                SelectionKey ckey = chan.register(this._selector, 1);
                NTCPConnection con = new NTCPConnection(this._context, this._transport, chan, ckey);
                if (this._log.shouldLog(10)) {
                    this._log.debug("new NTCP connection established: " + con);
                }
            }
            catch (IOException ioe) {
                if (!this._log.shouldLog(40)) break block12;
                this._log.error("Error accepting", (Throwable)ioe);
            }
        }
    }

    private void processConnect(SelectionKey key) {
        NTCPConnection con = (NTCPConnection)key.attachment();
        try {
            SocketChannel chan = con.getChannel();
            boolean connected = chan.finishConnect();
            if (this._log.shouldLog(10)) {
                this._log.debug("processing connect for " + key + " / " + con + ": connected? " + connected);
            }
            if (connected) {
                con.setKey(key);
                con.outboundConnected();
                this._context.statManager().addRateData("ntcp.connectSuccessful", 1L, 0L);
            } else {
                con.close();
                this._transport.markUnreachable(con.getRemotePeer().calculateHash());
                this._context.statManager().addRateData("ntcp.connectFailedTimeout", 1L, 0L);
            }
        }
        catch (IOException ioe) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Failed outbound connection to " + con.getRemotePeer().calculateHash(), (Throwable)ioe);
            }
            con.close();
            this._transport.markUnreachable(con.getRemotePeer().calculateHash());
            this._context.statManager().addRateData("ntcp.connectFailedTimeoutIOE", 1L, 0L);
        }
        catch (NoConnectionPendingException noConnectionPendingException) {
            // empty catch block
        }
    }

    private void processRead(SelectionKey key) {
        NTCPConnection con = (NTCPConnection)key.attachment();
        ByteBuffer buf = this.acquireBuf();
        try {
            int read = con.getChannel().read(buf);
            if (read == -1) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("EOF on " + con);
                }
                this._context.statManager().addRateData("ntcp.readEOF", 1L, 0L);
                con.close();
                this.releaseBuf(buf);
            } else if (read == 0) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("nothing to read for " + con + ", but stay interested");
                }
                key.interestOps(key.interestOps() | 1);
                this.releaseBuf(buf);
            } else if (read > 0) {
                byte[] data = new byte[read];
                buf.flip();
                buf.get(data);
                this.releaseBuf(buf);
                ByteBuffer rbuf = ByteBuffer.wrap(data);
                FIFOBandwidthLimiter.Request req = this._context.bandwidthLimiter().requestInbound(read, "NTCP read", null, null);
                if (req.getPendingInboundRequested() > 0) {
                    key.interestOps(key.interestOps() & 0xFFFFFFFE);
                    if (this._log.shouldLog(10)) {
                        this._log.debug("bw throttled reading for " + con + ", so we don't want to read anymore");
                    }
                    this._context.statManager().addRateData("ntcp.queuedRecv", (long)read, 0L);
                    con.queuedRecv(rbuf, req);
                } else {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("not bw throttled reading for " + con);
                    }
                    key.interestOps(key.interestOps() | 1);
                    con.recv(rbuf);
                }
            }
        }
        catch (CancelledKeyException cke) {
            if (this._log.shouldLog(30)) {
                this._log.warn("error reading", (Throwable)cke);
            }
            con.close();
            this._context.statManager().addRateData("ntcp.readError", 1L, 0L);
            if (buf != null) {
                this.releaseBuf(buf);
            }
        }
        catch (IOException ioe) {
            if (this._log.shouldLog(30)) {
                this._log.warn("error reading", (Throwable)ioe);
            }
            con.close();
            this._context.statManager().addRateData("ntcp.readError", 1L, 0L);
            if (buf != null) {
                this.releaseBuf(buf);
            }
        }
        catch (NotYetConnectedException nyce) {
            // empty catch block
        }
    }

    private void processWrite(SelectionKey key) {
        int totalWritten = 0;
        int buffers = 0;
        long before = System.currentTimeMillis();
        NTCPConnection con = (NTCPConnection)key.attachment();
        try {
            ByteBuffer buf;
            while ((buf = con.getNextWriteBuf()) != null) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("writing " + buf.remaining() + "...");
                }
                if (buf.remaining() <= 0) {
                    long beforeRem = System.currentTimeMillis();
                    con.removeWriteBuf(buf);
                    long afterRem = System.currentTimeMillis();
                    if (this._log.shouldLog(10)) {
                        this._log.debug("buffer was already fully written and removed after " + (afterRem - beforeRem) + "...");
                    }
                    buf = null;
                    ++buffers;
                    continue;
                }
                int written = con.getChannel().write(buf);
                totalWritten += written;
                if (written == 0) {
                    if (buf.remaining() > 0 || con.getWriteBufCount() >= 1) {
                        if (this._log.shouldLog(10)) {
                            this._log.debug("done writing, but data remains...");
                        }
                        key.interestOps(key.interestOps() | 4);
                    } else if (this._log.shouldLog(10)) {
                        this._log.debug("done writing, no data remains...");
                    }
                    break;
                }
                if (buf.remaining() > 0) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("buffer data remaining...");
                    }
                    key.interestOps(key.interestOps() | 4);
                    break;
                }
                long beforeRem = System.currentTimeMillis();
                con.removeWriteBuf(buf);
                long afterRem = System.currentTimeMillis();
                if (this._log.shouldLog(10)) {
                    this._log.debug("buffer " + buffers + "/" + written + "/" + totalWritten + " fully written after " + (beforeRem - before) + ", then removed after " + (afterRem - beforeRem) + "...");
                }
                buf = null;
                ++buffers;
            }
        }
        catch (CancelledKeyException cke) {
            if (this._log.shouldLog(30)) {
                this._log.warn("error writing", (Throwable)cke);
            }
            this._context.statManager().addRateData("ntcp.writeError", 1L, 0L);
            con.close();
        }
        catch (IOException ioe) {
            if (this._log.shouldLog(30)) {
                this._log.warn("error writing", (Throwable)ioe);
            }
            this._context.statManager().addRateData("ntcp.writeError", 1L, 0L);
            con.close();
        }
        long after = System.currentTimeMillis();
        if (this._log.shouldLog(20)) {
            this._log.info("Wrote " + totalWritten + " in " + buffers + " buffers on " + con + " after " + (after - before));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runDelayedEvents(List buf) {
        Object chan;
        SelectionKey key;
        Object con;
        List list = this._wantsRead;
        synchronized (list) {
            if (this._wantsRead.size() > 0) {
                buf.addAll(this._wantsRead);
                this._wantsRead.clear();
            }
        }
        while (buf.size() > 0) {
            con = (NTCPConnection)buf.remove(0);
            key = ((NTCPConnection)con).getKey();
            try {
                key.interestOps(key.interestOps() | 1);
            }
            catch (CancelledKeyException cke) {}
        }
        con = this._wantsWrite;
        synchronized (con) {
            if (this._wantsWrite.size() > 0) {
                buf.addAll(this._wantsWrite);
                this._wantsWrite.clear();
            }
        }
        while (buf.size() > 0) {
            con = (NTCPConnection)buf.remove(0);
            key = ((NTCPConnection)con).getKey();
            try {
                key.interestOps(key.interestOps() | 4);
            }
            catch (CancelledKeyException cke) {}
        }
        con = this._wantsRegister;
        synchronized (con) {
            if (this._wantsRegister.size() > 0) {
                buf.addAll(this._wantsRegister);
                this._wantsRegister.clear();
            }
        }
        while (buf.size() > 0) {
            chan = (ServerSocketChannel)buf.remove(0);
            try {
                key = ((SelectableChannel)chan).register(this._selector, 16);
                key.attach(chan);
            }
            catch (ClosedChannelException cce) {
                if (!this._log.shouldLog(30)) continue;
                this._log.warn("Error registering", (Throwable)cce);
            }
        }
        chan = this._wantsConRegister;
        synchronized (chan) {
            if (this._wantsConRegister.size() > 0) {
                buf.addAll(this._wantsConRegister);
                this._wantsConRegister.clear();
            }
        }
        while (buf.size() > 0) {
            con = (NTCPConnection)buf.remove(0);
            try {
                key = ((NTCPConnection)con).getChannel().register(this._selector, 8);
                key.attach(con);
                ((NTCPConnection)con).setKey(key);
                try {
                    NTCPAddress naddr = ((NTCPConnection)con).getRemoteAddress();
                    if (naddr.getPort() <= 0) {
                        throw new IOException("Invalid NTCP address: " + naddr);
                    }
                    InetSocketAddress saddr = new InetSocketAddress(naddr.getHost(), naddr.getPort());
                    boolean connected = ((NTCPConnection)con).getChannel().connect(saddr);
                    if (!connected) continue;
                    this._context.statManager().addRateData("ntcp.connectImmediate", 1L, 0L);
                    key.interestOps(1);
                    this.processConnect(key);
                }
                catch (IOException ioe) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("error connecting", (Throwable)ioe);
                    }
                    this._context.statManager().addRateData("ntcp.connectFailedIOE", 1L, 0L);
                    this._transport.markUnreachable(((NTCPConnection)con).getRemotePeer().calculateHash());
                    ((NTCPConnection)con).close(true);
                }
                catch (UnresolvedAddressException uae) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("unresolved address connecting", (Throwable)uae);
                    }
                    this._context.statManager().addRateData("ntcp.connectFailedUnresolved", 1L, 0L);
                    this._transport.markUnreachable(((NTCPConnection)con).getRemotePeer().calculateHash());
                    ((NTCPConnection)con).close(true);
                }
                catch (CancelledKeyException cke) {
                    ((NTCPConnection)con).close(false);
                }
            }
            catch (ClosedChannelException cce) {
                if (!this._log.shouldLog(30)) continue;
                this._log.warn("Error registering", (Throwable)cce);
            }
        }
        long now = System.currentTimeMillis();
        if (this._lastExpired + 1000L <= now) {
            this.expireTimedOut();
            this._lastExpired = now;
        }
    }

    private boolean ntcpOnly(NTCPConnection con) {
        RouterIdentity ident = con.getRemotePeer();
        if (ident == null) {
            return true;
        }
        RouterInfo info = this._context.netDb().lookupRouterInfoLocally(ident.calculateHash());
        if (info == null) {
            return true;
        }
        return info.getAddresses().size() == 1;
    }

    private void expireTimedOut() {
        this._transport.expireTimedOut();
    }

    public long getIdleTimeout() {
        return this._expireIdleWriteTime;
    }
}

