/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport;

import java.io.IOException;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import net.i2p.data.Hash;
import net.i2p.data.RouterAddress;
import net.i2p.data.RouterIdentity;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.Addresses;
import net.i2p.router.transport.Transport;
import net.i2p.router.transport.TransportBid;
import net.i2p.router.transport.TransportEventListener;
import net.i2p.router.transport.TransportImpl;
import net.i2p.router.transport.UPnPManager;
import net.i2p.router.transport.ntcp.NTCPTransport;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransportManager
implements TransportEventListener {
    private Log _log;
    private List<Transport> _transports;
    private RouterContext _context;
    private UPnPManager _upnpManager;
    public static final String PROP_ENABLE_UDP = "i2np.udp.enable";
    public static final String PROP_ENABLE_NTCP = "i2np.ntcp.enable";
    public static final String DEFAULT_ENABLE_NTCP = "true";
    public static final String DEFAULT_ENABLE_UDP = "true";
    public static final String PROP_ENABLE_UPNP = "i2np.upnp.enable";
    private static final int HIGH_CAPACITY_PCT = 50;

    public TransportManager(RouterContext context) {
        this._context = context;
        this._log = this._context.logManager().getLog(TransportManager.class);
        this._context.statManager().createRateStat("transport.shitlistOnUnreachable", "Add a peer to the shitlist since none of the transports can reach them", "Transport", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("transport.noBidsYetNotAllUnreachable", "Add a peer to the shitlist since none of the transports can reach them", "Transport", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("transport.bidFailShitlisted", "Could not attempt to bid on message, as they were shitlisted", "Transport", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("transport.bidFailSelf", "Could not attempt to bid on message, as it targeted ourselves", "Transport", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("transport.bidFailNoTransports", "Could not attempt to bid on message, as none of the transports could attempt it", "Transport", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("transport.bidFailAllTransports", "Could not attempt to bid on message, as all of the transports had failed", "Transport", new long[]{60000L, 600000L, 3600000L});
        this._transports = new ArrayList<Transport>();
        if (Boolean.valueOf(this._context.getProperty(PROP_ENABLE_UPNP, "true")).booleanValue()) {
            this._upnpManager = new UPnPManager(context, this);
        }
    }

    public void addTransport(Transport transport) {
        if (transport == null) {
            return;
        }
        this._transports.add(transport);
        transport.setListener(this);
    }

    public void removeTransport(Transport transport) {
        if (transport == null) {
            return;
        }
        this._transports.remove(transport);
        transport.setListener(null);
    }

    private void configTransports() {
        String enableUDP = this._context.router().getConfigSetting(PROP_ENABLE_UDP);
        if (enableUDP == null) {
            enableUDP = "true";
        }
        if ("true".equalsIgnoreCase(enableUDP)) {
            UDPTransport udp = new UDPTransport(this._context);
            this.addTransport(udp);
            TransportManager.initializeAddress(udp);
        }
        if (TransportManager.enableNTCP(this._context)) {
            this.addTransport(new NTCPTransport(this._context));
        }
        if (this._transports.size() <= 0) {
            this._log.log(50, "No transports are enabled");
        }
    }

    public static boolean enableNTCP(RouterContext ctx) {
        String enableNTCP = ctx.router().getConfigSetting(PROP_ENABLE_NTCP);
        if (enableNTCP == null) {
            enableNTCP = "true";
        }
        return "true".equalsIgnoreCase(enableNTCP);
    }

    private static void initializeAddress(Transport t) {
        String ips = Addresses.getAnyAddress();
        if (ips == null) {
            return;
        }
        InetAddress ia = null;
        try {
            ia = InetAddress.getByName(ips);
        }
        catch (UnknownHostException e) {
            return;
        }
        if (ia == null) {
            return;
        }
        byte[] ip = ia.getAddress();
        t.externalAddressReceived("local", ip, 0);
    }

    public void externalAddressReceived(String source, byte[] ip, int port) {
        Transport t = this.getTransport("SSU");
        if (t != null) {
            t.externalAddressReceived(source, ip, port);
        }
    }

    public void forwardPortStatus(String style, int port, boolean success, String reason) {
        Transport t = this.getTransport(style);
        if (t != null) {
            t.forwardPortStatus(port, success, reason);
        }
    }

    public void startListening() {
        if (this._upnpManager != null && Addresses.getAnyAddress() == null) {
            this._upnpManager.start();
        }
        this.configTransports();
        this._log.debug("Starting up the transport manager");
        for (int i = 0; i < this._transports.size(); ++i) {
            Transport t = this._transports.get(i);
            RouterAddress addr = t.startListening();
            if (!this._log.shouldLog(10)) continue;
            this._log.debug("Transport " + i + " (" + t.getStyle() + ") started");
        }
        this.transportAddressChanged();
        this._log.debug("Done start listening on transports");
        this._context.router().rebuildRouterInfo();
    }

    public void restart() {
        this.stopListening();
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.startListening();
    }

    public void stopListening() {
        if (this._upnpManager != null) {
            this._upnpManager.stop();
        }
        for (int i = 0; i < this._transports.size(); ++i) {
            this._transports.get(i).stopListening();
        }
        this._transports.clear();
    }

    public Transport getTransport(String style) {
        for (int i = 0; i < this._transports.size(); ++i) {
            Transport t = this._transports.get(i);
            if (!style.equals(t.getStyle())) continue;
            return t;
        }
        return null;
    }

    int getTransportCount() {
        return this._transports.size();
    }

    private boolean isSupported(Set addresses, Transport t) {
        for (RouterAddress addr : addresses) {
            if (!addr.getTransportStyle().equals(t.getStyle())) continue;
            return true;
        }
        return false;
    }

    public int countActivePeers() {
        int peers = 0;
        for (int i = 0; i < this._transports.size(); ++i) {
            peers += this._transports.get(i).countActivePeers();
        }
        return peers;
    }

    public int countActiveSendPeers() {
        int peers = 0;
        for (int i = 0; i < this._transports.size(); ++i) {
            peers += this._transports.get(i).countActiveSendPeers();
        }
        return peers;
    }

    public boolean haveOutboundCapacity(int pct) {
        for (int i = 0; i < this._transports.size(); ++i) {
            if (!this._transports.get(i).haveCapacity(pct)) continue;
            return true;
        }
        return false;
    }

    public boolean haveHighOutboundCapacity() {
        if (this._transports.size() <= 0) {
            return false;
        }
        for (int i = 0; i < this._transports.size(); ++i) {
            if (this._transports.get(i).haveCapacity(50)) continue;
            return false;
        }
        return true;
    }

    public boolean haveInboundCapacity(int pct) {
        for (int i = 0; i < this._transports.size(); ++i) {
            if (this._transports.get(i).getCurrentAddress() == null || !this._transports.get(i).haveCapacity(pct)) continue;
            return true;
        }
        return false;
    }

    public Vector getClockSkews() {
        Vector skews = new Vector();
        for (int i = 0; i < this._transports.size(); ++i) {
            Vector tempSkews = this._transports.get(i).getClockSkews();
            if (tempSkews == null || tempSkews.size() <= 0) continue;
            skews.addAll(tempSkews);
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Transport manager returning " + skews.size() + " peer clock skews.");
        }
        return skews;
    }

    public short getReachabilityStatus() {
        short rv = 4;
        for (Transport t : this._transports) {
            short s = t.getReachabilityStatus();
            if (s >= rv) continue;
            rv = s;
        }
        return rv;
    }

    public void recheckReachability() {
        for (int i = 0; i < this._transports.size(); ++i) {
            this._transports.get(i).recheckReachability();
        }
    }

    public boolean isBacklogged(Hash dest) {
        for (int i = 0; i < this._transports.size(); ++i) {
            Transport t = this._transports.get(i);
            if (!t.isBacklogged(dest)) continue;
            return true;
        }
        return false;
    }

    public boolean isEstablished(Hash dest) {
        for (int i = 0; i < this._transports.size(); ++i) {
            Transport t = this._transports.get(i);
            if (!t.isEstablished(dest)) continue;
            return true;
        }
        return false;
    }

    public boolean wasUnreachable(Hash dest) {
        for (int i = 0; i < this._transports.size(); ++i) {
            Transport t = this._transports.get(i);
            if (t.wasUnreachable(dest)) continue;
            return false;
        }
        return true;
    }

    public byte[] getIP(Hash dest) {
        return TransportImpl.getIP(dest);
    }

    public Map<String, RouterAddress> getAddresses() {
        HashMap<String, RouterAddress> rv = new HashMap<String, RouterAddress>(this._transports.size());
        for (Transport t : this._transports) {
            if (t.getCurrentAddress() == null) continue;
            rv.put(t.getStyle(), t.getCurrentAddress());
        }
        return rv;
    }

    private Map<String, Integer> getPorts() {
        HashMap<String, Integer> rv = new HashMap<String, Integer>(this._transports.size());
        for (Transport t : this._transports) {
            Transport udp;
            String s;
            Properties opts;
            int port = t.getRequestedPort();
            if (t.getCurrentAddress() != null && (opts = t.getCurrentAddress().getOptions()) != null && (s = opts.getProperty("port")) != null) {
                try {
                    port = Integer.parseInt(s);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            if (t.getStyle().equals("NTCP") && port <= 0 && Boolean.valueOf(this._context.getProperty("i2np.ntcp.autoport")).booleanValue() && (udp = this.getTransport("SSU")) != null) {
                port = t.getRequestedPort();
            }
            if (port <= 0) continue;
            rv.put(t.getStyle(), port);
        }
        return rv;
    }

    public TransportBid getBid(OutNetMessage msg) {
        List bids = this.getBids(msg);
        if (bids == null || bids.size() <= 0) {
            return null;
        }
        return (TransportBid)bids.get(0);
    }

    public List getBids(OutNetMessage msg) {
        if (msg == null) {
            throw new IllegalArgumentException("Null message?  no bidding on a null outNetMessage!");
        }
        if (this._context.router().getRouterInfo().equals((Object)msg.getTarget())) {
            throw new IllegalArgumentException("WTF, bids for a message bound to ourselves?");
        }
        ArrayList<TransportBid> rv = new ArrayList<TransportBid>(this._transports.size());
        Set failedTransports = msg.getFailedTransports();
        for (int i = 0; i < this._transports.size(); ++i) {
            Transport t = this._transports.get(i);
            if (failedTransports.contains(t.getStyle())) {
                if (!this._log.shouldLog(10)) continue;
                this._log.debug("Skipping transport " + t.getStyle() + " as it already failed");
                continue;
            }
            TransportBid bid = t.bid(msg.getTarget(), msg.getMessageSize());
            if (bid != null) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Transport " + t.getStyle() + " bid: " + bid);
                }
                rv.add(bid);
                continue;
            }
            if (!this._log.shouldLog(10)) continue;
            this._log.debug("Transport " + t.getStyle() + " did not produce a bid");
        }
        return rv;
    }

    public TransportBid getNextBid(OutNetMessage msg) {
        int unreachableTransports = 0;
        Hash peer = msg.getTarget().getIdentity().calculateHash();
        Set failedTransports = msg.getFailedTransports();
        TransportBid rv = null;
        for (int i = 0; i < this._transports.size(); ++i) {
            Transport t = this._transports.get(i);
            if (t.isUnreachable(peer)) {
                ++unreachableTransports;
                msg.transportFailed(t.getStyle());
                continue;
            }
            if (failedTransports.contains(t.getStyle())) {
                if (!this._log.shouldLog(10)) continue;
                this._log.debug("Skipping transport " + t.getStyle() + " as it already failed");
                continue;
            }
            TransportBid bid = t.bid(msg.getTarget(), msg.getMessageSize());
            if (bid != null) {
                if (bid.getLatencyMs() == 999999) {
                    msg.transportFailed(t.getStyle());
                } else if (rv == null || rv.getLatencyMs() > bid.getLatencyMs()) {
                    rv = bid;
                }
                if (!this._log.shouldLog(10)) continue;
                this._log.debug("Transport " + t.getStyle() + " bid: " + bid + " currently winning? " + (rv == bid) + " (winning latency: " + rv.getLatencyMs() + " / " + rv + ")");
                continue;
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("Transport " + t.getStyle() + " did not produce a bid");
            }
            if (!t.isUnreachable(peer)) continue;
            ++unreachableTransports;
        }
        if (unreachableTransports >= this._transports.size()) {
            if (unreachableTransports >= this._transports.size() && this.countActivePeers() > 0) {
                this._context.statManager().addRateData("transport.shitlistOnUnreachable", msg.getLifetime(), msg.getLifetime());
                this._context.shitlist().shitlistRouter(peer, "Unreachable on any transport");
            }
        } else if (rv == null) {
            this._context.statManager().addRateData("transport.noBidsYetNotAllUnreachable", (long)unreachableTransports, msg.getLifetime());
        }
        return rv;
    }

    @Override
    public void messageReceived(I2NPMessage message, RouterIdentity fromRouter, Hash fromRouterHash) {
        block4: {
            if (this._log.shouldLog(10)) {
                this._log.debug("I2NPMessage received: " + message.getClass().getName(), (Throwable)new Exception("Where did I come from again?"));
            }
            try {
                int num = this._context.inNetMessagePool().add(message, fromRouter, fromRouterHash);
                if (this._log.shouldLog(10)) {
                    this._log.debug("Added to in pool: " + num);
                }
            }
            catch (IllegalArgumentException iae) {
                if (!this._log.shouldLog(30)) break block4;
                this._log.warn("Error receiving message", (Throwable)iae);
            }
        }
    }

    @Override
    public void transportAddressChanged() {
        if (this._upnpManager != null) {
            this._upnpManager.update(this.getPorts());
        }
    }

    public List getMostRecentErrorMessages() {
        ArrayList rv = new ArrayList(16);
        for (int i = 0; i < this._transports.size(); ++i) {
            Transport t = this._transports.get(i);
            rv.addAll(t.getMostRecentErrorMessages());
        }
        return rv;
    }

    public void renderStatusHTML(Writer out, String urlBase, int sortFlags) throws IOException {
        TreeMap<String, Transport> transports = new TreeMap<String, Transport>();
        for (int i = 0; i < this._transports.size(); ++i) {
            Transport t = this._transports.get(i);
            transports.put(t.getStyle(), t);
        }
        for (Transport t : transports.values()) {
            t.renderStatusHTML(out, urlBase, sortFlags);
        }
        StringBuilder buf = new StringBuilder(4096);
        buf.append("<h3>Router Transport Addresses:</h3><pre>\n");
        for (int i = 0; i < this._transports.size(); ++i) {
            Transport t = this._transports.get(i);
            if (t.getCurrentAddress() != null) {
                buf.append(t.getCurrentAddress()).append("\n\n");
                continue;
            }
            buf.append(t.getStyle()).append(" is used for outbound connections only\n\n");
        }
        buf.append("</pre>\n");
        out.write(buf.toString());
        if (this._upnpManager != null) {
            out.write(this._upnpManager.renderStatusHTML());
        }
        buf.append("</p>\n");
        out.flush();
    }
}

