/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.router.transport.FIFOBandwidthRefiller;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

public class FIFOBandwidthLimiter {
    private Log _log;
    private I2PAppContext _context;
    private final List _pendingInboundRequests;
    private final List _pendingOutboundRequests;
    private volatile int _availableInbound;
    private volatile int _availableOutbound;
    private volatile int _unavailableInboundBurst;
    private volatile int _unavailableOutboundBurst;
    private int _maxInboundBurst;
    private int _maxOutboundBurst;
    private int _maxInbound;
    private int _maxOutbound;
    private boolean _outboundUnlimited;
    private boolean _inboundUnlimited;
    private volatile long _totalAllocatedInboundBytes;
    private volatile long _totalAllocatedOutboundBytes;
    private volatile long _totalWastedInboundBytes;
    private volatile long _totalWastedOutboundBytes;
    private FIFOBandwidthRefiller _refiller;
    private long _lastTotalSent;
    private long _lastTotalReceived;
    private long _lastStatsUpdated;
    private float _sendBps;
    private float _recvBps;
    private float _sendBps15s;
    private float _recvBps15s;
    private static int __id = 0;
    private static long __requestId = 0L;
    private static final NoopRequest _noop = new NoopRequest();

    public long now() {
        return System.currentTimeMillis();
    }

    public FIFOBandwidthLimiter(I2PAppContext context) {
        this._context = context;
        this._log = context.logManager().getLog(FIFOBandwidthLimiter.class);
        this._context.statManager().createRateStat("bwLimiter.pendingOutboundRequests", "How many outbound requests are ahead of the current one (ignoring ones with 0)?", "BandwidthLimiter", new long[]{60000L, 300000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("bwLimiter.pendingInboundRequests", "How many inbound requests are ahead of the current one (ignoring ones with 0)?", "BandwidthLimiter", new long[]{60000L, 300000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("bwLimiter.outboundDelayedTime", "How long it takes to honor an outbound request (ignoring ones with that go instantly)?", "BandwidthLimiter", new long[]{60000L, 300000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("bwLimiter.inboundDelayedTime", "How long it takes to honor an inbound request (ignoring ones with that go instantly)?", "BandwidthLimiter", new long[]{60000L, 300000L, 600000L, 3600000L});
        if (this._log.shouldLog(30)) {
            this._context.statManager().createRateStat("bw.sendBps1s", "How fast we are transmitting for the 1s quantization (period is the number of bytes transmitted)?", "Bandwidth", new long[]{60000L, 600000L});
            this._context.statManager().createRateStat("bw.recvBps1s", "How fast we are receiving for the 1s quantization (period is the number of bytes transmitted)?", "Bandwidth", new long[]{60000L, 600000L});
            this._context.statManager().createRateStat("bw.sendBps15s", "How fast we are transmitting for the 15s quantization (period is the number of bytes transmitted)?", "Bandwidth", new long[]{60000L, 600000L});
            this._context.statManager().createRateStat("bw.recvBps15s", "How fast we are receiving for the 15s quantization (period is the number of bytes transmitted)?", "Bandwidth", new long[]{60000L, 600000L});
        }
        this._pendingInboundRequests = new ArrayList(16);
        this._pendingOutboundRequests = new ArrayList(16);
        this._lastTotalSent = this._totalAllocatedOutboundBytes;
        this._lastTotalReceived = this._totalAllocatedInboundBytes;
        this._sendBps = 0.0f;
        this._recvBps = 0.0f;
        this._lastStatsUpdated = this.now();
        this._refiller = new FIFOBandwidthRefiller(this._context, this);
        I2PThread t = new I2PThread((Runnable)this._refiller);
        t.setName("BWRefiller" + ++__id);
        t.setDaemon(true);
        t.setPriority(4);
        t.start();
    }

    public long getTotalAllocatedInboundBytes() {
        return this._totalAllocatedInboundBytes;
    }

    public long getTotalAllocatedOutboundBytes() {
        return this._totalAllocatedOutboundBytes;
    }

    public long getTotalWastedInboundBytes() {
        return this._totalWastedInboundBytes;
    }

    public long getTotalWastedOutboundBytes() {
        return this._totalWastedOutboundBytes;
    }

    public boolean getInboundUnlimited() {
        return this._inboundUnlimited;
    }

    public void setInboundUnlimited(boolean isUnlimited) {
        this._inboundUnlimited = isUnlimited;
    }

    public boolean getOutboundUnlimited() {
        return this._outboundUnlimited;
    }

    public void setOutboundUnlimited(boolean isUnlimited) {
        this._outboundUnlimited = isUnlimited;
    }

    public float getSendBps() {
        return this._sendBps;
    }

    public float getReceiveBps() {
        return this._recvBps;
    }

    public float getSendBps15s() {
        return this._sendBps15s;
    }

    public float getReceiveBps15s() {
        return this._recvBps15s;
    }

    public int getOutboundKBytesPerSecond() {
        return this._refiller.getOutboundKBytesPerSecond();
    }

    public int getInboundKBytesPerSecond() {
        return this._refiller.getInboundKBytesPerSecond();
    }

    public int getOutboundBurstKBytesPerSecond() {
        return this._refiller.getOutboundBurstKBytesPerSecond();
    }

    public int getInboundBurstKBytesPerSecond() {
        return this._refiller.getInboundBurstKBytesPerSecond();
    }

    public void reinitialize() {
        this._pendingInboundRequests.clear();
        this._pendingOutboundRequests.clear();
        this._availableInbound = 0;
        this._availableOutbound = 0;
        this._maxInbound = 0;
        this._maxOutbound = 0;
        this._maxInboundBurst = 0;
        this._maxOutboundBurst = 0;
        this._unavailableInboundBurst = 0;
        this._unavailableOutboundBurst = 0;
        this._inboundUnlimited = false;
        this._outboundUnlimited = false;
        this._refiller.reinitialize();
    }

    public Request createRequest() {
        return new SimpleRequest();
    }

    public Request requestInbound(int bytesIn, String purpose) {
        return this.requestInbound(bytesIn, purpose, null, null);
    }

    public Request requestInbound(int bytesIn, String purpose, CompleteListener lsnr, Object attachment) {
        if (this._inboundUnlimited) {
            this._totalAllocatedInboundBytes += (long)bytesIn;
            return _noop;
        }
        SimpleRequest req = new SimpleRequest(bytesIn, 0, purpose, lsnr, attachment);
        this.requestInbound(req, bytesIn, purpose);
        return req;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestInbound(Request req, int bytesIn, String purpose) {
        req.init(bytesIn, 0, purpose);
        int pending = 0;
        List list = this._pendingInboundRequests;
        synchronized (list) {
            pending = this._pendingInboundRequests.size();
            this._pendingInboundRequests.add(req);
        }
        this.satisfyInboundRequests(((SimpleRequest)req).satisfiedBuffer);
        ((SimpleRequest)req).satisfiedBuffer.clear();
        if (pending > 0) {
            this._context.statManager().addRateData("bwLimiter.pendingInboundRequests", (long)pending, (long)pending);
        }
    }

    public Request requestOutbound(int bytesOut, String purpose) {
        return this.requestOutbound(bytesOut, purpose, null, null);
    }

    public Request requestOutbound(int bytesOut, String purpose, CompleteListener lsnr, Object attachment) {
        if (this._outboundUnlimited) {
            this._totalAllocatedOutboundBytes += (long)bytesOut;
            return _noop;
        }
        SimpleRequest req = new SimpleRequest(0, bytesOut, purpose, lsnr, attachment);
        this.requestOutbound(req, bytesOut, purpose);
        return req;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestOutbound(Request req, int bytesOut, String purpose) {
        req.init(0, bytesOut, purpose);
        int pending = 0;
        List list = this._pendingOutboundRequests;
        synchronized (list) {
            pending = this._pendingOutboundRequests.size();
            this._pendingOutboundRequests.add(req);
        }
        this.satisfyOutboundRequests(((SimpleRequest)req).satisfiedBuffer);
        ((SimpleRequest)req).satisfiedBuffer.clear();
        if (pending > 0) {
            this._context.statManager().addRateData("bwLimiter.pendingOutboundRequests", (long)pending, (long)pending);
        }
    }

    void setInboundBurstKBps(int kbytesPerSecond) {
        this._maxInbound = kbytesPerSecond * 1024;
    }

    void setOutboundBurstKBps(int kbytesPerSecond) {
        this._maxOutbound = kbytesPerSecond * 1024;
    }

    public int getInboundBurstBytes() {
        return this._maxInboundBurst;
    }

    public int getOutboundBurstBytes() {
        return this._maxOutboundBurst;
    }

    void setInboundBurstBytes(int bytes) {
        this._maxInboundBurst = bytes;
    }

    void setOutboundBurstBytes(int bytes) {
        this._maxOutboundBurst = bytes;
    }

    StringBuilder getStatus() {
        StringBuilder rv = new StringBuilder(64);
        rv.append("Available: ").append(this._availableInbound).append('/').append(this._availableOutbound).append(' ');
        rv.append("Max: ").append(this._maxInbound).append('/').append(this._maxOutbound).append(' ');
        rv.append("Burst: ").append(this._unavailableInboundBurst).append('/').append(this._unavailableOutboundBurst).append(' ');
        rv.append("Burst max: ").append(this._maxInboundBurst).append('/').append(this._maxOutboundBurst).append(' ');
        return rv;
    }

    final void refillBandwidthQueues(List buf, long bytesInbound, long bytesOutbound, long maxBurstIn, long maxBurstOut) {
        int want;
        if (this._log.shouldLog(10)) {
            this._log.debug("Refilling the queues with " + bytesInbound + "/" + bytesOutbound + ": " + this.getStatus().toString());
        }
        this._availableInbound = (int)((long)this._availableInbound + bytesInbound);
        this._availableOutbound = (int)((long)this._availableOutbound + bytesOutbound);
        if (this._availableInbound > this._maxInbound) {
            if (this._log.shouldLog(10)) {
                this._log.debug("available inbound (" + this._availableInbound + ") exceeds our inbound burst (" + this._maxInbound + "), so no supplement");
            }
            this._unavailableInboundBurst += this._availableInbound - this._maxInbound;
            this._availableInbound = this._maxInbound;
            if (this._unavailableInboundBurst > this._maxInboundBurst) {
                this._totalWastedInboundBytes += (long)(this._unavailableInboundBurst - this._maxInboundBurst);
                this._unavailableInboundBurst = this._maxInboundBurst;
            }
        } else {
            want = (int)maxBurstIn;
            if (want > this._maxInbound - this._availableInbound) {
                want = this._maxInbound - this._availableInbound;
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("want to pull " + want + " from the inbound burst (" + this._unavailableInboundBurst + ") to supplement " + this._availableInbound + " (max: " + this._maxInbound + ")");
            }
            if (want > 0) {
                if (want <= this._unavailableInboundBurst) {
                    this._availableInbound += want;
                    this._unavailableInboundBurst -= want;
                } else {
                    this._availableInbound += this._unavailableInboundBurst;
                    this._unavailableInboundBurst = 0;
                }
            }
        }
        if (this._availableOutbound > this._maxOutbound) {
            if (this._log.shouldLog(10)) {
                this._log.debug("available outbound (" + this._availableOutbound + ") exceeds our outbound burst (" + this._maxOutbound + "), so no supplement");
            }
            this._unavailableOutboundBurst += this._availableOutbound - this._maxOutbound;
            this._availableOutbound = this._maxOutbound;
            if (this._unavailableOutboundBurst > this._maxOutboundBurst) {
                this._totalWastedOutboundBytes += (long)(this._unavailableOutboundBurst - this._maxOutboundBurst);
                this._unavailableOutboundBurst = this._maxOutboundBurst;
            }
        } else {
            want = (int)maxBurstOut;
            if (want > this._maxOutbound - this._availableOutbound) {
                want = this._maxOutbound - this._availableOutbound;
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("want to pull " + want + " from the outbound burst (" + this._unavailableOutboundBurst + ") to supplement " + this._availableOutbound + " (max: " + this._maxOutbound + ")");
            }
            if (want > 0) {
                if (want <= this._unavailableOutboundBurst) {
                    this._availableOutbound += want;
                    this._unavailableOutboundBurst -= want;
                } else {
                    this._availableOutbound += this._unavailableOutboundBurst;
                    this._unavailableOutboundBurst = 0;
                }
            }
        }
        this.satisfyRequests(buf);
        this.updateStats();
    }

    private void updateStats() {
        long now = this.now();
        long time = now - this._lastStatsUpdated;
        if (time >= 1000L) {
            long totS = this._totalAllocatedOutboundBytes;
            long totR = this._totalAllocatedInboundBytes;
            long sent = totS - this._lastTotalSent;
            long recv = totR - this._lastTotalReceived;
            this._lastTotalSent = totS;
            this._lastTotalReceived = totR;
            this._lastStatsUpdated = now;
            this._sendBps = this._sendBps <= 0.0f ? (float)sent * 1000.0f / (float)time : 0.9f * this._sendBps + 0.1f * ((float)sent * 1000.0f) / (float)time;
            this._recvBps = this._recvBps <= 0.0f ? (float)recv * 1000.0f / (float)time : 0.9f * this._recvBps + 0.1f * ((float)recv * 1000.0f) / (float)time;
            this._sendBps15s = 0.955f * this._sendBps15s + 0.045f * ((float)sent * 1000.0f) / (float)time;
            this._recvBps15s = 0.955f * this._recvBps15s + 0.045f * ((float)recv * 1000.0f) / (float)time;
        }
    }

    private final void satisfyRequests(List buffer) {
        buffer.clear();
        this.satisfyInboundRequests(buffer);
        buffer.clear();
        this.satisfyOutboundRequests(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void satisfyInboundRequests(List satisfied) {
        List list = this._pendingInboundRequests;
        synchronized (list) {
            if (this._inboundUnlimited) {
                this.locked_satisfyInboundUnlimited(satisfied);
            } else if (this._availableInbound > 0) {
                this.locked_satisfyInboundAvailable(satisfied);
            } else if (this._log.shouldLog(10)) {
                this._log.debug("Still denying the " + this._pendingInboundRequests.size() + " pending inbound requests (status: " + this.getStatus().toString() + ", longest waited " + this.locked_getLongestInboundWait() + " in)");
            }
        }
        if (satisfied != null) {
            for (int i = 0; i < satisfied.size(); ++i) {
                SimpleRequest creq = (SimpleRequest)satisfied.get(i);
                creq.notifyAllocation();
            }
        }
    }

    private long locked_getLongestInboundWait() {
        long start = -1L;
        for (int i = 0; i < this._pendingInboundRequests.size(); ++i) {
            SimpleRequest req = (SimpleRequest)this._pendingInboundRequests.get(i);
            if (start >= 0L && start <= req.getRequestTime()) continue;
            start = req.getRequestTime();
        }
        if (start == -1L) {
            return 0L;
        }
        return this.now() - start;
    }

    private long locked_getLongestOutboundWait() {
        long start = -1L;
        for (int i = 0; i < this._pendingOutboundRequests.size(); ++i) {
            SimpleRequest req = (SimpleRequest)this._pendingOutboundRequests.get(i);
            if (req == null || start >= 0L && start <= req.getRequestTime()) continue;
            start = req.getRequestTime();
        }
        if (start == -1L) {
            return 0L;
        }
        return this.now() - start;
    }

    private final void locked_satisfyInboundUnlimited(List satisfied) {
        while (this._pendingInboundRequests.size() > 0) {
            SimpleRequest req = (SimpleRequest)this._pendingInboundRequests.remove(0);
            int allocated = req.getPendingInboundRequested();
            this._totalAllocatedInboundBytes += (long)allocated;
            req.allocateBytes(allocated, 0);
            satisfied.add(req);
            long waited = this.now() - req.getRequestTime();
            if (this._log.shouldLog(10)) {
                this._log.debug("Granting inbound request " + req.getRequestName() + " fully for " + req.getTotalInboundRequested() + " bytes (waited " + waited + "ms) pending " + this._pendingInboundRequests.size());
            }
            if (waited <= 10L) continue;
            this._context.statManager().addRateData("bwLimiter.inboundDelayedTime", waited, waited);
        }
    }

    private final void locked_satisfyInboundAvailable(List satisfied) {
        for (int i = 0; i < this._pendingInboundRequests.size() && this._availableInbound > 0; ++i) {
            SimpleRequest req = (SimpleRequest)this._pendingInboundRequests.get(i);
            long waited = this.now() - req.getRequestTime();
            if (req.getAborted()) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Aborting inbound request to " + req.getRequestName() + " (total " + req.getTotalInboundRequested() + " bytes, waited " + waited + "ms) pending " + this._pendingInboundRequests.size());
                }
                this._pendingInboundRequests.remove(i);
                --i;
                continue;
            }
            if (req.getAllocationsSinceWait() > 0 && req.getCompleteListener() == null) continue;
            int requested = req.getPendingInboundRequested();
            int allocated = 0;
            allocated = this._availableInbound > requested ? requested : this._availableInbound;
            this._availableInbound -= allocated;
            this._totalAllocatedInboundBytes += (long)allocated;
            req.allocateBytes(allocated, 0);
            satisfied.add(req);
            if (req.getPendingInboundRequested() > 0) {
                if (!this._log.shouldLog(10)) continue;
                this._log.debug("Allocating " + allocated + " bytes inbound as a partial grant to " + req.getRequestName() + " (wanted " + req.getTotalInboundRequested() + " bytes, waited " + waited + "ms) pending " + this._pendingInboundRequests.size() + ", longest waited " + this.locked_getLongestInboundWait() + " in");
                continue;
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("Allocating " + allocated + " bytes inbound to finish the partial grant to " + req.getRequestName() + " (total " + req.getTotalInboundRequested() + " bytes, waited " + waited + "ms) pending " + this._pendingInboundRequests.size() + ", longest waited " + this.locked_getLongestInboundWait() + " out");
            }
            this._pendingInboundRequests.remove(i);
            --i;
            if (waited <= 10L) continue;
            this._context.statManager().addRateData("bwLimiter.inboundDelayedTime", waited, waited);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void satisfyOutboundRequests(List satisfied) {
        List list = this._pendingOutboundRequests;
        synchronized (list) {
            if (this._outboundUnlimited) {
                this.locked_satisfyOutboundUnlimited(satisfied);
            } else if (this._availableOutbound > 0) {
                this.locked_satisfyOutboundAvailable(satisfied);
            } else if (this._log.shouldLog(20)) {
                this._log.info("Still denying the " + this._pendingOutboundRequests.size() + " pending outbound requests (status: " + this.getStatus().toString() + ", longest waited " + this.locked_getLongestOutboundWait() + " out)");
            }
        }
        if (satisfied != null) {
            for (int i = 0; i < satisfied.size(); ++i) {
                SimpleRequest creq = (SimpleRequest)satisfied.get(i);
                creq.notifyAllocation();
            }
        }
    }

    private final void locked_satisfyOutboundUnlimited(List satisfied) {
        while (this._pendingOutboundRequests.size() > 0) {
            SimpleRequest req = (SimpleRequest)this._pendingOutboundRequests.remove(0);
            int allocated = req.getPendingOutboundRequested();
            this._totalAllocatedOutboundBytes += (long)allocated;
            req.allocateBytes(0, allocated);
            satisfied.add(req);
            long waited = this.now() - req.getRequestTime();
            if (this._log.shouldLog(10)) {
                this._log.debug("Granting outbound request " + req.getRequestName() + " fully for " + req.getTotalOutboundRequested() + " bytes (waited " + waited + "ms) pending " + this._pendingOutboundRequests.size() + ", longest waited " + this.locked_getLongestOutboundWait() + " out");
            }
            if (waited <= 10L) continue;
            this._context.statManager().addRateData("bwLimiter.outboundDelayedTime", waited, waited);
        }
    }

    private final void locked_satisfyOutboundAvailable(List satisfied) {
        for (int i = 0; i < this._pendingOutboundRequests.size() && this._availableOutbound > 0; ++i) {
            SimpleRequest req = (SimpleRequest)this._pendingOutboundRequests.get(i);
            long waited = this.now() - req.getRequestTime();
            if (req.getAborted()) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Aborting outbound request to " + req.getRequestName() + " (total " + req.getTotalOutboundRequested() + " bytes, waited " + waited + "ms) pending " + this._pendingOutboundRequests.size());
                }
                this._pendingOutboundRequests.remove(i);
                --i;
                continue;
            }
            if (req.getAllocationsSinceWait() > 0) {
                if (!this._log.shouldLog(30)) continue;
                this._log.warn("multiple allocations since wait... ntcp shouldn't do this: " + req.getRequestName());
                continue;
            }
            int requested = req.getPendingOutboundRequested();
            int allocated = 0;
            allocated = this._availableOutbound > requested ? requested : this._availableOutbound;
            this._availableOutbound -= allocated;
            this._totalAllocatedOutboundBytes += (long)allocated;
            req.allocateBytes(0, allocated);
            satisfied.add(req);
            if (req.getPendingOutboundRequested() > 0) {
                if (req.attachment() != null && this._log.shouldLog(20)) {
                    this._log.info("Allocating " + allocated + " bytes outbound as a partial grant to " + req.getRequestName() + " (wanted " + req.getTotalOutboundRequested() + " bytes, waited " + waited + "ms) pending " + this._pendingOutboundRequests.size() + ", longest waited " + this.locked_getLongestOutboundWait() + " out");
                }
                if (!this._log.shouldLog(10)) continue;
                this._log.debug("Allocating " + allocated + " bytes outbound as a partial grant to " + req.getRequestName() + " (wanted " + req.getTotalOutboundRequested() + " bytes, waited " + waited + "ms) pending " + this._pendingOutboundRequests.size() + ", longest waited " + this.locked_getLongestOutboundWait() + " out");
                continue;
            }
            if (req.attachment() != null && this._log.shouldLog(20)) {
                this._log.info("Allocating " + allocated + " bytes outbound to finish the partial grant to " + req.getRequestName() + " (total " + req.getTotalOutboundRequested() + " bytes, waited " + waited + "ms) pending " + this._pendingOutboundRequests.size() + ", longest waited " + this.locked_getLongestOutboundWait() + " out)");
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("Allocating " + allocated + " bytes outbound to finish the partial grant to " + req.getRequestName() + " (total " + req.getTotalOutboundRequested() + " bytes, waited " + waited + "ms) pending " + this._pendingOutboundRequests.size() + ", longest waited " + this.locked_getLongestOutboundWait() + " out)");
            }
            this._pendingOutboundRequests.remove(i);
            --i;
            if (waited <= 10L) continue;
            this._context.statManager().addRateData("bwLimiter.outboundDelayedTime", waited, waited);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderStatusHTML(Writer out) throws IOException {
        Request req;
        int i;
        long now = this.now();
        StringBuilder buf = new StringBuilder(4096);
        buf.append("<h3><b id=\"bwlim\">Limiter Status:</b></h3>").append(this.getStatus().toString()).append("\n");
        buf.append("<h3>Pending bandwidth requests:</h3><ul>");
        buf.append("<li>Inbound requests: <ol>");
        List list = this._pendingInboundRequests;
        synchronized (list) {
            for (i = 0; i < this._pendingInboundRequests.size(); ++i) {
                req = (Request)this._pendingInboundRequests.get(i);
                buf.append("<li>").append(req.getRequestName()).append(" for ");
                buf.append(req.getTotalInboundRequested()).append(" bytes ");
                buf.append("requested (").append(req.getPendingInboundRequested()).append(" pending) as of ");
                buf.append(now - req.getRequestTime());
                buf.append("ms ago</li>\n");
            }
        }
        buf.append("</ol></li><li>Outbound requests: <ol>\n");
        list = this._pendingOutboundRequests;
        synchronized (list) {
            for (i = 0; i < this._pendingOutboundRequests.size(); ++i) {
                req = (Request)this._pendingOutboundRequests.get(i);
                buf.append("<li>").append(req.getRequestName()).append(" for ");
                buf.append(req.getTotalOutboundRequested()).append(" bytes ");
                buf.append("requested (").append(req.getPendingOutboundRequested()).append(" pending) as of ");
                buf.append(now - req.getRequestTime());
                buf.append("ms ago</li>\n");
            }
        }
        buf.append("</ol></li></ul><hr>\n");
        out.write(buf.toString());
        out.flush();
    }

    private static class NoopRequest
    implements Request {
        private CompleteListener _lsnr;
        private Object _attachment;

        private NoopRequest() {
        }

        public void abort() {
        }

        public boolean getAborted() {
            return false;
        }

        public int getPendingInboundRequested() {
            return 0;
        }

        public int getPendingOutboundRequested() {
            return 0;
        }

        public String getRequestName() {
            return "noop";
        }

        public long getRequestTime() {
            return 0L;
        }

        public int getTotalInboundRequested() {
            return 0;
        }

        public int getTotalOutboundRequested() {
            return 0;
        }

        public void waitForNextAllocation() {
        }

        public void init(int in, int out, String target) {
        }

        public CompleteListener getCompleteListener() {
            return this._lsnr;
        }

        public void setCompleteListener(CompleteListener lsnr) {
            this._lsnr = lsnr;
            lsnr.complete(this);
        }

        public void attach(Object obj) {
            this._attachment = obj;
        }

        public Object attachment() {
            return this._attachment;
        }
    }

    public static interface CompleteListener {
        public void complete(Request var1);
    }

    public static interface Request {
        public String getRequestName();

        public long getRequestTime();

        public int getTotalOutboundRequested();

        public int getPendingOutboundRequested();

        public int getTotalInboundRequested();

        public int getPendingInboundRequested();

        public void waitForNextAllocation();

        public void abort();

        public boolean getAborted();

        public void init(int var1, int var2, String var3);

        public void setCompleteListener(CompleteListener var1);

        public void attach(Object var1);

        public Object attachment();

        public CompleteListener getCompleteListener();
    }

    private final class SimpleRequest
    implements Request {
        private int _inAllocated;
        private int _inTotal;
        private int _outAllocated;
        private int _outTotal;
        private long _requestId;
        private long _requestTime;
        private String _target;
        private int _allocationsSinceWait;
        private boolean _aborted;
        private boolean _waited;
        List satisfiedBuffer = new ArrayList(1);
        private CompleteListener _lsnr;
        private Object _attachment;

        public SimpleRequest() {
            this.init(0, 0, null);
        }

        public SimpleRequest(int in, int out, String target) {
            this.init(in, out, target);
        }

        public SimpleRequest(int in, int out, String target, CompleteListener lsnr, Object attachment) {
            this._lsnr = lsnr;
            this._attachment = attachment;
            this.init(in, out, target);
        }

        public void init(int in, int out, String target) {
            this._waited = false;
            this._inTotal = in;
            this._outTotal = out;
            this._inAllocated = 0;
            this._outAllocated = 0;
            this._aborted = false;
            this._target = target;
            this.satisfiedBuffer.clear();
            this._requestId = ++__requestId;
            this._requestTime = FIFOBandwidthLimiter.this.now();
        }

        public Object getAvailabilityMonitor() {
            return this;
        }

        public String getRequestName() {
            return "Req" + this._requestId + " to " + this._target;
        }

        public long getRequestTime() {
            return this._requestTime;
        }

        public int getTotalOutboundRequested() {
            return this._outTotal;
        }

        public int getPendingOutboundRequested() {
            return this._outTotal - this._outAllocated;
        }

        public int getTotalInboundRequested() {
            return this._inTotal;
        }

        public int getPendingInboundRequested() {
            return this._inTotal - this._inAllocated;
        }

        public boolean getAborted() {
            return this._aborted;
        }

        public void abort() {
            this._aborted = true;
        }

        public CompleteListener getCompleteListener() {
            return this._lsnr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setCompleteListener(CompleteListener lsnr) {
            boolean complete = false;
            SimpleRequest simpleRequest = this;
            synchronized (simpleRequest) {
                this._lsnr = lsnr;
                if (this.isComplete()) {
                    complete = true;
                }
            }
            if (complete && lsnr != null) {
                if (FIFOBandwidthLimiter.this._log.shouldLog(20)) {
                    FIFOBandwidthLimiter.this._log.info("complete listener set AND completed: " + lsnr);
                }
                lsnr.complete(this);
            }
        }

        private boolean isComplete() {
            return this._outAllocated >= this._outTotal && this._inAllocated >= this._inTotal;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForNextAllocation() {
            this._waited = true;
            this._allocationsSinceWait = 0;
            boolean complete = false;
            try {
                SimpleRequest simpleRequest = this;
                synchronized (simpleRequest) {
                    if (this.isComplete()) {
                        complete = true;
                    } else {
                        this.wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (complete && this._lsnr != null) {
                this._lsnr.complete(this);
            }
        }

        int getAllocationsSinceWait() {
            return this._waited ? this._allocationsSinceWait : 0;
        }

        void allocateAll() {
            this._inAllocated = this._inTotal;
            this._outAllocated = this._outTotal;
            this._outAllocated = this._outTotal;
            if (this._lsnr == null) {
                ++this._allocationsSinceWait;
            }
            if (FIFOBandwidthLimiter.this._log.shouldLog(10)) {
                FIFOBandwidthLimiter.this._log.debug("allocate all");
            }
            this.notifyAllocation();
        }

        void allocateBytes(int in, int out) {
            this._inAllocated += in;
            this._outAllocated += out;
            if (this._lsnr == null) {
                ++this._allocationsSinceWait;
            }
            if (this.isComplete() && FIFOBandwidthLimiter.this._log.shouldLog(20)) {
                FIFOBandwidthLimiter.this._log.info("allocate " + in + "/" + out + " completed, listener=" + this._lsnr);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void notifyAllocation() {
            boolean complete = false;
            SimpleRequest simpleRequest = this;
            synchronized (simpleRequest) {
                if (this.isComplete()) {
                    complete = true;
                }
                this.notifyAll();
            }
            if (complete && this._lsnr != null) {
                this._lsnr.complete(this);
                if (FIFOBandwidthLimiter.this._log.shouldLog(20)) {
                    FIFOBandwidthLimiter.this._log.info("at completion for " + this._inTotal + "/" + this._outTotal + ", recvBps=" + FIFOBandwidthLimiter.this._recvBps + "/" + FIFOBandwidthLimiter.this._recvBps15s + " listener is " + this._lsnr);
                }
            }
        }

        public void attach(Object obj) {
            this._attachment = obj;
        }

        public Object attachment() {
            return this._attachment;
        }

        public String toString() {
            return this.getRequestName();
        }
    }
}

