/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import net.i2p.data.Hash;
import net.i2p.data.RouterAddress;
import net.i2p.data.RouterInfo;
import net.i2p.router.CommSystemFacade;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.GeoIP;
import net.i2p.router.transport.GetBidsJob;
import net.i2p.router.transport.Transport;
import net.i2p.router.transport.TransportBid;
import net.i2p.router.transport.TransportImpl;
import net.i2p.router.transport.TransportManager;
import net.i2p.router.transport.ntcp.NTCPTransport;
import net.i2p.util.Log;
import net.i2p.util.SimpleScheduler;
import net.i2p.util.SimpleTimer;

public class CommSystemFacadeImpl
extends CommSystemFacade {
    private Log _log;
    private RouterContext _context;
    private TransportManager _manager;
    private GeoIP _geoIP;
    public static final String PROP_I2NP_NTCP_HOSTNAME = "i2np.ntcp.hostname";
    public static final String PROP_I2NP_NTCP_PORT = "i2np.ntcp.port";
    public static final String PROP_I2NP_NTCP_AUTO_PORT = "i2np.ntcp.autoport";
    public static final String PROP_I2NP_NTCP_AUTO_IP = "i2np.ntcp.autoip";
    private static final int START_DELAY = 300000;
    private static final int LOOKUP_TIME = 1800000;

    public CommSystemFacadeImpl(RouterContext context) {
        this._context = context;
        this._log = this._context.logManager().getLog(CommSystemFacadeImpl.class);
        this._manager = null;
        this.startGeoIP();
    }

    public void startup() {
        this._log.info("Starting up the comm system");
        this._manager = new TransportManager(this._context);
        this._manager.startListening();
    }

    public void shutdown() {
        if (this._manager != null) {
            this._manager.stopListening();
        }
    }

    public void restart() {
        if (this._manager == null) {
            this.startup();
        } else {
            this._manager.restart();
        }
    }

    public int countActivePeers() {
        return this._manager == null ? 0 : this._manager.countActivePeers();
    }

    public int countActiveSendPeers() {
        return this._manager == null ? 0 : this._manager.countActiveSendPeers();
    }

    public boolean haveInboundCapacity(int pct) {
        return this._manager == null ? false : this._manager.haveInboundCapacity(pct);
    }

    public boolean haveOutboundCapacity(int pct) {
        return this._manager == null ? false : this._manager.haveOutboundCapacity(pct);
    }

    public boolean haveHighOutboundCapacity() {
        return this._manager == null ? false : this._manager.haveHighOutboundCapacity();
    }

    public Long getFramedAveragePeerClockSkew(int percentToInclude) {
        if (this._manager == null) {
            if (this._log.shouldLog(20)) {
                this._log.info("Returning null for framed averege peer clock skew (no transport manager)!");
            }
            return null;
        }
        Vector skews = this._manager.getClockSkews();
        if (skews == null) {
            if (this._log.shouldLog(40)) {
                this._log.error("Returning null for framed average peer clock skew (no data)!");
            }
            return null;
        }
        if (skews.size() < 20) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Returning null for framed average peer clock skew (only " + skews.size() + " peers)!");
            }
            return null;
        }
        Collections.sort(skews);
        int frameSize = skews.size() * percentToInclude / 100;
        int first = skews.size() / 2 - frameSize / 2;
        int last = skews.size() / 2 + frameSize / 2;
        long sum = 0L;
        for (int i = first; i < last; ++i) {
            long value = (Long)skews.get(i);
            if (this._log.shouldLog(10)) {
                this._log.debug("Adding clock skew " + i + " valued " + value + " s.");
            }
            sum += value;
        }
        Long framedAverageClockSkew = new Long(sum / (long)frameSize);
        if (this._log.shouldLog(20)) {
            this._log.info("Our framed average peer clock skew is " + framedAverageClockSkew + " s.");
        }
        return framedAverageClockSkew;
    }

    public List getBids(OutNetMessage msg) {
        return this._manager.getBids(msg);
    }

    public TransportBid getBid(OutNetMessage msg) {
        return this._manager.getBid(msg);
    }

    public TransportBid getNextBid(OutNetMessage msg) {
        return this._manager.getNextBid(msg);
    }

    int getTransportCount() {
        return this._manager.getTransportCount();
    }

    public void processMessage(OutNetMessage msg) {
        GetBidsJob.getBids(this._context, this, msg);
    }

    public boolean isBacklogged(Hash dest) {
        return this._manager.isBacklogged(dest);
    }

    public boolean isEstablished(Hash dest) {
        return this._manager.isEstablished(dest);
    }

    public boolean wasUnreachable(Hash dest) {
        return this._manager.wasUnreachable(dest);
    }

    public byte[] getIP(Hash dest) {
        return this._manager.getIP(dest);
    }

    public List getMostRecentErrorMessages() {
        return this._manager.getMostRecentErrorMessages();
    }

    public short getReachabilityStatus() {
        if (this._manager == null) {
            return 4;
        }
        if (this._context.router().isHidden()) {
            return 0;
        }
        return this._manager.getReachabilityStatus();
    }

    public void recheckReachability() {
        this._manager.recheckReachability();
    }

    public void renderStatusHTML(Writer out, String urlBase, int sortFlags) throws IOException {
        this._manager.renderStatusHTML(out, urlBase, sortFlags);
    }

    public Set createAddresses() {
        Map<String, RouterAddress> addresses = null;
        boolean newCreated = false;
        if (this._manager != null) {
            addresses = this._manager.getAddresses();
        } else {
            addresses = new HashMap<String, RouterAddress>(1);
            newCreated = true;
        }
        if (!addresses.containsKey("NTCP")) {
            RouterAddress addr = CommSystemFacadeImpl.createNTCPAddress(this._context);
            if (this._log.shouldLog(20)) {
                this._log.info("NTCP address: " + addr);
            }
            if (addr != null) {
                addresses.put("NTCP", addr);
            }
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Creating addresses: " + addresses + " isNew? " + newCreated, (Throwable)new Exception("creator"));
        }
        return new HashSet<RouterAddress>(addresses.values());
    }

    public static RouterAddress createNTCPAddress(RouterContext ctx) {
        if (!TransportManager.enableNTCP(ctx)) {
            return null;
        }
        String name = ctx.router().getConfigSetting(PROP_I2NP_NTCP_HOSTNAME);
        String port = ctx.router().getConfigSetting(PROP_I2NP_NTCP_PORT);
        if (name == null || port == null || name.trim().length() <= 0 || "null".equals(name)) {
            return null;
        }
        try {
            int p = Integer.parseInt(port);
            if (p <= 0 || p > 65536) {
                return null;
            }
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        Properties props = new Properties();
        props.setProperty("host", name);
        props.setProperty("port", port);
        RouterAddress addr = new RouterAddress();
        addr.setCost(10);
        addr.setExpiration(null);
        addr.setOptions(props);
        addr.setTransportStyle("NTCP");
        ctx.router().setConfigSetting(PROP_I2NP_NTCP_HOSTNAME, name);
        ctx.router().setConfigSetting(PROP_I2NP_NTCP_PORT, port);
        ctx.router().saveConfig();
        return addr;
    }

    public void notifyReplaceAddress(RouterAddress UDPAddr) {
        Properties newProps;
        RouterAddress newAddr;
        if (UDPAddr == null) {
            return;
        }
        NTCPTransport t = (NTCPTransport)this._manager.getTransport("NTCP");
        if (t == null) {
            return;
        }
        Properties UDPProps = UDPAddr.getOptions();
        if (UDPProps == null) {
            return;
        }
        RouterAddress oldAddr = t.getCurrentAddress();
        if (this._log.shouldLog(20)) {
            this._log.info("Changing NTCP Address? was " + oldAddr);
        }
        if ((newAddr = oldAddr) == null) {
            newAddr = new RouterAddress();
            newAddr.setCost(10);
            newAddr.setExpiration(null);
            newAddr.setTransportStyle("NTCP");
            newProps = new Properties();
        } else {
            newProps = newAddr.getOptions();
            if (newProps == null) {
                newProps = new Properties();
            }
        }
        boolean changed = false;
        String oport = newProps.getProperty("port");
        String nport = null;
        String cport = this._context.getProperty(PROP_I2NP_NTCP_PORT);
        if (cport != null && cport.length() > 0) {
            nport = cport;
        } else if (Boolean.valueOf(this._context.getProperty(PROP_I2NP_NTCP_AUTO_PORT, "true")).booleanValue()) {
            nport = UDPProps.getProperty("port");
        }
        if (this._log.shouldLog(20)) {
            this._log.info("old: " + oport + " config: " + cport + " new: " + nport);
        }
        if (nport == null || nport.length() <= 0) {
            return;
        }
        if (oport == null || !oport.equals(nport)) {
            newProps.setProperty("port", nport);
            changed = true;
        }
        String ohost = newProps.getProperty("host");
        String enabled = this._context.getProperty(PROP_I2NP_NTCP_AUTO_IP, "true");
        String name = this._context.getProperty(PROP_I2NP_NTCP_HOSTNAME);
        if (name != null && name.length() > 0) {
            enabled = "false";
        }
        Transport udp = this._manager.getTransport("SSU");
        int status = 4;
        if (udp != null) {
            status = udp.getReachabilityStatus();
        }
        if (this._log.shouldLog(20)) {
            this._log.info("old: " + ohost + " config: " + name + " auto: " + enabled + " status: " + status);
        }
        if (enabled.equalsIgnoreCase("always") || enabled.equalsIgnoreCase("true") && status == 0) {
            String nhost = UDPProps.getProperty("host");
            if (this._log.shouldLog(20)) {
                this._log.info("old: " + ohost + " config: " + name + " new: " + nhost);
            }
            if (nhost == null || nhost.length() <= 0) {
                return;
            }
            if (ohost == null || !ohost.equalsIgnoreCase(nhost)) {
                newProps.setProperty("host", nhost);
                changed = true;
            }
        } else {
            if (ohost == null || ohost.length() <= 0) {
                return;
            }
            if (enabled.equalsIgnoreCase("true") && status != 0) {
                if (this._log.shouldLog(20)) {
                    this._log.info("old: " + ohost + " config: " + name + " new: null");
                }
                newAddr = null;
                changed = true;
            }
        }
        if (!changed) {
            this._log.warn("No change to NTCP Address");
            return;
        }
        this._log.warn("Halting NTCP to change address");
        t.stopListening();
        if (newAddr != null) {
            newAddr.setOptions(newProps);
        }
        while (t.isAlive()) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ie) {}
        }
        t.restartListening(newAddr);
        this._log.warn("Changed NTCP Address and started up, address is now " + newAddr);
    }

    private void startGeoIP() {
        this._geoIP = new GeoIP(this._context);
        SimpleScheduler.getInstance().addEvent((SimpleTimer.TimedEvent)new QueueAll(), 300000L);
    }

    public void queueLookup(byte[] ip) {
        this._geoIP.add(ip);
    }

    public String getCountry(Hash peer) {
        byte[] ip = TransportImpl.getIP(peer);
        if (ip != null) {
            return this._geoIP.get(ip);
        }
        RouterInfo ri = this._context.netDb().lookupRouterInfoLocally(peer);
        if (ri == null) {
            return null;
        }
        String s = this.getIPString(ri);
        if (s != null) {
            return this._geoIP.get(s);
        }
        return null;
    }

    private String getIPString(RouterInfo ri) {
        RouterAddress ra = ri.getTargetAddress("SSU");
        if (ra == null) {
            return null;
        }
        Properties props = ra.getOptions();
        if (props == null) {
            return null;
        }
        return props.getProperty("host");
    }

    public String getCountryName(String c) {
        if (this._geoIP == null) {
            return c;
        }
        String n = this._geoIP.fullName(c);
        if (n == null) {
            return c;
        }
        return n;
    }

    public String renderPeerHTML(Hash peer) {
        boolean found;
        String h = peer.toBase64().substring(0, 4);
        StringBuilder buf = new StringBuilder(128);
        String c = this.getCountry(peer);
        if (c != null) {
            buf.append("<img height=\"11\" width=\"16\" alt=\"").append(c.toUpperCase()).append("\" title=\"");
            buf.append(this.getCountryName(c));
            buf.append("\" src=\"/flags.jsp?c=").append(c).append("\"> ");
        }
        buf.append("<tt>");
        boolean bl = found = this._context.netDb().lookupRouterInfoLocally(peer) != null;
        if (found) {
            buf.append("<a title=\"NetDb entry\" href=\"netdb.jsp?r=").append(h).append("\">");
        }
        buf.append(h);
        if (found) {
            buf.append("</a>");
        }
        buf.append("</tt>");
        return buf.toString();
    }

    private class Lookup
    implements SimpleTimer.TimedEvent {
        private Lookup() {
        }

        public void timeReached() {
            CommSystemFacadeImpl.this._geoIP.blockingLookup();
        }
    }

    private class QueueAll
    implements SimpleTimer.TimedEvent {
        private QueueAll() {
        }

        public void timeReached() {
            Iterator<Hash> iter = CommSystemFacadeImpl.this._context.netDb().getAllRouters().iterator();
            while (iter.hasNext()) {
                String host;
                RouterInfo ri = CommSystemFacadeImpl.this._context.netDb().lookupRouterInfoLocally(iter.next());
                if (ri == null || (host = CommSystemFacadeImpl.this.getIPString(ri)) == null) continue;
                CommSystemFacadeImpl.this._geoIP.add(host);
            }
            SimpleScheduler.getInstance().addPeriodicEvent((SimpleTimer.TimedEvent)new Lookup(), 5000L, 1800000L);
        }
    }
}

